/*
 * Decompiled with CFR 0.152.
 */
package android.util.cts;

import android.test.AndroidTestCase;
import android.util.SparseArray;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;

@TestTargetClass(value=SparseArray.class)
public class SparseArrayTest
extends AndroidTestCase {
    private static final int[] KEYS = new int[]{12, 23, 4, 6, 8, 1, 3, -12, 0, -3, 11, 14, -23};
    private static final Integer[] VALUES = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    private static final int LENGTH = VALUES.length;
    private static final int NON_EXISTED_KEY = 123;
    private static final Integer VALUE_FOR_NON_EXISTED_KEY = -1;

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, method="SparseArray", args={}), @TestTargetNew(level=TestLevel.COMPLETE, method="append", args={int.class, Object.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="clear", args={}), @TestTargetNew(level=TestLevel.COMPLETE, method="delete", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="remove", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="get", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="get", args={int.class, Object.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="indexOfKey", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="indexOfValue", args={Object.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="keyAt", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="put", args={int.class, Object.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="setValueAt", args={int.class, Object.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="size", args={}), @TestTargetNew(level=TestLevel.COMPLETE, method="valueAt", args={int.class})})
    public void testSparseArrayWithDefaultCapacity() {
        int i;
        SparseArray sparseArray = new SparseArray();
        SparseArrayTest.assertEquals((int)0, (int)sparseArray.size());
        int length = VALUES.length;
        for (i = 0; i < length; ++i) {
            sparseArray.put(KEYS[i], (Object)VALUES[i]);
            SparseArrayTest.assertEquals((int)(i + 1), (int)sparseArray.size());
        }
        for (i = 0; i < length; ++i) {
            SparseArrayTest.assertEquals((Object)new Integer(i), (Object)sparseArray.get(KEYS[i]));
        }
        for (i = 0; i < length; ++i) {
            SparseArrayTest.assertEquals((int)sparseArray.indexOfValue((Object)VALUES[i]), (int)sparseArray.indexOfKey(KEYS[i]));
        }
        int existKey = KEYS[0];
        Integer oldValue = VALUES[0];
        Integer newValue = 100;
        SparseArrayTest.assertEquals((Object)oldValue, (Object)sparseArray.get(existKey));
        SparseArrayTest.assertEquals((int)LENGTH, (int)sparseArray.size());
        sparseArray.put(existKey, (Object)newValue);
        SparseArrayTest.assertEquals((Object)newValue, (Object)sparseArray.get(existKey));
        SparseArrayTest.assertEquals((int)LENGTH, (int)sparseArray.size());
        SparseArrayTest.assertEquals((Object)VALUE_FOR_NON_EXISTED_KEY, (Object)sparseArray.get(123, (Object)VALUE_FOR_NON_EXISTED_KEY));
        SparseArrayTest.assertNull((Object)sparseArray.get(123));
        int size = sparseArray.size();
        sparseArray.append(123, (Object)VALUE_FOR_NON_EXISTED_KEY);
        SparseArrayTest.assertEquals((int)(size + 1), (int)sparseArray.size());
        SparseArrayTest.assertEquals((int)size, (int)sparseArray.indexOfKey(123));
        SparseArrayTest.assertEquals((int)size, (int)sparseArray.indexOfValue((Object)VALUE_FOR_NON_EXISTED_KEY));
        SparseArrayTest.assertEquals((int)123, (int)sparseArray.keyAt(size));
        SparseArrayTest.assertEquals((Object)VALUE_FOR_NON_EXISTED_KEY, (Object)sparseArray.valueAt(size));
        sparseArray.setValueAt(size, (Object)VALUES[1]);
        SparseArrayTest.assertTrue((VALUE_FOR_NON_EXISTED_KEY != sparseArray.valueAt(size) ? 1 : 0) != 0);
        SparseArrayTest.assertEquals((Object)VALUES[1], (Object)sparseArray.valueAt(size));
        size = sparseArray.size();
        SparseArrayTest.assertEquals((Object)VALUES[1], (Object)sparseArray.get(KEYS[1]));
        SparseArrayTest.assertFalse((VALUE_FOR_NON_EXISTED_KEY == VALUES[1] ? 1 : 0) != 0);
        sparseArray.delete(KEYS[1]);
        SparseArrayTest.assertEquals((Object)VALUE_FOR_NON_EXISTED_KEY, (Object)sparseArray.get(KEYS[1], (Object)VALUE_FOR_NON_EXISTED_KEY));
        SparseArrayTest.assertEquals((int)(size - 1), (int)sparseArray.size());
        size = sparseArray.size();
        SparseArrayTest.assertEquals((Object)VALUES[2], (Object)sparseArray.get(KEYS[2]));
        SparseArrayTest.assertFalse((VALUE_FOR_NON_EXISTED_KEY == VALUES[2] ? 1 : 0) != 0);
        sparseArray.remove(KEYS[2]);
        SparseArrayTest.assertEquals((Object)VALUE_FOR_NON_EXISTED_KEY, (Object)sparseArray.get(KEYS[2], (Object)VALUE_FOR_NON_EXISTED_KEY));
        SparseArrayTest.assertEquals((int)(size - 1), (int)sparseArray.size());
        sparseArray.clear();
        SparseArrayTest.assertEquals((int)0, (int)sparseArray.size());
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, method="SparseArray", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="append", args={int.class, Object.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="clear", args={}), @TestTargetNew(level=TestLevel.COMPLETE, method="delete", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="remove", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="get", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="get", args={int.class, Object.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="indexOfKey", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="indexOfValue", args={Object.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="keyAt", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="put", args={int.class, Object.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="setValueAt", args={int.class, Object.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="size", args={}), @TestTargetNew(level=TestLevel.COMPLETE, method="valueAt", args={int.class})})
    public void testSparseArrayWithSpecifiedCapacity() {
        int i;
        SparseArray sparseArray = new SparseArray(5);
        SparseArrayTest.assertEquals((int)0, (int)sparseArray.size());
        int length = VALUES.length;
        for (i = 0; i < length; ++i) {
            sparseArray.put(KEYS[i], (Object)VALUES[i]);
            SparseArrayTest.assertEquals((int)(i + 1), (int)sparseArray.size());
        }
        for (i = 0; i < length; ++i) {
            SparseArrayTest.assertEquals((Object)VALUES[i], (Object)sparseArray.get(KEYS[i]));
        }
        for (i = 0; i < length; ++i) {
            SparseArrayTest.assertEquals((int)sparseArray.indexOfValue((Object)VALUES[i]), (int)sparseArray.indexOfKey(KEYS[i]));
        }
        int existKey = KEYS[0];
        Integer oldValue = VALUES[0];
        Integer newValue = 100;
        SparseArrayTest.assertEquals((Object)oldValue, (Object)sparseArray.get(existKey));
        SparseArrayTest.assertEquals((int)LENGTH, (int)sparseArray.size());
        sparseArray.put(existKey, (Object)newValue);
        SparseArrayTest.assertEquals((Object)newValue, (Object)sparseArray.get(existKey));
        SparseArrayTest.assertEquals((int)LENGTH, (int)sparseArray.size());
        SparseArrayTest.assertEquals((Object)VALUE_FOR_NON_EXISTED_KEY, (Object)sparseArray.get(123, (Object)VALUE_FOR_NON_EXISTED_KEY));
        SparseArrayTest.assertNull((Object)sparseArray.get(123));
        int size = sparseArray.size();
        sparseArray.append(123, (Object)VALUE_FOR_NON_EXISTED_KEY);
        SparseArrayTest.assertEquals((int)(size + 1), (int)sparseArray.size());
        SparseArrayTest.assertEquals((int)size, (int)sparseArray.indexOfKey(123));
        SparseArrayTest.assertEquals((int)size, (int)sparseArray.indexOfValue((Object)VALUE_FOR_NON_EXISTED_KEY));
        SparseArrayTest.assertEquals((int)123, (int)sparseArray.keyAt(size));
        SparseArrayTest.assertEquals((Object)VALUE_FOR_NON_EXISTED_KEY, (Object)sparseArray.valueAt(size));
        sparseArray.setValueAt(size, (Object)VALUES[1]);
        SparseArrayTest.assertTrue((VALUE_FOR_NON_EXISTED_KEY != sparseArray.valueAt(size) ? 1 : 0) != 0);
        SparseArrayTest.assertEquals((Object)VALUES[1], (Object)sparseArray.valueAt(size));
        size = sparseArray.size();
        SparseArrayTest.assertEquals((Object)VALUES[1], (Object)sparseArray.get(KEYS[1]));
        SparseArrayTest.assertFalse((VALUE_FOR_NON_EXISTED_KEY == VALUES[1] ? 1 : 0) != 0);
        sparseArray.delete(KEYS[1]);
        SparseArrayTest.assertEquals((Object)VALUE_FOR_NON_EXISTED_KEY, (Object)sparseArray.get(KEYS[1], (Object)VALUE_FOR_NON_EXISTED_KEY));
        SparseArrayTest.assertEquals((int)(size - 1), (int)sparseArray.size());
        size = sparseArray.size();
        SparseArrayTest.assertEquals((Object)VALUES[2], (Object)sparseArray.get(KEYS[2]));
        SparseArrayTest.assertFalse((VALUE_FOR_NON_EXISTED_KEY == VALUES[2] ? 1 : 0) != 0);
        sparseArray.remove(KEYS[2]);
        SparseArrayTest.assertEquals((Object)VALUE_FOR_NON_EXISTED_KEY, (Object)sparseArray.get(KEYS[2], (Object)VALUE_FOR_NON_EXISTED_KEY));
        SparseArrayTest.assertEquals((int)(size - 1), (int)sparseArray.size());
        sparseArray.clear();
        SparseArrayTest.assertEquals((int)0, (int)sparseArray.size());
    }
}

