/*
 * Decompiled with CFR 0.152.
 */
package android.util.cts;

import android.test.AndroidTestCase;
import android.util.PrintWriterPrinter;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

@TestTargetClass(value=PrintWriterPrinter.class)
public class PrintWriterPrinterTest
extends AndroidTestCase {
    private File mFile;

    protected void setUp() throws Exception {
        super.setUp();
        File dbDir = this.getContext().getDir("tests", 0);
        this.mFile = new File(dbDir, "print.log");
        if (!this.mFile.exists()) {
            this.mFile.createNewFile();
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test constructor(s) of PrintWriterPrinter.", method="PrintWriterPrinter", args={PrintWriter.class})
    public void testConstructor() {
        PrintWriterPrinter printWriterPrinter = null;
        try {
            PrintWriter pw = new PrintWriter(this.mFile);
            printWriterPrinter = new PrintWriterPrinter(pw);
        }
        catch (FileNotFoundException e) {
            PrintWriterPrinterTest.fail((String)"shouldn't throw exception");
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test println(String x).", method="println", args={String.class})
    public void testPrintln() {
        PrintWriterPrinter printWriterPrinter = null;
        String mMessage = "testMessage";
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(this.mFile);
            printWriterPrinter = new PrintWriterPrinter(pw);
        }
        catch (FileNotFoundException e) {
            PrintWriterPrinterTest.fail((String)"shouldn't throw exception");
        }
        printWriterPrinter.println(mMessage);
        pw.flush();
        pw.close();
        String mLine = "";
        try {
            FileInputStream is = new FileInputStream(this.mFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            mLine = reader.readLine();
        }
        catch (Exception e) {
            // empty catch block
        }
        PrintWriterPrinterTest.assertEquals((String)mMessage, (String)mLine);
    }

    protected void tearDown() throws Exception {
        if (this.mFile.exists()) {
            this.mFile.delete();
        }
    }
}

