/*
 * Decompiled with CFR 0.152.
 */
package android.util.cts;

import android.test.AndroidTestCase;
import android.util.PrintStreamPrinter;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

@TestTargetClass(value=PrintStreamPrinter.class)
public class PrintStreamPrinterTest
extends AndroidTestCase {
    private File mFile;

    protected void setUp() throws Exception {
        super.setUp();
        this.mFile = new File(this.getContext().getFilesDir(), "PrintStreamPrinter.log");
        if (!this.mFile.exists()) {
            this.mFile.createNewFile();
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, method="PrintStreamPrinter", args={PrintStream.class})
    public void testConstructor() throws FileNotFoundException {
        new PrintStreamPrinter(new PrintStream(this.mFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, method="println", args={String.class})
    public void testPrintln() throws FileNotFoundException, SecurityException, IOException {
        PrintStreamPrinter printStreamPrinter = null;
        String message = "testMessageOfPrintStreamPrinter";
        InputStream is = null;
        PrintStream ps = new PrintStream(this.mFile);
        printStreamPrinter = new PrintStreamPrinter(ps);
        printStreamPrinter.println("testMessageOfPrintStreamPrinter");
        ps.flush();
        ps.close();
        try {
            is = new FileInputStream(this.mFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String mLine = reader.readLine();
            PrintStreamPrinterTest.assertEquals((String)"testMessageOfPrintStreamPrinter", (String)mLine);
            reader.close();
        }
        finally {
            is.close();
        }
    }

    protected void tearDown() throws Exception {
        if (this.mFile.exists()) {
            this.mFile.delete();
        }
        super.tearDown();
    }
}

