/*
 * Decompiled with CFR 0.152.
 */
package android.util.cts;

import android.test.AndroidTestCase;
import android.util.MonthDisplayHelper;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;

@TestTargetClass(value=MonthDisplayHelper.class)
public class MonthDisplayHelperTest
extends AndroidTestCase {
    private MonthDisplayHelper mHelper;

    protected void setUp() throws Exception {
        super.setUp();
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test constructor(s) of MonthDisplayHelper.", method="MonthDisplayHelper", args={int.class, int.class, int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test constructor(s) of MonthDisplayHelper.", method="MonthDisplayHelper", args={int.class, int.class})})
    public void testConstructor() {
        try {
            this.mHelper = new MonthDisplayHelper(2008, 11, 2);
            this.mHelper = new MonthDisplayHelper(2008, 11);
        }
        catch (Exception e) {
            MonthDisplayHelperTest.fail((String)"shouldn't throw exception");
        }
        try {
            this.mHelper = new MonthDisplayHelper(2008, 11, 0);
            MonthDisplayHelperTest.fail((String)"should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.mHelper = new MonthDisplayHelper(2008, 11, 8);
            MonthDisplayHelperTest.fail((String)"should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.mHelper = new MonthDisplayHelper(-1, 11, 8);
            MonthDisplayHelperTest.fail((String)"should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.mHelper = new MonthDisplayHelper(-1, 12, 8);
            MonthDisplayHelperTest.fail((String)"should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test getNumberOfDaysInMonth().", method="getNumberOfDaysInMonth", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test getNumberOfDaysInMonth().", method="MonthDisplayHelper", args={int.class, int.class})})
    public void testNumberOfDaysInCurrentMonth() {
        MonthDisplayHelperTest.assertEquals((int)30, (int)new MonthDisplayHelper(2007, 8).getNumberOfDaysInMonth());
        MonthDisplayHelperTest.assertEquals((int)28, (int)new MonthDisplayHelper(2007, 1).getNumberOfDaysInMonth());
        MonthDisplayHelperTest.assertEquals((int)29, (int)new MonthDisplayHelper(2008, 1).getNumberOfDaysInMonth());
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test nextMonth().", method="nextMonth", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test nextMonth().", method="getDigitsForRow", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test nextMonth().", method="getMonth", args={})})
    public void testNextMonth() {
        this.mHelper = new MonthDisplayHelper(2007, 7, 1);
        this.assertArraysEqual(new int[]{29, 30, 31, 1, 2, 3, 4}, this.mHelper.getDigitsForRow(0));
        this.mHelper.nextMonth();
        MonthDisplayHelperTest.assertEquals((int)8, (int)this.mHelper.getMonth());
        this.assertArraysEqual(new int[]{26, 27, 28, 29, 30, 31, 1}, this.mHelper.getDigitsForRow(0));
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test getRowOf(int day).", method="getRowOf", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test getRowOf(int day).", method="MonthDisplayHelper", args={int.class, int.class})})
    public void testGetRowOf() {
        this.mHelper = new MonthDisplayHelper(2007, 7, 1);
        MonthDisplayHelperTest.assertEquals((int)0, (int)this.mHelper.getRowOf(2));
        MonthDisplayHelperTest.assertEquals((int)0, (int)this.mHelper.getRowOf(4));
        MonthDisplayHelperTest.assertEquals((int)2, (int)this.mHelper.getRowOf(12));
        MonthDisplayHelperTest.assertEquals((int)2, (int)this.mHelper.getRowOf(18));
        MonthDisplayHelperTest.assertEquals((int)3, (int)this.mHelper.getRowOf(19));
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test getWeekStartDay().", method="getWeekStartDay", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test getWeekStartDay().", method="getOffset", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test getWeekStartDay().", method="MonthDisplayHelper", args={int.class, int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test getWeekStartDay().", method="MonthDisplayHelper", args={int.class, int.class, int.class})})
    public void testHelperProperties() {
        this.mHelper = new MonthDisplayHelper(2007, 7, 1);
        MonthDisplayHelperTest.assertEquals((int)1, (int)this.mHelper.getWeekStartDay());
        MonthDisplayHelperTest.assertEquals((int)3, (int)this.mHelper.getOffset());
        this.mHelper = new MonthDisplayHelper(2007, 7);
        MonthDisplayHelperTest.assertEquals((int)1, (int)this.mHelper.getWeekStartDay());
        MonthDisplayHelperTest.assertEquals((int)3, (int)this.mHelper.getOffset());
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test getDigitsForRow(int row).", method="getDigitsForRow", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test getDigitsForRow(int row).", method="MonthDisplayHelper", args={int.class, int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test getDigitsForRow(int row).", method="MonthDisplayHelper", args={int.class, int.class, int.class})})
    public void testMonthRows() {
        this.mHelper = new MonthDisplayHelper(2007, 8);
        this.assertArraysEqual(new int[]{26, 27, 28, 29, 30, 31, 1}, this.mHelper.getDigitsForRow(0));
        this.assertArraysEqual(new int[]{2, 3, 4, 5, 6, 7, 8}, this.mHelper.getDigitsForRow(1));
        this.assertArraysEqual(new int[]{30, 1, 2, 3, 4, 5, 6}, this.mHelper.getDigitsForRow(5));
        this.mHelper = new MonthDisplayHelper(2007, 8, 2);
        this.assertArraysEqual(new int[]{27, 28, 29, 30, 31, 1, 2}, this.mHelper.getDigitsForRow(0));
        this.assertArraysEqual(new int[]{3, 4, 5, 6, 7, 8, 9}, this.mHelper.getDigitsForRow(1));
        this.assertArraysEqual(new int[]{24, 25, 26, 27, 28, 29, 30}, this.mHelper.getDigitsForRow(4));
        this.assertArraysEqual(new int[]{1, 2, 3, 4, 5, 6, 7}, this.mHelper.getDigitsForRow(5));
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test getFirstDayOfMonth().", method="getFirstDayOfMonth", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test getFirstDayOfMonth().", method="MonthDisplayHelper", args={int.class, int.class})})
    public void testFirstDayOfMonth() {
        MonthDisplayHelperTest.assertEquals((String)"august 2007", (int)4, (int)new MonthDisplayHelper(2007, 7).getFirstDayOfMonth());
        MonthDisplayHelperTest.assertEquals((String)"september, 2007", (int)7, (int)new MonthDisplayHelper(2007, 8).getFirstDayOfMonth());
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test getColumnOf(int day).", method="getColumnOf", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test getColumnOf(int day).", method="MonthDisplayHelper", args={int.class, int.class})})
    public void testGetColumnOf() {
        this.mHelper = new MonthDisplayHelper(2007, 7, 1);
        MonthDisplayHelperTest.assertEquals((int)3, (int)this.mHelper.getColumnOf(1));
        MonthDisplayHelperTest.assertEquals((int)4, (int)this.mHelper.getColumnOf(9));
        MonthDisplayHelperTest.assertEquals((int)5, (int)this.mHelper.getColumnOf(17));
        MonthDisplayHelperTest.assertEquals((int)6, (int)this.mHelper.getColumnOf(25));
        MonthDisplayHelperTest.assertEquals((int)0, (int)this.mHelper.getColumnOf(26));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test getDayAt(int row, int column).", method="getDayAt", args={int.class, int.class})
    public void testGetDayAt() {
        this.mHelper = new MonthDisplayHelper(2007, 7, 1);
        MonthDisplayHelperTest.assertEquals((int)30, (int)this.mHelper.getDayAt(0, 1));
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test previousMonth().", method="previousMonth", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test previousMonth().", method="getDigitsForRow", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test previousMonth().", method="getYear", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test previousMonth().", method="getMonth", args={})})
    public void testPrevMonth() {
        this.mHelper = new MonthDisplayHelper(2007, 8, 1);
        this.assertArraysEqual(new int[]{26, 27, 28, 29, 30, 31, 1}, this.mHelper.getDigitsForRow(0));
        this.mHelper.previousMonth();
        MonthDisplayHelperTest.assertEquals((int)7, (int)this.mHelper.getMonth());
        this.assertArraysEqual(new int[]{29, 30, 31, 1, 2, 3, 4}, this.mHelper.getDigitsForRow(0));
        this.mHelper = new MonthDisplayHelper(2007, 0);
        this.mHelper.previousMonth();
        MonthDisplayHelperTest.assertEquals((int)2006, (int)this.mHelper.getYear());
        MonthDisplayHelperTest.assertEquals((int)11, (int)this.mHelper.getMonth());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test isWithinCurrentMonth(int row, int column).", method="isWithinCurrentMonth", args={int.class, int.class})
    public void testIsWithinCurrentMonth() {
        this.mHelper = new MonthDisplayHelper(2007, 8, 1);
        MonthDisplayHelperTest.assertFalse((boolean)this.mHelper.isWithinCurrentMonth(-1, 3));
        MonthDisplayHelperTest.assertFalse((boolean)this.mHelper.isWithinCurrentMonth(6, 3));
        MonthDisplayHelperTest.assertFalse((boolean)this.mHelper.isWithinCurrentMonth(2, -1));
        MonthDisplayHelperTest.assertFalse((boolean)this.mHelper.isWithinCurrentMonth(2, 7));
        MonthDisplayHelperTest.assertFalse((boolean)this.mHelper.isWithinCurrentMonth(0, 5));
        MonthDisplayHelperTest.assertFalse((boolean)this.mHelper.isWithinCurrentMonth(5, 1));
        MonthDisplayHelperTest.assertTrue((boolean)this.mHelper.isWithinCurrentMonth(0, 6));
        MonthDisplayHelperTest.assertTrue((boolean)this.mHelper.isWithinCurrentMonth(5, 0));
    }

    private void assertArraysEqual(int[] expected, int[] actual) {
        MonthDisplayHelperTest.assertEquals((String)"array length", (int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            MonthDisplayHelperTest.assertEquals((String)("index " + i), (int)expected[i], (int)actual[i]);
        }
    }
}

