/*
 * Decompiled with CFR 0.152.
 */
package android.util.cts;

import android.os.Process;
import android.util.EventLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventLogTest
extends TestCase {
    private static final int ANSWER_TAG = 42;
    private static final int PI_TAG = 314;
    private static final int E_TAG = 2718;

    public void testWriteEvent() throws Exception {
        long markerData = System.currentTimeMillis();
        EventLog.writeEvent((int)42, (long)markerData);
        EventLog.writeEvent((int)42, (int)12345);
        EventLog.writeEvent((int)42, (long)23456L);
        EventLog.writeEvent((int)42, (String)"Test");
        EventLog.writeEvent((int)42, (Object[])new Object[]{12345, 23456L, "Test"});
        List<EventLog.Event> events = this.getEventsAfterMarker(markerData, 42);
        EventLogTest.assertEquals((int)4, (int)events.size());
        EventLogTest.assertEquals((int)42, (int)events.get(0).getTag());
        EventLogTest.assertEquals((Object)12345, (Object)events.get(0).getData());
        EventLogTest.assertEquals((Object)23456L, (Object)events.get(1).getData());
        EventLogTest.assertEquals((Object)"Test", (Object)events.get(2).getData());
        Object[] arr = (Object[])events.get(3).getData();
        EventLogTest.assertEquals((int)3, (int)arr.length);
        EventLogTest.assertEquals((Object)12345, (Object)arr[0]);
        EventLogTest.assertEquals((Object)23456L, (Object)arr[1]);
        EventLogTest.assertEquals((Object)"Test", (Object)arr[2]);
    }

    public void testWriteEventWithOversizeValue() throws Exception {
        StringBuilder longString = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            longString.append("xyzzy");
        }
        Object[] longArray = new Object[1000];
        for (int i = 0; i < 1000; ++i) {
            longArray[i] = 12345;
        }
        Long markerData = System.currentTimeMillis();
        EventLog.writeEvent((int)42, (long)markerData);
        EventLog.writeEvent((int)42, (String)longString.toString());
        EventLog.writeEvent((int)42, (Object[])new Object[]{"hi", longString.toString()});
        EventLog.writeEvent((int)42, (Object[])new Object[]{12345, longString.toString()});
        EventLog.writeEvent((int)42, (Object[])new Object[]{12345L, longString.toString()});
        EventLog.writeEvent((int)42, (Object[])new Object[]{longString.toString(), longString.toString()});
        EventLog.writeEvent((int)42, (Object[])longArray);
        List<EventLog.Event> events = this.getEventsAfterMarker(markerData, 42);
        EventLogTest.assertEquals((int)6, (int)events.size());
        int max = 4071;
        String val0 = (String)events.get(0).getData();
        EventLogTest.assertEquals((int)4066, (int)val0.length());
        Object[] arr1 = (Object[])events.get(1).getData();
        EventLogTest.assertEquals((int)2, (int)arr1.length);
        EventLogTest.assertEquals((Object)"hi", (Object)arr1[0]);
        EventLogTest.assertEquals((int)4057, (int)((String)arr1[1]).length());
        Object[] arr2 = (Object[])events.get(2).getData();
        EventLogTest.assertEquals((int)2, (int)arr2.length);
        EventLogTest.assertEquals((Object)12345, (Object)arr2[0]);
        EventLogTest.assertEquals((int)4059, (int)((String)arr2[1]).length());
        Object[] arr3 = (Object[])events.get(3).getData();
        EventLogTest.assertEquals((int)2, (int)arr3.length);
        EventLogTest.assertEquals((Object)12345L, (Object)arr3[0]);
        EventLogTest.assertEquals((int)4055, (int)((String)arr3[1]).length());
        Object[] arr4 = (Object[])events.get(4).getData();
        EventLogTest.assertEquals((int)1, (int)arr4.length);
        EventLogTest.assertEquals((int)4064, (int)((String)arr4[0]).length());
        Object[] arr5 = (Object[])events.get(5).getData();
        EventLogTest.assertEquals((int)255, (int)arr5.length);
        EventLogTest.assertEquals((Object)12345, (Object)arr5[0]);
        EventLogTest.assertEquals((Object)12345, (Object)arr5[arr5.length - 1]);
    }

    public void testWriteNullEvent() throws Exception {
        Long markerData = System.currentTimeMillis();
        EventLog.writeEvent((int)42, (long)markerData);
        EventLog.writeEvent((int)42, (String)null);
        EventLog.writeEvent((int)42, (Object[])new Object[]{12345, null});
        List<EventLog.Event> events = this.getEventsAfterMarker(markerData, 42);
        EventLogTest.assertEquals((int)2, (int)events.size());
        EventLogTest.assertEquals((Object)"NULL", (Object)events.get(0).getData());
        Object[] arr = (Object[])events.get(1).getData();
        EventLogTest.assertEquals((int)2, (int)arr.length);
        EventLogTest.assertEquals((Object)12345, (Object)arr[0]);
        EventLogTest.assertEquals((Object)"NULL", (Object)arr[1]);
    }

    public void testReadEvents() throws Exception {
        Long markerData = System.currentTimeMillis();
        EventLog.writeEvent((int)42, (long)markerData);
        Long data0 = markerData + 1L;
        EventLog.writeEvent((int)42, (long)data0);
        Long data1 = data0 + 1L;
        EventLog.writeEvent((int)314, (long)data1);
        Long data2 = data1 + 1L;
        EventLog.writeEvent((int)2718, (long)data2);
        List<EventLog.Event> events = this.getEventsAfterMarker(markerData, 42, 314, 2718);
        EventLogTest.assertEquals((int)3, (int)events.size());
        this.assertEvent(events.get(0), 42, data0);
        this.assertEvent(events.get(1), 314, data1);
        this.assertEvent(events.get(2), 2718, data2);
        events = this.getEventsAfterMarker(markerData, 42, 2718);
        EventLogTest.assertEquals((int)2, (int)events.size());
        this.assertEvent(events.get(0), 42, data0);
        this.assertEvent(events.get(1), 2718, data2);
        events = this.getEventsAfterMarker(markerData, 42);
        EventLogTest.assertEquals((int)1, (int)events.size());
        this.assertEvent(events.get(0), 42, data0);
    }

    private List<EventLog.Event> getEventsAfterMarker(Object marker, int ... tags) throws IOException {
        ArrayList<EventLog.Event> events = new ArrayList<EventLog.Event>();
        EventLog.readEvents((int[])tags, events);
        Iterator itr = events.iterator();
        while (itr.hasNext()) {
            EventLog.Event event = (EventLog.Event)itr.next();
            itr.remove();
            if (!marker.equals(event.getData())) continue;
            break;
        }
        this.assertEventTimes(events);
        return events;
    }

    private void assertEvent(EventLog.Event event, int expectedTag, Object expectedData) {
        EventLogTest.assertEquals((int)Process.myPid(), (int)event.getProcessId());
        EventLogTest.assertEquals((int)Process.myTid(), (int)event.getThreadId());
        EventLogTest.assertEquals((int)expectedTag, (int)event.getTag());
        EventLogTest.assertEquals((Object)expectedData, (Object)event.getData());
    }

    private void assertEventTimes(List<EventLog.Event> events) {
        int i = 0;
        while (i + 1 < events.size()) {
            long nextTime;
            long time = events.get(i).getTimeNanos();
            EventLogTest.assertTrue((time <= (nextTime = events.get(i).getTimeNanos()) ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testGetTagName() throws Exception {
        EventLogTest.assertEquals((String)"answer", (String)EventLog.getTagName((int)42));
        EventLogTest.assertEquals((String)"pi", (String)EventLog.getTagName((int)314));
        EventLogTest.assertEquals((String)"e", (String)EventLog.getTagName((int)2718));
        EventLogTest.assertEquals(null, (String)EventLog.getTagName((int)999999999));
    }

    public void testGetTagCode() throws Exception {
        EventLogTest.assertEquals((int)42, (int)EventLog.getTagCode((String)"answer"));
        EventLogTest.assertEquals((int)314, (int)EventLog.getTagCode((String)"pi"));
        EventLogTest.assertEquals((int)2718, (int)EventLog.getTagCode((String)"e"));
        EventLogTest.assertEquals((int)-1, (int)EventLog.getTagCode((String)"does_not_exist"));
    }
}

