/*
 * Decompiled with CFR 0.152.
 */
package android.util.cts;

import android.test.AndroidTestCase;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;

@TestTargetClass(value=DisplayMetrics.class)
public class DisplayMetricsTest
extends AndroidTestCase {
    private Display initDisplay() {
        WindowManager windowManager = (WindowManager)this.getContext().getSystemService("window");
        DisplayMetricsTest.assertNotNull((Object)windowManager);
        Display display = windowManager.getDefaultDisplay();
        DisplayMetricsTest.assertNotNull((Object)display);
        return display;
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test constructor(s) of {@link DisplayMetrics}", method="DisplayMetrics", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test method: setTo", method="setTo", args={DisplayMetrics.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test method: setToDefaults", method="setToDefaults", args={})})
    public void testDisplayMetricsOp() {
        DisplayMetrics outMetrics = new DisplayMetrics();
        outMetrics.setToDefaults();
        DisplayMetricsTest.assertEquals((int)0, (int)outMetrics.widthPixels);
        DisplayMetricsTest.assertEquals((int)0, (int)outMetrics.heightPixels);
        DisplayMetricsTest.assertTrue((0.1 < (double)outMetrics.density && outMetrics.density < 3.0f ? 1 : 0) != 0);
        DisplayMetricsTest.assertTrue((0.1 < (double)outMetrics.scaledDensity && outMetrics.scaledDensity < 3.0f ? 1 : 0) != 0);
        DisplayMetricsTest.assertTrue((0.0f < outMetrics.xdpi ? 1 : 0) != 0);
        DisplayMetricsTest.assertTrue((0.0f < outMetrics.ydpi ? 1 : 0) != 0);
        Display display = this.initDisplay();
        display.getMetrics(outMetrics);
        DisplayMetrics metrics = new DisplayMetrics();
        metrics.setTo(outMetrics);
        DisplayMetricsTest.assertEquals((int)display.getHeight(), (int)metrics.heightPixels);
        DisplayMetricsTest.assertEquals((int)display.getWidth(), (int)metrics.widthPixels);
        DisplayMetricsTest.assertTrue((0.1 < (double)metrics.density && metrics.density < 3.0f ? 1 : 0) != 0);
        DisplayMetricsTest.assertTrue((0.1 < (double)metrics.scaledDensity && metrics.scaledDensity < 3.0f ? 1 : 0) != 0);
        DisplayMetricsTest.assertTrue((0.0f < metrics.xdpi ? 1 : 0) != 0);
        DisplayMetricsTest.assertTrue((0.0f < metrics.ydpi ? 1 : 0) != 0);
    }
}

