/*
 * Decompiled with CFR 0.152.
 */
package android.performance5.cts;

import android.app.Activity;
import android.content.Intent;
import android.test.InstrumentationTestCase;
import android.util.Log;

public class AppStartup
extends InstrumentationTestCase {
    private static final long MAX_AVG_STARTUP_TIME = 650L;
    private static final String PACKAGE_UNDER_TEST = "com.android.alarmclock";
    private static final String ACTIVITY_UNDER_TEST = "AlarmClock";
    private static final int NUMBER_OF_ITERS = 10;

    private Intent buildIntent(String pkgName, String className) {
        String fullClassName = pkgName + "." + className;
        Intent intent = new Intent();
        intent.setClassName(pkgName, fullClassName);
        intent.addFlags(0x10000000);
        intent.setAction("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        return intent;
    }

    public void testStartup() throws InterruptedException {
        int x;
        long totalTime = 0L;
        Intent i = this.buildIntent(PACKAGE_UNDER_TEST, ACTIVITY_UNDER_TEST);
        for (x = 0; x < 3; ++x) {
            Activity a = this.getInstrumentation().startActivitySync(i);
            a.finish();
        }
        for (x = 0; x < 10; ++x) {
            long start = System.currentTimeMillis();
            Activity a = this.getInstrumentation().startActivitySync(i);
            long end = System.currentTimeMillis();
            long diff = end - start;
            totalTime += diff;
            a.finish();
        }
        long avgStartupTime = totalTime / 10L;
        Log.d((String)"AppStartup", (String)("AppStartup for com.android.alarmclock/AlarmClock took " + avgStartupTime + "ms."));
        AppStartup.assertTrue((String)("App Took too long to startup: " + avgStartupTime + " " + 650L), (avgStartupTime < 650L ? 1 : 0) != 0);
    }
}

