/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.provider.ContactsContract;
import android.provider.SocialContract;
import com.android.providers.contacts.ContactsDatabaseHelper;
import java.util.ArrayList;
import java.util.HashMap;

public class SocialProvider
extends ContentProvider {
    private static final String TAG = "SocialProvider ~~~~";
    private static final UriMatcher sUriMatcher;
    private static final int ACTIVITIES = 1000;
    private static final int ACTIVITIES_ID = 1001;
    private static final int ACTIVITIES_AUTHORED_BY = 1002;
    private static final int CONTACT_STATUS_ID = 3000;
    private static final String DEFAULT_SORT_ORDER = "thread_published DESC, published ASC";
    private static final HashMap<String, String> sContactsProjectionMap;
    private static final HashMap<String, String> sRawContactsProjectionMap;
    private static final HashMap<String, String> sActivitiesProjectionMap;
    private static final HashMap<String, String> sActivitiesContactsProjectionMap;
    private ContactsDatabaseHelper mDbHelper;

    public boolean onCreate() {
        Context context = this.getContext();
        this.mDbHelper = ContactsDatabaseHelper.getInstance(context);
        return true;
    }

    private void onChange(Uri uri) {
        this.getContext().getContentResolver().notifyChange(ContactsContract.AUTHORITY_URI, null);
    }

    public boolean isTemporary() {
        return false;
    }

    public Uri insert(Uri uri, ContentValues values) {
        int match = sUriMatcher.match(uri);
        long id = 0L;
        switch (match) {
            case 1000: {
                id = this.insertActivity(values);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown uri: " + uri);
            }
        }
        Uri result = ContentUris.withAppendedId((Uri)SocialContract.Activities.CONTENT_URI, (long)id);
        this.onChange(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long insertActivity(ContentValues values) {
        SQLiteDatabase db = this.mDbHelper.getWritableDatabase();
        long id = 0L;
        db.beginTransaction();
        try {
            long published;
            String packageName = values.getAsString("res_package");
            if (packageName != null) {
                values.put("package_id", Long.valueOf(this.mDbHelper.getPackageId(packageName)));
            }
            values.remove("res_package");
            String mimeType = values.getAsString("mimetype");
            values.put("mimetype_id", Long.valueOf(this.mDbHelper.getMimeTypeId(mimeType)));
            values.remove("mimetype");
            long threadPublished = published = values.getAsLong("published").longValue();
            String inReplyTo = values.getAsString("in_reply_to");
            if (inReplyTo != null) {
                threadPublished = this.getThreadPublished(db, inReplyTo, published);
            }
            values.put("thread_published", Long.valueOf(threadPublished));
            id = db.insert("activities", "raw_id", values);
            if (values.containsKey("raw_id")) {
                this.adjustReplyTimestamps(db, values.getAsString("raw_id"), published);
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getThreadPublished(SQLiteDatabase db, String rawId, long defaultValue) {
        String inReplyTo = null;
        long threadPublished = defaultValue;
        Cursor c = db.query("activities", new String[]{"in_reply_to", "published"}, "raw_id = ?", new String[]{rawId}, null, null, null);
        try {
            if (c.moveToFirst()) {
                inReplyTo = c.getString(0);
                threadPublished = c.getLong(1);
            }
        }
        finally {
            c.close();
        }
        if (inReplyTo != null) {
            return this.getThreadPublished(db, inReplyTo, threadPublished);
        }
        return threadPublished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustReplyTimestamps(SQLiteDatabase db, String inReplyTo, long threadPublished) {
        ContentValues values = new ContentValues();
        values.put("thread_published", Long.valueOf(threadPublished));
        int replies = db.update("activities", values, "in_reply_to= ?", new String[]{inReplyTo});
        if (replies == 0) {
            return;
        }
        ArrayList<String> rawIds = new ArrayList<String>(replies);
        Cursor c = db.query("activities", new String[]{"raw_id"}, "in_reply_to = ?", new String[]{inReplyTo}, null, null, null);
        try {
            while (c.moveToNext()) {
                rawIds.add(c.getString(0));
            }
        }
        finally {
            c.close();
        }
        for (String rawId : rawIds) {
            this.adjustReplyTimestamps(db, rawId, threadPublished);
        }
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        SQLiteDatabase db = this.mDbHelper.getWritableDatabase();
        int match = sUriMatcher.match(uri);
        switch (match) {
            case 1001: {
                long activityId = ContentUris.parseId((Uri)uri);
                return db.delete("activities", "_id=" + activityId, null);
            }
            case 1002: {
                long contactId = ContentUris.parseId((Uri)uri);
                return db.delete("activities", "author_contact_id=" + contactId, null);
            }
        }
        throw new UnsupportedOperationException("Unknown uri: " + uri);
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException();
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Cursor c;
        SQLiteDatabase db = this.mDbHelper.getReadableDatabase();
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        String limit = null;
        int match = sUriMatcher.match(uri);
        switch (match) {
            case 1000: {
                qb.setTables("activities LEFT OUTER JOIN packages ON (activities.package_id = packages._id) LEFT OUTER JOIN mimetypes ON (activities.mimetype_id = mimetypes._id) LEFT OUTER JOIN raw_contacts ON (activities.author_contact_id = raw_contacts._id) LEFT OUTER JOIN contacts ON (raw_contacts.contact_id = contacts._id)");
                qb.setProjectionMap(sActivitiesContactsProjectionMap);
                break;
            }
            case 1001: {
                long activityId = ContentUris.parseId((Uri)uri);
                qb.setTables("activities LEFT OUTER JOIN packages ON (activities.package_id = packages._id) LEFT OUTER JOIN mimetypes ON (activities.mimetype_id = mimetypes._id) LEFT OUTER JOIN raw_contacts ON (activities.author_contact_id = raw_contacts._id) LEFT OUTER JOIN contacts ON (raw_contacts.contact_id = contacts._id)");
                qb.setProjectionMap(sActivitiesContactsProjectionMap);
                qb.appendWhere((CharSequence)("_id=" + activityId));
                break;
            }
            case 1002: {
                long contactId = ContentUris.parseId((Uri)uri);
                qb.setTables("activities LEFT OUTER JOIN packages ON (activities.package_id = packages._id) LEFT OUTER JOIN mimetypes ON (activities.mimetype_id = mimetypes._id) LEFT OUTER JOIN raw_contacts ON (activities.author_contact_id = raw_contacts._id) LEFT OUTER JOIN contacts ON (raw_contacts.contact_id = contacts._id)");
                qb.setProjectionMap(sActivitiesContactsProjectionMap);
                qb.appendWhere((CharSequence)("author_contact_id=" + contactId));
                break;
            }
            case 3000: {
                long aggId = ContentUris.parseId((Uri)uri);
                qb.setTables("activities LEFT OUTER JOIN packages ON (activities.package_id = packages._id) LEFT OUTER JOIN mimetypes ON (activities.mimetype_id = mimetypes._id) LEFT OUTER JOIN raw_contacts ON (activities.author_contact_id = raw_contacts._id) LEFT OUTER JOIN contacts ON (raw_contacts.contact_id = contacts._id)");
                qb.setProjectionMap(sActivitiesContactsProjectionMap);
                qb.appendWhere((CharSequence)"in_reply_to IS NULL AND ");
                qb.appendWhere((CharSequence)("author_contact_id IN (SELECT _id FROM raw_contacts WHERE contact_id=" + aggId + ")"));
                sortOrder = "published DESC";
                limit = "1";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown uri: " + uri);
            }
        }
        if (sortOrder == null) {
            sortOrder = DEFAULT_SORT_ORDER;
        }
        if ((c = qb.query(db, projection, selection, selectionArgs, null, null, sortOrder, limit)) != null) {
            c.setNotificationUri(this.getContext().getContentResolver(), ContactsContract.AUTHORITY_URI);
        }
        return c;
    }

    public String getType(Uri uri) {
        int match = sUriMatcher.match(uri);
        switch (match) {
            case 1000: 
            case 1002: {
                return "vnd.android.cursor.dir/activity";
            }
            case 1001: {
                SQLiteDatabase db = this.mDbHelper.getReadableDatabase();
                long activityId = ContentUris.parseId((Uri)uri);
                return this.mDbHelper.getActivityMimeType(activityId);
            }
            case 3000: {
                return "vnd.android.cursor.item/contact";
            }
        }
        throw new UnsupportedOperationException("Unknown uri: " + uri);
    }

    static {
        UriMatcher matcher = sUriMatcher = new UriMatcher(-1);
        matcher.addURI("com.android.social", "activities", 1000);
        matcher.addURI("com.android.social", "activities/#", 1001);
        matcher.addURI("com.android.social", "activities/authored_by/#", 1002);
        matcher.addURI("com.android.social", "contact_status/#", 3000);
        HashMap<String, String> columns = new HashMap<String, String>();
        columns.put("display_name", "contact.display_name AS display_name");
        sContactsProjectionMap = columns;
        columns = new HashMap();
        columns.put("_id", "raw_contacts._id AS _id");
        columns.put("contact_id", "contact_id");
        sRawContactsProjectionMap = columns;
        columns = new HashMap();
        columns.put("_id", "activities._id AS _id");
        columns.put("res_package", "package AS res_package");
        columns.put("mimetype", "mimetype");
        columns.put("raw_id", "raw_id");
        columns.put("in_reply_to", "in_reply_to");
        columns.put("author_contact_id", "author_contact_id");
        columns.put("target_contact_id", "target_contact_id");
        columns.put("published", "published");
        columns.put("thread_published", "thread_published");
        columns.put("title", "title");
        columns.put("summary", "summary");
        columns.put("link", "link");
        columns.put("thumbnail", "thumbnail");
        sActivitiesProjectionMap = columns;
        columns = new HashMap();
        columns.putAll(sContactsProjectionMap);
        columns.putAll(sRawContactsProjectionMap);
        columns.putAll(sActivitiesProjectionMap);
        sActivitiesContactsProjectionMap = columns;
    }
}

