/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteTransactionListener;
import android.net.Uri;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQLiteContentProvider
extends ContentProvider
implements SQLiteTransactionListener {
    private static final String TAG = "SQLiteContentProvider";
    private SQLiteOpenHelper mOpenHelper;
    private volatile boolean mNotifyChange;
    protected SQLiteDatabase mDb;
    private final ThreadLocal<Boolean> mApplyingBatch = new ThreadLocal();
    private static final int SLEEP_AFTER_YIELD_DELAY = 4000;
    private static final int MAX_OPERATIONS_PER_YIELD_POINT = 500;

    public boolean onCreate() {
        Context context = this.getContext();
        this.mOpenHelper = this.getDatabaseHelper(context);
        return true;
    }

    protected abstract SQLiteOpenHelper getDatabaseHelper(Context var1);

    protected abstract Uri insertInTransaction(Uri var1, ContentValues var2);

    protected abstract int updateInTransaction(Uri var1, ContentValues var2, String var3, String[] var4);

    protected abstract int deleteInTransaction(Uri var1, String var2, String[] var3);

    protected abstract void notifyChange();

    protected SQLiteOpenHelper getDatabaseHelper() {
        return this.mOpenHelper;
    }

    private boolean applyingBatch() {
        return this.mApplyingBatch.get() != null && this.mApplyingBatch.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri insert(Uri uri, ContentValues values) {
        Uri result = null;
        boolean applyingBatch = this.applyingBatch();
        if (!applyingBatch) {
            this.mDb = this.mOpenHelper.getWritableDatabase();
            this.mDb.beginTransactionWithListener((SQLiteTransactionListener)this);
            try {
                result = this.insertInTransaction(uri, values);
                if (result != null) {
                    this.mNotifyChange = true;
                }
                this.mDb.setTransactionSuccessful();
            }
            finally {
                this.mDb.endTransaction();
            }
            this.onEndTransaction();
        } else {
            result = this.insertInTransaction(uri, values);
            if (result != null) {
                this.mNotifyChange = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkInsert(Uri uri, ContentValues[] values) {
        int numValues = values.length;
        this.mDb = this.mOpenHelper.getWritableDatabase();
        this.mDb.beginTransactionWithListener((SQLiteTransactionListener)this);
        try {
            for (int i = 0; i < numValues; ++i) {
                Uri result = this.insertInTransaction(uri, values[i]);
                if (result != null) {
                    this.mNotifyChange = true;
                }
                this.mDb.yieldIfContendedSafely();
            }
            this.mDb.setTransactionSuccessful();
        }
        finally {
            this.mDb.endTransaction();
        }
        this.onEndTransaction();
        return numValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        int count = 0;
        boolean applyingBatch = this.applyingBatch();
        if (!applyingBatch) {
            this.mDb = this.mOpenHelper.getWritableDatabase();
            this.mDb.beginTransactionWithListener((SQLiteTransactionListener)this);
            try {
                count = this.updateInTransaction(uri, values, selection, selectionArgs);
                if (count > 0) {
                    this.mNotifyChange = true;
                }
                this.mDb.setTransactionSuccessful();
            }
            finally {
                this.mDb.endTransaction();
            }
            this.onEndTransaction();
        } else {
            count = this.updateInTransaction(uri, values, selection, selectionArgs);
            if (count > 0) {
                this.mNotifyChange = true;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        int count = 0;
        boolean applyingBatch = this.applyingBatch();
        if (!applyingBatch) {
            this.mDb = this.mOpenHelper.getWritableDatabase();
            this.mDb.beginTransactionWithListener((SQLiteTransactionListener)this);
            try {
                count = this.deleteInTransaction(uri, selection, selectionArgs);
                if (count > 0) {
                    this.mNotifyChange = true;
                }
                this.mDb.setTransactionSuccessful();
            }
            finally {
                this.mDb.endTransaction();
            }
            this.onEndTransaction();
        } else {
            count = this.deleteInTransaction(uri, selection, selectionArgs);
            if (count > 0) {
                this.mNotifyChange = true;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        int ypCount = 0;
        int opCount = 0;
        this.mDb = this.mOpenHelper.getWritableDatabase();
        this.mDb.beginTransactionWithListener((SQLiteTransactionListener)this);
        try {
            this.mApplyingBatch.set(true);
            int numOperations = operations.size();
            ContentProviderResult[] results = new ContentProviderResult[numOperations];
            for (int i = 0; i < numOperations; ++i) {
                if (++opCount >= 500) {
                    throw new OperationApplicationException("Too many content provider operations between yield points. The maximum number of operations per yield point is 500", ypCount);
                }
                ContentProviderOperation operation = operations.get(i);
                if (i > 0 && operation.isYieldAllowed()) {
                    opCount = 0;
                    if (this.mDb.yieldIfContendedSafely(4000L)) {
                        ++ypCount;
                    }
                }
                results[i] = operation.apply((ContentProvider)this, results, i);
            }
            this.mDb.setTransactionSuccessful();
            ContentProviderResult[] contentProviderResultArray = results;
            return contentProviderResultArray;
        }
        finally {
            this.mApplyingBatch.set(false);
            this.mDb.endTransaction();
            this.onEndTransaction();
        }
    }

    public void onBegin() {
        this.onBeginTransaction();
    }

    public void onCommit() {
        this.beforeTransactionCommit();
    }

    public void onRollback() {
    }

    protected void onBeginTransaction() {
    }

    protected void beforeTransactionCommit() {
    }

    protected void onEndTransaction() {
        if (this.mNotifyChange) {
            this.mNotifyChange = false;
            this.notifyChange();
        }
    }
}

