/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import android.database.AbstractCursor;
import android.database.Cursor;

public class ReorderingCursorWrapper
extends AbstractCursor {
    private final Cursor mCursor;
    private final int[] mPositionMap;

    public ReorderingCursorWrapper(Cursor cursor, int[] positionMap) {
        if (cursor.getCount() != positionMap.length) {
            throw new IllegalArgumentException("Cursor and position map have different sizes.");
        }
        this.mCursor = cursor;
        this.mPositionMap = positionMap;
    }

    public void close() {
        super.close();
        this.mCursor.close();
    }

    public boolean onMove(int oldPosition, int newPosition) {
        return this.mCursor.moveToPosition(this.mPositionMap[newPosition]);
    }

    public String[] getColumnNames() {
        return this.mCursor.getColumnNames();
    }

    public int getCount() {
        return this.mCursor.getCount();
    }

    public double getDouble(int column) {
        return this.mCursor.getDouble(column);
    }

    public float getFloat(int column) {
        return this.mCursor.getFloat(column);
    }

    public int getInt(int column) {
        return this.mCursor.getInt(column);
    }

    public long getLong(int column) {
        return this.mCursor.getLong(column);
    }

    public short getShort(int column) {
        return this.mCursor.getShort(column);
    }

    public String getString(int column) {
        return this.mCursor.getString(column);
    }

    public boolean isNull(int column) {
        return this.mCursor.isNull(column);
    }
}

