/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import android.content.ContentValues;
import android.text.TextUtils;
import java.util.Locale;

public class PostalSplitter {
    private static final String JAPANESE_LANGUAGE = Locale.JAPANESE.getLanguage().toLowerCase();
    private final Locale mLocale;
    private static final String NEWLINE = "\n";
    private static final String COMMA = ",";
    private static final String SPACE = " ";

    public PostalSplitter(Locale locale) {
        this.mLocale = locale;
    }

    public void split(Postal postal, String formattedAddress) {
        if (!TextUtils.isEmpty((CharSequence)formattedAddress)) {
            postal.street = formattedAddress;
        }
    }

    public String join(Postal postal) {
        String[] values = new String[]{postal.street, postal.pobox, postal.neighborhood, postal.city, postal.region, postal.postcode, postal.country};
        if (this.mLocale != null && JAPANESE_LANGUAGE.equals(this.mLocale.getLanguage()) && !PostalSplitter.arePrintableAsciiOnly(values)) {
            return this.joinJaJp(postal);
        }
        return this.joinEnUs(postal);
    }

    private String joinJaJp(Postal postal) {
        boolean hasThirdBlock;
        boolean hasStreet = !TextUtils.isEmpty((CharSequence)postal.street);
        boolean hasPobox = !TextUtils.isEmpty((CharSequence)postal.pobox);
        boolean hasNeighborhood = !TextUtils.isEmpty((CharSequence)postal.neighborhood);
        boolean hasCity = !TextUtils.isEmpty((CharSequence)postal.city);
        boolean hasRegion = !TextUtils.isEmpty((CharSequence)postal.region);
        boolean hasPostcode = !TextUtils.isEmpty((CharSequence)postal.postcode);
        boolean hasCountry = !TextUtils.isEmpty((CharSequence)postal.country);
        StringBuilder builder = new StringBuilder();
        boolean hasFirstBlock = hasCountry || hasPostcode;
        boolean hasSecondBlock = hasRegion || hasCity || hasNeighborhood;
        boolean bl = hasThirdBlock = hasStreet || hasPobox;
        if (hasFirstBlock) {
            if (hasCountry) {
                builder.append(postal.country);
            }
            if (hasPostcode) {
                if (hasCountry) {
                    builder.append(SPACE);
                }
                builder.append(postal.postcode);
            }
        }
        if (hasSecondBlock) {
            if (hasFirstBlock) {
                builder.append(NEWLINE);
            }
            if (hasRegion) {
                builder.append(postal.region);
            }
            if (hasCity) {
                if (hasRegion) {
                    builder.append(SPACE);
                }
                builder.append(postal.city);
            }
            if (hasNeighborhood) {
                if (hasRegion || hasCity) {
                    builder.append(SPACE);
                }
                builder.append(postal.neighborhood);
            }
        }
        if (hasThirdBlock) {
            if (hasFirstBlock || hasSecondBlock) {
                builder.append(NEWLINE);
            }
            if (hasStreet) {
                builder.append(postal.street);
            }
            if (hasPobox) {
                if (hasStreet) {
                    builder.append(SPACE);
                }
                builder.append(postal.pobox);
            }
        }
        if (builder.length() > 0) {
            return builder.toString();
        }
        return null;
    }

    private String joinEnUs(Postal postal) {
        boolean hasStreet = !TextUtils.isEmpty((CharSequence)postal.street);
        boolean hasPobox = !TextUtils.isEmpty((CharSequence)postal.pobox);
        boolean hasNeighborhood = !TextUtils.isEmpty((CharSequence)postal.neighborhood);
        boolean hasCity = !TextUtils.isEmpty((CharSequence)postal.city);
        boolean hasRegion = !TextUtils.isEmpty((CharSequence)postal.region);
        boolean hasPostcode = !TextUtils.isEmpty((CharSequence)postal.postcode);
        boolean hasCountry = !TextUtils.isEmpty((CharSequence)postal.country);
        StringBuilder builder = new StringBuilder();
        boolean hasFirstBlock = hasStreet || hasPobox || hasNeighborhood;
        boolean hasSecondBlock = hasCity || hasRegion || hasPostcode;
        boolean hasThirdBlock = hasCountry;
        if (hasFirstBlock) {
            if (hasStreet) {
                builder.append(postal.street);
            }
            if (hasPobox) {
                if (hasStreet) {
                    builder.append(NEWLINE);
                }
                builder.append(postal.pobox);
            }
            if (hasNeighborhood) {
                if (hasStreet || hasPobox) {
                    builder.append(NEWLINE);
                }
                builder.append(postal.neighborhood);
            }
        }
        if (hasSecondBlock) {
            if (hasFirstBlock) {
                builder.append(NEWLINE);
            }
            if (hasCity) {
                builder.append(postal.city);
            }
            if (hasRegion) {
                if (hasCity) {
                    builder.append(", ");
                }
                builder.append(postal.region);
            }
            if (hasPostcode) {
                if (hasCity || hasRegion) {
                    builder.append(SPACE);
                }
                builder.append(postal.postcode);
            }
        }
        if (hasThirdBlock) {
            if (hasFirstBlock || hasSecondBlock) {
                builder.append(NEWLINE);
            }
            if (hasCountry) {
                builder.append(postal.country);
            }
        }
        if (builder.length() > 0) {
            return builder.toString();
        }
        return null;
    }

    private static boolean arePrintableAsciiOnly(String[] values) {
        if (values == null) {
            return true;
        }
        for (String value : values) {
            if (TextUtils.isEmpty((CharSequence)value) || TextUtils.isPrintableAsciiOnly((CharSequence)value)) continue;
            return false;
        }
        return true;
    }

    public static class Postal {
        public String street;
        public String pobox;
        public String neighborhood;
        public String city;
        public String region;
        public String postcode;
        public String country;

        public void fromValues(ContentValues values) {
            this.street = values.getAsString("data4");
            this.pobox = values.getAsString("data5");
            this.neighborhood = values.getAsString("data6");
            this.city = values.getAsString("data7");
            this.region = values.getAsString("data8");
            this.postcode = values.getAsString("data9");
            this.country = values.getAsString("data10");
        }

        public void toValues(ContentValues values) {
            values.put("data4", this.street);
            values.put("data5", this.pobox);
            values.put("data6", this.neighborhood);
            values.put("data7", this.city);
            values.put("data8", this.region);
            values.put("data9", this.postcode);
            values.put("data10", this.country);
        }
    }
}

