/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import android.accounts.AccountManager;
import android.accounts.AuthenticatorDescription;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.res.XmlResourceParser;
import android.util.Log;
import com.android.internal.util.XmlUtils;
import com.google.android.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PhotoPriorityResolver {
    private static final String TAG = "PhotoPriorityResolver";
    public static final int DEFAULT_PRIORITY = 7;
    private static final String METADATA_CONTACTS = "android.provider.CONTACTS_STRUCTURE";
    private static final String PICTURE_TAG = "Picture";
    private static final String PRIORITY_ATTR = "priority";
    private Context mContext;
    private HashMap<String, Integer> mPhotoPriorities = Maps.newHashMap();

    public PhotoPriorityResolver(Context context) {
        this.mContext = context;
    }

    public synchronized int getPhotoPriority(String accountType) {
        if (accountType == null) {
            return 7;
        }
        Integer priority = this.mPhotoPriorities.get(accountType);
        if (priority == null) {
            priority = this.resolvePhotoPriority(accountType);
            this.mPhotoPriorities.put(accountType, priority);
        }
        return priority;
    }

    private int resolvePhotoPriority(String accountType) {
        AccountManager am = AccountManager.get((Context)this.mContext);
        for (AuthenticatorDescription auth : am.getAuthenticatorTypes()) {
            if (!accountType.equals(auth.type)) continue;
            return this.resolvePhotoPriorityFromMetaData(auth.packageName);
        }
        return 7;
    }

    int resolvePhotoPriorityFromMetaData(String packageName) {
        PackageManager pm = this.mContext.getPackageManager();
        try {
            PackageInfo pi = pm.getPackageInfo(packageName, 132);
            if (pi != null && pi.services != null) {
                for (ServiceInfo si : pi.services) {
                    XmlResourceParser parser = si.loadXmlMetaData(pm, METADATA_CONTACTS);
                    if (parser == null) continue;
                    return this.loadPhotoPriorityFromXml(this.mContext, (XmlPullParser)parser);
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)TAG, (String)("Problem loading photo priorities: " + e.toString()));
        }
        return 7;
    }

    private int loadPhotoPriorityFromXml(Context context, XmlPullParser parser) {
        int priority = 7;
        try {
            int type;
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new IllegalStateException("No start tag found");
            }
            int depth = parser.getDepth();
            while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
                String name = parser.getName();
                if (type != 2 || !PICTURE_TAG.equals(name)) continue;
                int attributeCount = parser.getAttributeCount();
                for (int i = 0; i < attributeCount; ++i) {
                    String attr2 = parser.getAttributeName(i);
                    if (!PRIORITY_ATTR.equals(attr2)) {
                        throw new IllegalStateException("Unsupported attribute " + attr2);
                    }
                    priority = XmlUtils.convertValueToInt((CharSequence)parser.getAttributeValue(i), (int)7);
                }
            }
        }
        catch (XmlPullParserException e) {
            throw new IllegalStateException("Problem reading XML", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem reading XML", e);
        }
        return priority;
    }
}

