/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import android.content.ContentValues;
import android.text.TextUtils;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameSplitter {
    public static final int MAX_TOKENS = 10;
    private static final String JAPANESE_LANGUAGE = Locale.JAPANESE.getLanguage().toLowerCase();
    private static final String KOREAN_LANGUAGE = Locale.KOREAN.getLanguage().toLowerCase();
    private static final String CHINESE_LANGUAGE = Locale.CHINESE.getLanguage().toLowerCase();
    private final HashSet<String> mPrefixesSet;
    private final HashSet<String> mSuffixesSet;
    private final int mMaxSuffixLength;
    private final HashSet<String> mLastNamePrefixesSet;
    private final HashSet<String> mConjuctions;
    private final Locale mLocale;
    private final String mLanguage;

    public NameSplitter(String commonPrefixes, String commonLastNamePrefixes, String commonSuffixes, String commonConjunctions, Locale locale) {
        this.mPrefixesSet = NameSplitter.convertToSet(commonPrefixes);
        this.mLastNamePrefixesSet = NameSplitter.convertToSet(commonLastNamePrefixes);
        this.mSuffixesSet = NameSplitter.convertToSet(commonSuffixes);
        this.mConjuctions = NameSplitter.convertToSet(commonConjunctions);
        this.mLocale = locale != null ? locale : Locale.getDefault();
        this.mLanguage = this.mLocale.getLanguage().toLowerCase();
        int maxLength = 0;
        for (String suffix : this.mSuffixesSet) {
            if (suffix.length() <= maxLength) continue;
            maxLength = suffix.length();
        }
        this.mMaxSuffixLength = maxLength;
    }

    private static HashSet<String> convertToSet(String strings) {
        HashSet<String> set = new HashSet<String>();
        if (strings != null) {
            String[] split = strings.split(",");
            for (int i = 0; i < split.length; ++i) {
                set.add(split[i].trim().toUpperCase());
            }
        }
        return set;
    }

    public int tokenize(String[] tokens, String fullName) {
        if (fullName == null) {
            return 0;
        }
        NameTokenizer tokenizer = new NameTokenizer(fullName);
        if (tokenizer.mStartPointer == tokenizer.mEndPointer) {
            return 0;
        }
        String firstToken = tokenizer.mTokens[tokenizer.mStartPointer];
        if (this.mPrefixesSet.contains(firstToken.toUpperCase())) {
            tokenizer.mStartPointer++;
        }
        int count = 0;
        for (int i = tokenizer.mStartPointer; i < tokenizer.mEndPointer; ++i) {
            tokens[count++] = tokenizer.mTokens[i];
        }
        return count;
    }

    public void split(Name name, String fullName) {
        if (fullName == null) {
            return;
        }
        int fullNameStyle = this.guessFullNameStyle(fullName);
        if (fullNameStyle == 2) {
            fullNameStyle = this.getAdjustedFullNameStyle(fullNameStyle);
        }
        name.fullNameStyle = fullNameStyle;
        switch (fullNameStyle) {
            case 3: {
                this.splitChineseName(name, fullName);
                break;
            }
            case 4: 
            case 5: {
                this.splitJapaneseOrKoreanName(name, fullName);
                break;
            }
            default: {
                this.splitWesternName(name, fullName);
            }
        }
    }

    private void splitWesternName(Name name, String fullName) {
        NameTokenizer tokens = new NameTokenizer(fullName);
        this.parsePrefix(name, tokens);
        if (tokens.mEndPointer > 2) {
            this.parseSuffix(name, tokens);
        }
        if (name.prefix == null && tokens.mEndPointer - tokens.mStartPointer == 1) {
            name.givenNames = tokens.mTokens[tokens.mStartPointer];
        } else {
            this.parseLastName(name, tokens);
            this.parseMiddleName(name, tokens);
            this.parseGivenNames(name, tokens);
        }
    }

    private void splitChineseName(Name name, String fullName) {
        StringTokenizer tokenizer = new StringTokenizer(fullName);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (name.givenNames == null) {
                name.givenNames = token;
                continue;
            }
            if (name.familyName == null) {
                name.familyName = name.givenNames;
                name.givenNames = token;
                continue;
            }
            if (name.middleName == null) {
                name.middleName = name.givenNames;
                name.givenNames = token;
                continue;
            }
            name.middleName = name.middleName + name.givenNames;
            name.givenNames = token;
        }
        if (name.givenNames != null && name.familyName == null && name.middleName == null) {
            int length = fullName.length();
            if (length == 2) {
                name.familyName = fullName.substring(0, 1);
                name.givenNames = fullName.substring(1);
            } else if (length == 3) {
                name.familyName = fullName.substring(0, 1);
                name.middleName = fullName.substring(1, 2);
                name.givenNames = fullName.substring(2);
            } else if (length == 4) {
                name.familyName = fullName.substring(0, 2);
                name.middleName = fullName.substring(2, 3);
                name.givenNames = fullName.substring(3);
            }
        }
    }

    private void splitJapaneseOrKoreanName(Name name, String fullName) {
        StringTokenizer tokenizer = new StringTokenizer(fullName);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (name.givenNames == null) {
                name.givenNames = token;
                continue;
            }
            if (name.familyName == null) {
                name.familyName = name.givenNames;
                name.givenNames = token;
                continue;
            }
            name.givenNames = name.givenNames + " " + token;
        }
    }

    public String join(Name name, boolean givenNameFirst) {
        switch (name.fullNameStyle) {
            case 2: 
            case 3: 
            case 5: {
                return this.join(name.familyName, name.middleName, name.givenNames, name.suffix, false, false, false);
            }
            case 4: {
                return this.join(name.familyName, name.middleName, name.givenNames, name.suffix, true, false, false);
            }
        }
        if (givenNameFirst) {
            return this.join(name.givenNames, name.middleName, name.familyName, name.suffix, true, false, true);
        }
        return this.join(name.familyName, name.givenNames, name.middleName, name.suffix, true, true, true);
    }

    public String joinPhoneticName(Name name) {
        return this.join(name.phoneticFamilyName, name.phoneticMiddleName, name.phoneticGivenName, null, true, false, false);
    }

    private String join(String part1, String part2, String part3, String suffix, boolean useSpace, boolean useCommaAfterPart1, boolean useCommaAfterPart3) {
        boolean hasPart1 = !TextUtils.isEmpty((CharSequence)part1);
        boolean hasPart2 = !TextUtils.isEmpty((CharSequence)part2);
        boolean hasPart3 = !TextUtils.isEmpty((CharSequence)part3);
        boolean hasSuffix = !TextUtils.isEmpty((CharSequence)suffix);
        boolean isSingleWord = true;
        String singleWord = null;
        if (hasPart1) {
            singleWord = part1;
        }
        if (hasPart2) {
            if (singleWord != null) {
                isSingleWord = false;
            } else {
                singleWord = part2;
            }
        }
        if (hasPart3) {
            if (singleWord != null) {
                isSingleWord = false;
            } else {
                singleWord = part3;
            }
        }
        if (hasSuffix) {
            if (singleWord != null) {
                isSingleWord = false;
            } else {
                singleWord = this.normalizedSuffix(suffix);
            }
        }
        if (isSingleWord) {
            return singleWord;
        }
        StringBuilder sb = new StringBuilder();
        if (hasPart1) {
            sb.append(part1);
        }
        if (hasPart2) {
            if (hasPart1) {
                if (useCommaAfterPart1) {
                    sb.append(',');
                }
                if (useSpace) {
                    sb.append(' ');
                }
            }
            sb.append(part2);
        }
        if (hasPart3) {
            if ((hasPart1 || hasPart2) && useSpace) {
                sb.append(' ');
            }
            sb.append(part3);
        }
        if (hasSuffix) {
            if (hasPart1 || hasPart2 || hasPart3) {
                if (useCommaAfterPart3) {
                    sb.append(',');
                }
                if (useSpace) {
                    sb.append(' ');
                }
            }
            sb.append(this.normalizedSuffix(suffix));
        }
        return sb.toString();
    }

    private String normalizedSuffix(String suffix) {
        int length = suffix.length();
        if (length == 0 || suffix.charAt(length - 1) == '.') {
            return suffix;
        }
        String withDot = suffix + '.';
        if (this.mSuffixesSet.contains(withDot.toUpperCase())) {
            return withDot;
        }
        return suffix;
    }

    public int getAdjustedFullNameStyle(int nameStyle) {
        if (nameStyle == 0) {
            if (JAPANESE_LANGUAGE.equals(this.mLanguage)) {
                return 4;
            }
            if (KOREAN_LANGUAGE.equals(this.mLanguage)) {
                return 5;
            }
            if (CHINESE_LANGUAGE.equals(this.mLanguage)) {
                return 3;
            }
            return 1;
        }
        if (nameStyle == 2) {
            if (JAPANESE_LANGUAGE.equals(this.mLanguage)) {
                return 4;
            }
            if (KOREAN_LANGUAGE.equals(this.mLanguage)) {
                return 5;
            }
            return 3;
        }
        return nameStyle;
    }

    private void parsePrefix(Name name, NameTokenizer tokens) {
        if (tokens.mStartPointer == tokens.mEndPointer) {
            return;
        }
        String firstToken = tokens.mTokens[tokens.mStartPointer];
        if (this.mPrefixesSet.contains(firstToken.toUpperCase())) {
            name.prefix = firstToken;
            tokens.mStartPointer++;
        }
    }

    private void parseSuffix(Name name, NameTokenizer tokens) {
        if (tokens.mStartPointer == tokens.mEndPointer) {
            return;
        }
        String lastToken = tokens.mTokens[tokens.mEndPointer - 1];
        if (lastToken.length() > this.mMaxSuffixLength) {
            return;
        }
        String normalized = lastToken.toUpperCase();
        if (this.mSuffixesSet.contains(normalized)) {
            name.suffix = lastToken;
            tokens.mEndPointer--;
            return;
        }
        if (tokens.hasDot(tokens.mEndPointer - 1)) {
            lastToken = lastToken + '.';
        }
        normalized = normalized + ".";
        int pos = tokens.mEndPointer - 1;
        while (normalized.length() <= this.mMaxSuffixLength) {
            if (this.mSuffixesSet.contains(normalized)) {
                name.suffix = lastToken;
                tokens.mEndPointer = pos;
                return;
            }
            if (pos == tokens.mStartPointer) break;
            lastToken = tokens.hasDot(--pos) ? tokens.mTokens[pos] + "." + lastToken : tokens.mTokens[pos] + " " + lastToken;
            normalized = tokens.mTokens[pos].toUpperCase() + "." + normalized;
        }
    }

    private void parseLastName(Name name, NameTokenizer tokens) {
        String lastNamePrefix;
        if (tokens.mStartPointer == tokens.mEndPointer) {
            return;
        }
        if (tokens.hasComma(tokens.mStartPointer)) {
            name.familyName = tokens.mTokens[tokens.mStartPointer];
            tokens.mStartPointer++;
            return;
        }
        if (tokens.mStartPointer + 1 < tokens.mEndPointer && tokens.hasComma(tokens.mStartPointer + 1) && this.isFamilyNamePrefix(tokens.mTokens[tokens.mStartPointer])) {
            String familyNamePrefix = tokens.mTokens[tokens.mStartPointer];
            if (tokens.hasDot(tokens.mStartPointer)) {
                familyNamePrefix = familyNamePrefix + '.';
            }
            name.familyName = familyNamePrefix + " " + tokens.mTokens[tokens.mStartPointer + 1];
            tokens.mStartPointer += 2;
            return;
        }
        name.familyName = tokens.mTokens[tokens.mEndPointer - 1];
        tokens.mEndPointer--;
        if (tokens.mEndPointer - tokens.mStartPointer > 0 && this.isFamilyNamePrefix(lastNamePrefix = tokens.mTokens[tokens.mEndPointer - 1])) {
            if (tokens.hasDot(tokens.mEndPointer - 1)) {
                lastNamePrefix = lastNamePrefix + '.';
            }
            name.familyName = lastNamePrefix + " " + name.familyName;
            tokens.mEndPointer--;
        }
    }

    private boolean isFamilyNamePrefix(String word) {
        String normalized = word.toUpperCase();
        return this.mLastNamePrefixesSet.contains(normalized) || this.mLastNamePrefixesSet.contains(normalized + ".");
    }

    private void parseMiddleName(Name name, NameTokenizer tokens) {
        if (tokens.mStartPointer == tokens.mEndPointer) {
            return;
        }
        if (!(tokens.mEndPointer - tokens.mStartPointer <= 1 || tokens.mEndPointer - tokens.mStartPointer != 2 && this.mConjuctions.contains(tokens.mTokens[tokens.mEndPointer - 2].toUpperCase()))) {
            name.middleName = tokens.mTokens[tokens.mEndPointer - 1];
            if (tokens.hasDot(tokens.mEndPointer - 1)) {
                name.middleName = name.middleName + '.';
            }
            tokens.mEndPointer--;
        }
    }

    private void parseGivenNames(Name name, NameTokenizer tokens) {
        if (tokens.mStartPointer == tokens.mEndPointer) {
            return;
        }
        if (tokens.mEndPointer - tokens.mStartPointer == 1) {
            name.givenNames = tokens.mTokens[tokens.mStartPointer];
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = tokens.mStartPointer; i < tokens.mEndPointer; ++i) {
                if (i != tokens.mStartPointer) {
                    sb.append(' ');
                }
                sb.append(tokens.mTokens[i]);
                if (!tokens.hasDot(i)) continue;
                sb.append('.');
            }
            name.givenNames = sb.toString();
        }
    }

    public void guessNameStyle(Name name) {
        this.guessFullNameStyle(name);
        this.guessPhoneticNameStyle(name);
        name.fullNameStyle = this.getAdjustedNameStyleBasedOnPhoneticNameStyle(name.fullNameStyle, name.phoneticNameStyle);
    }

    public int getAdjustedNameStyleBasedOnPhoneticNameStyle(int nameStyle, int phoneticNameStyle) {
        if (phoneticNameStyle != 0 && (nameStyle == 0 || nameStyle == 2)) {
            if (phoneticNameStyle == 4) {
                return 4;
            }
            if (phoneticNameStyle == 5) {
                return 5;
            }
            if (nameStyle == 2 && phoneticNameStyle == 3) {
                return 3;
            }
        }
        return nameStyle;
    }

    private void guessFullNameStyle(Name name) {
        if (name.fullNameStyle != 0) {
            return;
        }
        int bestGuess = this.guessFullNameStyle(name.givenNames);
        if (bestGuess != 0 && bestGuess != 2 && bestGuess != 1) {
            name.fullNameStyle = bestGuess;
            return;
        }
        int guess = this.guessFullNameStyle(name.familyName);
        if (guess != 0) {
            if (guess != 2 && guess != 1) {
                name.fullNameStyle = guess;
                return;
            }
            bestGuess = guess;
        }
        if ((guess = this.guessFullNameStyle(name.middleName)) != 0) {
            if (guess != 2 && guess != 1) {
                name.fullNameStyle = guess;
                return;
            }
            bestGuess = guess;
        }
        name.fullNameStyle = bestGuess;
    }

    public int guessFullNameStyle(String name) {
        int codePoint;
        if (name == null) {
            return 0;
        }
        int nameStyle = 0;
        int length = name.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(name, offset);
            if (!Character.isLetter(codePoint)) continue;
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(codePoint);
            if (!NameSplitter.isLatinUnicodeBlock(unicodeBlock)) {
                if (NameSplitter.isCJKUnicodeBlock(unicodeBlock)) {
                    return this.guessCJKNameStyle(name, offset + Character.charCount(codePoint));
                }
                if (NameSplitter.isJapanesePhoneticUnicodeBlock(unicodeBlock)) {
                    return 4;
                }
                if (NameSplitter.isKoreanUnicodeBlock(unicodeBlock)) {
                    return 5;
                }
            }
            nameStyle = 1;
        }
        return nameStyle;
    }

    private int guessCJKNameStyle(String name, int offset) {
        int length = name.length();
        while (offset < length) {
            int codePoint = Character.codePointAt(name, offset);
            if (Character.isLetter(codePoint)) {
                Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(codePoint);
                if (NameSplitter.isJapanesePhoneticUnicodeBlock(unicodeBlock)) {
                    return 4;
                }
                if (NameSplitter.isKoreanUnicodeBlock(unicodeBlock)) {
                    return 5;
                }
            }
            offset += Character.charCount(codePoint);
        }
        return 2;
    }

    private void guessPhoneticNameStyle(Name name) {
        if (name.phoneticNameStyle != 0) {
            return;
        }
        int bestGuess = this.guessPhoneticNameStyle(name.phoneticFamilyName);
        if (bestGuess != 0 && bestGuess != 2) {
            name.phoneticNameStyle = bestGuess;
            return;
        }
        int guess = this.guessPhoneticNameStyle(name.phoneticGivenName);
        if (guess != 0) {
            if (guess != 2) {
                name.phoneticNameStyle = guess;
                return;
            }
            bestGuess = guess;
        }
        if ((guess = this.guessPhoneticNameStyle(name.phoneticMiddleName)) != 0) {
            if (guess != 2) {
                name.phoneticNameStyle = guess;
                return;
            }
            bestGuess = guess;
        }
    }

    public int guessPhoneticNameStyle(String name) {
        int codePoint;
        if (name == null) {
            return 0;
        }
        int nameStyle = 0;
        int length = name.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(name, offset);
            if (!Character.isLetter(codePoint)) continue;
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(codePoint);
            if (NameSplitter.isJapanesePhoneticUnicodeBlock(unicodeBlock)) {
                return 4;
            }
            if (NameSplitter.isKoreanUnicodeBlock(unicodeBlock)) {
                return 5;
            }
            if (!NameSplitter.isLatinUnicodeBlock(unicodeBlock)) continue;
            return 3;
        }
        return nameStyle;
    }

    private static boolean isLatinUnicodeBlock(Character.UnicodeBlock unicodeBlock) {
        return unicodeBlock == Character.UnicodeBlock.BASIC_LATIN || unicodeBlock == Character.UnicodeBlock.LATIN_1_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_A || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_B || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL;
    }

    private static boolean isCJKUnicodeBlock(Character.UnicodeBlock block) {
        return block == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || block == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || block == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || block == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || block == Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT || block == Character.UnicodeBlock.CJK_COMPATIBILITY || block == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || block == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || block == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT;
    }

    private static boolean isKoreanUnicodeBlock(Character.UnicodeBlock unicodeBlock) {
        return unicodeBlock == Character.UnicodeBlock.HANGUL_SYLLABLES || unicodeBlock == Character.UnicodeBlock.HANGUL_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO;
    }

    private static boolean isJapanesePhoneticUnicodeBlock(Character.UnicodeBlock unicodeBlock) {
        return unicodeBlock == Character.UnicodeBlock.KATAKANA || unicodeBlock == Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS || unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || unicodeBlock == Character.UnicodeBlock.HIRAGANA;
    }

    private static class NameTokenizer
    extends StringTokenizer {
        private final String[] mTokens = new String[10];
        private int mDotBitmask;
        private int mCommaBitmask;
        private int mStartPointer;
        private int mEndPointer;

        public NameTokenizer(String fullName) {
            super(fullName, " .,", true);
            while (this.hasMoreTokens() && this.mEndPointer < 10) {
                char c;
                String token = this.nextToken();
                if (token.length() > 0 && (c = token.charAt(0)) == ' ') continue;
                if (this.mEndPointer > 0 && token.charAt(0) == '.') {
                    this.mDotBitmask |= 1 << this.mEndPointer - 1;
                    continue;
                }
                if (this.mEndPointer > 0 && token.charAt(0) == ',') {
                    this.mCommaBitmask |= 1 << this.mEndPointer - 1;
                    continue;
                }
                this.mTokens[this.mEndPointer] = token;
                ++this.mEndPointer;
            }
        }

        public boolean hasDot(int index) {
            return (this.mDotBitmask & 1 << index) != 0;
        }

        public boolean hasComma(int index) {
            return (this.mCommaBitmask & 1 << index) != 0;
        }
    }

    public static class Name {
        public String prefix;
        public String givenNames;
        public String middleName;
        public String familyName;
        public String suffix;
        public int fullNameStyle;
        public String phoneticFamilyName;
        public String phoneticMiddleName;
        public String phoneticGivenName;
        public int phoneticNameStyle;

        public Name() {
        }

        public Name(String prefix, String givenNames, String middleName, String familyName, String suffix) {
            this.prefix = prefix;
            this.givenNames = givenNames;
            this.middleName = middleName;
            this.familyName = familyName;
            this.suffix = suffix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getGivenNames() {
            return this.givenNames;
        }

        public String getMiddleName() {
            return this.middleName;
        }

        public String getFamilyName() {
            return this.familyName;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public int getFullNameStyle() {
            return this.fullNameStyle;
        }

        public String getPhoneticFamilyName() {
            return this.phoneticFamilyName;
        }

        public String getPhoneticMiddleName() {
            return this.phoneticMiddleName;
        }

        public String getPhoneticGivenName() {
            return this.phoneticGivenName;
        }

        public int getPhoneticNameStyle() {
            return this.phoneticNameStyle;
        }

        public void fromValues(ContentValues values) {
            this.prefix = values.getAsString("data4");
            this.givenNames = values.getAsString("data2");
            this.middleName = values.getAsString("data5");
            this.familyName = values.getAsString("data3");
            this.suffix = values.getAsString("data6");
            Integer integer = values.getAsInteger("data10");
            this.fullNameStyle = integer == null ? 0 : integer;
            this.phoneticFamilyName = values.getAsString("data9");
            this.phoneticMiddleName = values.getAsString("data8");
            this.phoneticGivenName = values.getAsString("data7");
            integer = values.getAsInteger("data11");
            this.phoneticNameStyle = integer == null ? 0 : integer;
        }

        public void toValues(ContentValues values) {
            this.putValueIfPresent(values, "data4", this.prefix);
            this.putValueIfPresent(values, "data2", this.givenNames);
            this.putValueIfPresent(values, "data5", this.middleName);
            this.putValueIfPresent(values, "data3", this.familyName);
            this.putValueIfPresent(values, "data6", this.suffix);
            values.put("data10", Integer.valueOf(this.fullNameStyle));
            this.putValueIfPresent(values, "data9", this.phoneticFamilyName);
            this.putValueIfPresent(values, "data8", this.phoneticMiddleName);
            this.putValueIfPresent(values, "data7", this.phoneticGivenName);
            values.put("data11", Integer.valueOf(this.phoneticNameStyle));
        }

        private void putValueIfPresent(ContentValues values, String name, String value) {
            if (value != null) {
                values.put(name, value);
            }
        }

        public void clear() {
            this.prefix = null;
            this.givenNames = null;
            this.middleName = null;
            this.familyName = null;
            this.suffix = null;
            this.fullNameStyle = 0;
            this.phoneticFamilyName = null;
            this.phoneticMiddleName = null;
            this.phoneticGivenName = null;
            this.phoneticNameStyle = 0;
        }

        public boolean isEmpty() {
            return TextUtils.isEmpty((CharSequence)this.givenNames) && TextUtils.isEmpty((CharSequence)this.middleName) && TextUtils.isEmpty((CharSequence)this.familyName) && TextUtils.isEmpty((CharSequence)this.suffix) && TextUtils.isEmpty((CharSequence)this.phoneticFamilyName) && TextUtils.isEmpty((CharSequence)this.phoneticMiddleName) && TextUtils.isEmpty((CharSequence)this.phoneticGivenName);
        }

        public String toString() {
            return "[given: " + this.givenNames + " middle: " + this.middleName + " family: " + this.familyName + " ph/given: " + this.phoneticGivenName + " ph/middle: " + this.phoneticMiddleName + " ph/family: " + this.phoneticFamilyName + "]";
        }
    }
}

