/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import com.android.providers.contacts.Hex;
import com.ibm.icu4jni.text.CollationKey;
import com.ibm.icu4jni.text.Collator;
import com.ibm.icu4jni.text.RuleBasedCollator;
import java.util.Locale;

public class NameNormalizer {
    private static final RuleBasedCollator sCompressingCollator = (RuleBasedCollator)Collator.getInstance((Locale)Locale.getDefault());
    private static final RuleBasedCollator sComplexityCollator;

    public static String normalize(String name) {
        CollationKey key = sCompressingCollator.getCollationKey(NameNormalizer.lettersAndDigitsOnly(name));
        return Hex.encodeHex(key.toByteArray(), true);
    }

    public static int compareComplexity(String name1, String name2) {
        int diff = sComplexityCollator.compare(NameNormalizer.lettersAndDigitsOnly(name1), NameNormalizer.lettersAndDigitsOnly(name2));
        if (diff != 0) {
            return diff;
        }
        return name1.length() - name2.length();
    }

    private static String lettersAndDigitsOnly(String name) {
        char[] letters = name.toCharArray();
        int length = 0;
        for (int i = 0; i < letters.length; ++i) {
            char c = letters[i];
            if (!Character.isLetterOrDigit(c)) continue;
            letters[length++] = c;
        }
        if (length != letters.length) {
            return new String(letters, 0, length);
        }
        return name;
    }

    static {
        sCompressingCollator.setStrength(0);
        sCompressingCollator.setDecomposition(17);
        sComplexityCollator = (RuleBasedCollator)Collator.getInstance((Locale)Locale.getDefault());
        sComplexityCollator.setStrength(2);
        sComplexityCollator.setAttribute(2, 24);
    }
}

