/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import com.android.providers.contacts.ContactLocaleUtils;
import com.android.providers.contacts.NameNormalizer;
import com.android.providers.contacts.NameSplitter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public abstract class NameLookupBuilder {
    private static final int MAX_NAME_TOKENS = 4;
    private final NameSplitter mSplitter;
    private String[][] mNicknameClusters = new String[4][];
    private StringBuilder mStringBuilder = new StringBuilder();
    private String[] mNames = new String[10];
    private static int[] KOREAN_JAUM_CONVERT_MAP = new int[]{4352, 4353, 0, 4354, 0, 0, 4355, 4356, 4357, 0, 0, 0, 0, 0, 0, 0, 4358, 4359, 4360, 0, 4361, 4362, 4363, 4364, 4365, 4366, 4367, 4368, 4369, 4370};
    private static int KOREAN_JAUM_CONVERT_MAP_COUNT = 30;

    public NameLookupBuilder(NameSplitter splitter) {
        this.mSplitter = splitter;
    }

    protected abstract void insertNameLookup(long var1, long var3, int var5, String var6);

    protected abstract String[] getCommonNicknameClusters(String var1);

    public void insertNameLookup(long rawContactId, long dataId, String name, int fullNameStyle) {
        boolean tooManyTokens;
        int tokenCount = this.mSplitter.tokenize(this.mNames, name);
        if (tokenCount == 0) {
            return;
        }
        for (int i = 0; i < tokenCount; ++i) {
            this.mNames[i] = this.normalizeName(this.mNames[i]);
        }
        boolean bl = tooManyTokens = tokenCount > 4;
        if (tooManyTokens) {
            this.insertNameVariant(rawContactId, dataId, tokenCount, 0, true);
            Arrays.sort(this.mNames, 0, tokenCount, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s2.length() - s1.length();
                }
            });
            String firstToken = this.mNames[0];
            for (int i = 4; i < tokenCount; ++i) {
                this.mNames[0] = this.mNames[i];
                this.insertCollationKey(rawContactId, dataId, 4);
            }
            this.mNames[0] = firstToken;
            tokenCount = 4;
        }
        for (int i = 0; i < tokenCount; ++i) {
            this.mNicknameClusters[i] = this.getCommonNicknameClusters(this.mNames[i]);
        }
        this.insertNameVariants(rawContactId, dataId, 0, tokenCount, !tooManyTokens, true);
        this.insertNicknamePermutations(rawContactId, dataId, 0, tokenCount);
        this.insertNameShorthandLookup(rawContactId, dataId, name, fullNameStyle);
        this.insertLocaleBasedSpecificLookup(rawContactId, dataId, name, fullNameStyle);
    }

    private void insertLocaleBasedSpecificLookup(long rawContactId, long dataId, String name, int fullNameStyle) {
        if (fullNameStyle == 5) {
            this.insertKoreanNameConsonantsLookup(rawContactId, dataId, name);
        }
    }

    private void insertKoreanNameConsonantsLookup(long rawContactId, long dataId, String name) {
        int position = 0;
        int consonantLength = 0;
        int stringLength = name.length();
        this.mStringBuilder.setLength(0);
        do {
            int character;
            if ((character = name.codePointAt(position++)) == 32) continue;
            if (character < 4352 || character > 4370 && character < 12593 || character > 12622 && character < 44032 || character > 55203) break;
            if (character >= 44032) {
                character = 4352 + (character - 44032) / 588;
            } else if (character >= 12593 && (character - 12593 >= KOREAN_JAUM_CONVERT_MAP_COUNT || (character = KOREAN_JAUM_CONVERT_MAP[character - 12593]) == 0)) break;
            this.mStringBuilder.appendCodePoint(character);
            ++consonantLength;
        } while (position < stringLength);
        if (consonantLength > 1) {
            this.insertNameLookup(rawContactId, dataId, 7, this.normalizeName(this.mStringBuilder.toString()));
        }
    }

    protected String normalizeName(String name) {
        return NameNormalizer.normalize(name);
    }

    private void insertNameVariants(long rawContactId, long dataId, int fromIndex, int toIndex, boolean initiallyExact, boolean buildCollationKey) {
        if (fromIndex == toIndex) {
            this.insertNameVariant(rawContactId, dataId, toIndex, initiallyExact ? 0 : 1, buildCollationKey);
            return;
        }
        String firstToken = this.mNames[fromIndex];
        for (int i = fromIndex; i < toIndex; ++i) {
            this.mNames[fromIndex] = this.mNames[i];
            this.mNames[i] = firstToken;
            this.insertNameVariants(rawContactId, dataId, fromIndex + 1, toIndex, initiallyExact && i == fromIndex, buildCollationKey);
            this.mNames[i] = this.mNames[fromIndex];
            this.mNames[fromIndex] = firstToken;
        }
    }

    private void insertNameVariant(long rawContactId, long dataId, int tokenCount, int lookupType, boolean buildCollationKey) {
        this.mStringBuilder.setLength(0);
        for (int i = 0; i < tokenCount; ++i) {
            if (i != 0) {
                this.mStringBuilder.append('.');
            }
            this.mStringBuilder.append(this.mNames[i]);
        }
        this.insertNameLookup(rawContactId, dataId, lookupType, this.mStringBuilder.toString());
        if (buildCollationKey) {
            this.insertCollationKey(rawContactId, dataId, tokenCount);
        }
    }

    private void insertCollationKey(long rawContactId, long dataId, int tokenCount) {
        this.mStringBuilder.setLength(0);
        for (int i = 0; i < tokenCount; ++i) {
            this.mStringBuilder.append(this.mNames[i]);
        }
        this.insertNameLookup(rawContactId, dataId, 2, this.mStringBuilder.toString());
    }

    private void insertNicknamePermutations(long rawContactId, long dataId, int fromIndex, int tokenCount) {
        for (int i = fromIndex; i < tokenCount; ++i) {
            String[] clusters = this.mNicknameClusters[i];
            if (clusters == null) continue;
            String token = this.mNames[i];
            for (int j = 0; j < clusters.length; ++j) {
                this.mNames[i] = clusters[j];
                this.insertNameVariants(rawContactId, dataId, 0, tokenCount, false, false);
                this.insertNicknamePermutations(rawContactId, dataId, i + 1, tokenCount);
            }
            this.mNames[i] = token;
        }
    }

    private void insertNameShorthandLookup(long rawContactId, long dataId, String name, int fullNameStyle) {
        Iterator<String> it = ContactLocaleUtils.getIntance().getNameLookupKeys(name, fullNameStyle);
        if (it != null) {
            while (it.hasNext()) {
                String key = it.next();
                this.insertNameLookup(rawContactId, dataId, 6, this.normalizeName(key));
            }
        }
    }
}

