/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import java.util.Arrays;

public class NameDistance {
    private static final float WINKLER_BONUS_THRESHOLD = 0.7f;
    private static final int MIN_EXACT_PREFIX_LENGTH = 3;
    private final int mMaxLength;
    private final boolean mPrefixOnly;
    private final boolean[] mMatchFlags1;
    private final boolean[] mMatchFlags2;

    public NameDistance(int maxLength) {
        this.mMaxLength = maxLength;
        this.mPrefixOnly = false;
        this.mMatchFlags1 = new boolean[maxLength];
        this.mMatchFlags2 = new boolean[maxLength];
    }

    public NameDistance() {
        this.mPrefixOnly = true;
        this.mMaxLength = 0;
        this.mMatchFlags2 = null;
        this.mMatchFlags1 = null;
    }

    public float getDistance(byte[] bytes1, byte[] bytes2) {
        int length2;
        byte[] array1;
        byte[] array2;
        if (bytes1.length > bytes2.length) {
            array2 = bytes1;
            array1 = bytes2;
        } else {
            array2 = bytes2;
            array1 = bytes1;
        }
        int length1 = array1.length;
        if (length1 >= 3) {
            boolean prefix = true;
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i] == array2[i]) continue;
                prefix = false;
                break;
            }
            if (prefix) {
                return 1.0f;
            }
        }
        if (this.mPrefixOnly) {
            return 0.0f;
        }
        if (length1 > this.mMaxLength) {
            length1 = this.mMaxLength;
        }
        if ((length2 = array2.length) > this.mMaxLength) {
            length2 = this.mMaxLength;
        }
        Arrays.fill(this.mMatchFlags1, 0, length1, false);
        Arrays.fill(this.mMatchFlags2, 0, length2, false);
        int range = length2 / 2 - 1;
        if (range < 0) {
            range = 0;
        }
        int matches = 0;
        block1: for (int i = 0; i < length1; ++i) {
            int to;
            byte c1 = array1[i];
            int from = i - range;
            if (from < 0) {
                from = 0;
            }
            if ((to = i + range + 1) > length2) {
                to = length2;
            }
            for (int j = from; j < to; ++j) {
                if (this.mMatchFlags2[j] || c1 != array2[j]) continue;
                this.mMatchFlags2[j] = true;
                this.mMatchFlags1[i] = true;
                ++matches;
                continue block1;
            }
        }
        if (matches == 0) {
            return 0.0f;
        }
        int transpositions = 0;
        int j = 0;
        for (int i = 0; i < length1; ++i) {
            if (!this.mMatchFlags1[i]) continue;
            while (!this.mMatchFlags2[j]) {
                ++j;
            }
            if (array1[i] != array2[j]) {
                ++transpositions;
            }
            ++j;
        }
        float m = matches;
        float jaro = (m / (float)length1 + m / (float)length2 + (m - (float)(transpositions / 2)) / m) / 3.0f;
        if (jaro < 0.7f) {
            return jaro;
        }
        int prefix = 0;
        for (int i = 0; i < length1 && bytes1[i] == bytes2[i]; ++i) {
            ++prefix;
        }
        return jaro + Math.min(0.1f, 1.0f / (float)length2) * (float)prefix * (1.0f - jaro);
    }
}

