/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteStatement;
import android.provider.CallLog;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Log;
import com.android.providers.contacts.ContactsDatabaseHelper;
import com.android.providers.contacts.ContactsProvider2;
import com.android.providers.contacts.NameSplitter;
import java.io.File;

public class LegacyContactImporter {
    public static final String TAG = "LegacyContactImporter";
    private static final int MAX_ATTEMPTS = 5;
    private static final int DELAY_BETWEEN_ATTEMPTS = 2000;
    public static final String DEFAULT_ACCOUNT_TYPE = "com.google";
    private static final String DATABASE_NAME = "contacts.db";
    private static final int INSERT_BATCH_SIZE = 200;
    private static final long DATABASE_SIZE_MULTIPLIER = 4L;
    private static final long DATABASE_MIN_SIZE = 5L;
    private final Context mContext;
    private final ContactsProvider2 mContactsProvider;
    private ContactsDatabaseHelper mDbHelper;
    private ContentValues mValues = new ContentValues();
    private ContentResolver mResolver;
    private boolean mPhoneticNameAvailable = true;
    private SQLiteDatabase mSourceDb;
    private SQLiteDatabase mTargetDb;
    private NameSplitter mNameSplitter;
    private int mBatchCounter;
    private int mContactCount;
    private long mStructuredNameMimetypeId;
    private long mNoteMimetypeId;
    private long mOrganizationMimetypeId;
    private long mPhoneMimetypeId;
    private long mEmailMimetypeId;
    private long mImMimetypeId;
    private long mPostalMimetypeId;
    private long mPhotoMimetypeId;
    private long mGroupMembershipMimetypeId;
    private long mEstimatedStorageRequirement = 5L;

    public LegacyContactImporter(Context context, ContactsProvider2 contactsProvider) {
        this.mContext = context;
        this.mContactsProvider = contactsProvider;
        this.mResolver = this.mContactsProvider.getContext().getContentResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importContacts() throws Exception {
        String path = this.mContext.getDatabasePath(DATABASE_NAME).getPath();
        File file = new File(path);
        if (!file.exists()) {
            Log.i((String)TAG, (String)("Legacy contacts database does not exist at " + path));
            return true;
        }
        Log.w((String)TAG, (String)("Importing contacts from " + path));
        for (int i = 0; i < 5; ++i) {
            try {
                this.mSourceDb = SQLiteDatabase.openDatabase((String)path, null, (int)1);
                this.importContactsFromLegacyDb();
                Log.i((String)TAG, (String)("Imported legacy contacts: " + this.mContactCount));
                this.mContactsProvider.notifyChange();
                boolean bl = true;
                return bl;
            }
            catch (SQLiteException e) {
                Log.e((String)TAG, (String)"Database import exception. Will retry in 2000ms", (Throwable)e);
                Thread.sleep(2000L);
                continue;
            }
            finally {
                if (this.mSourceDb != null) {
                    this.mSourceDb.close();
                }
            }
        }
        long oldDatabaseSize = file.length();
        this.mEstimatedStorageRequirement = oldDatabaseSize * 4L / 1024L / 1024L;
        if (this.mEstimatedStorageRequirement < 5L) {
            this.mEstimatedStorageRequirement = 5L;
        }
        return false;
    }

    public long getEstimatedStorageRequirement() {
        return this.mEstimatedStorageRequirement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importContactsFromLegacyDb() {
        int version = this.mSourceDb.getVersion();
        if (version < 78) {
            return;
        }
        if (version < 80) {
            this.mPhoneticNameAvailable = false;
        }
        this.mDbHelper = (ContactsDatabaseHelper)this.mContactsProvider.getDatabaseHelper();
        this.mTargetDb = this.mDbHelper.getWritableDatabase();
        this.mStructuredNameMimetypeId = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/name");
        this.mNoteMimetypeId = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/note");
        this.mOrganizationMimetypeId = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/organization");
        this.mPhoneMimetypeId = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/phone_v2");
        this.mEmailMimetypeId = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/email_v2");
        this.mImMimetypeId = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/im");
        this.mPostalMimetypeId = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/postal-address_v2");
        this.mPhotoMimetypeId = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/photo");
        this.mGroupMembershipMimetypeId = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/group_membership");
        this.mNameSplitter = this.mContactsProvider.getNameSplitter();
        this.mTargetDb.beginTransaction();
        try {
            this.checkForImportFailureTest();
            this.mContactsProvider.wipeData();
            this.importGroups();
            this.importPeople();
            this.importOrganizations();
            this.importPhones();
            this.importContactMethods();
            this.importPhotos();
            this.importGroupMemberships();
            this.updateDisplayNamesAndLookupKeys();
            this.importDeletedPeople();
            this.mDbHelper.updateAllVisible();
            this.mTargetDb.setTransactionSuccessful();
        }
        finally {
            this.mTargetDb.endTransaction();
        }
        this.importCalls();
    }

    private void checkForImportFailureTest() {
        long isTest = DatabaseUtils.longForQuery((SQLiteDatabase)this.mSourceDb, (String)"SELECT COUNT(*) FROM settings WHERE key='TEST'", null);
        if (isTest != 0L) {
            throw new SQLiteException("Testing import failure.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importGroups() {
        SQLiteStatement insert = this.mTargetDb.compileStatement("INSERT INTO groups(_id,title,notes,system_id,dirty,group_visible,account_name,account_type,sourceid) VALUES (?,?,?,?,?,?,?,?,?)");
        Cursor c = this.mSourceDb.query("groups", GroupsQuery.COLUMNS, null, null, null, null, null);
        try {
            while (c.moveToNext()) {
                this.insertGroup(c, insert);
            }
        }
        finally {
            c.close();
            insert.close();
        }
    }

    private void insertGroup(Cursor c, SQLiteStatement insert) {
        long id = c.getLong(0);
        insert.bindLong(1, id);
        this.bindString(insert, 2, c.getString(1));
        this.bindString(insert, 3, c.getString(2));
        this.bindString(insert, 4, c.getString(4));
        insert.bindLong(5, c.getLong(7));
        insert.bindLong(6, 1L);
        String account = c.getString(5);
        if (!TextUtils.isEmpty((CharSequence)account)) {
            this.bindString(insert, 7, account);
            this.bindString(insert, 8, DEFAULT_ACCOUNT_TYPE);
            this.bindString(insert, 9, c.getString(6));
        } else {
            insert.bindNull(7);
            insert.bindNull(8);
            insert.bindNull(9);
        }
        this.insert(insert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importPeople() {
        SQLiteStatement rawContactInsert = this.mTargetDb.compileStatement("INSERT INTO raw_contacts(_id,contact_id,custom_ringtone,dirty,last_time_contacted,send_to_voicemail,starred,times_contacted,sync1,sync2,account_name,account_type,sourceid,display_name,contact_in_visible_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        SQLiteStatement contactInsert = this.mTargetDb.compileStatement("INSERT INTO contacts(_id,custom_ringtone,last_time_contacted,send_to_voicemail,starred,times_contacted,name_raw_contact_id,in_visible_group) VALUES (?,?,?,?,?,?,?,?)");
        SQLiteStatement structuredNameInsert = this.mTargetDb.compileStatement("INSERT INTO data(raw_contact_id,mimetype_id,data1,data4,data2,data5,data3,data6,data10,data9,data8,data7,data11) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
        SQLiteStatement noteInsert = this.mTargetDb.compileStatement("INSERT INTO data(raw_contact_id,mimetype_id,data1) VALUES (?,?,?)");
        try {
            String[] columns = this.mPhoneticNameAvailable ? PeopleQuery.COLUMNS_WITH_DISPLAY_NAME_WITH_PHONETIC_NAME : PeopleQuery.COLUMNS_WITH_DISPLAY_NAME_WITHOUT_PHONETIC_NAME;
            Cursor c = this.mSourceDb.query("people", columns, "name IS NULL", null, null, null, null);
            try {
                while (c.moveToNext()) {
                    this.insertRawContact(c, rawContactInsert);
                    this.insertContact(c, contactInsert);
                    this.insertNote(c, noteInsert);
                    ++this.mContactCount;
                }
            }
            finally {
                c.close();
            }
            columns = this.mPhoneticNameAvailable ? PeopleQuery.COLUMNS_WITH_PHONETIC_NAME : PeopleQuery.COLUMNS_WITHOUT_PHONETIC_NAME;
            c = this.mSourceDb.query("people", columns, "name IS NOT NULL", null, null, null, null);
            try {
                while (c.moveToNext()) {
                    long id = this.insertRawContact(c, rawContactInsert);
                    this.insertContact(c, contactInsert);
                    this.insertStructuredName(c, structuredNameInsert);
                    this.insertNote(c, noteInsert);
                    ++this.mContactCount;
                }
            }
            finally {
                c.close();
            }
        }
        finally {
            rawContactInsert.close();
            contactInsert.close();
            structuredNameInsert.close();
            noteInsert.close();
        }
    }

    private long insertRawContact(Cursor c, SQLiteStatement insert) {
        long id = c.getLong(0);
        insert.bindLong(1, id);
        insert.bindLong(2, id);
        this.bindString(insert, 3, c.getString(9));
        this.bindString(insert, 4, c.getString(15));
        insert.bindLong(5, c.getLong(4));
        insert.bindLong(6, c.getLong(10));
        insert.bindLong(7, c.getLong(5));
        insert.bindLong(8, c.getLong(3));
        this.bindString(insert, 9, c.getString(13));
        this.bindString(insert, 10, c.getString(14));
        this.bindString(insert, 14, c.getString(1));
        insert.bindLong(15, 1L);
        String account = c.getString(11);
        if (!TextUtils.isEmpty((CharSequence)account)) {
            this.bindString(insert, 11, account);
            this.bindString(insert, 12, DEFAULT_ACCOUNT_TYPE);
            this.bindString(insert, 13, c.getString(12));
        } else {
            insert.bindNull(11);
            insert.bindNull(12);
            insert.bindNull(13);
        }
        this.insert(insert);
        return id;
    }

    private void insertContact(Cursor c, SQLiteStatement insert) {
        long id = c.getLong(0);
        insert.bindLong(1, id);
        this.bindString(insert, 2, c.getString(9));
        insert.bindLong(3, c.getLong(4));
        insert.bindLong(4, c.getLong(10));
        insert.bindLong(5, c.getLong(5));
        insert.bindLong(6, c.getLong(3));
        insert.bindLong(7, id);
        insert.bindLong(8, 1L);
        this.insert(insert);
    }

    private void insertStructuredName(Cursor c, SQLiteStatement insert) {
        String phoneticName;
        String name = c.getString(1);
        if (TextUtils.isEmpty((CharSequence)name)) {
            return;
        }
        long id = c.getLong(0);
        insert.bindLong(1, id);
        insert.bindLong(2, this.mStructuredNameMimetypeId);
        this.bindString(insert, 3, name);
        NameSplitter.Name splitName = new NameSplitter.Name();
        this.mNameSplitter.split(splitName, name);
        this.bindString(insert, 4, splitName.getPrefix());
        this.bindString(insert, 5, splitName.getGivenNames());
        this.bindString(insert, 6, splitName.getMiddleName());
        this.bindString(insert, 7, splitName.getFamilyName());
        this.bindString(insert, 8, splitName.getSuffix());
        String joined = this.mNameSplitter.join(splitName, true);
        this.bindString(insert, 3, joined);
        if (this.mPhoneticNameAvailable && (phoneticName = c.getString(16)) != null) {
            int index = phoneticName.indexOf(32);
            if (index == -1) {
                splitName.phoneticFamilyName = phoneticName;
            } else {
                splitName.phoneticFamilyName = phoneticName.substring(0, index).trim();
                splitName.phoneticGivenName = phoneticName.substring(index + 1).trim();
            }
        }
        this.mNameSplitter.guessNameStyle(splitName);
        int fullNameStyle = splitName.getFullNameStyle();
        insert.bindLong(9, (long)fullNameStyle);
        this.bindString(insert, 10, splitName.phoneticFamilyName);
        this.bindString(insert, 11, splitName.phoneticMiddleName);
        this.bindString(insert, 12, splitName.phoneticGivenName);
        insert.bindLong(13, (long)splitName.phoneticNameStyle);
        long dataId = this.insert(insert);
        this.mContactsProvider.insertNameLookupForStructuredName(id, dataId, name, this.mNameSplitter.getAdjustedFullNameStyle(fullNameStyle));
        if (splitName.phoneticFamilyName != null || splitName.phoneticMiddleName != null || splitName.phoneticGivenName != null) {
            this.mContactsProvider.insertNameLookupForPhoneticName(id, dataId, splitName.phoneticFamilyName, splitName.phoneticMiddleName, splitName.phoneticGivenName);
        }
    }

    private void insertNote(Cursor c, SQLiteStatement insert) {
        String notes = c.getString(2);
        if (TextUtils.isEmpty((CharSequence)notes)) {
            return;
        }
        long id = c.getLong(0);
        insert.bindLong(1, id);
        insert.bindLong(2, this.mNoteMimetypeId);
        this.bindString(insert, 3, notes);
        this.insert(insert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importOrganizations() {
        SQLiteStatement insert = this.mTargetDb.compileStatement("INSERT INTO data(raw_contact_id,mimetype_id,is_primary,is_super_primary,data1,data4,data2,data3) VALUES (?,?,?,?,?,?,?,?)");
        Cursor c = this.mSourceDb.query("organizations", OrganizationsQuery.COLUMNS, null, null, null, null, null);
        try {
            while (c.moveToNext()) {
                this.insertOrganization(c, insert);
            }
        }
        finally {
            c.close();
            insert.close();
        }
    }

    private void insertOrganization(Cursor c, SQLiteStatement insert) {
        long id = c.getLong(0);
        insert.bindLong(1, id);
        insert.bindLong(2, this.mOrganizationMimetypeId);
        this.bindString(insert, 3, c.getString(3));
        this.bindString(insert, 4, c.getString(3));
        this.bindString(insert, 5, c.getString(1));
        this.bindString(insert, 6, c.getString(2));
        this.bindString(insert, 7, c.getString(4));
        this.bindString(insert, 8, c.getString(5));
        this.insert(insert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importContactMethods() {
        SQLiteStatement emailInsert = this.mTargetDb.compileStatement("INSERT INTO data(raw_contact_id,mimetype_id,is_primary,is_super_primary,data1,data2,data3,data14) VALUES (?,?,?,?,?,?,?,?)");
        SQLiteStatement imInsert = this.mTargetDb.compileStatement("INSERT INTO data(raw_contact_id,mimetype_id,is_primary,is_super_primary,data1,data2,data3,data14) VALUES (?,?,?,?,?,?,?,?)");
        SQLiteStatement postalInsert = this.mTargetDb.compileStatement("INSERT INTO data(raw_contact_id,mimetype_id,is_primary,is_super_primary,data1,data2,data3,data14) VALUES (?,?,?,?,?,?,?,?)");
        Cursor c = this.mSourceDb.query("contact_methods", ContactMethodsQuery.COLUMNS, null, null, null, null, null);
        try {
            while (c.moveToNext()) {
                int kind = c.getInt(1);
                switch (kind) {
                    case 1: {
                        this.insertEmail(c, emailInsert);
                        break;
                    }
                    case 3: {
                        this.insertIm(c, imInsert);
                        break;
                    }
                    case 2: {
                        this.insertPostal(c, postalInsert);
                    }
                }
            }
        }
        finally {
            c.close();
            emailInsert.close();
            imInsert.close();
            postalInsert.close();
        }
    }

    private void insertEmail(Cursor c, SQLiteStatement insert) {
        long personId = c.getLong(0);
        String email = c.getString(2);
        insert.bindLong(1, personId);
        insert.bindLong(2, this.mEmailMimetypeId);
        this.bindString(insert, 3, c.getString(6));
        this.bindString(insert, 4, c.getString(6));
        this.bindString(insert, 5, email);
        this.bindString(insert, 8, c.getString(3));
        this.bindString(insert, 6, c.getString(4));
        this.bindString(insert, 7, c.getString(5));
        long dataId = this.insert(insert);
        this.mContactsProvider.insertNameLookupForEmail(personId, dataId, email);
    }

    private void insertIm(Cursor c, SQLiteStatement insert) {
        long personId = c.getLong(0);
        insert.bindLong(1, personId);
        insert.bindLong(2, this.mImMimetypeId);
        this.bindString(insert, 3, c.getString(6));
        this.bindString(insert, 4, c.getString(6));
        this.bindString(insert, 5, c.getString(2));
        this.bindString(insert, 8, c.getString(3));
        this.bindString(insert, 6, c.getString(4));
        this.bindString(insert, 7, c.getString(5));
        this.insert(insert);
    }

    private void insertPostal(Cursor c, SQLiteStatement insert) {
        long personId = c.getLong(0);
        insert.bindLong(1, personId);
        insert.bindLong(2, this.mPostalMimetypeId);
        this.bindString(insert, 3, c.getString(6));
        this.bindString(insert, 4, c.getString(6));
        this.bindString(insert, 5, c.getString(2));
        this.bindString(insert, 8, c.getString(3));
        this.bindString(insert, 6, c.getString(4));
        this.bindString(insert, 7, c.getString(5));
        this.insert(insert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importPhones() {
        SQLiteStatement phoneInsert = this.mTargetDb.compileStatement("INSERT INTO data(raw_contact_id,mimetype_id,is_primary,is_super_primary,data1,data2,data3,data4) VALUES (?,?,?,?,?,?,?,?)");
        SQLiteStatement phoneLookupInsert = this.mTargetDb.compileStatement("INSERT INTO phone_lookup(raw_contact_id,data_id,normalized_number,min_match) VALUES (?,?,?,?)");
        SQLiteStatement hasPhoneUpdate = this.mTargetDb.compileStatement("UPDATE contacts SET has_phone_number=1 WHERE _id=?");
        Cursor c = this.mSourceDb.query("phones", PhonesQuery.COLUMNS, null, null, null, null, null);
        try {
            while (c.moveToNext()) {
                this.insertPhone(c, phoneInsert, phoneLookupInsert, hasPhoneUpdate);
            }
        }
        finally {
            c.close();
            phoneInsert.close();
            phoneLookupInsert.close();
            hasPhoneUpdate.close();
        }
    }

    private void insertPhone(Cursor c, SQLiteStatement phoneInsert, SQLiteStatement phoneLookupInsert, SQLiteStatement hasPhoneUpdate) {
        long lastUpdatedContact = -1L;
        long id = c.getLong(0);
        String number = c.getString(2);
        String normalizedNumber = null;
        if (number != null) {
            normalizedNumber = PhoneNumberUtils.getStrippedReversed((String)number);
        }
        phoneInsert.bindLong(1, id);
        phoneInsert.bindLong(2, this.mPhoneMimetypeId);
        this.bindString(phoneInsert, 3, c.getString(4));
        this.bindString(phoneInsert, 4, c.getString(4));
        this.bindString(phoneInsert, 5, number);
        this.bindString(phoneInsert, 6, c.getString(1));
        this.bindString(phoneInsert, 7, c.getString(3));
        this.bindString(phoneInsert, 8, normalizedNumber);
        long dataId = this.insert(phoneInsert);
        if (normalizedNumber != null) {
            phoneLookupInsert.bindLong(1, id);
            phoneLookupInsert.bindLong(2, dataId);
            phoneLookupInsert.bindString(3, normalizedNumber);
            phoneLookupInsert.bindString(4, PhoneNumberUtils.toCallerIDMinMatch((String)number));
            this.insert(phoneLookupInsert);
            if (lastUpdatedContact != id) {
                lastUpdatedContact = id;
                hasPhoneUpdate.bindLong(1, id);
                hasPhoneUpdate.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importPhotos() {
        SQLiteStatement insert = this.mTargetDb.compileStatement("INSERT INTO data(raw_contact_id,mimetype_id,data15,data_sync1) VALUES (?,?,?,?)");
        SQLiteStatement photoIdUpdate = this.mTargetDb.compileStatement("UPDATE contacts SET photo_id=? WHERE _id=?");
        Cursor c = this.mSourceDb.query("photos", PhotosQuery.COLUMNS, null, null, null, null, null);
        try {
            while (c.moveToNext()) {
                this.insertPhoto(c, insert, photoIdUpdate);
            }
        }
        finally {
            c.close();
            insert.close();
            photoIdUpdate.close();
        }
    }

    private void insertPhoto(Cursor c, SQLiteStatement insert, SQLiteStatement photoIdUpdate) {
        if (c.isNull(1)) {
            return;
        }
        long personId = c.getLong(0);
        insert.bindLong(1, personId);
        insert.bindLong(2, this.mPhotoMimetypeId);
        insert.bindBlob(3, c.getBlob(1));
        String account = c.getString(3);
        if (!TextUtils.isEmpty((CharSequence)account)) {
            this.bindString(insert, 4, c.getString(2));
        } else {
            insert.bindNull(4);
        }
        long rowId = this.insert(insert);
        photoIdUpdate.bindLong(1, rowId);
        photoIdUpdate.bindLong(2, personId);
        photoIdUpdate.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importGroupMemberships() {
        SQLiteStatement insert = this.mTargetDb.compileStatement("INSERT INTO data(raw_contact_id,mimetype_id,data1) VALUES (?,?,?)");
        Cursor c = this.mSourceDb.query("groupmembership", GroupMembershipQuery.COLUMNS, null, null, null, null, null);
        try {
            while (c.moveToNext()) {
                this.insertGroupMembership(c, insert);
            }
        }
        finally {
            c.close();
            insert.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertGroupMembership(Cursor c, SQLiteStatement insert) {
        long personId = c.getLong(0);
        long groupId = 0L;
        if (c.isNull(1)) {
            String account = c.getString(2);
            if (!TextUtils.isEmpty((CharSequence)account)) {
                String syncId = c.getString(3);
                Cursor cursor = this.mTargetDb.query("groups", new String[]{"_id"}, "sourceid=?", new String[]{syncId}, null, null, null);
                try {
                    if (cursor.moveToFirst()) {
                        groupId = cursor.getLong(0);
                    }
                }
                finally {
                    cursor.close();
                }
                if (groupId == 0L) {
                    ContentValues values = new ContentValues();
                    values.put("account_name", account);
                    values.put("account_type", DEFAULT_ACCOUNT_TYPE);
                    values.put("group_visible", Boolean.valueOf(true));
                    values.put("sourceid", syncId);
                    groupId = this.mTargetDb.insert("groups", null, values);
                }
            }
        } else {
            groupId = c.getLong(1);
        }
        insert.bindLong(1, personId);
        insert.bindLong(2, this.mGroupMembershipMimetypeId);
        insert.bindLong(3, groupId);
        this.insert(insert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCalls() {
        Cursor c = this.mSourceDb.query("calls", CallsQuery.COLUMNS, null, null, null, null, null);
        try {
            while (c.moveToNext()) {
                this.insertCall(c);
            }
        }
        finally {
            c.close();
        }
    }

    private void insertCall(Cursor c) {
        this.mValues.clear();
        this.mValues.put("_id", Long.valueOf(c.getLong(0)));
        this.mValues.put("number", c.getString(1));
        this.mValues.put("date", Long.valueOf(c.getLong(2)));
        this.mValues.put("duration", Long.valueOf(c.getLong(3)));
        this.mValues.put("new", Long.valueOf(c.getLong(5)));
        this.mValues.put("type", Long.valueOf(c.getLong(4)));
        this.mValues.put("name", c.getString(6));
        this.mValues.put("numberlabel", c.getString(8));
        this.mValues.put("numbertype", c.getString(7));
        this.mResolver.insert(CallLog.Calls.CONTENT_URI, this.mValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDisplayNamesAndLookupKeys() {
        Cursor cursor = this.mResolver.query(ContactsContract.RawContacts.CONTENT_URI, new String[]{"_id"}, null, null, null);
        try {
            while (cursor.moveToNext()) {
                long rawContactId = cursor.getLong(0);
                this.mContactsProvider.updateRawContactDisplayName(this.mTargetDb, rawContactId);
                this.mContactsProvider.updateLookupKeyForRawContact(this.mTargetDb, rawContactId);
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importDeletedPeople() {
        SQLiteStatement insert = this.mTargetDb.compileStatement("INSERT INTO raw_contacts(account_name,account_type,sourceid,deleted,aggregation_mode) VALUES (?,?,?,?,?)");
        Cursor c = this.mSourceDb.query("_deleted_people", DeletedPeopleQuery.COLUMNS, null, null, null, null, null);
        try {
            while (c.moveToNext()) {
                this.insertDeletedPerson(c, insert);
            }
        }
        finally {
            c.close();
            insert.close();
        }
    }

    private void insertDeletedPerson(Cursor c, SQLiteStatement insert) {
        String account = c.getString(1);
        if (account == null) {
            return;
        }
        insert.bindString(1, account);
        insert.bindString(2, DEFAULT_ACCOUNT_TYPE);
        this.bindString(insert, 3, c.getString(0));
        insert.bindLong(4, 1L);
        insert.bindLong(5, 3L);
        this.insert(insert);
    }

    private void bindString(SQLiteStatement insert, int index, String string2) {
        if (string2 == null) {
            insert.bindNull(index);
        } else {
            insert.bindString(index, string2);
        }
    }

    private long insert(SQLiteStatement insertStatement) {
        long rowId = insertStatement.executeInsert();
        if (rowId == 0L) {
            throw new RuntimeException("Insert failed");
        }
        ++this.mBatchCounter;
        if (this.mBatchCounter >= 200) {
            this.mTargetDb.setTransactionSuccessful();
            this.mTargetDb.endTransaction();
            this.mTargetDb.beginTransaction();
            this.mBatchCounter = 0;
        }
        return rowId;
    }

    private static interface DeletedRawContactInsert {
        public static final String INSERT_SQL = "INSERT INTO raw_contacts(account_name,account_type,sourceid,deleted,aggregation_mode) VALUES (?,?,?,?,?)";
        public static final int ACCOUNT_NAME = 1;
        public static final int ACCOUNT_TYPE = 2;
        public static final int SOURCE_ID = 3;
        public static final int DELETED = 4;
        public static final int AGGREGATION_MODE = 5;
    }

    private static interface DeletedPeopleQuery {
        public static final String TABLE = "_deleted_people";
        public static final String[] COLUMNS = new String[]{"_sync_id", "_sync_account"};
        public static final int _SYNC_ID = 0;
        public static final int _SYNC_ACCOUNT = 1;
    }

    private static interface CallsQuery {
        public static final String TABLE = "calls";
        public static final String[] COLUMNS = new String[]{"_id", "number", "date", "duration", "type", "new", "name", "numbertype", "numberlabel"};
        public static final int ID = 0;
        public static final int NUMBER = 1;
        public static final int DATE = 2;
        public static final int DURATION = 3;
        public static final int TYPE = 4;
        public static final int NEW = 5;
        public static final int NAME = 6;
        public static final int NUMBER_TYPE = 7;
        public static final int NUMBER_LABEL = 8;
    }

    private static interface GroupMembershipInsert {
        public static final String INSERT_SQL = "INSERT INTO data(raw_contact_id,mimetype_id,data1) VALUES (?,?,?)";
        public static final int RAW_CONTACT_ID = 1;
        public static final int MIMETYPE_ID = 2;
        public static final int GROUP_ROW_ID = 3;
    }

    private static interface GroupMembershipQuery {
        public static final String TABLE = "groupmembership";
        public static final String[] COLUMNS = new String[]{"person", "group_id", "group_sync_account", "group_sync_id"};
        public static final int PERSON_ID = 0;
        public static final int GROUP_ID = 1;
        public static final int GROUP_SYNC_ACCOUNT = 2;
        public static final int GROUP_SYNC_ID = 3;
    }

    private static interface PhotoIdUpdate {
        public static final String UPDATE_SQL = "UPDATE contacts SET photo_id=? WHERE _id=?";
        public static final int PHOTO_ID = 1;
        public static final int CONTACT_ID = 2;
    }

    private static interface PhotoInsert {
        public static final String INSERT_SQL = "INSERT INTO data(raw_contact_id,mimetype_id,data15,data_sync1) VALUES (?,?,?,?)";
        public static final int RAW_CONTACT_ID = 1;
        public static final int MIMETYPE_ID = 2;
        public static final int PHOTO = 3;
        public static final int SYNC1 = 4;
    }

    private static interface PhotosQuery {
        public static final String TABLE = "photos";
        public static final String[] COLUMNS = new String[]{"person", "data", "_sync_id", "_sync_account"};
        public static final int PERSON = 0;
        public static final int DATA = 1;
        public static final int _SYNC_ID = 2;
        public static final int _SYNC_ACCOUNT = 3;
    }

    private static interface HasPhoneNumberUpdate {
        public static final String UPDATE_SQL = "UPDATE contacts SET has_phone_number=1 WHERE _id=?";
        public static final int CONTACT_ID = 1;
    }

    private static interface PhoneLookupInsert {
        public static final String INSERT_SQL = "INSERT INTO phone_lookup(raw_contact_id,data_id,normalized_number,min_match) VALUES (?,?,?,?)";
        public static final int RAW_CONTACT_ID = 1;
        public static final int DATA_ID = 2;
        public static final int NORMALIZED_NUMBER = 3;
        public static final int MIN_MATCH = 4;
    }

    private static interface PhoneInsert {
        public static final String INSERT_SQL = "INSERT INTO data(raw_contact_id,mimetype_id,is_primary,is_super_primary,data1,data2,data3,data4) VALUES (?,?,?,?,?,?,?,?)";
        public static final int RAW_CONTACT_ID = 1;
        public static final int MIMETYPE_ID = 2;
        public static final int IS_PRIMARY = 3;
        public static final int IS_SUPER_PRIMARY = 4;
        public static final int NUMBER = 5;
        public static final int TYPE = 6;
        public static final int LABEL = 7;
        public static final int NORMALIZED_NUMBER = 8;
    }

    private static interface PhonesQuery {
        public static final String TABLE = "phones";
        public static final String[] COLUMNS = new String[]{"person", "type", "number", "label", "isprimary"};
        public static final int PERSON = 0;
        public static final int TYPE = 1;
        public static final int NUMBER = 2;
        public static final int LABEL = 3;
        public static final int ISPRIMARY = 4;
    }

    private static interface PostalInsert {
        public static final String INSERT_SQL = "INSERT INTO data(raw_contact_id,mimetype_id,is_primary,is_super_primary,data1,data2,data3,data14) VALUES (?,?,?,?,?,?,?,?)";
        public static final int RAW_CONTACT_ID = 1;
        public static final int MIMETYPE_ID = 2;
        public static final int IS_PRIMARY = 3;
        public static final int IS_SUPER_PRIMARY = 4;
        public static final int DATA = 5;
        public static final int TYPE = 6;
        public static final int LABEL = 7;
        public static final int AUX_DATA = 8;
    }

    private static interface ImInsert {
        public static final String INSERT_SQL = "INSERT INTO data(raw_contact_id,mimetype_id,is_primary,is_super_primary,data1,data2,data3,data14) VALUES (?,?,?,?,?,?,?,?)";
        public static final int RAW_CONTACT_ID = 1;
        public static final int MIMETYPE_ID = 2;
        public static final int IS_PRIMARY = 3;
        public static final int IS_SUPER_PRIMARY = 4;
        public static final int DATA = 5;
        public static final int TYPE = 6;
        public static final int LABEL = 7;
        public static final int AUX_DATA = 8;
    }

    private static interface EmailInsert {
        public static final String INSERT_SQL = "INSERT INTO data(raw_contact_id,mimetype_id,is_primary,is_super_primary,data1,data2,data3,data14) VALUES (?,?,?,?,?,?,?,?)";
        public static final int RAW_CONTACT_ID = 1;
        public static final int MIMETYPE_ID = 2;
        public static final int IS_PRIMARY = 3;
        public static final int IS_SUPER_PRIMARY = 4;
        public static final int DATA = 5;
        public static final int TYPE = 6;
        public static final int LABEL = 7;
        public static final int AUX_DATA = 8;
    }

    private static interface ContactMethodsQuery {
        public static final String TABLE = "contact_methods";
        public static final String[] COLUMNS = new String[]{"person", "kind", "data", "aux_data", "type", "label", "isprimary"};
        public static final int PERSON = 0;
        public static final int KIND = 1;
        public static final int DATA = 2;
        public static final int AUX_DATA = 3;
        public static final int TYPE = 4;
        public static final int LABEL = 5;
        public static final int ISPRIMARY = 6;
    }

    private static interface OrganizationInsert {
        public static final String INSERT_SQL = "INSERT INTO data(raw_contact_id,mimetype_id,is_primary,is_super_primary,data1,data4,data2,data3) VALUES (?,?,?,?,?,?,?,?)";
        public static final int RAW_CONTACT_ID = 1;
        public static final int MIMETYPE_ID = 2;
        public static final int IS_PRIMARY = 3;
        public static final int IS_SUPER_PRIMARY = 4;
        public static final int COMPANY = 5;
        public static final int TITLE = 6;
        public static final int TYPE = 7;
        public static final int LABEL = 8;
    }

    private static interface OrganizationsQuery {
        public static final String TABLE = "organizations";
        public static final String[] COLUMNS = new String[]{"person", "company", "title", "isprimary", "type", "label"};
        public static final int PERSON = 0;
        public static final int COMPANY = 1;
        public static final int TITLE = 2;
        public static final int ISPRIMARY = 3;
        public static final int TYPE = 4;
        public static final int LABEL = 5;
    }

    private static interface NoteInsert {
        public static final String INSERT_SQL = "INSERT INTO data(raw_contact_id,mimetype_id,data1) VALUES (?,?,?)";
        public static final int RAW_CONTACT_ID = 1;
        public static final int MIMETYPE_ID = 2;
        public static final int NOTE = 3;
    }

    private static interface StructuredNameInsert {
        public static final String INSERT_SQL = "INSERT INTO data(raw_contact_id,mimetype_id,data1,data4,data2,data5,data3,data6,data10,data9,data8,data7,data11) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        public static final int RAW_CONTACT_ID = 1;
        public static final int MIMETYPE_ID = 2;
        public static final int DISPLAY_NAME = 3;
        public static final int PREFIX = 4;
        public static final int GIVEN_NAME = 5;
        public static final int MIDDLE_NAME = 6;
        public static final int FAMILY_NAME = 7;
        public static final int SUFFIX = 8;
        public static final int FULL_NAME_STYLE = 9;
        public static final int PHONETIC_FAMILY_NAME = 10;
        public static final int PHONETIC_MIDDLE_NAME = 11;
        public static final int PHONETIC_GIVEN_NAME = 12;
        public static final int PHONETIC_NAME_STYLE = 13;
    }

    private static interface ContactsInsert {
        public static final String INSERT_SQL = "INSERT INTO contacts(_id,custom_ringtone,last_time_contacted,send_to_voicemail,starred,times_contacted,name_raw_contact_id,in_visible_group) VALUES (?,?,?,?,?,?,?,?)";
        public static final int ID = 1;
        public static final int CUSTOM_RINGTONE = 2;
        public static final int LAST_TIME_CONTACTED = 3;
        public static final int SEND_TO_VOICEMAIL = 4;
        public static final int STARRED = 5;
        public static final int TIMES_CONTACTED = 6;
        public static final int NAME_RAW_CONTACT_ID = 7;
        public static final int IN_VISIBLE_GROUP = 8;
    }

    private static interface RawContactsInsert {
        public static final String INSERT_SQL = "INSERT INTO raw_contacts(_id,contact_id,custom_ringtone,dirty,last_time_contacted,send_to_voicemail,starred,times_contacted,sync1,sync2,account_name,account_type,sourceid,display_name,contact_in_visible_group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        public static final int ID = 1;
        public static final int CONTACT_ID = 2;
        public static final int CUSTOM_RINGTONE = 3;
        public static final int DIRTY = 4;
        public static final int LAST_TIME_CONTACTED = 5;
        public static final int SEND_TO_VOICEMAIL = 6;
        public static final int STARRED = 7;
        public static final int TIMES_CONTACTED = 8;
        public static final int SYNC1 = 9;
        public static final int SYNC2 = 10;
        public static final int ACCOUNT_NAME = 11;
        public static final int ACCOUNT_TYPE = 12;
        public static final int SOURCE_ID = 13;
        public static final int DISPLAY_NAME = 14;
        public static final int CONTACT_IN_VISIBLE_GROUP = 15;
    }

    private static interface PeopleQuery {
        public static final String TABLE = "people";
        public static final String NAME_SQL = "(CASE WHEN (name IS NOT NULL AND name != '') THEN name ELSE (CASE WHEN primary_organization is NOT NULL THEN (SELECT company FROM organizations WHERE organizations._id = primary_organization) ELSE (CASE WHEN primary_phone IS NOT NULL THEN (SELECT number FROM phones WHERE phones._id = primary_phone) ELSE (CASE WHEN primary_email IS NOT NULL THEN (SELECT data FROM contact_methods WHERE contact_methods._id = primary_email) ELSE null END) END) END) END) ";
        public static final String[] COLUMNS_WITH_DISPLAY_NAME_WITHOUT_PHONETIC_NAME = new String[]{"_id", "(CASE WHEN (name IS NOT NULL AND name != '') THEN name ELSE (CASE WHEN primary_organization is NOT NULL THEN (SELECT company FROM organizations WHERE organizations._id = primary_organization) ELSE (CASE WHEN primary_phone IS NOT NULL THEN (SELECT number FROM phones WHERE phones._id = primary_phone) ELSE (CASE WHEN primary_email IS NOT NULL THEN (SELECT data FROM contact_methods WHERE contact_methods._id = primary_email) ELSE null END) END) END) END) ", "notes", "times_contacted", "last_time_contacted", "starred", "primary_phone", "primary_organization", "primary_email", "custom_ringtone", "send_to_voicemail", "_sync_account", "_sync_id", "_sync_time", "_sync_local_id", "_sync_dirty"};
        public static final String[] COLUMNS_WITH_DISPLAY_NAME_WITH_PHONETIC_NAME = new String[]{"_id", "(CASE WHEN (name IS NOT NULL AND name != '') THEN name ELSE (CASE WHEN primary_organization is NOT NULL THEN (SELECT company FROM organizations WHERE organizations._id = primary_organization) ELSE (CASE WHEN primary_phone IS NOT NULL THEN (SELECT number FROM phones WHERE phones._id = primary_phone) ELSE (CASE WHEN primary_email IS NOT NULL THEN (SELECT data FROM contact_methods WHERE contact_methods._id = primary_email) ELSE null END) END) END) END) ", "notes", "times_contacted", "last_time_contacted", "starred", "primary_phone", "primary_organization", "primary_email", "custom_ringtone", "send_to_voicemail", "_sync_account", "_sync_id", "_sync_time", "_sync_local_id", "_sync_dirty", "phonetic_name"};
        public static final String[] COLUMNS_WITHOUT_PHONETIC_NAME = new String[]{"_id", "name", "notes", "times_contacted", "last_time_contacted", "starred", "primary_phone", "primary_organization", "primary_email", "custom_ringtone", "send_to_voicemail", "_sync_account", "_sync_id", "_sync_time", "_sync_local_id", "_sync_dirty"};
        public static final String[] COLUMNS_WITH_PHONETIC_NAME = new String[]{"_id", "name", "notes", "times_contacted", "last_time_contacted", "starred", "primary_phone", "primary_organization", "primary_email", "custom_ringtone", "send_to_voicemail", "_sync_account", "_sync_id", "_sync_time", "_sync_local_id", "_sync_dirty", "phonetic_name"};
        public static final int _ID = 0;
        public static final int NAME = 1;
        public static final int NOTES = 2;
        public static final int TIMES_CONTACTED = 3;
        public static final int LAST_TIME_CONTACTED = 4;
        public static final int STARRED = 5;
        public static final int PRIMARY_PHONE = 6;
        public static final int PRIMARY_ORGANIZATION = 7;
        public static final int PRIMARY_EMAIL = 8;
        public static final int CUSTOM_RINGTONE = 9;
        public static final int SEND_TO_VOICEMAIL = 10;
        public static final int _SYNC_ACCOUNT = 11;
        public static final int _SYNC_ID = 12;
        public static final int _SYNC_TIME = 13;
        public static final int _SYNC_LOCAL_ID = 14;
        public static final int _SYNC_DIRTY = 15;
        public static final int PHONETIC_NAME = 16;
    }

    private static interface GroupsInsert {
        public static final String INSERT_SQL = "INSERT INTO groups(_id,title,notes,system_id,dirty,group_visible,account_name,account_type,sourceid) VALUES (?,?,?,?,?,?,?,?,?)";
        public static final int ID = 1;
        public static final int TITLE = 2;
        public static final int NOTES = 3;
        public static final int SYSTEM_ID = 4;
        public static final int DIRTY = 5;
        public static final int GROUP_VISIBLE = 6;
        public static final int ACCOUNT_NAME = 7;
        public static final int ACCOUNT_TYPE = 8;
        public static final int SOURCE_ID = 9;
    }

    private static interface GroupsQuery {
        public static final String TABLE = "groups";
        public static final String[] COLUMNS = new String[]{"_id", "name", "notes", "should_sync", "system_id", "_sync_account", "_sync_id", "_sync_dirty"};
        public static final int ID = 0;
        public static final int NAME = 1;
        public static final int NOTES = 2;
        public static final int SHOULD_SYNC = 3;
        public static final int SYSTEM_ID = 4;
        public static final int _SYNC_ACCOUNT = 5;
        public static final int _SYNC_ID = 6;
        public static final int _SYNC_DIRTY = 7;
    }
}

