/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import android.accounts.Account;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteQueryBuilder;
import android.database.sqlite.SQLiteStatement;
import android.net.Uri;
import android.provider.Contacts;
import android.provider.ContactsContract;
import android.util.Log;
import com.android.providers.contacts.ContactsDatabaseHelper;
import com.android.providers.contacts.ContactsProvider2;
import com.android.providers.contacts.GlobalSearchSupport;
import com.android.providers.contacts.NameSplitter;
import java.util.HashMap;
import java.util.Locale;

public class LegacyApiSupport {
    private static final String TAG = "ContactsProviderV1";
    private static final UriMatcher sUriMatcher = new UriMatcher(-1);
    private static final int PEOPLE = 1;
    private static final int PEOPLE_ID = 2;
    private static final int PEOPLE_UPDATE_CONTACT_TIME = 3;
    private static final int ORGANIZATIONS = 4;
    private static final int ORGANIZATIONS_ID = 5;
    private static final int PEOPLE_CONTACTMETHODS = 6;
    private static final int PEOPLE_CONTACTMETHODS_ID = 7;
    private static final int CONTACTMETHODS = 8;
    private static final int CONTACTMETHODS_ID = 9;
    private static final int PEOPLE_PHONES = 10;
    private static final int PEOPLE_PHONES_ID = 11;
    private static final int PHONES = 12;
    private static final int PHONES_ID = 13;
    private static final int EXTENSIONS = 14;
    private static final int EXTENSIONS_ID = 15;
    private static final int PEOPLE_EXTENSIONS = 16;
    private static final int PEOPLE_EXTENSIONS_ID = 17;
    private static final int GROUPS = 18;
    private static final int GROUPS_ID = 19;
    private static final int GROUPMEMBERSHIP = 20;
    private static final int GROUPMEMBERSHIP_ID = 21;
    private static final int PEOPLE_GROUPMEMBERSHIP = 22;
    private static final int PEOPLE_GROUPMEMBERSHIP_ID = 23;
    private static final int PEOPLE_PHOTO = 24;
    private static final int PHOTOS = 25;
    private static final int PHOTOS_ID = 26;
    private static final int PEOPLE_FILTER = 29;
    private static final int DELETED_PEOPLE = 30;
    private static final int DELETED_GROUPS = 31;
    private static final int SEARCH_SUGGESTIONS = 32;
    private static final int SEARCH_SHORTCUT = 33;
    private static final int PHONES_FILTER = 34;
    private static final int LIVE_FOLDERS_PEOPLE = 35;
    private static final int LIVE_FOLDERS_PEOPLE_GROUP_NAME = 36;
    private static final int LIVE_FOLDERS_PEOPLE_WITH_PHONES = 37;
    private static final int LIVE_FOLDERS_PEOPLE_FAVORITES = 38;
    private static final int CONTACTMETHODS_EMAIL = 39;
    private static final int GROUP_NAME_MEMBERS = 40;
    private static final int GROUP_SYSTEM_ID_MEMBERS = 41;
    private static final int PEOPLE_ORGANIZATIONS = 42;
    private static final int PEOPLE_ORGANIZATIONS_ID = 43;
    private static final int SETTINGS = 44;
    private static final String PEOPLE_JOINS = " LEFT OUTER JOIN data name ON (raw_contacts._id = name.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = name.mimetype_id)='vnd.android.cursor.item/name') LEFT OUTER JOIN data organization ON (raw_contacts._id = organization.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = organization.mimetype_id)='vnd.android.cursor.item/organization' AND organization.is_primary) LEFT OUTER JOIN data email ON (raw_contacts._id = email.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = email.mimetype_id)='vnd.android.cursor.item/email_v2' AND email.is_primary) LEFT OUTER JOIN data note ON (raw_contacts._id = note.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = note.mimetype_id)='vnd.android.cursor.item/note') LEFT OUTER JOIN data phone ON (raw_contacts._id = phone.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = phone.mimetype_id)='vnd.android.cursor.item/phone_v2' AND phone.is_primary)";
    public static final String DATA_JOINS = " JOIN mimetypes ON (mimetypes._id = data.mimetype_id) JOIN raw_contacts ON (raw_contacts._id = data.raw_contact_id) LEFT OUTER JOIN data name ON (raw_contacts._id = name.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = name.mimetype_id)='vnd.android.cursor.item/name') LEFT OUTER JOIN data organization ON (raw_contacts._id = organization.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = organization.mimetype_id)='vnd.android.cursor.item/organization' AND organization.is_primary) LEFT OUTER JOIN data email ON (raw_contacts._id = email.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = email.mimetype_id)='vnd.android.cursor.item/email_v2' AND email.is_primary) LEFT OUTER JOIN data note ON (raw_contacts._id = note.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = note.mimetype_id)='vnd.android.cursor.item/note') LEFT OUTER JOIN data phone ON (raw_contacts._id = phone.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = phone.mimetype_id)='vnd.android.cursor.item/phone_v2' AND phone.is_primary)";
    public static final String PRESENCE_JOINS = " LEFT OUTER JOIN presence ON (presence.presence_data_id=(SELECT MAX(presence_data_id) FROM presence WHERE people._id = presence_raw_contact_id) )";
    private static final String PHONETIC_NAME_SQL = "trim(trim(ifnull(name.data7,' ')||' '||ifnull(name.data8,' '))||' '||ifnull(name.data9,' ')) ";
    private static final String CONTACT_METHOD_KIND_SQL = "CAST ((CASE WHEN mimetype='vnd.android.cursor.item/email_v2' THEN 1 ELSE (CASE WHEN mimetype='vnd.android.cursor.item/im' THEN 3 ELSE (CASE WHEN mimetype='vnd.android.cursor.item/postal-address_v2' THEN 2 ELSE NULL END) END) END) AS INTEGER)";
    private static final String IM_PROTOCOL_SQL = "(CASE WHEN protocol=-1 THEN 'custom:'||custom_protocol ELSE 'pre:'||protocol END)";
    private static String CONTACT_METHOD_DATA_SQL = "(CASE WHEN mimetype='vnd.android.cursor.item/im' THEN (CASE WHEN data.data5=-1 THEN 'custom:'||data.data6 ELSE 'pre:'||data.data5 END) ELSE data.data1 END)";
    private static final Uri LIVE_FOLDERS_CONTACTS_URI = Uri.withAppendedPath((Uri)ContactsContract.AUTHORITY_URI, (String)"live_folders/contacts");
    private static final Uri LIVE_FOLDERS_CONTACTS_WITH_PHONES_URI = Uri.withAppendedPath((Uri)ContactsContract.AUTHORITY_URI, (String)"live_folders/contacts_with_phones");
    private static final Uri LIVE_FOLDERS_CONTACTS_FAVORITES_URI = Uri.withAppendedPath((Uri)ContactsContract.AUTHORITY_URI, (String)"live_folders/favorites");
    private static final String CONTACTS_UPDATE_LASTTIMECONTACTED = "UPDATE contacts SET last_time_contacted=? WHERE _id=?";
    private static final String RAWCONTACTS_UPDATE_LASTTIMECONTACTED = "UPDATE raw_contacts SET last_time_contacted=? WHERE _id=?";
    private String[] mSelectionArgs1 = new String[1];
    private String[] mSelectionArgs2 = new String[2];
    private static final String[] ORGANIZATION_MIME_TYPES = new String[]{"vnd.android.cursor.item/organization"};
    private static final String[] CONTACT_METHOD_MIME_TYPES = new String[]{"vnd.android.cursor.item/email_v2", "vnd.android.cursor.item/im", "vnd.android.cursor.item/postal-address_v2"};
    private static final String[] PHONE_MIME_TYPES = new String[]{"vnd.android.cursor.item/phone_v2"};
    private static final String[] PHOTO_MIME_TYPES = new String[]{"vnd.android.cursor.item/photo"};
    private static final String[] GROUP_MEMBERSHIP_MIME_TYPES = new String[]{"vnd.android.cursor.item/group_membership"};
    private static final String[] EXTENSION_MIME_TYPES = new String[]{"vnd.android.cursor.item/contact_extensions"};
    public static final String LEGACY_PHOTO_JOIN = " LEFT OUTER JOIN data legacy_photo ON (raw_contacts._id = legacy_photo.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = legacy_photo.mimetype_id)='vnd.android.cursor.item/photo_v1_extras' AND data._id = legacy_photo.data1)";
    private static final HashMap<String, String> sPeopleProjectionMap;
    private static final HashMap<String, String> sOrganizationProjectionMap;
    private static final HashMap<String, String> sContactMethodProjectionMap;
    private static final HashMap<String, String> sPhoneProjectionMap;
    private static final HashMap<String, String> sExtensionProjectionMap;
    private static final HashMap<String, String> sGroupProjectionMap;
    private static final HashMap<String, String> sGroupMembershipProjectionMap;
    private static final HashMap<String, String> sPhotoProjectionMap;
    private final Context mContext;
    private final ContactsDatabaseHelper mDbHelper;
    private final ContactsProvider2 mContactsProvider;
    private final NameSplitter mPhoneticNameSplitter;
    private final GlobalSearchSupport mGlobalSearchSupport;
    private final SQLiteStatement mDataMimetypeQuery;
    private final SQLiteStatement mDataRawContactIdQuery;
    private final ContentValues mValues = new ContentValues();
    private final ContentValues mValues2 = new ContentValues();
    private final ContentValues mValues3 = new ContentValues();
    private boolean mDefaultAccountKnown;
    private Account mAccount;
    private long mMimetypeEmail;
    private long mMimetypeIm;
    private long mMimetypePostal;

    public LegacyApiSupport(Context context, ContactsDatabaseHelper contactsDatabaseHelper, ContactsProvider2 contactsProvider, GlobalSearchSupport globalSearchSupport) {
        this.mContext = context;
        this.mContactsProvider = contactsProvider;
        this.mDbHelper = contactsDatabaseHelper;
        this.mGlobalSearchSupport = globalSearchSupport;
        this.mPhoneticNameSplitter = new NameSplitter("", "", "", context.getString(17039532), Locale.getDefault());
        SQLiteDatabase db = this.mDbHelper.getReadableDatabase();
        this.mDataMimetypeQuery = db.compileStatement("SELECT mimetype_id FROM data WHERE _id=?");
        this.mDataRawContactIdQuery = db.compileStatement("SELECT raw_contact_id FROM data WHERE _id=?");
        this.mMimetypeEmail = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/email_v2");
        this.mMimetypeIm = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/im");
        this.mMimetypePostal = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/postal-address_v2");
    }

    private void ensureDefaultAccount() {
        if (!this.mDefaultAccountKnown) {
            this.mAccount = this.mContactsProvider.getDefaultAccount();
            this.mDefaultAccountKnown = true;
        }
    }

    public static void createDatabase(SQLiteDatabase db) {
        Log.i((String)TAG, (String)"Bootstrapping database legacy support");
        LegacyApiSupport.createViews(db);
        LegacyApiSupport.createSettingsTable(db);
    }

    public static void createViews(SQLiteDatabase db) {
        String peopleColumns = "name.data1 AS name, raw_contacts.display_name AS display_name, trim(trim(ifnull(name.data7,' ')||' '||ifnull(name.data8,' '))||' '||ifnull(name.data9,' '))  AS phonetic_name , note.data1 AS notes, account_name, account_type, raw_contacts.times_contacted AS times_contacted, raw_contacts.last_time_contacted AS last_time_contacted, raw_contacts.custom_ringtone AS custom_ringtone, raw_contacts.send_to_voicemail AS send_to_voicemail, raw_contacts.starred AS starred, organization._id AS primary_organization, email._id AS primary_email, phone._id AS primary_phone, phone.data1 AS number, phone.data2 AS type, phone.data3 AS label, phone.data4 AS number_key";
        db.execSQL("DROP VIEW IF EXISTS view_v1_people;");
        db.execSQL("CREATE VIEW view_v1_people AS SELECT raw_contacts._id AS _id, " + peopleColumns + " FROM " + "raw_contacts" + PEOPLE_JOINS + " WHERE " + "raw_contacts" + "." + "deleted" + "=0" + " AND " + "is_restricted" + "=0" + ";");
        db.execSQL("DROP VIEW IF EXISTS view_v1_organizations;");
        db.execSQL("CREATE VIEW view_v1_organizations AS SELECT data._id AS _id, raw_contact_id AS person, is_primary AS isprimary, account_name, account_type, data1 AS company, data2 AS type, data3 AS label, data4 AS title FROM data JOIN mimetypes ON (data.mimetype_id = mimetypes._id) JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id) WHERE mimetypes.mimetype='vnd.android.cursor.item/organization' AND raw_contacts.deleted=0 AND is_restricted=0;");
        db.execSQL("DROP VIEW IF EXISTS view_v1_contact_methods;");
        db.execSQL("CREATE VIEW view_v1_contact_methods AS SELECT data._id AS _id, data.raw_contact_id AS person, CAST ((CASE WHEN mimetype='vnd.android.cursor.item/email_v2' THEN 1 ELSE (CASE WHEN mimetype='vnd.android.cursor.item/im' THEN 3 ELSE (CASE WHEN mimetype='vnd.android.cursor.item/postal-address_v2' THEN 2 ELSE NULL END) END) END) AS INTEGER) AS kind, data.is_primary AS isprimary, data.data2 AS type, " + CONTACT_METHOD_DATA_SQL + " AS " + "data" + ", " + "data" + "." + "data3" + " AS " + "label" + ", " + "data.data14" + " AS " + "aux_data" + ", " + peopleColumns + " FROM " + "data" + DATA_JOINS + " WHERE " + "kind" + " IS NOT NULL" + " AND " + "raw_contacts" + "." + "deleted" + "=0" + " AND " + "is_restricted" + "=0" + ";");
        db.execSQL("DROP VIEW IF EXISTS view_v1_phones;");
        db.execSQL("CREATE VIEW view_v1_phones AS SELECT data._id AS _id, data.raw_contact_id AS person, data.is_primary AS isprimary, data.data1 AS number, data.data2 AS type, data.data3 AS label, phone_lookup.normalized_number AS number_key, " + peopleColumns + " FROM " + "data" + " JOIN " + "phone_lookup" + " ON (" + "data" + "._id = " + "phone_lookup" + "." + "data_id" + ")" + DATA_JOINS + " WHERE " + "mimetypes.mimetype" + "='" + "vnd.android.cursor.item/phone_v2" + "'" + " AND " + "raw_contacts" + "." + "deleted" + "=0" + " AND " + "is_restricted" + "=0" + ";");
        db.execSQL("DROP VIEW IF EXISTS view_v1_extensions;");
        db.execSQL("CREATE VIEW view_v1_extensions AS SELECT data._id AS _id, data.raw_contact_id AS person, account_name, account_type, data1 AS name, data2 AS value FROM data JOIN mimetypes ON (data.mimetype_id = mimetypes._id) JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id) WHERE mimetypes.mimetype='vnd.android.cursor.item/contact_extensions' AND raw_contacts.deleted=0 AND is_restricted=0;");
        db.execSQL("DROP VIEW IF EXISTS view_v1_groups;");
        db.execSQL("CREATE VIEW view_v1_groups AS SELECT groups._id AS _id, account_name, account_type, title AS name, notes AS notes , system_id AS system_id FROM groups;");
        db.execSQL("DROP VIEW IF EXISTS view_v1_group_membership;");
        db.execSQL("CREATE VIEW view_v1_group_membership AS SELECT data._id AS _id, data.raw_contact_id AS person, raw_contacts.account_name AS account_name, raw_contacts.account_type AS account_type, data1 AS group_id, title AS name, notes AS notes, system_id AS system_id, groups.sourceid AS group_sync_id, groups.account_name AS group_sync_account, groups.account_type AS group_sync_account_type FROM data JOIN mimetypes ON (data.mimetype_id = mimetypes._id) JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id) LEFT OUTER JOIN packages ON (data.package_id = packages._id) LEFT OUTER JOIN groups   ON (mimetypes.mimetype='vnd.android.cursor.item/group_membership'       AND groups._id = data.data1)  WHERE mimetypes.mimetype='vnd.android.cursor.item/group_membership' AND raw_contacts.deleted=0;");
        db.execSQL("DROP VIEW IF EXISTS view_v1_photos;");
        db.execSQL("CREATE VIEW view_v1_photos AS SELECT data._id AS _id, data.raw_contact_id AS person, account_name, account_type, data.data15 AS data, legacy_photo.data4 AS exists_on_server, legacy_photo.data3 AS download_required, legacy_photo.data2 AS local_version, legacy_photo.data5 AS sync_error FROM data JOIN mimetypes ON (mimetypes._id = data.mimetype_id) JOIN raw_contacts ON (raw_contacts._id = data.raw_contact_id) LEFT OUTER JOIN data name ON (raw_contacts._id = name.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = name.mimetype_id)='vnd.android.cursor.item/name') LEFT OUTER JOIN data organization ON (raw_contacts._id = organization.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = organization.mimetype_id)='vnd.android.cursor.item/organization' AND organization.is_primary) LEFT OUTER JOIN data email ON (raw_contacts._id = email.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = email.mimetype_id)='vnd.android.cursor.item/email_v2' AND email.is_primary) LEFT OUTER JOIN data note ON (raw_contacts._id = note.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = note.mimetype_id)='vnd.android.cursor.item/note') LEFT OUTER JOIN data phone ON (raw_contacts._id = phone.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = phone.mimetype_id)='vnd.android.cursor.item/phone_v2' AND phone.is_primary) LEFT OUTER JOIN data legacy_photo ON (raw_contacts._id = legacy_photo.raw_contact_id AND (SELECT mimetype FROM mimetypes WHERE mimetypes._id = legacy_photo.mimetype_id)='vnd.android.cursor.item/photo_v1_extras' AND data._id = legacy_photo.data1) WHERE mimetypes.mimetype='vnd.android.cursor.item/photo' AND raw_contacts.deleted=0 AND is_restricted=0;");
    }

    public static void createSettingsTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS v1_settings;");
        db.execSQL("CREATE TABLE v1_settings (_id INTEGER PRIMARY KEY,_sync_account TEXT,_sync_account_type TEXT,key STRING NOT NULL,value STRING );");
    }

    public Uri insert(Uri uri, ContentValues values) {
        this.ensureDefaultAccount();
        int match = sUriMatcher.match(uri);
        long id = 0L;
        switch (match) {
            case 1: {
                id = this.insertPeople(values);
                break;
            }
            case 4: {
                id = this.insertOrganization(values);
                break;
            }
            case 6: {
                long rawContactId = Long.parseLong((String)uri.getPathSegments().get(1));
                id = this.insertContactMethod(rawContactId, values);
                break;
            }
            case 8: {
                long rawContactId = this.getRequiredValue(values, "person");
                id = this.insertContactMethod(rawContactId, values);
                break;
            }
            case 12: {
                long rawContactId = this.getRequiredValue(values, "person");
                id = this.insertPhone(rawContactId, values);
                break;
            }
            case 10: {
                long rawContactId = Long.parseLong((String)uri.getPathSegments().get(1));
                id = this.insertPhone(rawContactId, values);
                break;
            }
            case 14: {
                long rawContactId = this.getRequiredValue(values, "person");
                id = this.insertExtension(rawContactId, values);
                break;
            }
            case 18: {
                id = this.insertGroup(values);
                break;
            }
            case 20: {
                long rawContactId = this.getRequiredValue(values, "person");
                long groupId = this.getRequiredValue(values, "group_id");
                id = this.insertGroupMembership(rawContactId, groupId);
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.mDbHelper.exceptionMessage(uri));
            }
        }
        if (id < 0L) {
            return null;
        }
        Uri result = ContentUris.withAppendedId((Uri)uri, (long)id);
        this.onChange(result);
        return result;
    }

    private long getRequiredValue(ContentValues values, String column) {
        if (!values.containsKey(column)) {
            throw new RuntimeException("Required value: " + column);
        }
        return values.getAsLong(column);
    }

    private long insertPeople(ContentValues values) {
        this.parsePeopleValues(values);
        Uri contactUri = this.mContactsProvider.insertInTransaction(ContactsContract.RawContacts.CONTENT_URI, this.mValues);
        long rawContactId = ContentUris.parseId((Uri)contactUri);
        if (this.mValues2.size() != 0) {
            this.mValues2.put("raw_contact_id", Long.valueOf(rawContactId));
            this.mContactsProvider.insertInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues2);
        }
        if (this.mValues3.size() != 0) {
            this.mValues3.put("raw_contact_id", Long.valueOf(rawContactId));
            this.mContactsProvider.insertInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues3);
        }
        return rawContactId;
    }

    private long insertOrganization(ContentValues values) {
        this.parseOrganizationValues(values);
        ContactsDatabaseHelper.copyLongValue(this.mValues, "raw_contact_id", values, "person");
        Uri uri = this.mContactsProvider.insertInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues);
        return ContentUris.parseId((Uri)uri);
    }

    private long insertPhone(long rawContactId, ContentValues values) {
        this.parsePhoneValues(values);
        this.mValues.put("raw_contact_id", Long.valueOf(rawContactId));
        Uri uri = this.mContactsProvider.insertInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues);
        return ContentUris.parseId((Uri)uri);
    }

    private long insertContactMethod(long rawContactId, ContentValues values) {
        Integer kind = values.getAsInteger("kind");
        if (kind == null) {
            throw new RuntimeException("Required value: kind");
        }
        this.parseContactMethodValues(kind, values);
        this.mValues.put("raw_contact_id", Long.valueOf(rawContactId));
        Uri uri = this.mContactsProvider.insertInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues);
        return ContentUris.parseId((Uri)uri);
    }

    private long insertExtension(long rawContactId, ContentValues values) {
        this.mValues.clear();
        this.mValues.put("raw_contact_id", Long.valueOf(rawContactId));
        this.mValues.put("mimetype", "vnd.android.cursor.item/contact_extensions");
        this.parseExtensionValues(values);
        Uri uri = this.mContactsProvider.insertInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues);
        return ContentUris.parseId((Uri)uri);
    }

    private long insertGroup(ContentValues values) {
        this.parseGroupValues(values);
        if (this.mAccount != null) {
            this.mValues.put("account_name", this.mAccount.name);
            this.mValues.put("account_type", this.mAccount.type);
        }
        Uri uri = this.mContactsProvider.insertInTransaction(ContactsContract.Groups.CONTENT_URI, this.mValues);
        return ContentUris.parseId((Uri)uri);
    }

    private long insertGroupMembership(long rawContactId, long groupId) {
        this.mValues.clear();
        this.mValues.put("mimetype", "vnd.android.cursor.item/group_membership");
        this.mValues.put("raw_contact_id", Long.valueOf(rawContactId));
        this.mValues.put("data1", Long.valueOf(groupId));
        Uri uri = this.mContactsProvider.insertInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues);
        return ContentUris.parseId((Uri)uri);
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        this.ensureDefaultAccount();
        int match = sUriMatcher.match(uri);
        int count = 0;
        switch (match) {
            case 3: {
                count = this.updateContactTime(uri, values);
                break;
            }
            case 24: {
                long rawContactId = Long.parseLong((String)uri.getPathSegments().get(1));
                return this.updatePhoto(rawContactId, values);
            }
            case 44: {
                return this.updateSettings(values);
            }
            case -1: 
            case 20: 
            case 21: {
                throw new UnsupportedOperationException(this.mDbHelper.exceptionMessage(uri));
            }
            default: {
                count = this.updateAll(uri, match, values, selection, selectionArgs);
            }
        }
        if (count > 0) {
            this.mContext.getContentResolver().notifyChange(uri, null);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateAll(Uri uri, int match, ContentValues values, String selection, String[] selectionArgs) {
        Cursor c = this.query(uri, IdQuery.COLUMNS, selection, selectionArgs, null, null);
        if (c == null) {
            return 0;
        }
        int count = 0;
        try {
            while (c.moveToNext()) {
                long id = c.getLong(0);
                count += this.update(match, id, values);
            }
        }
        finally {
            c.close();
        }
        return count;
    }

    public int update(int match, long id, ContentValues values) {
        int count = 0;
        switch (match) {
            case 1: 
            case 2: {
                count = this.updatePeople(id, values);
                break;
            }
            case 4: 
            case 5: {
                count = this.updateOrganizations(id, values);
                break;
            }
            case 12: 
            case 13: {
                count = this.updatePhones(id, values);
                break;
            }
            case 8: 
            case 9: {
                count = this.updateContactMethods(id, values);
                break;
            }
            case 14: 
            case 15: {
                count = this.updateExtensions(id, values);
                break;
            }
            case 18: 
            case 19: {
                count = this.updateGroups(id, values);
                break;
            }
            case 25: 
            case 26: {
                count = this.updatePhotoByDataId(id, values);
            }
        }
        return count;
    }

    private int updatePeople(long rawContactId, ContentValues values) {
        Uri dataUri;
        this.parsePeopleValues(values);
        int count = this.mContactsProvider.update(ContactsContract.RawContacts.CONTENT_URI, this.mValues, "_id=" + rawContactId, null);
        if (count == 0) {
            return 0;
        }
        if (this.mValues2.size() != 0) {
            dataUri = this.findFirstDataRow(rawContactId, "vnd.android.cursor.item/name");
            if (dataUri != null) {
                this.mContactsProvider.update(dataUri, this.mValues2, null, null);
            } else {
                this.mValues2.put("raw_contact_id", Long.valueOf(rawContactId));
                this.mContactsProvider.insertInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues2);
            }
        }
        if (this.mValues3.size() != 0) {
            dataUri = this.findFirstDataRow(rawContactId, "vnd.android.cursor.item/note");
            if (dataUri != null) {
                this.mContactsProvider.update(dataUri, this.mValues3, null, null);
            } else {
                this.mValues3.put("raw_contact_id", Long.valueOf(rawContactId));
                this.mContactsProvider.insertInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues3);
            }
        }
        if (values.containsKey("last_time_contacted") && !values.containsKey("times_contacted")) {
            this.updateContactTime(rawContactId, values);
        }
        return count;
    }

    private int updateOrganizations(long dataId, ContentValues values) {
        this.parseOrganizationValues(values);
        return this.mContactsProvider.updateInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues, "_id=" + dataId, null);
    }

    private int updatePhones(long dataId, ContentValues values) {
        this.parsePhoneValues(values);
        return this.mContactsProvider.updateInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues, "_id=" + dataId, null);
    }

    private int updateContactMethods(long dataId, ContentValues values) {
        int kind;
        long mimetype_id;
        this.mDataMimetypeQuery.bindLong(1, dataId);
        try {
            mimetype_id = this.mDataMimetypeQuery.simpleQueryForLong();
        }
        catch (SQLiteDoneException e) {
            return 0;
        }
        if (mimetype_id == this.mMimetypeEmail) {
            kind = 1;
        } else if (mimetype_id == this.mMimetypeIm) {
            kind = 3;
        } else if (mimetype_id == this.mMimetypePostal) {
            kind = 2;
        } else {
            return 0;
        }
        this.parseContactMethodValues(kind, values);
        return this.mContactsProvider.updateInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues, "_id=" + dataId, null);
    }

    private int updateExtensions(long dataId, ContentValues values) {
        this.parseExtensionValues(values);
        return this.mContactsProvider.updateInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues, "_id=" + dataId, null);
    }

    private int updateGroups(long groupId, ContentValues values) {
        this.parseGroupValues(values);
        return this.mContactsProvider.updateInTransaction(ContactsContract.Groups.CONTENT_URI, this.mValues, "_id=" + groupId, null);
    }

    private int updateContactTime(Uri uri, ContentValues values) {
        long rawContactId = Long.parseLong((String)uri.getPathSegments().get(1));
        this.updateContactTime(rawContactId, values);
        return 1;
    }

    private void updateContactTime(long rawContactId, ContentValues values) {
        long lastTimeContacted = values.containsKey("last_time_contacted") ? values.getAsLong("last_time_contacted") : System.currentTimeMillis();
        long contactId = this.mDbHelper.getContactId(rawContactId);
        SQLiteDatabase mDb = this.mDbHelper.getWritableDatabase();
        this.mSelectionArgs2[0] = String.valueOf(lastTimeContacted);
        if (contactId != 0L) {
            this.mSelectionArgs2[1] = String.valueOf(contactId);
            mDb.execSQL(CONTACTS_UPDATE_LASTTIMECONTACTED, (Object[])this.mSelectionArgs2);
            this.mSelectionArgs1[0] = String.valueOf(contactId);
            mDb.execSQL("UPDATE contacts SET times_contacted= CASE WHEN times_contacted IS NULL THEN 1 ELSE  (times_contacted + 1) END WHERE _id=?", (Object[])this.mSelectionArgs1);
        }
        this.mSelectionArgs2[1] = String.valueOf(rawContactId);
        mDb.execSQL(RAWCONTACTS_UPDATE_LASTTIMECONTACTED, (Object[])this.mSelectionArgs2);
        this.mSelectionArgs1[0] = String.valueOf(contactId);
        mDb.execSQL("UPDATE raw_contacts SET times_contacted= CASE WHEN times_contacted IS NULL THEN 1 ELSE  (times_contacted + 1) END WHERE contact_id=?", (Object[])this.mSelectionArgs1);
    }

    private int updatePhoto(long rawContactId, ContentValues values) {
        int count;
        long dataId = this.findFirstDataId(rawContactId, "vnd.android.cursor.item/photo");
        this.mValues.clear();
        byte[] bytes = values.getAsByteArray("data");
        this.mValues.put("data15", bytes);
        if (dataId == -1L) {
            this.mValues.put("mimetype", "vnd.android.cursor.item/photo");
            this.mValues.put("raw_contact_id", Long.valueOf(rawContactId));
            Uri dataUri = this.mContactsProvider.insertInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues);
            dataId = ContentUris.parseId((Uri)dataUri);
            count = 1;
        } else {
            Uri dataUri = ContentUris.withAppendedId((Uri)ContactsContract.Data.CONTENT_URI, (long)dataId);
            count = this.mContactsProvider.updateInTransaction(dataUri, this.mValues, null, null);
        }
        this.updateLegacyPhotoData(rawContactId, dataId, values);
        return count;
    }

    private int updatePhotoByDataId(long dataId, ContentValues values) {
        long rawContactId;
        this.mDataRawContactIdQuery.bindLong(1, dataId);
        try {
            rawContactId = this.mDataRawContactIdQuery.simpleQueryForLong();
        }
        catch (SQLiteDoneException e) {
            return 0;
        }
        if (values.containsKey("data")) {
            byte[] bytes = values.getAsByteArray("data");
            this.mValues.clear();
            this.mValues.put("data15", bytes);
            this.mContactsProvider.updateInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues, "_id=" + dataId, null);
        }
        this.updateLegacyPhotoData(rawContactId, dataId, values);
        return 1;
    }

    private void updateLegacyPhotoData(long rawContactId, long dataId, ContentValues values) {
        this.mValues.clear();
        ContactsDatabaseHelper.copyStringValue(this.mValues, "data2", values, "local_version");
        ContactsDatabaseHelper.copyStringValue(this.mValues, "data3", values, "download_required");
        ContactsDatabaseHelper.copyStringValue(this.mValues, "data4", values, "exists_on_server");
        ContactsDatabaseHelper.copyStringValue(this.mValues, "data5", values, "sync_error");
        int updated = this.mContactsProvider.updateInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues, "mimetype='vnd.android.cursor.item/photo_v1_extras' AND raw_contact_id=" + rawContactId + " AND " + "data1" + "=" + dataId, null);
        if (updated == 0) {
            this.mValues.put("raw_contact_id", Long.valueOf(rawContactId));
            this.mValues.put("mimetype", "vnd.android.cursor.item/photo_v1_extras");
            this.mValues.put("data1", Long.valueOf(dataId));
            this.mContactsProvider.insertInTransaction(ContactsContract.Data.CONTENT_URI, this.mValues);
        }
    }

    private int updateSettings(ContentValues values) {
        SQLiteDatabase db = this.mDbHelper.getWritableDatabase();
        String accountName = values.getAsString("_sync_account");
        String accountType = values.getAsString("_sync_account_type");
        String key = values.getAsString("key");
        if (key == null) {
            throw new IllegalArgumentException("you must specify the key when updating settings");
        }
        this.updateSetting(db, accountName, accountType, values);
        if (key.equals("syncEverything")) {
            String selection;
            String[] selectionArgs;
            this.mValues.clear();
            this.mValues.put("should_sync", values.getAsInteger("value"));
            if (accountName != null && accountType != null) {
                selectionArgs = new String[]{accountName, accountType};
                selection = "account_name=? AND account_type=?";
            } else {
                selectionArgs = null;
                selection = "account_name IS NULL AND account_type IS NULL";
            }
            int count = this.mContactsProvider.updateInTransaction(ContactsContract.Settings.CONTENT_URI, this.mValues, selection, selectionArgs);
            if (count == 0) {
                this.mValues.put("account_name", accountName);
                this.mValues.put("account_type", accountType);
                this.mContactsProvider.insertInTransaction(ContactsContract.Settings.CONTENT_URI, this.mValues);
            }
        }
        return 1;
    }

    private void updateSetting(SQLiteDatabase db, String accountName, String accountType, ContentValues values) {
        String key = values.getAsString("key");
        if (accountName == null || accountType == null) {
            db.delete("v1_settings", "_sync_account IS NULL AND key=?", new String[]{key});
        } else {
            db.delete("v1_settings", "_sync_account=? AND _sync_account_type=? AND key=?", new String[]{accountName, accountType, key});
        }
        long rowId = db.insert("v1_settings", "key", values);
        if (rowId < 0L) {
            throw new SQLException("error updating settings with " + values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copySettingsToLegacySettings() {
        SQLiteDatabase db = this.mDbHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("SELECT account_name,account_type,should_sync FROM settings LEFT OUTER JOIN v1_settings ON (account_name=_sync_account AND account_type=_sync_account_type AND key='syncEverything') WHERE should_sync<>value", null);
        try {
            while (cursor.moveToNext()) {
                String accountName = cursor.getString(0);
                String accountType = cursor.getString(1);
                String value = cursor.getString(2);
                this.mValues.clear();
                this.mValues.put("_sync_account", accountName);
                this.mValues.put("_sync_account_type", accountType);
                this.mValues.put("key", "syncEverything");
                this.mValues.put("value", value);
                this.updateSetting(db, accountName, accountType, this.mValues);
            }
        }
        finally {
            cursor.close();
        }
    }

    private void parsePeopleValues(ContentValues values) {
        this.mValues.clear();
        this.mValues2.clear();
        this.mValues3.clear();
        ContactsDatabaseHelper.copyStringValue(this.mValues, "custom_ringtone", values, "custom_ringtone");
        ContactsDatabaseHelper.copyLongValue(this.mValues, "send_to_voicemail", values, "send_to_voicemail");
        ContactsDatabaseHelper.copyLongValue(this.mValues, "last_time_contacted", values, "last_time_contacted");
        ContactsDatabaseHelper.copyLongValue(this.mValues, "times_contacted", values, "times_contacted");
        ContactsDatabaseHelper.copyLongValue(this.mValues, "starred", values, "starred");
        if (this.mAccount != null) {
            this.mValues.put("account_name", this.mAccount.name);
            this.mValues.put("account_type", this.mAccount.type);
        }
        if (values.containsKey("name") || values.containsKey("phonetic_name")) {
            this.mValues2.put("mimetype", "vnd.android.cursor.item/name");
            ContactsDatabaseHelper.copyStringValue(this.mValues2, "data1", values, "name");
            if (values.containsKey("phonetic_name")) {
                String phoneticName = values.getAsString("phonetic_name");
                NameSplitter.Name parsedName = new NameSplitter.Name();
                this.mPhoneticNameSplitter.split(parsedName, phoneticName);
                this.mValues2.put("data7", parsedName.getGivenNames());
                this.mValues2.put("data8", parsedName.getMiddleName());
                this.mValues2.put("data9", parsedName.getFamilyName());
            }
        }
        if (values.containsKey("notes")) {
            this.mValues3.put("mimetype", "vnd.android.cursor.item/note");
            ContactsDatabaseHelper.copyStringValue(this.mValues3, "data1", values, "notes");
        }
    }

    private void parseOrganizationValues(ContentValues values) {
        this.mValues.clear();
        this.mValues.put("mimetype", "vnd.android.cursor.item/organization");
        ContactsDatabaseHelper.copyLongValue(this.mValues, "is_primary", values, "isprimary");
        ContactsDatabaseHelper.copyStringValue(this.mValues, "data1", values, "company");
        ContactsDatabaseHelper.copyLongValue(this.mValues, "data2", values, "type");
        ContactsDatabaseHelper.copyStringValue(this.mValues, "data3", values, "label");
        ContactsDatabaseHelper.copyStringValue(this.mValues, "data4", values, "title");
    }

    private void parsePhoneValues(ContentValues values) {
        this.mValues.clear();
        this.mValues.put("mimetype", "vnd.android.cursor.item/phone_v2");
        ContactsDatabaseHelper.copyLongValue(this.mValues, "is_primary", values, "isprimary");
        ContactsDatabaseHelper.copyStringValue(this.mValues, "data1", values, "number");
        ContactsDatabaseHelper.copyLongValue(this.mValues, "data2", values, "type");
        ContactsDatabaseHelper.copyStringValue(this.mValues, "data3", values, "label");
    }

    private void parseContactMethodValues(int kind, ContentValues values) {
        this.mValues.clear();
        ContactsDatabaseHelper.copyLongValue(this.mValues, "is_primary", values, "isprimary");
        switch (kind) {
            case 1: {
                this.copyCommonFields(values, "vnd.android.cursor.item/email_v2", "data2", "data3", "data14");
                ContactsDatabaseHelper.copyStringValue(this.mValues, "data1", values, "data");
                break;
            }
            case 3: {
                String protocol = values.getAsString("data");
                if (protocol.startsWith("pre:")) {
                    this.mValues.put("data5", Integer.valueOf(Integer.parseInt(protocol.substring(4))));
                } else if (protocol.startsWith("custom:")) {
                    this.mValues.put("data5", Integer.valueOf(-1));
                    this.mValues.put("data6", protocol.substring(7));
                }
                this.copyCommonFields(values, "vnd.android.cursor.item/im", "data2", "data3", "data14");
                break;
            }
            case 2: {
                this.copyCommonFields(values, "vnd.android.cursor.item/postal-address_v2", "data2", "data3", "data14");
                ContactsDatabaseHelper.copyStringValue(this.mValues, "data1", values, "data");
            }
        }
    }

    private void copyCommonFields(ContentValues values, String mimeType, String typeColumn, String labelColumn, String auxDataColumn) {
        this.mValues.put("mimetype", mimeType);
        ContactsDatabaseHelper.copyLongValue(this.mValues, typeColumn, values, "type");
        ContactsDatabaseHelper.copyStringValue(this.mValues, labelColumn, values, "label");
        ContactsDatabaseHelper.copyStringValue(this.mValues, auxDataColumn, values, "aux_data");
    }

    private void parseGroupValues(ContentValues values) {
        this.mValues.clear();
        ContactsDatabaseHelper.copyStringValue(this.mValues, "title", values, "name");
        ContactsDatabaseHelper.copyStringValue(this.mValues, "notes", values, "notes");
        ContactsDatabaseHelper.copyStringValue(this.mValues, "system_id", values, "system_id");
    }

    private void parseExtensionValues(ContentValues values) {
        ContactsDatabaseHelper.copyStringValue(this.mValues, "data1", values, "name");
        ContactsDatabaseHelper.copyStringValue(this.mValues, "data2", values, "value");
    }

    private Uri findFirstDataRow(long rawContactId, String contentItemType) {
        long dataId = this.findFirstDataId(rawContactId, contentItemType);
        if (dataId == -1L) {
            return null;
        }
        return ContentUris.withAppendedId((Uri)ContactsContract.Data.CONTENT_URI, (long)dataId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findFirstDataId(long rawContactId, String mimeType) {
        long dataId = -1L;
        Cursor c = this.mContactsProvider.query(ContactsContract.Data.CONTENT_URI, IdQuery.COLUMNS, "raw_contact_id=" + rawContactId + " AND " + "mimetype" + "='" + mimeType + "'", null, null);
        try {
            if (c.moveToFirst()) {
                dataId = c.getLong(0);
            }
        }
        finally {
            c.close();
        }
        return dataId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        int match = sUriMatcher.match(uri);
        if (match == -1 || match == 44) {
            throw new UnsupportedOperationException(this.mDbHelper.exceptionMessage(uri));
        }
        Cursor c = this.query(uri, IdQuery.COLUMNS, selection, selectionArgs, null, null);
        if (c == null) {
            return 0;
        }
        int count = 0;
        try {
            while (c.moveToNext()) {
                long id = c.getLong(0);
                count += this.delete(uri, match, id);
            }
        }
        finally {
            c.close();
        }
        return count;
    }

    public int delete(Uri uri, int match, long id) {
        int count = 0;
        switch (match) {
            case 1: 
            case 2: {
                count = this.mContactsProvider.deleteRawContact(id, this.mDbHelper.getContactId(id), false);
                break;
            }
            case 24: {
                this.mValues.clear();
                this.mValues.putNull("data");
                this.updatePhoto(id, this.mValues);
                break;
            }
            case 4: 
            case 5: {
                count = this.mContactsProvider.deleteData(id, ORGANIZATION_MIME_TYPES);
                break;
            }
            case 8: 
            case 9: {
                count = this.mContactsProvider.deleteData(id, CONTACT_METHOD_MIME_TYPES);
                break;
            }
            case 12: 
            case 13: {
                count = this.mContactsProvider.deleteData(id, PHONE_MIME_TYPES);
                break;
            }
            case 14: 
            case 15: {
                count = this.mContactsProvider.deleteData(id, EXTENSION_MIME_TYPES);
                break;
            }
            case 25: 
            case 26: {
                count = this.mContactsProvider.deleteData(id, PHOTO_MIME_TYPES);
                break;
            }
            case 20: 
            case 21: {
                count = this.mContactsProvider.deleteData(id, GROUP_MEMBERSHIP_MIME_TYPES);
                break;
            }
            case 18: 
            case 19: {
                count = this.mContactsProvider.deleteGroup(uri, id, false);
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.mDbHelper.exceptionMessage(uri));
            }
        }
        return count;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, String limit) {
        this.ensureDefaultAccount();
        SQLiteDatabase db = this.mDbHelper.getReadableDatabase();
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        String groupBy = null;
        int match = sUriMatcher.match(uri);
        switch (match) {
            case 1: {
                qb.setTables("view_v1_people people  LEFT OUTER JOIN presence ON (presence.presence_data_id=(SELECT MAX(presence_data_id) FROM presence WHERE people._id = presence_raw_contact_id) )");
                qb.setProjectionMap(sPeopleProjectionMap);
                this.applyRawContactsAccount(qb);
                break;
            }
            case 2: {
                qb.setTables("view_v1_people people  LEFT OUTER JOIN presence ON (presence.presence_data_id=(SELECT MAX(presence_data_id) FROM presence WHERE people._id = presence_raw_contact_id) )");
                qb.setProjectionMap(sPeopleProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND _id=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                break;
            }
            case 29: {
                qb.setTables("view_v1_people people  LEFT OUTER JOIN presence ON (presence.presence_data_id=(SELECT MAX(presence_data_id) FROM presence WHERE people._id = presence_raw_contact_id) )");
                qb.setProjectionMap(sPeopleProjectionMap);
                this.applyRawContactsAccount(qb);
                String filterParam = (String)uri.getPathSegments().get(2);
                qb.appendWhere((CharSequence)(" AND _id IN " + this.mContactsProvider.getRawContactsByFilterAsNestedQuery(filterParam)));
                break;
            }
            case 40: {
                qb.setTables("view_v1_people people  LEFT OUTER JOIN presence ON (presence.presence_data_id=(SELECT MAX(presence_data_id) FROM presence WHERE people._id = presence_raw_contact_id) )");
                qb.setProjectionMap(sPeopleProjectionMap);
                this.applyRawContactsAccount(qb);
                String group = (String)uri.getPathSegments().get(2);
                qb.appendWhere((CharSequence)(" AND " + this.buildGroupNameMatchWhereClause(group)));
                break;
            }
            case 41: {
                qb.setTables("view_v1_people people  LEFT OUTER JOIN presence ON (presence.presence_data_id=(SELECT MAX(presence_data_id) FROM presence WHERE people._id = presence_raw_contact_id) )");
                qb.setProjectionMap(sPeopleProjectionMap);
                this.applyRawContactsAccount(qb);
                String systemId = (String)uri.getPathSegments().get(2);
                qb.appendWhere((CharSequence)(" AND " + this.buildGroupSystemIdMatchWhereClause(systemId)));
                break;
            }
            case 4: {
                qb.setTables("view_v1_organizations organizations");
                qb.setProjectionMap(sOrganizationProjectionMap);
                this.applyRawContactsAccount(qb);
                break;
            }
            case 5: {
                qb.setTables("view_v1_organizations organizations");
                qb.setProjectionMap(sOrganizationProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND _id=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                break;
            }
            case 42: {
                qb.setTables("view_v1_organizations organizations");
                qb.setProjectionMap(sOrganizationProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND person=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                break;
            }
            case 43: {
                qb.setTables("view_v1_organizations organizations");
                qb.setProjectionMap(sOrganizationProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND person=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                qb.appendWhere((CharSequence)" AND _id=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(3));
                break;
            }
            case 8: {
                qb.setTables("view_v1_contact_methods contact_methods");
                qb.setProjectionMap(sContactMethodProjectionMap);
                this.applyRawContactsAccount(qb);
                break;
            }
            case 9: {
                qb.setTables("view_v1_contact_methods contact_methods");
                qb.setProjectionMap(sContactMethodProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND _id=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                break;
            }
            case 39: {
                qb.setTables("view_v1_contact_methods contact_methods");
                qb.setProjectionMap(sContactMethodProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND kind=1");
                break;
            }
            case 6: {
                qb.setTables("view_v1_contact_methods contact_methods");
                qb.setProjectionMap(sContactMethodProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND person=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                qb.appendWhere((CharSequence)" AND kind IS NOT NULL");
                break;
            }
            case 7: {
                qb.setTables("view_v1_contact_methods contact_methods");
                qb.setProjectionMap(sContactMethodProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND person=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                qb.appendWhere((CharSequence)" AND _id=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(3));
                qb.appendWhere((CharSequence)" AND kind IS NOT NULL");
                break;
            }
            case 12: {
                qb.setTables("view_v1_phones phones");
                qb.setProjectionMap(sPhoneProjectionMap);
                this.applyRawContactsAccount(qb);
                break;
            }
            case 13: {
                qb.setTables("view_v1_phones phones");
                qb.setProjectionMap(sPhoneProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND _id=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                break;
            }
            case 34: {
                qb.setTables("view_v1_phones phones");
                qb.setProjectionMap(sPhoneProjectionMap);
                this.applyRawContactsAccount(qb);
                if (uri.getPathSegments().size() <= 2) break;
                String filterParam = uri.getLastPathSegment();
                qb.appendWhere((CharSequence)" AND person =");
                qb.appendWhere((CharSequence)this.mDbHelper.buildPhoneLookupAsNestedQuery(filterParam));
                break;
            }
            case 10: {
                qb.setTables("view_v1_phones phones");
                qb.setProjectionMap(sPhoneProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND person=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                break;
            }
            case 11: {
                qb.setTables("view_v1_phones phones");
                qb.setProjectionMap(sPhoneProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND person=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                qb.appendWhere((CharSequence)" AND _id=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(3));
                break;
            }
            case 14: {
                qb.setTables("view_v1_extensions extensions");
                qb.setProjectionMap(sExtensionProjectionMap);
                this.applyRawContactsAccount(qb);
                break;
            }
            case 15: {
                qb.setTables("view_v1_extensions extensions");
                qb.setProjectionMap(sExtensionProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND _id=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                break;
            }
            case 16: {
                qb.setTables("view_v1_extensions extensions");
                qb.setProjectionMap(sExtensionProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND person=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                break;
            }
            case 17: {
                qb.setTables("view_v1_extensions extensions");
                qb.setProjectionMap(sExtensionProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND person=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                qb.appendWhere((CharSequence)" AND _id=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(3));
                break;
            }
            case 18: {
                qb.setTables("view_v1_groups groups");
                qb.setProjectionMap(sGroupProjectionMap);
                this.applyGroupAccount(qb);
                break;
            }
            case 19: {
                qb.setTables("view_v1_groups groups");
                qb.setProjectionMap(sGroupProjectionMap);
                this.applyGroupAccount(qb);
                qb.appendWhere((CharSequence)" AND _id=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                break;
            }
            case 20: {
                qb.setTables("view_v1_group_membership groupmembership");
                qb.setProjectionMap(sGroupMembershipProjectionMap);
                this.applyRawContactsAccount(qb);
                break;
            }
            case 21: {
                qb.setTables("view_v1_group_membership groupmembership");
                qb.setProjectionMap(sGroupMembershipProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND _id=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                break;
            }
            case 22: {
                qb.setTables("view_v1_group_membership groupmembership");
                qb.setProjectionMap(sGroupMembershipProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND person=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                break;
            }
            case 23: {
                qb.setTables("view_v1_group_membership groupmembership");
                qb.setProjectionMap(sGroupMembershipProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND person=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                qb.appendWhere((CharSequence)" AND _id=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(3));
                break;
            }
            case 24: {
                qb.setTables("view_v1_photos photos");
                qb.setProjectionMap(sPhotoProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND person=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                limit = "1";
                break;
            }
            case 25: {
                qb.setTables("view_v1_photos photos");
                qb.setProjectionMap(sPhotoProjectionMap);
                this.applyRawContactsAccount(qb);
                break;
            }
            case 26: {
                qb.setTables("view_v1_photos photos");
                qb.setProjectionMap(sPhotoProjectionMap);
                this.applyRawContactsAccount(qb);
                qb.appendWhere((CharSequence)" AND _id=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                break;
            }
            case 32: {
                return this.mGlobalSearchSupport.handleSearchSuggestionsQuery(db, uri, limit);
            }
            case 33: {
                String lookupKey = uri.getLastPathSegment();
                return this.mGlobalSearchSupport.handleSearchShortcutRefresh(db, lookupKey, projection);
            }
            case 35: {
                return this.mContactsProvider.query(LIVE_FOLDERS_CONTACTS_URI, projection, selection, selectionArgs, sortOrder);
            }
            case 37: {
                return this.mContactsProvider.query(LIVE_FOLDERS_CONTACTS_WITH_PHONES_URI, projection, selection, selectionArgs, sortOrder);
            }
            case 38: {
                return this.mContactsProvider.query(LIVE_FOLDERS_CONTACTS_FAVORITES_URI, projection, selection, selectionArgs, sortOrder);
            }
            case 36: {
                return this.mContactsProvider.query(Uri.withAppendedPath((Uri)LIVE_FOLDERS_CONTACTS_URI, (String)Uri.encode((String)uri.getLastPathSegment())), projection, selection, selectionArgs, sortOrder);
            }
            case 30: 
            case 31: {
                throw new UnsupportedOperationException(this.mDbHelper.exceptionMessage(uri));
            }
            case 44: {
                this.copySettingsToLegacySettings();
                qb.setTables("v1_settings");
                break;
            }
            default: {
                throw new IllegalArgumentException(this.mDbHelper.exceptionMessage(uri));
            }
        }
        Cursor c = qb.query(db, projection, selection, selectionArgs, groupBy, null, sortOrder, limit);
        if (c != null) {
            c.setNotificationUri(this.mContext.getContentResolver(), Contacts.CONTENT_URI);
        }
        return c;
    }

    private void applyRawContactsAccount(SQLiteQueryBuilder qb) {
        StringBuilder sb = new StringBuilder();
        this.appendRawContactsAccount(sb);
        qb.appendWhere((CharSequence)sb.toString());
    }

    private void appendRawContactsAccount(StringBuilder sb) {
        if (this.mAccount != null) {
            sb.append("account_name=");
            DatabaseUtils.appendEscapedSQLString((StringBuilder)sb, (String)this.mAccount.name);
            sb.append(" AND account_type=");
            DatabaseUtils.appendEscapedSQLString((StringBuilder)sb, (String)this.mAccount.type);
        } else {
            sb.append("account_name IS NULL AND account_type IS NULL");
        }
    }

    private void applyGroupAccount(SQLiteQueryBuilder qb) {
        StringBuilder sb = new StringBuilder();
        this.appendGroupAccount(sb);
        qb.appendWhere((CharSequence)sb.toString());
    }

    private void appendGroupAccount(StringBuilder sb) {
        if (this.mAccount != null) {
            sb.append("account_name=");
            DatabaseUtils.appendEscapedSQLString((StringBuilder)sb, (String)this.mAccount.name);
            sb.append(" AND account_type=");
            DatabaseUtils.appendEscapedSQLString((StringBuilder)sb, (String)this.mAccount.type);
        } else {
            sb.append("account_name IS NULL AND account_type IS NULL");
        }
    }

    private String buildGroupNameMatchWhereClause(String groupName) {
        return "people._id IN (SELECT data.raw_contact_id FROM data JOIN mimetypes ON (data.mimetype_id = mimetypes._id) WHERE mimetype='vnd.android.cursor.item/group_membership' AND data1=(SELECT groups._id FROM groups WHERE title=" + DatabaseUtils.sqlEscapeString((String)groupName) + "))";
    }

    private String buildGroupSystemIdMatchWhereClause(String systemId) {
        return "people._id IN (SELECT data.raw_contact_id FROM data JOIN mimetypes ON (data.mimetype_id = mimetypes._id) WHERE mimetype='vnd.android.cursor.item/group_membership' AND data1=(SELECT groups._id FROM groups WHERE system_id=" + DatabaseUtils.sqlEscapeString((String)systemId) + "))";
    }

    private void onChange(Uri uri) {
        this.mContext.getContentResolver().notifyChange(Contacts.CONTENT_URI, null);
    }

    public String getType(Uri uri) {
        int match = sUriMatcher.match(uri);
        switch (match) {
            case 14: 
            case 16: {
                return "vnd.android.cursor.dir/contact_extensions";
            }
            case 15: 
            case 17: {
                return "vnd.android.cursor.item/contact_extensions";
            }
            case 1: {
                return "vnd.android.cursor.dir/person";
            }
            case 2: {
                return "vnd.android.cursor.item/person";
            }
            case 10: {
                return "vnd.android.cursor.dir/phone";
            }
            case 11: {
                return "vnd.android.cursor.item/phone";
            }
            case 6: {
                return "vnd.android.cursor.dir/contact-methods";
            }
            case 7: {
                return this.getContactMethodType(uri);
            }
            case 12: {
                return "vnd.android.cursor.dir/phone";
            }
            case 13: {
                return "vnd.android.cursor.item/phone";
            }
            case 34: {
                return "vnd.android.cursor.dir/phone";
            }
            case 26: {
                return "vnd.android.cursor.item/photo";
            }
            case 25: {
                return "vnd.android.cursor.dir/photo";
            }
            case 24: {
                return "vnd.android.cursor.item/photo";
            }
            case 8: {
                return "vnd.android.cursor.dir/contact-methods";
            }
            case 9: {
                return this.getContactMethodType(uri);
            }
            case 4: {
                return "vnd.android.cursor.dir/organizations";
            }
            case 5: {
                return "vnd.android.cursor.item/organization";
            }
            case 32: {
                return "vnd.android.cursor.dir/vnd.android.search.suggest";
            }
            case 33: {
                return "vnd.android.cursor.item/vnd.android.search.suggest";
            }
        }
        throw new IllegalArgumentException(this.mDbHelper.exceptionMessage(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getContactMethodType(Uri url) {
        String mime = null;
        Cursor c = this.query(url, new String[]{"kind"}, null, null, null, null);
        if (c == null) return mime;
        try {
            if (!c.moveToFirst()) return mime;
            int kind = c.getInt(0);
            switch (kind) {
                case 1: {
                    mime = "vnd.android.cursor.item/email";
                    return mime;
                }
                case 3: {
                    mime = "vnd.android.cursor.item/jabber-im";
                    return mime;
                }
                case 2: {
                    mime = "vnd.android.cursor.item/postal-address";
                    return mime;
                }
            }
            return mime;
        }
        finally {
            c.close();
        }
    }

    static {
        UriMatcher matcher = sUriMatcher;
        String authority = "contacts";
        matcher.addURI(authority, "extensions", 14);
        matcher.addURI(authority, "extensions/#", 15);
        matcher.addURI(authority, "groups", 18);
        matcher.addURI(authority, "groups/#", 19);
        matcher.addURI(authority, "groups/name/*/members", 40);
        matcher.addURI(authority, "groups/system_id/*/members", 41);
        matcher.addURI(authority, "groupmembership", 20);
        matcher.addURI(authority, "groupmembership/#", 21);
        matcher.addURI(authority, "people", 1);
        matcher.addURI(authority, "people/filter/*", 29);
        matcher.addURI(authority, "people/#", 2);
        matcher.addURI(authority, "people/#/extensions", 16);
        matcher.addURI(authority, "people/#/extensions/#", 17);
        matcher.addURI(authority, "people/#/phones", 10);
        matcher.addURI(authority, "people/#/phones/#", 11);
        matcher.addURI(authority, "people/#/photo", 24);
        matcher.addURI(authority, "people/#/contact_methods", 6);
        matcher.addURI(authority, "people/#/contact_methods/#", 7);
        matcher.addURI(authority, "people/#/organizations", 42);
        matcher.addURI(authority, "people/#/organizations/#", 43);
        matcher.addURI(authority, "people/#/groupmembership", 22);
        matcher.addURI(authority, "people/#/groupmembership/#", 23);
        matcher.addURI(authority, "people/#/update_contact_time", 3);
        matcher.addURI(authority, "deleted_people", 30);
        matcher.addURI(authority, "deleted_groups", 31);
        matcher.addURI(authority, "phones", 12);
        matcher.addURI(authority, "phones/filter/*", 34);
        matcher.addURI(authority, "phones/#", 13);
        matcher.addURI(authority, "photos", 25);
        matcher.addURI(authority, "photos/#", 26);
        matcher.addURI(authority, "contact_methods", 8);
        matcher.addURI(authority, "contact_methods/email", 39);
        matcher.addURI(authority, "contact_methods/#", 9);
        matcher.addURI(authority, "organizations", 4);
        matcher.addURI(authority, "organizations/#", 5);
        matcher.addURI(authority, "search_suggest_query", 32);
        matcher.addURI(authority, "search_suggest_query/*", 32);
        matcher.addURI(authority, "search_suggest_shortcut/*", 33);
        matcher.addURI(authority, "settings", 44);
        matcher.addURI(authority, "live_folders/people", 35);
        matcher.addURI(authority, "live_folders/people/*", 36);
        matcher.addURI(authority, "live_folders/people_with_phones", 37);
        matcher.addURI(authority, "live_folders/favorites", 38);
        HashMap<String, String> peopleProjectionMap = new HashMap<String, String>();
        peopleProjectionMap.put("name", "name");
        peopleProjectionMap.put("display_name", "display_name");
        peopleProjectionMap.put("phonetic_name", "phonetic_name");
        peopleProjectionMap.put("notes", "notes");
        peopleProjectionMap.put("times_contacted", "times_contacted");
        peopleProjectionMap.put("last_time_contacted", "last_time_contacted");
        peopleProjectionMap.put("custom_ringtone", "custom_ringtone");
        peopleProjectionMap.put("send_to_voicemail", "send_to_voicemail");
        peopleProjectionMap.put("starred", "starred");
        peopleProjectionMap.put("primary_organization", "primary_organization");
        peopleProjectionMap.put("primary_email", "primary_email");
        peopleProjectionMap.put("primary_phone", "primary_phone");
        sPeopleProjectionMap = new HashMap(peopleProjectionMap);
        sPeopleProjectionMap.put("_id", "_id");
        sPeopleProjectionMap.put("number", "number");
        sPeopleProjectionMap.put("type", "type");
        sPeopleProjectionMap.put("label", "label");
        sPeopleProjectionMap.put("number_key", "number_key");
        sPeopleProjectionMap.put("im_protocol", "(CASE WHEN protocol=-1 THEN 'custom:'||custom_protocol ELSE 'pre:'||protocol END) AS im_protocol");
        sPeopleProjectionMap.put("im_handle", "im_handle");
        sPeopleProjectionMap.put("im_account", "im_account");
        sPeopleProjectionMap.put("mode", "mode");
        sPeopleProjectionMap.put("status", "(SELECT status FROM status_updates JOIN data   ON(status_update_data_id=data._id) WHERE data.raw_contact_id=people._id ORDER BY status_ts DESC  LIMIT 1) AS status");
        sOrganizationProjectionMap = new HashMap();
        sOrganizationProjectionMap.put("_id", "_id");
        sOrganizationProjectionMap.put("person", "person");
        sOrganizationProjectionMap.put("isprimary", "isprimary");
        sOrganizationProjectionMap.put("company", "company");
        sOrganizationProjectionMap.put("type", "type");
        sOrganizationProjectionMap.put("label", "label");
        sOrganizationProjectionMap.put("title", "title");
        sContactMethodProjectionMap = new HashMap(peopleProjectionMap);
        sContactMethodProjectionMap.put("_id", "_id");
        sContactMethodProjectionMap.put("person", "person");
        sContactMethodProjectionMap.put("kind", "kind");
        sContactMethodProjectionMap.put("isprimary", "isprimary");
        sContactMethodProjectionMap.put("type", "type");
        sContactMethodProjectionMap.put("data", "data");
        sContactMethodProjectionMap.put("label", "label");
        sContactMethodProjectionMap.put("aux_data", "aux_data");
        sPhoneProjectionMap = new HashMap(peopleProjectionMap);
        sPhoneProjectionMap.put("_id", "_id");
        sPhoneProjectionMap.put("person", "person");
        sPhoneProjectionMap.put("isprimary", "isprimary");
        sPhoneProjectionMap.put("number", "number");
        sPhoneProjectionMap.put("type", "type");
        sPhoneProjectionMap.put("label", "label");
        sPhoneProjectionMap.put("number_key", "number_key");
        sExtensionProjectionMap = new HashMap();
        sExtensionProjectionMap.put("_id", "_id");
        sExtensionProjectionMap.put("person", "person");
        sExtensionProjectionMap.put("name", "name");
        sExtensionProjectionMap.put("value", "value");
        sGroupProjectionMap = new HashMap();
        sGroupProjectionMap.put("_id", "_id");
        sGroupProjectionMap.put("name", "name");
        sGroupProjectionMap.put("notes", "notes");
        sGroupProjectionMap.put("system_id", "system_id");
        sGroupMembershipProjectionMap = new HashMap<String, String>(sGroupProjectionMap);
        sGroupMembershipProjectionMap.put("_id", "_id");
        sGroupMembershipProjectionMap.put("person", "person");
        sGroupMembershipProjectionMap.put("group_id", "group_id");
        sGroupMembershipProjectionMap.put("group_sync_id", "group_sync_id");
        sGroupMembershipProjectionMap.put("group_sync_account", "group_sync_account");
        sGroupMembershipProjectionMap.put("group_sync_account_type", "group_sync_account_type");
        sPhotoProjectionMap = new HashMap();
        sPhotoProjectionMap.put("_id", "_id");
        sPhotoProjectionMap.put("person", "person");
        sPhotoProjectionMap.put("data", "data");
        sPhotoProjectionMap.put("local_version", "local_version");
        sPhotoProjectionMap.put("download_required", "download_required");
        sPhotoProjectionMap.put("exists_on_server", "exists_on_server");
        sPhotoProjectionMap.put("sync_error", "sync_error");
    }

    private static interface SettingsMatchQuery {
        public static final String SQL = "SELECT account_name,account_type,should_sync FROM settings LEFT OUTER JOIN v1_settings ON (account_name=_sync_account AND account_type=_sync_account_type AND key='syncEverything') WHERE should_sync<>value";
        public static final int ACCOUNT_NAME = 0;
        public static final int ACCOUNT_TYPE = 1;
        public static final int SHOULD_SYNC = 2;
    }

    private static interface LegacyPhotoData {
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/photo_v1_extras";
        public static final String PHOTO_DATA_ID = "data1";
        public static final String LOCAL_VERSION = "data2";
        public static final String DOWNLOAD_REQUIRED = "data3";
        public static final String EXISTS_ON_SERVER = "data4";
        public static final String SYNC_ERROR = "data5";
    }

    private static interface IdQuery {
        public static final String[] COLUMNS = new String[]{"_id"};
        public static final int _ID = 0;
    }

    public static interface LegacyTables {
        public static final String PEOPLE = "view_v1_people";
        public static final String PEOPLE_JOIN_PRESENCE = "view_v1_people people  LEFT OUTER JOIN presence ON (presence.presence_data_id=(SELECT MAX(presence_data_id) FROM presence WHERE people._id = presence_raw_contact_id) )";
        public static final String GROUPS = "view_v1_groups";
        public static final String ORGANIZATIONS = "view_v1_organizations";
        public static final String CONTACT_METHODS = "view_v1_contact_methods";
        public static final String PHONES = "view_v1_phones";
        public static final String EXTENSIONS = "view_v1_extensions";
        public static final String GROUP_MEMBERSHIP = "view_v1_group_membership";
        public static final String PHOTOS = "view_v1_photos";
        public static final String SETTINGS = "v1_settings";
    }
}

