/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

public class Hex {
    private static final char[] HEX_DIGITS;
    private static final char[] FIRST_CHAR;
    private static final char[] SECOND_CHAR;
    private static final byte[] DIGITS;

    public static String encodeHex(byte[] array2, boolean zeroTerminated) {
        int index;
        char[] cArray = new char[array2.length * 2];
        int j = 0;
        for (int i = 0; !(i >= array2.length || (index = array2[i] & 0xFF) == 0 && zeroTerminated); ++i) {
            cArray[j++] = FIRST_CHAR[index];
            cArray[j++] = SECOND_CHAR[index];
        }
        return new String(cArray, 0, j);
    }

    public static byte[] decodeHex(String hexString) {
        int length = hexString.length();
        if ((length & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters.");
        }
        boolean badHex = false;
        byte[] out = new byte[length >> 1];
        int i = 0;
        int j = 0;
        while (j < length) {
            char c2;
            char c1;
            if ((c1 = hexString.charAt(j++)) > 'f') {
                badHex = true;
                break;
            }
            byte d1 = DIGITS[c1];
            if (d1 == -1) {
                badHex = true;
                break;
            }
            if ((c2 = hexString.charAt(j++)) > 'f') {
                badHex = true;
                break;
            }
            byte d2 = DIGITS[c2];
            if (d2 == -1) {
                badHex = true;
                break;
            }
            out[i] = (byte)(d1 << 4 | d2);
            ++i;
        }
        if (badHex) {
            throw new IllegalArgumentException("Invalid hexadecimal digit: " + hexString);
        }
        return out;
    }

    static {
        int i;
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        FIRST_CHAR = new char[256];
        SECOND_CHAR = new char[256];
        for (i = 0; i < 256; ++i) {
            Hex.FIRST_CHAR[i] = HEX_DIGITS[i >> 4 & 0xF];
            Hex.SECOND_CHAR[i] = HEX_DIGITS[i & 0xF];
        }
        DIGITS = new byte[103];
        for (i = 0; i <= 70; ++i) {
            Hex.DIGITS[i] = -1;
        }
        for (i = 0; i < 10; i = (int)((byte)(i + 1))) {
            Hex.DIGITS[48 + i] = i;
        }
        for (i = 0; i < 6; i = (int)((byte)(i + 1))) {
            Hex.DIGITS[65 + i] = (byte)(10 + i);
            Hex.DIGITS[97 + i] = (byte)(10 + i);
        }
    }
}

