/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import android.content.ContentUris;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.provider.ContactsContract;
import android.text.TextUtils;
import com.android.common.ArrayListCursor;
import com.android.providers.contacts.ContactsDatabaseHelper;
import com.android.providers.contacts.ContactsProvider2;
import com.android.providers.contacts.NameNormalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class GlobalSearchSupport {
    private static final String[] SEARCH_SUGGESTIONS_BASED_ON_PHONE_NUMBER_COLUMNS = new String[]{"_id", "suggest_text_1", "suggest_text_2", "suggest_icon_1", "suggest_intent_data", "suggest_intent_action", "suggest_shortcut_id"};
    private static final String[] SEARCH_SUGGESTIONS_BASED_ON_NAME_COLUMNS = new String[]{"_id", "suggest_text_1", "suggest_text_2", "suggest_icon_1", "suggest_icon_2", "suggest_intent_data_id", "suggest_shortcut_id"};
    private final ContactsProvider2 mContactsProvider;
    private boolean mMimeTypeIdsLoaded;
    private long mMimeTypeIdEmail;
    private long mMimeTypeIdStructuredName;
    private long mMimeTypeIdOrganization;
    private long mMimeTypeIdPhone;

    public GlobalSearchSupport(ContactsProvider2 contactsProvider) {
        this.mContactsProvider = contactsProvider;
    }

    private void ensureMimetypeIdsLoaded() {
        if (!this.mMimeTypeIdsLoaded) {
            ContactsDatabaseHelper dbHelper = (ContactsDatabaseHelper)this.mContactsProvider.getDatabaseHelper();
            this.mMimeTypeIdStructuredName = dbHelper.getMimeTypeId("vnd.android.cursor.item/name");
            this.mMimeTypeIdOrganization = dbHelper.getMimeTypeId("vnd.android.cursor.item/organization");
            this.mMimeTypeIdPhone = dbHelper.getMimeTypeId("vnd.android.cursor.item/phone_v2");
            this.mMimeTypeIdEmail = dbHelper.getMimeTypeId("vnd.android.cursor.item/email_v2");
            this.mMimeTypeIdsLoaded = true;
        }
    }

    public Cursor handleSearchSuggestionsQuery(SQLiteDatabase db, Uri uri, String limit) {
        if (uri.getPathSegments().size() <= 1) {
            return null;
        }
        String searchClause = uri.getLastPathSegment();
        if (TextUtils.isDigitsOnly((CharSequence)searchClause)) {
            return this.buildCursorForSearchSuggestionsBasedOnPhoneNumber(searchClause);
        }
        return this.buildCursorForSearchSuggestionsBasedOnName(db, searchClause, limit);
    }

    public Cursor handleSearchShortcutRefresh(SQLiteDatabase db, String lookupKey, String[] projection) {
        long contactId;
        this.ensureMimetypeIdsLoaded();
        try {
            contactId = this.mContactsProvider.lookupContactIdByLookupKey(db, lookupKey);
        }
        catch (IllegalArgumentException e) {
            contactId = -1L;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.mContactsProvider.getContactsRestrictions());
        this.appendMimeTypeFilter(sb);
        sb.append(" AND contacts._id=" + contactId);
        return this.buildCursorForSearchSuggestions(db, sb.toString(), projection, null);
    }

    private Cursor buildCursorForSearchSuggestionsBasedOnPhoneNumber(String searchClause) {
        Resources r = this.mContactsProvider.getContext().getResources();
        ArrayList<Object> dialNumber = new ArrayList<Object>();
        dialNumber.add(0);
        String s = r.getString(17040226, new Object[]{searchClause});
        int i = s.indexOf(10);
        if (i < 0) {
            dialNumber.add(s);
            dialNumber.add("");
        } else {
            dialNumber.add(s.substring(0, i));
            dialNumber.add(s.substring(i + 1));
        }
        dialNumber.add(String.valueOf(17301830));
        dialNumber.add("tel:" + searchClause);
        dialNumber.add("android.provider.Contacts.SEARCH_SUGGESTION_DIAL_NUMBER_CLICKED");
        dialNumber.add(null);
        ArrayList<Object> createContact = new ArrayList<Object>();
        createContact.add(1);
        s = r.getString(17040227, new Object[]{searchClause});
        i = s.indexOf(10);
        if (i < 0) {
            createContact.add(s);
            createContact.add("");
        } else {
            createContact.add(s.substring(0, i));
            createContact.add(s.substring(i + 1));
        }
        createContact.add(String.valueOf(17301842));
        createContact.add("tel:" + searchClause);
        createContact.add("android.provider.Contacts.SEARCH_SUGGESTION_CREATE_CONTACT_CLICKED");
        createContact.add("_-1");
        ArrayList<ArrayList> rows = new ArrayList<ArrayList>();
        rows.add(dialNumber);
        rows.add(createContact);
        return new ArrayListCursor(SEARCH_SUGGESTIONS_BASED_ON_PHONE_NUMBER_COLUMNS, rows);
    }

    private Cursor buildCursorForSearchSuggestionsBasedOnName(SQLiteDatabase db, String searchClause, String limit) {
        this.ensureMimetypeIdsLoaded();
        StringBuilder sb = new StringBuilder();
        sb.append(this.mContactsProvider.getContactsRestrictions());
        this.appendMimeTypeFilter(sb);
        sb.append(" AND data.raw_contact_id IN ");
        this.mContactsProvider.appendRawContactsByFilterAsNestedQuery(sb, searchClause);
        sb.append(" AND +in_visible_group=1");
        String selection = sb.toString();
        return this.buildCursorForSearchSuggestions(db, selection, null, limit);
    }

    private void appendMimeTypeFilter(StringBuilder sb) {
        sb.append(" AND +mimetype_id IN (" + this.mMimeTypeIdEmail + "," + this.mMimeTypeIdOrganization + "," + this.mMimeTypeIdPhone + "," + this.mMimeTypeIdStructuredName + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cursor buildCursorForSearchSuggestions(SQLiteDatabase db, String selection, String[] projection, String limit) {
        ArrayList<SearchSuggestion> suggestionList = new ArrayList<SearchSuggestion>();
        HashMap<Long, SearchSuggestion> suggestionMap = new HashMap<Long, SearchSuggestion>();
        Cursor c = db.query(false, "data  JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id)  JOIN contacts ON (raw_contacts.contact_id = contacts._id) JOIN raw_contacts AS name_raw_contact ON (name_raw_contact_id=name_raw_contact._id)", SearchSuggestionQuery.COLUMNS, selection, null, null, null, null, limit);
        try {
            while (c.moveToNext()) {
                long mimetype;
                long contactId = c.getLong(0);
                SearchSuggestion suggestion = (SearchSuggestion)suggestionMap.get(contactId);
                if (suggestion == null) {
                    suggestion = new SearchSuggestion(contactId);
                    suggestionList.add(suggestion);
                    suggestionMap.put(contactId, suggestion);
                }
                boolean isSuperPrimary = c.getInt(5) != 0;
                suggestion.text1 = c.getString(1);
                if (!c.isNull(2)) {
                    suggestion.presence = c.getInt(2);
                }
                if ((mimetype = c.getLong(4)) == this.mMimeTypeIdStructuredName) {
                    suggestion.titleIsName = true;
                } else if (mimetype == this.mMimeTypeIdOrganization) {
                    if (isSuperPrimary || suggestion.organization == null) {
                        suggestion.organization = c.getString(6);
                    }
                } else if (mimetype == this.mMimeTypeIdEmail) {
                    if (isSuperPrimary || suggestion.email == null) {
                        suggestion.email = c.getString(6);
                    }
                } else if (mimetype == this.mMimeTypeIdPhone && (isSuperPrimary || suggestion.phoneNumber == null)) {
                    suggestion.phoneNumber = c.getString(6);
                }
                if (!c.isNull(7)) {
                    suggestion.photoUri = Uri.withAppendedPath((Uri)ContentUris.withAppendedId((Uri)ContactsContract.Contacts.CONTENT_URI, (long)contactId), (String)"photo");
                }
                suggestion.lookupKey = c.getString(8);
            }
        }
        finally {
            c.close();
        }
        Collections.sort(suggestionList, new Comparator<SearchSuggestion>(){

            @Override
            public int compare(SearchSuggestion row1, SearchSuggestion row2) {
                return row1.getSortKey().compareTo(row2.getSortKey());
            }
        });
        ArrayList<ArrayList> rows = new ArrayList<ArrayList>();
        for (int i = 0; i < suggestionList.size(); ++i) {
            rows.add(((SearchSuggestion)suggestionList.get(i)).asList(projection));
        }
        return new ArrayListCursor(projection != null ? projection : SEARCH_SUGGESTIONS_BASED_ON_NAME_COLUMNS, rows);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchSuggestion {
        long contactId;
        boolean titleIsName;
        String organization;
        String email;
        String phoneNumber;
        Uri photoUri;
        String lookupKey;
        String normalizedName;
        int presence = -1;
        boolean processed;
        String text1;
        String text2;
        String icon1;
        String icon2;

        public SearchSuggestion(long contactId) {
            this.contactId = contactId;
        }

        private void process() {
            boolean titleIsPhone;
            if (this.processed) {
                return;
            }
            boolean hasOrganization = !TextUtils.isEmpty((CharSequence)this.organization);
            boolean hasEmail = !TextUtils.isEmpty((CharSequence)this.email);
            boolean hasPhone = !TextUtils.isEmpty((CharSequence)this.phoneNumber);
            boolean titleIsOrganization = !this.titleIsName && hasOrganization;
            boolean titleIsEmail = !this.titleIsName && !titleIsOrganization && hasEmail;
            boolean bl = titleIsPhone = !this.titleIsName && !titleIsOrganization && !titleIsEmail && hasPhone;
            if (!titleIsOrganization && hasOrganization) {
                this.text2 = this.organization;
            } else if (!titleIsPhone && hasPhone) {
                this.text2 = this.phoneNumber;
            } else if (!titleIsEmail && hasEmail) {
                this.text2 = this.email;
            }
            this.icon1 = this.photoUri != null ? this.photoUri.toString() : String.valueOf(17301905);
            if (this.presence != -1) {
                this.icon2 = String.valueOf(ContactsContract.StatusUpdates.getPresenceIconResourceId((int)this.presence));
            }
            this.processed = true;
        }

        public String getSortKey() {
            if (this.normalizedName == null) {
                this.process();
                this.normalizedName = this.text1 == null ? "" : NameNormalizer.normalize(this.text1);
            }
            return this.normalizedName;
        }

        public ArrayList asList(String[] projection) {
            this.process();
            ArrayList<Object> list = new ArrayList<Object>();
            if (projection == null) {
                list.add(this.contactId);
                list.add(this.text1);
                list.add(this.text2);
                list.add(this.icon1);
                list.add(this.icon2);
                list.add(this.lookupKey);
                list.add(this.lookupKey);
            } else {
                for (int i = 0; i < projection.length; ++i) {
                    this.addColumnValue(list, projection[i]);
                }
            }
            return list;
        }

        private void addColumnValue(ArrayList<Object> list, String column) {
            if ("_id".equals(column)) {
                list.add(this.contactId);
            } else if ("suggest_text_1".equals(column)) {
                list.add(this.text1);
            } else if ("suggest_text_2".equals(column)) {
                list.add(this.text2);
            } else if ("suggest_icon_1".equals(column)) {
                list.add(this.icon1);
            } else if ("suggest_icon_2".equals(column)) {
                list.add(this.icon2);
            } else if ("suggest_intent_data_id".equals(column)) {
                list.add(this.lookupKey);
            } else if ("suggest_shortcut_id".equals(column)) {
                list.add(this.lookupKey);
            } else {
                throw new IllegalArgumentException("Invalid column name: " + column);
            }
        }
    }

    private static interface SearchSuggestionQuery {
        public static final String TABLE = "data  JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id)  JOIN contacts ON (raw_contacts.contact_id = contacts._id) JOIN raw_contacts AS name_raw_contact ON (name_raw_contact_id=name_raw_contact._id)";
        public static final String PRESENCE_SQL = "(SELECT mode FROM agg_presence WHERE presence_contact_id=contacts._id)";
        public static final String[] COLUMNS = new String[]{"contacts._id AS _id", "name_raw_contact.display_name AS display_name", "(SELECT mode FROM agg_presence WHERE presence_contact_id=contacts._id) AS contact_presence", "data._id AS data_id", "mimetype_id", "is_super_primary", "data1", "photo_id", "lookup"};
        public static final int CONTACT_ID = 0;
        public static final int DISPLAY_NAME = 1;
        public static final int PRESENCE_STATUS = 2;
        public static final int DATA_ID = 3;
        public static final int MIMETYPE_ID = 4;
        public static final int IS_SUPER_PRIMARY = 5;
        public static final int ORGANIZATION = 6;
        public static final int EMAIL = 6;
        public static final int PHONE = 6;
        public static final int PHOTO_ID = 7;
        public static final int LOOKUP_KEY = 8;
    }
}

