/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;
import com.android.providers.contacts.ContactsDatabaseHelper;
import com.android.providers.contacts.EventLogTags;

public class ContactsUpgradeReceiver
extends BroadcastReceiver {
    static final String TAG = "ContactsUpgradeReceiver";
    static final String PREF_DB_VERSION = "db_version";

    public void onReceive(Context context, Intent intent) {
        try {
            long startTime = System.currentTimeMillis();
            SharedPreferences prefs = context.getSharedPreferences(TAG, 0);
            int prefVersion = prefs.getInt(PREF_DB_VERSION, 0);
            if (prefVersion != 353) {
                prefs.edit().putInt(PREF_DB_VERSION, 353).apply();
                Log.i((String)TAG, (String)"Creating or opening contacts database");
                ContactsDatabaseHelper helper = ContactsDatabaseHelper.getInstance(context);
                helper.getWritableDatabase();
                helper.close();
                EventLogTags.writeContactsUpgradeReceiver(System.currentTimeMillis() - startTime);
            }
        }
        catch (Throwable t) {
            Log.wtf((String)TAG, (String)"Error during upgrade attempt. Disabling receiver.", (Throwable)t);
            context.getPackageManager().setComponentEnabledSetting(new ComponentName(context, ((Object)((Object)this)).getClass()), 2, 1);
        }
    }
}

