/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.OnAccountsUpdateListener;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentService;
import android.content.Intent;
import android.content.OperationApplicationException;
import android.content.SharedPreferences;
import android.content.SyncAdapterType;
import android.content.UriMatcher;
import android.content.res.AssetFileDescriptor;
import android.content.res.Configuration;
import android.database.CharArrayBuffer;
import android.database.Cursor;
import android.database.CursorWrapper;
import android.database.DatabaseUtils;
import android.database.MatrixCursor;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteContentHelper;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.database.sqlite.SQLiteStatement;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.MemoryFile;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.pim.vcard.VCardComposer;
import android.pim.vcard.VCardConfig;
import android.preference.PreferenceManager;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Log;
import com.android.providers.contacts.CommonNicknameCache;
import com.android.providers.contacts.ContactAggregator;
import com.android.providers.contacts.ContactLocaleUtils;
import com.android.providers.contacts.ContactLookupKey;
import com.android.providers.contacts.ContactsDatabaseHelper;
import com.android.providers.contacts.GlobalSearchSupport;
import com.android.providers.contacts.LegacyApiSupport;
import com.android.providers.contacts.LegacyContactImporter;
import com.android.providers.contacts.NameLookupBuilder;
import com.android.providers.contacts.NameNormalizer;
import com.android.providers.contacts.NameSplitter;
import com.android.providers.contacts.PhotoPriorityResolver;
import com.android.providers.contacts.PostalSplitter;
import com.android.providers.contacts.SQLiteContentProvider;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import com.google.android.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactsProvider2
extends SQLiteContentProvider
implements OnAccountsUpdateListener {
    private static final String TAG = "ContactsProvider";
    private static final boolean VERBOSE_LOGGING = Log.isLoggable((String)"ContactsProvider", (int)2);
    private static final int DEFAULT_MAX_SUGGESTIONS = 5;
    private static final String GOOGLE_MY_CONTACTS_GROUP_TITLE = "System Group: My Contacts";
    private static final String PROPERTY_CONTACTS_IMPORTED = "contacts_imported_v1";
    private static final int PROPERTY_CONTACTS_IMPORT_VERSION = 1;
    private static final String PREF_LOCALE = "locale";
    private static final String PROPERTY_AGGREGATION_ALGORITHM = "aggregation_v2";
    private static final int PROPERTY_AGGREGATION_ALGORITHM_VERSION = 2;
    private static final String AGGREGATE_CONTACTS = "sync.contacts.aggregate";
    private static final UriMatcher sUriMatcher = new UriMatcher(-1);
    private static final String TIMES_CONTACED_SORT_COLUMN = "times_contacted_sort";
    private static final String STREQUENT_ORDER_BY = "starred DESC, times_contacted_sort DESC, display_name COLLATE LOCALIZED ASC";
    private static final String STREQUENT_LIMIT = "(SELECT COUNT(1) FROM contacts WHERE starred=1) + 25";
    static final String UPDATE_TIMES_CONTACTED_CONTACTS_TABLE = "UPDATE contacts SET times_contacted= CASE WHEN times_contacted IS NULL THEN 1 ELSE  (times_contacted + 1) END WHERE _id=?";
    static final String UPDATE_TIMES_CONTACTED_RAWCONTACTS_TABLE = "UPDATE raw_contacts SET times_contacted= CASE WHEN times_contacted IS NULL THEN 1 ELSE  (times_contacted + 1) END WHERE contact_id=?";
    static final String PHONEBOOK_COLLATOR_NAME = "PHONEBOOK";
    private static final int CONTACTS = 1000;
    private static final int CONTACTS_ID = 1001;
    private static final int CONTACTS_LOOKUP = 1002;
    private static final int CONTACTS_LOOKUP_ID = 1003;
    private static final int CONTACTS_DATA = 1004;
    private static final int CONTACTS_FILTER = 1005;
    private static final int CONTACTS_STREQUENT = 1006;
    private static final int CONTACTS_STREQUENT_FILTER = 1007;
    private static final int CONTACTS_GROUP = 1008;
    private static final int CONTACTS_PHOTO = 1009;
    private static final int CONTACTS_AS_VCARD = 1010;
    private static final int CONTACTS_AS_MULTI_VCARD = 1011;
    private static final int RAW_CONTACTS = 2002;
    private static final int RAW_CONTACTS_ID = 2003;
    private static final int RAW_CONTACTS_DATA = 2004;
    private static final int RAW_CONTACT_ENTITY_ID = 2005;
    private static final int DATA = 3000;
    private static final int DATA_ID = 3001;
    private static final int PHONES = 3002;
    private static final int PHONES_ID = 3003;
    private static final int PHONES_FILTER = 3004;
    private static final int EMAILS = 3005;
    private static final int EMAILS_ID = 3006;
    private static final int EMAILS_LOOKUP = 3007;
    private static final int EMAILS_FILTER = 3008;
    private static final int POSTALS = 3009;
    private static final int POSTALS_ID = 3010;
    private static final int PHONE_LOOKUP = 4000;
    private static final int AGGREGATION_EXCEPTIONS = 6000;
    private static final int AGGREGATION_EXCEPTION_ID = 6001;
    private static final int STATUS_UPDATES = 7000;
    private static final int STATUS_UPDATES_ID = 7001;
    private static final int AGGREGATION_SUGGESTIONS = 8000;
    private static final int SETTINGS = 9000;
    private static final int GROUPS = 10000;
    private static final int GROUPS_ID = 10001;
    private static final int GROUPS_SUMMARY = 10003;
    private static final int SYNCSTATE = 11000;
    private static final int SYNCSTATE_ID = 11001;
    private static final int SEARCH_SUGGESTIONS = 12001;
    private static final int SEARCH_SHORTCUT = 12002;
    private static final int LIVE_FOLDERS_CONTACTS = 14000;
    private static final int LIVE_FOLDERS_CONTACTS_WITH_PHONES = 14001;
    private static final int LIVE_FOLDERS_CONTACTS_FAVORITES = 14002;
    private static final int LIVE_FOLDERS_CONTACTS_GROUP_NAME = 14003;
    private static final int RAW_CONTACT_ENTITIES = 15001;
    private static final int PROVIDER_STATUS = 16001;
    public static final String DEFAULT_ACCOUNT_TYPE = "com.google";
    public static final String FEATURE_LEGACY_HOSTED_OR_GOOGLE = "legacy_hosted_or_google";
    private static final String CONTACTS_IN_GROUP_SELECT = "_id IN (SELECT contact_id FROM raw_contacts WHERE raw_contacts._id IN (SELECT data.raw_contact_id FROM data JOIN mimetypes ON (data.mimetype_id = mimetypes._id) WHERE mimetype='vnd.android.cursor.item/group_membership' AND data1=(SELECT groups._id FROM groups WHERE title=?)))";
    private static final String UPDATE_RAW_CONTACT_SET_DIRTY_SQL = "UPDATE raw_contacts SET dirty=1 WHERE _id IN (";
    private static final String UPDATE_RAW_CONTACT_SET_VERSION_SQL = "UPDATE raw_contacts SET version = version + 1 WHERE _id IN (";
    private static final String CONTACT_LOOKUP_NAME_TYPES = "2,4,3,6,5,7";
    private static final HashMap<String, String> sCountProjectionMap;
    private static final HashMap<String, String> sContactsProjectionMap;
    private static final HashMap<String, String> sContactsProjectionWithSnippetMap;
    private static final HashMap<String, String> sStrequentStarredProjectionMap;
    private static final HashMap<String, String> sStrequentFrequentProjectionMap;
    private static final HashMap<String, String> sContactsVCardProjectionMap;
    private static final HashMap<String, String> sRawContactsProjectionMap;
    private static final HashMap<String, String> sRawContactsEntityProjectionMap;
    private static final HashMap<String, String> sDataProjectionMap;
    private static final HashMap<String, String> sDistinctDataProjectionMap;
    private static final HashMap<String, String> sPhoneLookupProjectionMap;
    private static final HashMap<String, String> sGroupsProjectionMap;
    private static final HashMap<String, String> sGroupsSummaryProjectionMap;
    private static final HashMap<String, String> sAggregationExceptionsProjectionMap;
    private static final HashMap<String, String> sSettingsProjectionMap;
    private static final HashMap<String, String> sStatusUpdatesProjectionMap;
    private static final HashMap<String, String> sLiveFoldersProjectionMap;
    private static final String WHERE_CLAUSE_FOR_STATUS_UPDATES_TABLE = "status_update_data_id IN (SELECT Distinct presence_data_id FROM status_updates LEFT OUTER JOIN presence ON status_update_data_id = presence_data_id WHERE ";
    private static final String[] EMPTY_STRING_ARRAY;
    private static final int LEGACY_IMPORT_FAILED_NOTIFICATION = 1;
    private SQLiteStatement mSetPrimaryStatement;
    private SQLiteStatement mSetSuperPrimaryStatement;
    private SQLiteStatement mRawContactDisplayNameUpdate;
    private SQLiteStatement mLastStatusUpdate;
    private SQLiteStatement mNameLookupInsert;
    private SQLiteStatement mNameLookupDelete;
    private SQLiteStatement mStatusUpdateAutoTimestamp;
    private SQLiteStatement mStatusUpdateInsert;
    private SQLiteStatement mStatusUpdateReplace;
    private SQLiteStatement mStatusAttributionUpdate;
    private SQLiteStatement mStatusUpdateDelete;
    private SQLiteStatement mResetNameVerifiedForOtherRawContacts;
    private long mMimeTypeIdEmail;
    private long mMimeTypeIdIm;
    private long mMimeTypeIdStructuredName;
    private long mMimeTypeIdOrganization;
    private long mMimeTypeIdNickname;
    private long mMimeTypeIdPhone;
    private StringBuilder mSb = new StringBuilder();
    private String[] mSelectionArgs1 = new String[1];
    private String[] mSelectionArgs2 = new String[2];
    private ArrayList<String> mSelectionArgs = Lists.newArrayList();
    private Account mAccount;
    private HashMap<String, DataRowHandler> mDataRowHandlers;
    private ContactsDatabaseHelper mDbHelper;
    private NameSplitter mNameSplitter;
    private NameLookupBuilder mNameLookupBuilder;
    private PostalSplitter mPostalSplitter;
    private HashMap<String, ArrayList<GroupIdCacheEntry>> mGroupIdCache = Maps.newHashMap();
    private ContactAggregator mContactAggregator;
    private LegacyApiSupport mLegacyApiSupport;
    private GlobalSearchSupport mGlobalSearchSupport;
    private CommonNicknameCache mCommonNicknameCache;
    private ContentValues mValues = new ContentValues();
    private CharArrayBuffer mCharArrayBuffer = new CharArrayBuffer(128);
    private NameSplitter.Name mName = new NameSplitter.Name();
    private HashMap<String, Boolean> mAccountWritability = Maps.newHashMap();
    private int mProviderStatus = 0;
    private long mEstimatedStorageRequirement = 0L;
    private volatile CountDownLatch mAccessLatch;
    private HashMap<Long, Account> mInsertedRawContacts = Maps.newHashMap();
    private HashSet<Long> mUpdatedRawContacts = Sets.newHashSet();
    private HashSet<Long> mDirtyRawContacts = Sets.newHashSet();
    private HashMap<Long, Object> mUpdatedSyncStates = Maps.newHashMap();
    private boolean mVisibleTouched = false;
    private boolean mSyncToNetwork;
    private Locale mCurrentLocale;
    private static final String CONTACT_MEMORY_FILE_NAME = "contactAssetFile";

    private static void addProjection(HashMap<String, String> map, String toField, String fromField) {
        map.put(toField, fromField + " AS " + toField);
    }

    @Override
    public boolean onCreate() {
        super.onCreate();
        try {
            return this.initialize();
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Cannot start provider", (Throwable)e);
            return false;
        }
    }

    private boolean initialize() {
        Context context = this.getContext();
        this.mDbHelper = (ContactsDatabaseHelper)this.getDatabaseHelper();
        this.mGlobalSearchSupport = new GlobalSearchSupport(this);
        this.mLegacyApiSupport = new LegacyApiSupport(context, this.mDbHelper, this, this.mGlobalSearchSupport);
        this.mContactAggregator = new ContactAggregator(this, this.mDbHelper, this.createPhotoPriorityResolver(context));
        this.mContactAggregator.setEnabled(SystemProperties.getBoolean((String)AGGREGATE_CONTACTS, (boolean)true));
        this.mDb = this.mDbHelper.getWritableDatabase();
        this.initForDefaultLocale();
        this.mSetPrimaryStatement = this.mDb.compileStatement("UPDATE data SET is_primary=(_id=?) WHERE mimetype_id=?   AND raw_contact_id=?");
        this.mSetSuperPrimaryStatement = this.mDb.compileStatement("UPDATE data SET is_super_primary=(_id=?) WHERE mimetype_id=?   AND raw_contact_id IN (SELECT _id FROM raw_contacts WHERE contact_id =(SELECT contact_id FROM raw_contacts WHERE _id=?))");
        this.mRawContactDisplayNameUpdate = this.mDb.compileStatement("UPDATE raw_contacts SET display_name_source=?,display_name=?,display_name_alt=?,phonetic_name=?,phonetic_name_style=?,sort_key=?,sort_key_alt=? WHERE _id=?");
        this.mLastStatusUpdate = this.mDb.compileStatement("UPDATE contacts SET status_update_id=(SELECT data._id FROM status_updates JOIN data   ON (status_update_data_id=data._id) JOIN raw_contacts   ON (data.raw_contact_id=raw_contacts._id) WHERE contact_id=? ORDER BY status_ts DESC,status LIMIT 1) WHERE contacts._id=?");
        this.mNameLookupInsert = this.mDb.compileStatement("INSERT OR IGNORE INTO name_lookup(raw_contact_id,data_id,name_type,normalized_name) VALUES (?,?,?,?)");
        this.mNameLookupDelete = this.mDb.compileStatement("DELETE FROM name_lookup WHERE data_id=?");
        this.mStatusUpdateInsert = this.mDb.compileStatement("INSERT INTO status_updates(status_update_data_id, status,status_res_package,status_icon,status_label) VALUES (?,?,?,?,?)");
        this.mStatusUpdateReplace = this.mDb.compileStatement("INSERT OR REPLACE INTO status_updates(status_update_data_id, status_ts,status,status_res_package,status_icon,status_label) VALUES (?,?,?,?,?,?)");
        this.mStatusUpdateAutoTimestamp = this.mDb.compileStatement("UPDATE status_updates SET status_ts=?,status=? WHERE status_update_data_id=? AND status!=?");
        this.mStatusAttributionUpdate = this.mDb.compileStatement("UPDATE status_updates SET status_res_package=?,status_icon=?,status_label=? WHERE status_update_data_id=?");
        this.mStatusUpdateDelete = this.mDb.compileStatement("DELETE FROM status_updates WHERE status_update_data_id=?");
        this.mResetNameVerifiedForOtherRawContacts = this.mDb.compileStatement("UPDATE raw_contacts SET name_verified=0 WHERE contact_id=(SELECT contact_id FROM raw_contacts WHERE _id=?) AND _id!=?");
        this.mMimeTypeIdEmail = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/email_v2");
        this.mMimeTypeIdIm = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/im");
        this.mMimeTypeIdStructuredName = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/name");
        this.mMimeTypeIdOrganization = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/organization");
        this.mMimeTypeIdNickname = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/nickname");
        this.mMimeTypeIdPhone = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/phone_v2");
        this.verifyAccounts();
        if (this.isLegacyContactImportNeeded()) {
            this.importLegacyContactsAsync();
        } else {
            this.verifyLocale();
        }
        if (this.isAggregationUpgradeNeeded()) {
            this.upgradeAggregationAlgorithm();
        }
        return this.mDb != null;
    }

    private void initDataRowHandlers() {
        this.mDataRowHandlers = new HashMap();
        this.mDataRowHandlers.put("vnd.android.cursor.item/email_v2", new EmailDataRowHandler());
        this.mDataRowHandlers.put("vnd.android.cursor.item/im", new CommonDataRowHandler("vnd.android.cursor.item/im", "data2", "data3"));
        this.mDataRowHandlers.put("vnd.android.cursor.item/nickname", new CommonDataRowHandler("vnd.android.cursor.item/postal-address_v2", "data2", "data3"));
        this.mDataRowHandlers.put("vnd.android.cursor.item/organization", new OrganizationDataRowHandler());
        this.mDataRowHandlers.put("vnd.android.cursor.item/phone_v2", new PhoneDataRowHandler());
        this.mDataRowHandlers.put("vnd.android.cursor.item/nickname", new NicknameDataRowHandler());
        this.mDataRowHandlers.put("vnd.android.cursor.item/name", new StructuredNameRowHandler(this.mNameSplitter));
        this.mDataRowHandlers.put("vnd.android.cursor.item/postal-address_v2", new StructuredPostalRowHandler(this.mPostalSplitter));
        this.mDataRowHandlers.put("vnd.android.cursor.item/group_membership", new GroupMembershipRowHandler());
        this.mDataRowHandlers.put("vnd.android.cursor.item/photo", new PhotoDataRowHandler());
    }

    PhotoPriorityResolver createPhotoPriorityResolver(Context context) {
        return new PhotoPriorityResolver(context);
    }

    private void initForDefaultLocale() {
        this.mCurrentLocale = this.getLocale();
        this.mNameSplitter = this.mDbHelper.createNameSplitter();
        this.mNameLookupBuilder = new StructuredNameLookupBuilder(this.mNameSplitter);
        this.mPostalSplitter = new PostalSplitter(this.mCurrentLocale);
        this.mCommonNicknameCache = new CommonNicknameCache(this.mDbHelper.getReadableDatabase());
        ContactLocaleUtils.getIntance().setLocale(this.mCurrentLocale);
        this.initDataRowHandlers();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        if (this.mProviderStatus != 0) {
            return;
        }
        this.initForDefaultLocale();
        this.verifyLocale();
    }

    protected void verifyAccounts() {
        AccountManager.get((Context)this.getContext()).addOnAccountsUpdatedListener((OnAccountsUpdateListener)this, null, false);
        this.onAccountsUpdated(AccountManager.get((Context)this.getContext()).getAccounts());
    }

    protected void verifyLocale() {
        if (this.mProviderStatus == 3) {
            return;
        }
        final SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.getContext());
        String providerLocale = prefs.getString(PREF_LOCALE, null);
        final Locale currentLocale = this.mCurrentLocale;
        if (currentLocale.toString().equals(providerLocale)) {
            return;
        }
        int providerStatus = this.mProviderStatus;
        this.setProviderStatus(3);
        AsyncTask<Integer, Void, Void> task = new AsyncTask<Integer, Void, Void>(){
            int savedProviderStatus;

            protected Void doInBackground(Integer ... params) {
                this.savedProviderStatus = params[0];
                ContactsProvider2.this.mDbHelper.setLocale(ContactsProvider2.this, currentLocale);
                return null;
            }

            protected void onPostExecute(Void result) {
                prefs.edit().putString(ContactsProvider2.PREF_LOCALE, currentLocale.toString()).apply();
                ContactsProvider2.this.setProviderStatus(this.savedProviderStatus);
                ContactsProvider2.this.verifyLocale();
            }
        };
        task.execute((Object[])new Integer[]{providerStatus});
    }

    @Override
    protected ContactsDatabaseHelper getDatabaseHelper(Context context) {
        return ContactsDatabaseHelper.getInstance(context);
    }

    NameSplitter getNameSplitter() {
        return this.mNameSplitter;
    }

    protected Locale getLocale() {
        return Locale.getDefault();
    }

    protected boolean isLegacyContactImportNeeded() {
        int version = Integer.parseInt(this.mDbHelper.getProperty(PROPERTY_CONTACTS_IMPORTED, "0"));
        return version < 1;
    }

    protected LegacyContactImporter getLegacyContactImporter() {
        return new LegacyContactImporter(this.getContext(), this);
    }

    private void importLegacyContactsAsync() {
        Log.v((String)TAG, (String)"Importing legacy contacts");
        this.setProviderStatus(1);
        if (this.mAccessLatch == null) {
            this.mAccessLatch = new CountDownLatch(1);
        }
        Thread importThread = new Thread("LegacyContactImport"){

            public void run() {
                SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)ContactsProvider2.this.getContext());
                ContactsProvider2.this.mDbHelper.setLocale(ContactsProvider2.this, ContactsProvider2.this.mCurrentLocale);
                prefs.edit().putString(ContactsProvider2.PREF_LOCALE, ContactsProvider2.this.mCurrentLocale.toString()).commit();
                LegacyContactImporter importer = ContactsProvider2.this.getLegacyContactImporter();
                if (ContactsProvider2.this.importLegacyContacts(importer)) {
                    ContactsProvider2.this.onLegacyContactImportSuccess();
                } else {
                    ContactsProvider2.this.onLegacyContactImportFailure();
                }
            }
        };
        importThread.start();
    }

    private void onLegacyContactImportSuccess() {
        NotificationManager nm = (NotificationManager)this.getContext().getSystemService("notification");
        nm.cancel(1);
        this.mDbHelper.setProperty(PROPERTY_CONTACTS_IMPORTED, String.valueOf(1));
        this.setProviderStatus(0);
        this.mAccessLatch.countDown();
        this.mAccessLatch = null;
        Log.v((String)TAG, (String)"Completed import of legacy contacts");
    }

    private void onLegacyContactImportFailure() {
        Context context = this.getContext();
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        Notification n = new Notification(17301624, (CharSequence)context.getString(2130903042), System.currentTimeMillis());
        n.setLatestEventInfo(context, (CharSequence)context.getString(2130903043), (CharSequence)context.getString(2130903044), PendingIntent.getActivity((Context)context, (int)0, (Intent)new Intent("com.android.contacts.action.LIST_DEFAULT"), (int)0));
        n.flags |= 0x22;
        nm.notify(1, n);
        this.setProviderStatus(2);
        Log.v((String)TAG, (String)"Failed to import legacy contacts");
    }

    boolean importLegacyContacts(LegacyContactImporter importer) {
        boolean aggregatorEnabled = this.mContactAggregator.isEnabled();
        this.mContactAggregator.setEnabled(false);
        try {
            if (importer.importContacts()) {
                this.mContactAggregator.setEnabled(aggregatorEnabled);
                return true;
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"Legacy contact import failed", (Throwable)e);
        }
        this.mEstimatedStorageRequirement = importer.getEstimatedStorageRequirement();
        return false;
    }

    void wipeData() {
        this.mDbHelper.wipeData();
    }

    private void waitForAccess() {
        CountDownLatch latch = this.mAccessLatch;
        if (latch != null) {
            while (true) {
                try {
                    latch.await();
                    this.mAccessLatch = null;
                    return;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public Uri insert(Uri uri, ContentValues values) {
        this.waitForAccess();
        return super.insert(uri, values);
    }

    @Override
    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        int match;
        if (this.mAccessLatch != null && (match = sUriMatcher.match(uri)) == 16001 && this.isLegacyContactImportNeeded()) {
            Integer newStatus = values.getAsInteger("status");
            if (newStatus != null && newStatus == 1) {
                this.importLegacyContactsAsync();
                return 1;
            }
            return 0;
        }
        this.waitForAccess();
        return super.update(uri, values, selection, selectionArgs);
    }

    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        this.waitForAccess();
        return super.delete(uri, selection, selectionArgs);
    }

    @Override
    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        this.waitForAccess();
        return super.applyBatch(operations);
    }

    @Override
    protected void onBeginTransaction() {
        if (VERBOSE_LOGGING) {
            Log.v((String)TAG, (String)"onBeginTransaction");
        }
        super.onBeginTransaction();
        this.mContactAggregator.clearPendingAggregations();
        this.clearTransactionalChanges();
    }

    private void clearTransactionalChanges() {
        this.mInsertedRawContacts.clear();
        this.mUpdatedRawContacts.clear();
        this.mUpdatedSyncStates.clear();
        this.mDirtyRawContacts.clear();
    }

    @Override
    protected void beforeTransactionCommit() {
        if (VERBOSE_LOGGING) {
            Log.v((String)TAG, (String)"beforeTransactionCommit");
        }
        super.beforeTransactionCommit();
        this.flushTransactionalChanges();
        this.mContactAggregator.aggregateInTransaction(this.mDb);
        if (this.mVisibleTouched) {
            this.mVisibleTouched = false;
            this.mDbHelper.updateAllVisible();
        }
    }

    private void flushTransactionalChanges() {
        if (VERBOSE_LOGGING) {
            Log.v((String)TAG, (String)"flushTransactionChanges");
        }
        Iterator<Object> i$ = this.mInsertedRawContacts.keySet().iterator();
        while (i$.hasNext()) {
            long l = i$.next();
            this.updateRawContactDisplayName(this.mDb, l);
            this.mContactAggregator.onRawContactInsert(this.mDb, l);
        }
        if (!this.mDirtyRawContacts.isEmpty()) {
            this.mSb.setLength(0);
            this.mSb.append(UPDATE_RAW_CONTACT_SET_DIRTY_SQL);
            this.appendIds(this.mSb, this.mDirtyRawContacts);
            this.mSb.append(")");
            this.mDb.execSQL(this.mSb.toString());
        }
        if (!this.mUpdatedRawContacts.isEmpty()) {
            this.mSb.setLength(0);
            this.mSb.append(UPDATE_RAW_CONTACT_SET_VERSION_SQL);
            this.appendIds(this.mSb, this.mUpdatedRawContacts);
            this.mSb.append(")");
            this.mDb.execSQL(this.mSb.toString());
        }
        for (Map.Entry entry : this.mUpdatedSyncStates.entrySet()) {
            long id = (Long)entry.getKey();
            if (this.mDbHelper.getSyncState().update(this.mDb, id, entry.getValue()) > 0) continue;
            throw new IllegalStateException("unable to update sync state, does it still exist?");
        }
        this.clearTransactionalChanges();
    }

    private void appendIds(StringBuilder sb, HashSet<Long> ids) {
        for (long id : ids) {
            sb.append(id).append(',');
        }
        sb.setLength(sb.length() - 1);
    }

    @Override
    protected void notifyChange() {
        this.notifyChange(this.mSyncToNetwork);
        this.mSyncToNetwork = false;
    }

    protected void notifyChange(boolean syncToNetwork) {
        this.getContext().getContentResolver().notifyChange(ContactsContract.AUTHORITY_URI, null, syncToNetwork);
    }

    protected void setProviderStatus(int status) {
        this.mProviderStatus = status;
        this.getContext().getContentResolver().notifyChange(ContactsContract.ProviderStatus.CONTENT_URI, null, false);
    }

    private boolean isNewRawContact(long rawContactId) {
        return this.mInsertedRawContacts.containsKey(rawContactId);
    }

    private DataRowHandler getDataRowHandler(String mimeType) {
        DataRowHandler handler = this.mDataRowHandlers.get(mimeType);
        if (handler == null) {
            handler = new CustomDataRowHandler(mimeType);
            this.mDataRowHandlers.put(mimeType, handler);
        }
        return handler;
    }

    @Override
    protected Uri insertInTransaction(Uri uri, ContentValues values) {
        if (VERBOSE_LOGGING) {
            Log.v((String)TAG, (String)("insertInTransaction: " + uri + " " + values));
        }
        boolean callerIsSyncAdapter = ContactsProvider2.readBooleanQueryParameter(uri, "caller_is_syncadapter", false);
        int match = sUriMatcher.match(uri);
        long id = 0L;
        switch (match) {
            case 11000: {
                id = this.mDbHelper.getSyncState().insert(this.mDb, values);
                break;
            }
            case 1000: {
                this.insertContact(values);
                break;
            }
            case 2002: {
                id = this.insertRawContact(uri, values);
                this.mSyncToNetwork |= !callerIsSyncAdapter;
                break;
            }
            case 2004: {
                values.put("raw_contact_id", (String)uri.getPathSegments().get(1));
                id = this.insertData(values, callerIsSyncAdapter);
                this.mSyncToNetwork |= !callerIsSyncAdapter;
                break;
            }
            case 3000: {
                id = this.insertData(values, callerIsSyncAdapter);
                this.mSyncToNetwork |= !callerIsSyncAdapter;
                break;
            }
            case 10000: {
                id = this.insertGroup(uri, values, callerIsSyncAdapter);
                this.mSyncToNetwork |= !callerIsSyncAdapter;
                break;
            }
            case 9000: {
                id = this.insertSettings(uri, values);
                this.mSyncToNetwork |= !callerIsSyncAdapter;
                break;
            }
            case 7000: {
                id = this.insertStatusUpdate(values);
                break;
            }
            default: {
                this.mSyncToNetwork = true;
                return this.mLegacyApiSupport.insert(uri, values);
            }
        }
        if (id < 0L) {
            return null;
        }
        return ContentUris.withAppendedId((Uri)uri, (long)id);
    }

    private Account resolveAccount(Uri uri, ContentValues values) throws IllegalArgumentException {
        boolean validValues;
        String accountName = ContactsProvider2.getQueryParameter(uri, "account_name");
        String accountType = ContactsProvider2.getQueryParameter(uri, "account_type");
        boolean partialUri = TextUtils.isEmpty((CharSequence)accountName) ^ TextUtils.isEmpty((CharSequence)accountType);
        String valueAccountName = values.getAsString("account_name");
        String valueAccountType = values.getAsString("account_type");
        boolean partialValues = TextUtils.isEmpty((CharSequence)valueAccountName) ^ TextUtils.isEmpty((CharSequence)valueAccountType);
        if (partialUri || partialValues) {
            throw new IllegalArgumentException(this.mDbHelper.exceptionMessage("Must specify both or neither of ACCOUNT_NAME and ACCOUNT_TYPE", uri));
        }
        boolean validUri = !TextUtils.isEmpty((CharSequence)accountName);
        boolean bl = validValues = !TextUtils.isEmpty((CharSequence)valueAccountName);
        if (validValues && validUri) {
            boolean accountMatch;
            boolean bl2 = accountMatch = TextUtils.equals((CharSequence)accountName, (CharSequence)valueAccountName) && TextUtils.equals((CharSequence)accountType, (CharSequence)valueAccountType);
            if (!accountMatch) {
                throw new IllegalArgumentException(this.mDbHelper.exceptionMessage("When both specified, ACCOUNT_NAME and ACCOUNT_TYPE must match", uri));
            }
        } else if (validUri) {
            values.put("account_name", accountName);
            values.put("account_type", accountType);
        } else if (validValues) {
            accountName = valueAccountName;
            accountType = valueAccountType;
        } else {
            return null;
        }
        if (this.mAccount == null || !this.mAccount.name.equals(accountName) || !this.mAccount.type.equals(accountType)) {
            this.mAccount = new Account(accountName, accountType);
        }
        return this.mAccount;
    }

    private long insertContact(ContentValues values) {
        throw new UnsupportedOperationException("Aggregate contacts are created automatically");
    }

    private long insertRawContact(Uri uri, ContentValues values) {
        this.mValues.clear();
        this.mValues.putAll(values);
        this.mValues.putNull("contact_id");
        Account account = this.resolveAccount(uri, this.mValues);
        if (values.containsKey("deleted") && values.getAsInteger("deleted") != 0) {
            this.mValues.put("aggregation_mode", Integer.valueOf(3));
        }
        long rawContactId = this.mDb.insert("raw_contacts", "contact_id", this.mValues);
        int aggregationMode = 0;
        if (this.mValues.containsKey("aggregation_mode")) {
            aggregationMode = this.mValues.getAsInteger("aggregation_mode");
        }
        this.mContactAggregator.markNewForAggregation(rawContactId, aggregationMode);
        this.mInsertedRawContacts.put(rawContactId, account);
        return rawContactId;
    }

    private long insertData(ContentValues values, boolean callerIsSyncAdapter) {
        long id = 0L;
        this.mValues.clear();
        this.mValues.putAll(values);
        long rawContactId = this.mValues.getAsLong("raw_contact_id");
        String packageName = this.mValues.getAsString("res_package");
        if (packageName != null) {
            this.mValues.put("package_id", Long.valueOf(this.mDbHelper.getPackageId(packageName)));
        }
        this.mValues.remove("res_package");
        String mimeType = this.mValues.getAsString("mimetype");
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            throw new IllegalArgumentException("mimetype is required");
        }
        this.mValues.put("mimetype_id", Long.valueOf(this.mDbHelper.getMimeTypeId(mimeType)));
        this.mValues.remove("mimetype");
        DataRowHandler rowHandler = this.getDataRowHandler(mimeType);
        id = rowHandler.insert(this.mDb, rawContactId, this.mValues);
        if (!callerIsSyncAdapter) {
            this.setRawContactDirty(rawContactId);
        }
        this.mUpdatedRawContacts.add(rawContactId);
        return id;
    }

    private void triggerAggregation(long rawContactId) {
        if (!this.mContactAggregator.isEnabled()) {
            return;
        }
        int aggregationMode = this.mDbHelper.getAggregationMode(rawContactId);
        switch (aggregationMode) {
            case 3: {
                break;
            }
            case 0: {
                this.mContactAggregator.markForAggregation(rawContactId, aggregationMode, false);
                break;
            }
            case 2: {
                long contactId = this.mDbHelper.getContactId(rawContactId);
                if (contactId == 0L) break;
                this.mContactAggregator.updateAggregateData(contactId);
                break;
            }
            case 1: {
                this.mContactAggregator.aggregateContact(this.mDb, rawContactId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getOrMakeGroup(SQLiteDatabase db, long rawContactId, String sourceId, Account account) {
        if (account == null) {
            this.mSelectionArgs1[0] = String.valueOf(rawContactId);
            Cursor c = db.query("raw_contacts", RawContactsQuery.COLUMNS, "_id=?", this.mSelectionArgs1, null, null, null);
            try {
                if (c.moveToFirst()) {
                    String accountName = c.getString(2);
                    String accountType = c.getString(1);
                    if (!TextUtils.isEmpty((CharSequence)accountName) && !TextUtils.isEmpty((CharSequence)accountType)) {
                        account = new Account(accountName, accountType);
                    }
                }
            }
            finally {
                c.close();
            }
        }
        if (account == null) {
            throw new IllegalArgumentException("if the groupmembership only has a sourceid the the contact must be associated with an account");
        }
        ArrayList<GroupIdCacheEntry> entries = this.mGroupIdCache.get(sourceId);
        if (entries == null) {
            entries = new ArrayList(1);
            this.mGroupIdCache.put(sourceId, entries);
        }
        int count = entries.size();
        for (int i = 0; i < count; ++i) {
            GroupIdCacheEntry entry = entries.get(i);
            if (!entry.accountName.equals(account.name) || !entry.accountType.equals(account.type)) continue;
            return entry.groupId;
        }
        GroupIdCacheEntry entry = new GroupIdCacheEntry();
        entry.accountName = account.name;
        entry.accountType = account.type;
        entry.sourceId = sourceId;
        entries.add(0, entry);
        Cursor c = db.query("groups", new String[]{"_id"}, "sourceid=? AND account_name=? AND account_type=?", new String[]{sourceId, account.name, account.type}, null, null, null);
        try {
            if (c.moveToFirst()) {
                entry.groupId = c.getLong(0);
            } else {
                ContentValues groupValues = new ContentValues();
                groupValues.put("account_name", account.name);
                groupValues.put("account_type", account.type);
                groupValues.put("sourceid", sourceId);
                long groupId = db.insert("groups", "account_name", groupValues);
                if (groupId < 0L) {
                    throw new IllegalStateException("unable to create a new group with this sourceid: " + groupValues);
                }
                entry.groupId = groupId;
            }
        }
        finally {
            c.close();
        }
        return entry.groupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRawContactDisplayName(SQLiteDatabase db, long rawContactId) {
        String displayNameAlternative;
        String displayNamePrimary;
        int bestDisplayNameSource = 0;
        NameSplitter.Name bestName = null;
        String bestDisplayName = null;
        String bestPhoneticName = null;
        int bestPhoneticNameStyle = 0;
        this.mSelectionArgs1[0] = String.valueOf(rawContactId);
        Cursor c = db.rawQuery("SELECT mimetype_id,is_primary,data1,data2,data3,data4,data5,data6,data7,data8,data9,data10,data11 FROM data WHERE raw_contact_id=? AND (data1 NOT NULL OR data4 NOT NULL)", this.mSelectionArgs1);
        try {
            while (c.moveToNext()) {
                int mimeType = c.getInt(0);
                int source = this.getDisplayNameSource(mimeType);
                if (source < bestDisplayNameSource || source == 0 || source == bestDisplayNameSource && c.getInt(1) == 0) continue;
                if ((long)mimeType == this.mMimeTypeIdStructuredName) {
                    NameSplitter.Name name;
                    if (bestName != null) {
                        name = new NameSplitter.Name();
                    } else {
                        name = this.mName;
                        name.clear();
                    }
                    name.prefix = c.getString(5);
                    name.givenNames = c.getString(3);
                    name.middleName = c.getString(6);
                    name.familyName = c.getString(4);
                    name.suffix = c.getString(7);
                    name.fullNameStyle = c.isNull(11) ? 0 : c.getInt(11);
                    name.phoneticFamilyName = c.getString(10);
                    name.phoneticMiddleName = c.getString(9);
                    name.phoneticGivenName = c.getString(8);
                    int n = name.phoneticNameStyle = c.isNull(12) ? 0 : c.getInt(12);
                    if (name.isEmpty()) continue;
                    bestDisplayNameSource = source;
                    bestName = name;
                    continue;
                }
                if ((long)mimeType == this.mMimeTypeIdOrganization) {
                    this.mCharArrayBuffer.sizeCopied = 0;
                    c.copyStringToBuffer(2, this.mCharArrayBuffer);
                    if (this.mCharArrayBuffer.sizeCopied != 0) {
                        bestDisplayNameSource = source;
                        bestDisplayName = new String(this.mCharArrayBuffer.data, 0, this.mCharArrayBuffer.sizeCopied);
                        bestPhoneticName = c.getString(9);
                        bestPhoneticNameStyle = c.isNull(11) ? 0 : c.getInt(11);
                        continue;
                    }
                    c.copyStringToBuffer(5, this.mCharArrayBuffer);
                    if (this.mCharArrayBuffer.sizeCopied == 0) continue;
                    bestDisplayNameSource = source;
                    bestDisplayName = new String(this.mCharArrayBuffer.data, 0, this.mCharArrayBuffer.sizeCopied);
                    bestPhoneticName = null;
                    bestPhoneticNameStyle = 0;
                    continue;
                }
                this.mCharArrayBuffer.sizeCopied = 0;
                c.copyStringToBuffer(2, this.mCharArrayBuffer);
                if (this.mCharArrayBuffer.sizeCopied == 0) continue;
                bestDisplayNameSource = source;
                bestDisplayName = new String(this.mCharArrayBuffer.data, 0, this.mCharArrayBuffer.sizeCopied);
                bestPhoneticName = null;
                bestPhoneticNameStyle = 0;
            }
        }
        finally {
            c.close();
        }
        String sortKeyPrimary = null;
        String sortKeyAlternative = null;
        int displayNameStyle = 0;
        if (bestDisplayNameSource == 40) {
            displayNameStyle = bestName.fullNameStyle;
            if (displayNameStyle == 2 || displayNameStyle == 0) {
                bestName.fullNameStyle = displayNameStyle = this.mNameSplitter.getAdjustedFullNameStyle(displayNameStyle);
            }
            displayNamePrimary = this.mNameSplitter.join(bestName, true);
            displayNameAlternative = this.mNameSplitter.join(bestName, false);
            bestPhoneticName = this.mNameSplitter.joinPhoneticName(bestName);
            bestPhoneticNameStyle = bestName.phoneticNameStyle;
        } else {
            displayNamePrimary = displayNameAlternative = bestDisplayName;
        }
        if (bestPhoneticName != null) {
            sortKeyPrimary = sortKeyAlternative = bestPhoneticName;
            if (bestPhoneticNameStyle == 0) {
                bestPhoneticNameStyle = this.mNameSplitter.guessPhoneticNameStyle(bestPhoneticName);
            }
        } else {
            if (displayNameStyle == 0) {
                displayNameStyle = this.mNameSplitter.guessFullNameStyle(bestDisplayName);
                if (displayNameStyle == 0 || displayNameStyle == 2) {
                    displayNameStyle = this.mNameSplitter.getAdjustedNameStyleBasedOnPhoneticNameStyle(displayNameStyle, bestPhoneticNameStyle);
                }
                displayNameStyle = this.mNameSplitter.getAdjustedFullNameStyle(displayNameStyle);
            }
            if (displayNameStyle == 3 || displayNameStyle == 2) {
                sortKeyPrimary = sortKeyAlternative = ContactLocaleUtils.getIntance().getSortKey(displayNamePrimary, displayNameStyle);
            }
        }
        if (sortKeyPrimary == null) {
            sortKeyPrimary = displayNamePrimary;
            sortKeyAlternative = displayNameAlternative;
        }
        this.setDisplayName(rawContactId, bestDisplayNameSource, displayNamePrimary, displayNameAlternative, bestPhoneticName, bestPhoneticNameStyle, sortKeyPrimary, sortKeyAlternative);
    }

    private int getDisplayNameSource(int mimeTypeId) {
        if ((long)mimeTypeId == this.mMimeTypeIdStructuredName) {
            return 40;
        }
        if ((long)mimeTypeId == this.mMimeTypeIdEmail) {
            return 10;
        }
        if ((long)mimeTypeId == this.mMimeTypeIdPhone) {
            return 20;
        }
        if ((long)mimeTypeId == this.mMimeTypeIdOrganization) {
            return 30;
        }
        if ((long)mimeTypeId == this.mMimeTypeIdNickname) {
            return 35;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteData(String selection, String[] selectionArgs, boolean callerIsSyncAdapter) {
        int count = 0;
        Cursor c = this.query(ContactsContract.Data.CONTENT_URI, DataDeleteQuery.COLUMNS, selection, selectionArgs, null);
        try {
            while (c.moveToNext()) {
                long rawContactId = c.getLong(2);
                String mimeType = c.getString(1);
                DataRowHandler rowHandler = this.getDataRowHandler(mimeType);
                count += rowHandler.delete(this.mDb, c);
                if (callerIsSyncAdapter) continue;
                this.setRawContactDirty(rawContactId);
            }
        }
        finally {
            c.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteData(long dataId, String[] allowedMimeTypes) {
        this.mSelectionArgs1[0] = String.valueOf(dataId);
        Cursor c = this.query(ContactsContract.Data.CONTENT_URI, DataDeleteQuery.COLUMNS, "_id=?", this.mSelectionArgs1, null);
        try {
            if (!c.moveToFirst()) {
                int n = 0;
                return n;
            }
            String mimeType = c.getString(1);
            boolean valid = false;
            for (int i = 0; i < allowedMimeTypes.length; ++i) {
                if (!TextUtils.equals((CharSequence)mimeType, (CharSequence)allowedMimeTypes[i])) continue;
                valid = true;
                break;
            }
            if (!valid) {
                throw new IllegalArgumentException("Data type mismatch: expected " + Lists.newArrayList((Object[])allowedMimeTypes));
            }
            DataRowHandler rowHandler = this.getDataRowHandler(mimeType);
            int n = rowHandler.delete(this.mDb, c);
            return n;
        }
        finally {
            c.close();
        }
    }

    private long insertGroup(Uri uri, ContentValues values, boolean callerIsSyncAdapter) {
        this.mValues.clear();
        this.mValues.putAll(values);
        Account account = this.resolveAccount(uri, this.mValues);
        String packageName = this.mValues.getAsString("res_package");
        if (packageName != null) {
            this.mValues.put("package_id", Long.valueOf(this.mDbHelper.getPackageId(packageName)));
        }
        this.mValues.remove("res_package");
        if (!callerIsSyncAdapter) {
            this.mValues.put("dirty", Integer.valueOf(1));
        }
        long result = this.mDb.insert("groups", "title", this.mValues);
        if (this.mValues.containsKey("group_visible")) {
            this.mVisibleTouched = true;
        }
        return result;
    }

    private long insertSettings(Uri uri, ContentValues values) {
        long id = this.mDb.insert("settings", null, values);
        if (values.containsKey("ungrouped_visible")) {
            this.mVisibleTouched = true;
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insertStatusUpdate(ContentValues values) {
        Long dataId;
        long contactId;
        long rawContactId;
        String customProtocol;
        Integer protocol;
        String handle;
        block26: {
            handle = values.getAsString("im_handle");
            protocol = values.getAsInteger("protocol");
            customProtocol = null;
            if (protocol != null && protocol == -1 && TextUtils.isEmpty((CharSequence)(customProtocol = values.getAsString("custom_protocol")))) {
                throw new IllegalArgumentException("CUSTOM_PROTOCOL is required when PROTOCOL=PROTOCOL_CUSTOM");
            }
            rawContactId = -1L;
            contactId = -1L;
            dataId = values.getAsLong("presence_data_id");
            this.mSb.setLength(0);
            this.mSelectionArgs.clear();
            if (dataId != null) {
                this.mSb.append("data._id=?");
                this.mSelectionArgs.add(String.valueOf(dataId));
            } else {
                if (TextUtils.isEmpty((CharSequence)handle) || protocol == null) {
                    throw new IllegalArgumentException("PROTOCOL and IM_HANDLE are required");
                }
                boolean matchEmail = 5 == protocol;
                String mimeTypeIdIm = String.valueOf(this.mMimeTypeIdIm);
                if (matchEmail) {
                    String mimeTypeIdEmail = String.valueOf(this.mMimeTypeIdEmail);
                    this.mSb.append("mimetype_id IN (?,?) AND data1=? AND ((mimetype_id=? AND data5=?");
                    this.mSelectionArgs.add(mimeTypeIdEmail);
                    this.mSelectionArgs.add(mimeTypeIdIm);
                    this.mSelectionArgs.add(handle);
                    this.mSelectionArgs.add(mimeTypeIdIm);
                    this.mSelectionArgs.add(String.valueOf(protocol));
                    if (customProtocol != null) {
                        this.mSb.append(" AND data6=?");
                        this.mSelectionArgs.add(customProtocol);
                    }
                    this.mSb.append(") OR (mimetype_id=?))");
                    this.mSelectionArgs.add(mimeTypeIdEmail);
                } else {
                    this.mSb.append("mimetype_id=? AND data5=? AND data1=?");
                    this.mSelectionArgs.add(mimeTypeIdIm);
                    this.mSelectionArgs.add(String.valueOf(protocol));
                    this.mSelectionArgs.add(handle);
                    if (customProtocol != null) {
                        this.mSb.append(" AND data6=?");
                        this.mSelectionArgs.add(customProtocol);
                    }
                }
                if (values.containsKey("presence_data_id")) {
                    this.mSb.append(" AND data._id=?");
                    this.mSelectionArgs.add(values.getAsString("presence_data_id"));
                }
            }
            this.mSb.append(" AND ").append(this.getContactsRestrictions());
            Cursor cursor = null;
            try {
                cursor = this.mDb.query("data JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id) JOIN contacts ON (raw_contacts.contact_id = contacts._id)", DataContactsQuery.PROJECTION, this.mSb.toString(), this.mSelectionArgs.toArray(EMPTY_STRING_ARRAY), null, null, "in_visible_group DESC, raw_contact_id");
                if (cursor.moveToFirst()) {
                    dataId = cursor.getLong(1);
                    rawContactId = cursor.getLong(0);
                    contactId = cursor.getLong(2);
                    break block26;
                }
                long mimeTypeIdIm = -1L;
                return mimeTypeIdIm;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        if (values.containsKey("mode")) {
            if (customProtocol == null) {
                customProtocol = "";
            }
            this.mValues.clear();
            this.mValues.put("presence_data_id", dataId);
            this.mValues.put("presence_raw_contact_id", Long.valueOf(rawContactId));
            this.mValues.put("presence_contact_id", Long.valueOf(contactId));
            this.mValues.put("protocol", protocol);
            this.mValues.put("custom_protocol", customProtocol);
            this.mValues.put("im_handle", handle);
            if (values.containsKey("im_account")) {
                this.mValues.put("im_account", values.getAsString("im_account"));
            }
            this.mValues.put("mode", values.getAsString("mode"));
            this.mValues.put("chat_capability", values.getAsString("chat_capability"));
            this.mDb.replace("presence", null, this.mValues);
        }
        if (values.containsKey("status")) {
            String status = values.getAsString("status");
            String resPackage = values.getAsString("status_res_package");
            Integer labelResource = values.getAsInteger("status_label");
            if (TextUtils.isEmpty((CharSequence)resPackage) && (labelResource == null || labelResource == 0) && protocol != null) {
                labelResource = ContactsContract.CommonDataKinds.Im.getProtocolLabelResource((int)protocol);
            }
            Long iconResource = values.getAsLong("status_icon");
            if (TextUtils.isEmpty((CharSequence)status)) {
                this.mStatusUpdateDelete.bindLong(1, dataId.longValue());
                this.mStatusUpdateDelete.execute();
            } else if (values.containsKey("status_ts")) {
                long timestamp = values.getAsLong("status_ts");
                this.mStatusUpdateReplace.bindLong(1, dataId.longValue());
                this.mStatusUpdateReplace.bindLong(2, timestamp);
                this.bindString(this.mStatusUpdateReplace, 3, status);
                this.bindString(this.mStatusUpdateReplace, 4, resPackage);
                this.bindLong(this.mStatusUpdateReplace, 5, iconResource);
                this.bindLong(this.mStatusUpdateReplace, 6, labelResource);
                this.mStatusUpdateReplace.execute();
            } else {
                try {
                    this.mStatusUpdateInsert.bindLong(1, dataId.longValue());
                    this.bindString(this.mStatusUpdateInsert, 2, status);
                    this.bindString(this.mStatusUpdateInsert, 3, resPackage);
                    this.bindLong(this.mStatusUpdateInsert, 4, iconResource);
                    this.bindLong(this.mStatusUpdateInsert, 5, labelResource);
                    this.mStatusUpdateInsert.executeInsert();
                }
                catch (SQLiteConstraintException e) {
                    long timestamp = System.currentTimeMillis();
                    this.mStatusUpdateAutoTimestamp.bindLong(1, timestamp);
                    this.bindString(this.mStatusUpdateAutoTimestamp, 2, status);
                    this.mStatusUpdateAutoTimestamp.bindLong(3, dataId.longValue());
                    this.bindString(this.mStatusUpdateAutoTimestamp, 4, status);
                    this.mStatusUpdateAutoTimestamp.execute();
                    this.bindString(this.mStatusAttributionUpdate, 1, resPackage);
                    this.bindLong(this.mStatusAttributionUpdate, 2, iconResource);
                    this.bindLong(this.mStatusAttributionUpdate, 3, labelResource);
                    this.mStatusAttributionUpdate.bindLong(4, dataId.longValue());
                    this.mStatusAttributionUpdate.execute();
                }
            }
        }
        if (contactId != -1L) {
            this.mLastStatusUpdate.bindLong(1, contactId);
            this.mLastStatusUpdate.bindLong(2, contactId);
            this.mLastStatusUpdate.execute();
        }
        return dataId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int deleteInTransaction(Uri uri, String selection, String[] selectionArgs) {
        if (VERBOSE_LOGGING) {
            Log.v((String)TAG, (String)("deleteInTransaction: " + uri));
        }
        this.flushTransactionalChanges();
        boolean callerIsSyncAdapter = ContactsProvider2.readBooleanQueryParameter(uri, "caller_is_syncadapter", false);
        int match = sUriMatcher.match(uri);
        switch (match) {
            case 11000: {
                return this.mDbHelper.getSyncState().delete(this.mDb, selection, selectionArgs);
            }
            case 11001: {
                String selectionWithId = "_id=" + ContentUris.parseId((Uri)uri) + " " + (selection == null ? "" : " AND (" + selection + ")");
                return this.mDbHelper.getSyncState().delete(this.mDb, selectionWithId, selectionArgs);
            }
            case 1000: {
                return 0;
            }
            case 1001: {
                long contactId = ContentUris.parseId((Uri)uri);
                return this.deleteContact(contactId);
            }
            case 1002: {
                List pathSegments = uri.getPathSegments();
                int segmentCount = pathSegments.size();
                if (segmentCount < 3) {
                    throw new IllegalArgumentException(this.mDbHelper.exceptionMessage("Missing a lookup key", uri));
                }
                String lookupKey = (String)pathSegments.get(2);
                long contactId = this.lookupContactIdByLookupKey(this.mDb, lookupKey);
                return this.deleteContact(contactId);
            }
            case 1003: {
                String[] args;
                long contactId = ContentUris.parseId((Uri)uri);
                List pathSegments = uri.getPathSegments();
                String lookupKey = (String)pathSegments.get(2);
                SQLiteQueryBuilder lookupQb = new SQLiteQueryBuilder();
                this.setTablesAndProjectionMapForContacts(lookupQb, uri, null);
                if (selectionArgs == null) {
                    args = new String[2];
                } else {
                    args = new String[selectionArgs.length + 2];
                    System.arraycopy(selectionArgs, 0, args, 2, selectionArgs.length);
                }
                args[0] = String.valueOf(contactId);
                args[1] = Uri.encode((String)lookupKey);
                lookupQb.appendWhere((CharSequence)"_id=? AND lookup=?");
                SQLiteDatabase db = this.mDbHelper.getReadableDatabase();
                Cursor c = this.query(db, lookupQb, null, selection, args, null, null, null);
                try {
                    if (c.getCount() == 1) {
                        int n = this.deleteContact(contactId);
                        return n;
                    }
                    int n = 0;
                    return n;
                }
                finally {
                    c.close();
                }
            }
            case 2002: {
                int numDeletes = 0;
                Cursor c = this.mDb.query("raw_contacts", new String[]{"_id", "contact_id"}, this.appendAccountToSelection(uri, selection), selectionArgs, null, null, null);
                try {
                    while (c.moveToNext()) {
                        long rawContactId = c.getLong(0);
                        long contactId = c.getLong(1);
                        numDeletes += this.deleteRawContact(rawContactId, contactId, callerIsSyncAdapter);
                    }
                }
                finally {
                    c.close();
                }
                return numDeletes;
            }
            case 2003: {
                long rawContactId = ContentUris.parseId((Uri)uri);
                return this.deleteRawContact(rawContactId, this.mDbHelper.getContactId(rawContactId), callerIsSyncAdapter);
            }
            case 3000: {
                this.mSyncToNetwork |= !callerIsSyncAdapter;
                return this.deleteData(this.appendAccountToSelection(uri, selection), selectionArgs, callerIsSyncAdapter);
            }
            case 3001: 
            case 3003: 
            case 3006: 
            case 3010: {
                long dataId = ContentUris.parseId((Uri)uri);
                this.mSyncToNetwork |= !callerIsSyncAdapter;
                this.mSelectionArgs1[0] = String.valueOf(dataId);
                return this.deleteData("_id=?", this.mSelectionArgs1, callerIsSyncAdapter);
            }
            case 10001: {
                this.mSyncToNetwork |= !callerIsSyncAdapter;
                return this.deleteGroup(uri, ContentUris.parseId((Uri)uri), callerIsSyncAdapter);
            }
            case 10000: {
                int numDeletes = 0;
                Cursor c = this.mDb.query("groups", new String[]{"_id"}, this.appendAccountToSelection(uri, selection), selectionArgs, null, null, null);
                try {
                    while (c.moveToNext()) {
                        numDeletes += this.deleteGroup(uri, c.getLong(0), callerIsSyncAdapter);
                    }
                }
                finally {
                    c.close();
                }
                if (numDeletes > 0) {
                    this.mSyncToNetwork |= !callerIsSyncAdapter;
                }
                return numDeletes;
            }
            case 9000: {
                this.mSyncToNetwork |= !callerIsSyncAdapter;
                return this.deleteSettings(uri, this.appendAccountToSelection(uri, selection), selectionArgs);
            }
            case 7000: {
                return this.deleteStatusUpdates(selection, selectionArgs);
            }
        }
        this.mSyncToNetwork = true;
        return this.mLegacyApiSupport.delete(uri, selection, selectionArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteGroup(Uri uri, long groupId, boolean callerIsSyncAdapter) {
        this.mGroupIdCache.clear();
        long groupMembershipMimetypeId = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/group_membership");
        this.mDb.delete("data", "mimetype_id=" + groupMembershipMimetypeId + " AND " + "data1" + "=" + groupId, null);
        try {
            if (callerIsSyncAdapter) {
                int n = this.mDb.delete("groups", "_id=" + groupId, null);
                return n;
            }
            this.mValues.clear();
            this.mValues.put("deleted", Integer.valueOf(1));
            this.mValues.put("dirty", Integer.valueOf(1));
            int n = this.mDb.update("groups", this.mValues, "_id=" + groupId, null);
            return n;
        }
        finally {
            this.mVisibleTouched = true;
        }
    }

    private int deleteSettings(Uri uri, String selection, String[] selectionArgs) {
        int count = this.mDb.delete("settings", selection, selectionArgs);
        this.mVisibleTouched = true;
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteContact(long contactId) {
        this.mSelectionArgs1[0] = Long.toString(contactId);
        Cursor c = this.mDb.query("raw_contacts", new String[]{"_id"}, "contact_id=?", this.mSelectionArgs1, null, null, null);
        try {
            while (c.moveToNext()) {
                long rawContactId = c.getLong(0);
                this.markRawContactAsDeleted(rawContactId);
            }
        }
        finally {
            c.close();
        }
        return this.mDb.delete("contacts", "_id=" + contactId, null);
    }

    public int deleteRawContact(long rawContactId, long contactId, boolean callerIsSyncAdapter) {
        this.mContactAggregator.invalidateAggregationExceptionCache();
        if (callerIsSyncAdapter) {
            this.mDb.delete("presence", "presence_raw_contact_id=" + rawContactId, null);
            int count = this.mDb.delete("raw_contacts", "_id=" + rawContactId, null);
            this.mContactAggregator.updateDisplayNameForContact(this.mDb, contactId);
            return count;
        }
        this.mDbHelper.removeContactIfSingleton(rawContactId);
        return this.markRawContactAsDeleted(rawContactId);
    }

    private int deleteStatusUpdates(String selection, String[] selectionArgs) {
        if (VERBOSE_LOGGING) {
            Log.v((String)TAG, (String)("deleting data from status_updates for " + selection));
        }
        this.mDb.delete("status_updates", this.getWhereClauseForStatusUpdatesTable(selection), selectionArgs);
        return this.mDb.delete("presence", selection, selectionArgs);
    }

    private int markRawContactAsDeleted(long rawContactId) {
        this.mSyncToNetwork = true;
        this.mValues.clear();
        this.mValues.put("deleted", Integer.valueOf(1));
        this.mValues.put("aggregation_mode", Integer.valueOf(3));
        this.mValues.put("aggregation_needed", Integer.valueOf(1));
        this.mValues.putNull("contact_id");
        this.mValues.put("dirty", Integer.valueOf(1));
        return this.updateRawContact(rawContactId, this.mValues);
    }

    @Override
    protected int updateInTransaction(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        if (VERBOSE_LOGGING) {
            Log.v((String)TAG, (String)("updateInTransaction: " + uri));
        }
        int count = 0;
        int match = sUriMatcher.match(uri);
        if (match == 11001 && selection == null) {
            long rowId = ContentUris.parseId((Uri)uri);
            Object data = values.get("data");
            this.mUpdatedSyncStates.put(rowId, data);
            return 1;
        }
        this.flushTransactionalChanges();
        boolean callerIsSyncAdapter = ContactsProvider2.readBooleanQueryParameter(uri, "caller_is_syncadapter", false);
        switch (match) {
            case 11000: {
                return this.mDbHelper.getSyncState().update(this.mDb, values, this.appendAccountToSelection(uri, selection), selectionArgs);
            }
            case 11001: {
                selection = this.appendAccountToSelection(uri, selection);
                String selectionWithId = "_id=" + ContentUris.parseId((Uri)uri) + " " + (selection == null ? "" : " AND (" + selection + ")");
                return this.mDbHelper.getSyncState().update(this.mDb, values, selectionWithId, selectionArgs);
            }
            case 1000: {
                count = this.updateContactOptions(values, selection, selectionArgs);
                break;
            }
            case 1001: {
                count = this.updateContactOptions(ContentUris.parseId((Uri)uri), values);
                break;
            }
            case 1002: 
            case 1003: {
                List pathSegments = uri.getPathSegments();
                int segmentCount = pathSegments.size();
                if (segmentCount < 3) {
                    throw new IllegalArgumentException(this.mDbHelper.exceptionMessage("Missing a lookup key", uri));
                }
                String lookupKey = (String)pathSegments.get(2);
                long contactId = this.lookupContactIdByLookupKey(this.mDb, lookupKey);
                count = this.updateContactOptions(contactId, values);
                break;
            }
            case 2004: {
                String rawContactId = (String)uri.getPathSegments().get(1);
                String selectionWithId = "raw_contact_id=" + rawContactId + " " + (selection == null ? "" : " AND " + selection);
                count = this.updateData(uri, values, selectionWithId, selectionArgs, callerIsSyncAdapter);
                break;
            }
            case 3000: {
                count = this.updateData(uri, values, this.appendAccountToSelection(uri, selection), selectionArgs, callerIsSyncAdapter);
                if (count <= 0) break;
                this.mSyncToNetwork |= !callerIsSyncAdapter;
                break;
            }
            case 3001: 
            case 3003: 
            case 3006: 
            case 3010: {
                count = this.updateData(uri, values, selection, selectionArgs, callerIsSyncAdapter);
                if (count <= 0) break;
                this.mSyncToNetwork |= !callerIsSyncAdapter;
                break;
            }
            case 2002: {
                selection = this.appendAccountToSelection(uri, selection);
                count = this.updateRawContacts(values, selection, selectionArgs);
                break;
            }
            case 2003: {
                long rawContactId = ContentUris.parseId((Uri)uri);
                if (selection != null) {
                    selectionArgs = this.insertSelectionArg(selectionArgs, String.valueOf(rawContactId));
                    count = this.updateRawContacts(values, "_id=? AND(" + selection + ")", selectionArgs);
                    break;
                }
                this.mSelectionArgs1[0] = String.valueOf(rawContactId);
                count = this.updateRawContacts(values, "_id=?", this.mSelectionArgs1);
                break;
            }
            case 10000: {
                count = this.updateGroups(uri, values, this.appendAccountToSelection(uri, selection), selectionArgs, callerIsSyncAdapter);
                if (count <= 0) break;
                this.mSyncToNetwork |= !callerIsSyncAdapter;
                break;
            }
            case 10001: {
                long groupId = ContentUris.parseId((Uri)uri);
                selectionArgs = this.insertSelectionArg(selectionArgs, String.valueOf(groupId));
                String selectionWithId = "_id=? " + (selection == null ? "" : " AND " + selection);
                count = this.updateGroups(uri, values, selectionWithId, selectionArgs, callerIsSyncAdapter);
                if (count <= 0) break;
                this.mSyncToNetwork |= !callerIsSyncAdapter;
                break;
            }
            case 6000: {
                count = this.updateAggregationException(this.mDb, values);
                break;
            }
            case 9000: {
                count = this.updateSettings(uri, values, this.appendAccountToSelection(uri, selection), selectionArgs);
                this.mSyncToNetwork |= !callerIsSyncAdapter;
                break;
            }
            case 7000: {
                count = this.updateStatusUpdate(uri, values, selection, selectionArgs);
                break;
            }
            default: {
                this.mSyncToNetwork = true;
                return this.mLegacyApiSupport.update(uri, values, selection, selectionArgs);
            }
        }
        return count;
    }

    private int updateStatusUpdate(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        int updateCount = 0;
        ContentValues settableValues = this.getSettableColumnsForStatusUpdatesTable(values);
        if (settableValues.size() > 0) {
            updateCount = this.mDb.update("status_updates", settableValues, this.getWhereClauseForStatusUpdatesTable(selection), selectionArgs);
        }
        if ((settableValues = this.getSettableColumnsForPresenceTable(values)).size() > 0) {
            updateCount = this.mDb.update("presence", settableValues, selection, selectionArgs);
        }
        return updateCount;
    }

    private String getWhereClauseForStatusUpdatesTable(String selection) {
        this.mSb.setLength(0);
        this.mSb.append(WHERE_CLAUSE_FOR_STATUS_UPDATES_TABLE);
        this.mSb.append(selection);
        this.mSb.append(")");
        return this.mSb.toString();
    }

    private ContentValues getSettableColumnsForStatusUpdatesTable(ContentValues values) {
        this.mValues.clear();
        ContactsDatabaseHelper.copyStringValue(this.mValues, "status", values, "status");
        ContactsDatabaseHelper.copyStringValue(this.mValues, "status_ts", values, "status_ts");
        ContactsDatabaseHelper.copyStringValue(this.mValues, "status_res_package", values, "status_res_package");
        ContactsDatabaseHelper.copyStringValue(this.mValues, "status_label", values, "status_label");
        ContactsDatabaseHelper.copyStringValue(this.mValues, "status_icon", values, "status_icon");
        return this.mValues;
    }

    private ContentValues getSettableColumnsForPresenceTable(ContentValues values) {
        this.mValues.clear();
        ContactsDatabaseHelper.copyStringValue(this.mValues, "mode", values, "mode");
        ContactsDatabaseHelper.copyStringValue(this.mValues, "chat_capability", values, "chat_capability");
        return this.mValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateGroups(Uri uri, ContentValues values, String selectionWithId, String[] selectionArgs, boolean callerIsSyncAdapter) {
        ContentValues updatedValues;
        this.mGroupIdCache.clear();
        if (!callerIsSyncAdapter && !values.containsKey("dirty")) {
            updatedValues = this.mValues;
            updatedValues.clear();
            updatedValues.putAll(values);
            updatedValues.put("dirty", Integer.valueOf(1));
        } else {
            updatedValues = values;
        }
        int count = this.mDb.update("groups", updatedValues, selectionWithId, selectionArgs);
        if (updatedValues.containsKey("group_visible")) {
            this.mVisibleTouched = true;
        }
        if (updatedValues.containsKey("should_sync") && updatedValues.getAsInteger("should_sync") != 0) {
            Cursor c = this.mDb.query("groups", new String[]{"account_name", "account_type"}, selectionWithId, selectionArgs, null, null, null);
            try {
                while (c.moveToNext()) {
                    String accountName = c.getString(0);
                    String accountType = c.getString(1);
                    if (TextUtils.isEmpty((CharSequence)accountName) || TextUtils.isEmpty((CharSequence)accountType)) continue;
                    Account account = new Account(accountName, accountType);
                    ContentResolver.requestSync((Account)account, (String)"com.android.contacts", (Bundle)new Bundle());
                    break;
                }
            }
            finally {
                c.close();
            }
        }
        return count;
    }

    private int updateSettings(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        int count = this.mDb.update("settings", values, selection, selectionArgs);
        if (values.containsKey("ungrouped_visible")) {
            this.mVisibleTouched = true;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateRawContacts(ContentValues values, String selection, String[] selectionArgs) {
        if (values.containsKey("contact_id")) {
            throw new IllegalArgumentException("contact_id should not be included in content values. Contact IDs are assigned automatically");
        }
        int count = 0;
        Cursor cursor = this.mDb.query(this.mDbHelper.getRawContactView(), new String[]{"_id"}, selection, selectionArgs, null, null, null);
        try {
            while (cursor.moveToNext()) {
                long rawContactId = cursor.getLong(0);
                this.updateRawContact(rawContactId, values);
                ++count;
            }
        }
        finally {
            cursor.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateRawContact(long rawContactId, ContentValues values) {
        int count;
        String selection = "_id = ?";
        this.mSelectionArgs1[0] = Long.toString(rawContactId);
        boolean requestUndoDelete = values.containsKey("deleted") && values.getAsInteger("deleted") == 0;
        int previousDeleted = 0;
        String accountType = null;
        String accountName = null;
        if (requestUndoDelete) {
            Cursor cursor = this.mDb.query("raw_contacts", RawContactsQuery.COLUMNS, "_id = ?", this.mSelectionArgs1, null, null, null);
            try {
                if (cursor.moveToFirst()) {
                    previousDeleted = cursor.getInt(0);
                    accountType = cursor.getString(1);
                    accountName = cursor.getString(2);
                }
            }
            finally {
                cursor.close();
            }
            values.put("aggregation_mode", Integer.valueOf(0));
        }
        if ((count = this.mDb.update("raw_contacts", values, "_id = ?", this.mSelectionArgs1)) != 0) {
            int aggregationMode;
            if (values.containsKey("aggregation_mode") && (aggregationMode = values.getAsInteger("aggregation_mode").intValue()) != 0) {
                this.mContactAggregator.markForAggregation(rawContactId, aggregationMode, false);
            }
            if (values.containsKey("starred")) {
                this.mContactAggregator.updateStarred(rawContactId);
            }
            if (values.containsKey("sourceid")) {
                this.mContactAggregator.updateLookupKeyForRawContact(this.mDb, rawContactId);
            }
            if (values.containsKey("name_verified")) {
                if (values.getAsInteger("name_verified") != 0) {
                    this.mResetNameVerifiedForOtherRawContacts.bindLong(1, rawContactId);
                    this.mResetNameVerifiedForOtherRawContacts.bindLong(2, rawContactId);
                    this.mResetNameVerifiedForOtherRawContacts.execute();
                }
                this.mContactAggregator.updateDisplayNameForRawContact(this.mDb, rawContactId);
            }
            if (requestUndoDelete && previousDeleted == 1) {
                this.mInsertedRawContacts.put(rawContactId, new Account(accountName, accountType));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateData(Uri uri, ContentValues values, String selection, String[] selectionArgs, boolean callerIsSyncAdapter) {
        this.mValues.clear();
        this.mValues.putAll(values);
        this.mValues.remove("_id");
        this.mValues.remove("raw_contact_id");
        this.mValues.remove("mimetype");
        String packageName = values.getAsString("res_package");
        if (packageName != null) {
            this.mValues.remove("res_package");
            this.mValues.put("package_id", Long.valueOf(this.mDbHelper.getPackageId(packageName)));
        }
        boolean containsIsSuperPrimary = this.mValues.containsKey("is_super_primary");
        boolean containsIsPrimary = this.mValues.containsKey("is_primary");
        if (containsIsSuperPrimary && this.mValues.getAsInteger("is_super_primary") == 0) {
            containsIsSuperPrimary = false;
            this.mValues.remove("is_super_primary");
        }
        if (containsIsPrimary && this.mValues.getAsInteger("is_primary") == 0) {
            containsIsPrimary = false;
            this.mValues.remove("is_primary");
        }
        int count = 0;
        Cursor c = this.query(uri, DataUpdateQuery.COLUMNS, selection, selectionArgs, null);
        try {
            while (c.moveToNext()) {
                count += this.updateData(this.mValues, c, callerIsSyncAdapter);
            }
        }
        finally {
            c.close();
        }
        return count;
    }

    private int updateData(ContentValues values, Cursor c, boolean callerIsSyncAdapter) {
        if (values.size() == 0) {
            return 0;
        }
        String mimeType = c.getString(2);
        DataRowHandler rowHandler = this.getDataRowHandler(mimeType);
        if (rowHandler.update(this.mDb, values, c, callerIsSyncAdapter)) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateContactOptions(ContentValues values, String selection, String[] selectionArgs) {
        int count = 0;
        Cursor cursor = this.mDb.query(this.mDbHelper.getContactView(), new String[]{"_id"}, selection, selectionArgs, null, null, null);
        try {
            while (cursor.moveToNext()) {
                long contactId = cursor.getLong(0);
                this.updateContactOptions(contactId, values);
                ++count;
            }
        }
        finally {
            cursor.close();
        }
        return count;
    }

    private int updateContactOptions(long contactId, ContentValues values) {
        this.mValues.clear();
        ContactsDatabaseHelper.copyStringValue(this.mValues, "custom_ringtone", values, "custom_ringtone");
        ContactsDatabaseHelper.copyLongValue(this.mValues, "send_to_voicemail", values, "send_to_voicemail");
        ContactsDatabaseHelper.copyLongValue(this.mValues, "last_time_contacted", values, "last_time_contacted");
        ContactsDatabaseHelper.copyLongValue(this.mValues, "times_contacted", values, "times_contacted");
        ContactsDatabaseHelper.copyLongValue(this.mValues, "starred", values, "starred");
        if (this.mValues.size() == 0) {
            return 0;
        }
        if (this.mValues.containsKey("starred")) {
            this.mValues.put("dirty", Integer.valueOf(1));
        }
        this.mSelectionArgs1[0] = String.valueOf(contactId);
        this.mDb.update("raw_contacts", this.mValues, "contact_id=?", this.mSelectionArgs1);
        this.mValues.clear();
        ContactsDatabaseHelper.copyStringValue(this.mValues, "custom_ringtone", values, "custom_ringtone");
        ContactsDatabaseHelper.copyLongValue(this.mValues, "send_to_voicemail", values, "send_to_voicemail");
        ContactsDatabaseHelper.copyLongValue(this.mValues, "last_time_contacted", values, "last_time_contacted");
        ContactsDatabaseHelper.copyLongValue(this.mValues, "times_contacted", values, "times_contacted");
        ContactsDatabaseHelper.copyLongValue(this.mValues, "starred", values, "starred");
        int rslt = this.mDb.update("contacts", this.mValues, "_id=?", this.mSelectionArgs1);
        if (values.containsKey("last_time_contacted") && !values.containsKey("times_contacted")) {
            this.mDb.execSQL(UPDATE_TIMES_CONTACTED_CONTACTS_TABLE, (Object[])this.mSelectionArgs1);
            this.mDb.execSQL(UPDATE_TIMES_CONTACTED_RAWCONTACTS_TABLE, (Object[])this.mSelectionArgs1);
        }
        return rslt;
    }

    private int updateAggregationException(SQLiteDatabase db, ContentValues values) {
        long rawContactId2;
        long rawContactId1;
        long rcId2;
        int exceptionType = values.getAsInteger("type");
        long rcId1 = values.getAsInteger("raw_contact_id1").intValue();
        if (rcId1 < (rcId2 = (long)values.getAsInteger("raw_contact_id2").intValue())) {
            rawContactId1 = rcId1;
            rawContactId2 = rcId2;
        } else {
            rawContactId2 = rcId1;
            rawContactId1 = rcId2;
        }
        if (exceptionType == 0) {
            this.mSelectionArgs2[0] = String.valueOf(rawContactId1);
            this.mSelectionArgs2[1] = String.valueOf(rawContactId2);
            db.delete("agg_exceptions", "raw_contact_id1=? AND raw_contact_id2=?", this.mSelectionArgs2);
        } else {
            ContentValues exceptionValues = new ContentValues(3);
            exceptionValues.put("type", Integer.valueOf(exceptionType));
            exceptionValues.put("raw_contact_id1", Long.valueOf(rawContactId1));
            exceptionValues.put("raw_contact_id2", Long.valueOf(rawContactId2));
            db.replace("agg_exceptions", "_id", exceptionValues);
        }
        this.mContactAggregator.invalidateAggregationExceptionCache();
        this.mContactAggregator.markForAggregation(rawContactId1, 0, true);
        this.mContactAggregator.markForAggregation(rawContactId2, 0, true);
        this.mContactAggregator.aggregateContact(db, rawContactId1);
        this.mContactAggregator.aggregateContact(db, rawContactId2);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getOrCreateMyContactsGroupInTransaction(String accountName, String accountType) {
        Cursor cursor = this.mDb.query("groups", new String[]{"_id"}, "account_name =? AND account_type =? AND title =?", new String[]{accountName, accountType, GOOGLE_MY_CONTACTS_GROUP_TITLE}, null, null, null);
        try {
            if (cursor.moveToNext()) {
                long l = cursor.getLong(0);
                return l;
            }
        }
        finally {
            cursor.close();
        }
        ContentValues values = new ContentValues();
        values.put("title", GOOGLE_MY_CONTACTS_GROUP_TITLE);
        values.put("account_name", accountName);
        values.put("account_type", accountType);
        values.put("group_visible", "1");
        return this.mDb.insert("groups", null, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAccountsUpdated(Account[] accounts) {
        HashSet<Account> existingAccounts = new HashSet<Account>();
        boolean[] hasUnassignedContacts = new boolean[]{false};
        this.mDb.beginTransaction();
        try {
            this.findValidAccounts(existingAccounts, hasUnassignedContacts);
            for (Account account : accounts) {
                if (existingAccounts.contains(account)) continue;
                this.mDb.execSQL("INSERT INTO accounts (account_name, account_type) VALUES (?, ?)", (Object[])new String[]{account.name, account.type});
            }
            HashSet<Account> accountsToDelete = new HashSet<Account>(existingAccounts);
            for (Account account : accounts) {
                accountsToDelete.remove(account);
            }
            for (Account account : accountsToDelete) {
                Log.d((String)TAG, (String)("removing data for removed account " + account));
                Object[] params = new String[]{account.name, account.type};
                this.mDb.execSQL("DELETE FROM groups WHERE account_name = ? AND account_type = ?", params);
                this.mDb.execSQL("DELETE FROM presence WHERE presence_raw_contact_id IN (SELECT _id FROM raw_contacts WHERE account_name = ? AND account_type = ?)", params);
                this.mDb.execSQL("DELETE FROM raw_contacts WHERE account_name = ? AND account_type = ?", params);
                this.mDb.execSQL("DELETE FROM settings WHERE account_name = ? AND account_type = ?", params);
                this.mDb.execSQL("DELETE FROM accounts WHERE account_name=? AND account_type=?", params);
            }
            if (!accountsToDelete.isEmpty()) {
                HashSet orphanContactIds = Sets.newHashSet();
                Cursor cursor = this.mDb.rawQuery("SELECT _id FROM contacts WHERE (name_raw_contact_id NOT NULL AND name_raw_contact_id NOT IN (SELECT _id FROM raw_contacts)) OR (photo_id NOT NULL AND photo_id NOT IN (SELECT _id FROM data))", null);
                try {
                    while (cursor.moveToNext()) {
                        orphanContactIds.add(cursor.getLong(0));
                    }
                }
                finally {
                    cursor.close();
                }
                for (Long contactId : orphanContactIds) {
                    this.mContactAggregator.updateAggregateData(contactId);
                }
            }
            if (hasUnassignedContacts[0]) {
                Account primaryAccount = null;
                for (Account account : accounts) {
                    if (!this.isWritableAccount(account.type)) continue;
                    primaryAccount = account;
                    break;
                }
                if (primaryAccount != null) {
                    long groupId;
                    Object[] params = new String[]{primaryAccount.name, primaryAccount.type};
                    if (primaryAccount.type.equals(DEFAULT_ACCOUNT_TYPE) && (groupId = this.getOrCreateMyContactsGroupInTransaction(primaryAccount.name, primaryAccount.type)) != -1L) {
                        long mimeTypeId = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/group_membership");
                        this.mDb.execSQL("INSERT INTO data(mimetype_id, raw_contact_id, data1) SELECT " + mimeTypeId + ", " + "_id" + ", " + groupId + " FROM " + "raw_contacts" + " WHERE " + "account_name" + " IS NULL" + " AND " + "account_type" + " IS NULL");
                    }
                    this.mDb.execSQL("UPDATE raw_contacts SET account_name=?,account_type=? WHERE account_name IS NULL AND account_type IS NULL", params);
                    this.mDb.execSQL("UPDATE groups SET account_name=?,account_type=? WHERE account_name IS NULL AND account_type IS NULL", params);
                    this.mDb.execSQL("DELETE FROM accounts WHERE account_name IS NULL AND account_type IS NULL");
                }
            }
            this.mDbHelper.updateAllVisible();
            this.mDbHelper.getSyncState().onAccountsChanged(this.mDb, accounts);
            this.mDb.setTransactionSuccessful();
        }
        finally {
            this.mDb.endTransaction();
        }
        this.mAccountWritability.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findValidAccounts(Set<Account> validAccounts, boolean[] hasUnassignedContacts) {
        Cursor c = this.mDb.rawQuery("SELECT account_name,account_type FROM accounts", null);
        try {
            while (c.moveToNext()) {
                if (c.isNull(0) && c.isNull(1)) {
                    hasUnassignedContacts[0] = true;
                    continue;
                }
                validAccounts.add(new Account(c.getString(0), c.getString(1)));
            }
        }
        finally {
            c.close();
        }
    }

    private static boolean areAllEmpty(ContentValues values, String[] keys) {
        for (String key : keys) {
            if (TextUtils.isEmpty((CharSequence)values.getAsString(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean areAnySpecified(ContentValues values, String[] keys) {
        for (String key : keys) {
            if (!values.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        if (VERBOSE_LOGGING) {
            Log.v((String)TAG, (String)("query: " + uri));
        }
        SQLiteDatabase db = this.mDbHelper.getReadableDatabase();
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        String groupBy = null;
        String limit = this.getLimit(uri);
        int match = sUriMatcher.match(uri);
        switch (match) {
            case 11000: {
                return this.mDbHelper.getSyncState().query(db, projection, selection, selectionArgs, sortOrder);
            }
            case 1000: {
                this.setTablesAndProjectionMapForContacts(qb, uri, projection);
                break;
            }
            case 1001: {
                long contactId = ContentUris.parseId((Uri)uri);
                this.setTablesAndProjectionMapForContacts(qb, uri, projection);
                selectionArgs = this.insertSelectionArg(selectionArgs, String.valueOf(contactId));
                qb.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 1002: 
            case 1003: {
                List pathSegments = uri.getPathSegments();
                int segmentCount = pathSegments.size();
                if (segmentCount < 3) {
                    throw new IllegalArgumentException(this.mDbHelper.exceptionMessage("Missing a lookup key", uri));
                }
                String lookupKey = (String)pathSegments.get(2);
                if (segmentCount == 4) {
                    String[] args;
                    long contactId = Long.parseLong((String)pathSegments.get(3));
                    SQLiteQueryBuilder lookupQb = new SQLiteQueryBuilder();
                    this.setTablesAndProjectionMapForContacts(lookupQb, uri, projection);
                    if (selectionArgs == null) {
                        args = new String[2];
                    } else {
                        args = new String[selectionArgs.length + 2];
                        System.arraycopy(selectionArgs, 0, args, 2, selectionArgs.length);
                    }
                    args[0] = String.valueOf(contactId);
                    args[1] = Uri.encode((String)lookupKey);
                    lookupQb.appendWhere((CharSequence)"_id=? AND lookup=?");
                    Cursor c = this.query(db, lookupQb, projection, selection, args, sortOrder, groupBy, limit);
                    if (c.getCount() != 0) {
                        return c;
                    }
                    c.close();
                }
                this.setTablesAndProjectionMapForContacts(qb, uri, projection);
                selectionArgs = this.insertSelectionArg(selectionArgs, String.valueOf(this.lookupContactIdByLookupKey(db, lookupKey)));
                qb.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 1010: {
                String lookupKey = Uri.encode((String)((String)uri.getPathSegments().get(2)));
                qb.setTables(this.mDbHelper.getContactView(true));
                qb.setProjectionMap(sContactsVCardProjectionMap);
                selectionArgs = this.insertSelectionArg(selectionArgs, String.valueOf(this.lookupContactIdByLookupKey(db, lookupKey)));
                qb.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 1011: {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
                String currentDateString = dateFormat.format(new Date()).toString();
                return db.rawQuery("SELECT 'vcards_' || ? || '.vcf' AS _display_name, NULL AS _size", new String[]{currentDateString});
            }
            case 1005: {
                String filterParam = "";
                if (uri.getPathSegments().size() > 2) {
                    filterParam = uri.getLastPathSegment();
                }
                this.setTablesAndProjectionMapForContactsWithSnippet(qb, uri, projection, filterParam);
                break;
            }
            case 1006: 
            case 1007: {
                String filterSql = null;
                if (match == 1007 && uri.getPathSegments().size() > 3) {
                    String filterParam = uri.getLastPathSegment();
                    StringBuilder sb = new StringBuilder();
                    sb.append("_id IN ");
                    this.appendContactFilterAsNestedQuery(sb, filterParam);
                    filterSql = sb.toString();
                }
                this.setTablesAndProjectionMapForContacts(qb, uri, projection);
                String[] starredProjection = null;
                String[] frequentProjection = null;
                if (projection != null) {
                    starredProjection = this.appendProjectionArg(projection, TIMES_CONTACED_SORT_COLUMN);
                    frequentProjection = this.appendProjectionArg(projection, TIMES_CONTACED_SORT_COLUMN);
                }
                if (filterSql != null) {
                    qb.appendWhere(filterSql);
                }
                qb.setProjectionMap(sStrequentStarredProjectionMap);
                String starredQuery = qb.buildQuery(starredProjection, "starred=1", null, "_id", null, null, null);
                qb = new SQLiteQueryBuilder();
                this.setTablesAndProjectionMapForContacts(qb, uri, projection);
                if (filterSql != null) {
                    qb.appendWhere((CharSequence)filterSql);
                }
                qb.setProjectionMap(sStrequentFrequentProjectionMap);
                String frequentQuery = qb.buildQuery(frequentProjection, "times_contacted > 0 AND (starred = 0 OR starred IS NULL)", null, "_id", null, null, null);
                String query = qb.buildUnionQuery(new String[]{starredQuery, frequentQuery}, STREQUENT_ORDER_BY, STREQUENT_LIMIT);
                Cursor c = db.rawQuery(query, null);
                if (c != null) {
                    c.setNotificationUri(this.getContext().getContentResolver(), ContactsContract.AUTHORITY_URI);
                }
                return c;
            }
            case 1008: {
                this.setTablesAndProjectionMapForContacts(qb, uri, projection);
                if (uri.getPathSegments().size() <= 2) break;
                qb.appendWhere((CharSequence)CONTACTS_IN_GROUP_SELECT);
                selectionArgs = this.insertSelectionArg(selectionArgs, uri.getLastPathSegment());
                break;
            }
            case 1004: {
                long contactId = Long.parseLong((String)uri.getPathSegments().get(1));
                this.setTablesAndProjectionMapForData(qb, uri, projection, false);
                selectionArgs = this.insertSelectionArg(selectionArgs, String.valueOf(contactId));
                qb.appendWhere((CharSequence)" AND contact_id=?");
                break;
            }
            case 1009: {
                long contactId = Long.parseLong((String)uri.getPathSegments().get(1));
                this.setTablesAndProjectionMapForData(qb, uri, projection, false);
                selectionArgs = this.insertSelectionArg(selectionArgs, String.valueOf(contactId));
                qb.appendWhere((CharSequence)" AND contact_id=?");
                qb.appendWhere((CharSequence)" AND _id=photo_id");
                break;
            }
            case 3002: {
                this.setTablesAndProjectionMapForData(qb, uri, projection, false);
                qb.appendWhere((CharSequence)" AND mimetype = 'vnd.android.cursor.item/phone_v2'");
                break;
            }
            case 3003: {
                this.setTablesAndProjectionMapForData(qb, uri, projection, false);
                selectionArgs = this.insertSelectionArg(selectionArgs, uri.getLastPathSegment());
                qb.appendWhere((CharSequence)" AND mimetype = 'vnd.android.cursor.item/phone_v2'");
                qb.appendWhere((CharSequence)" AND _id=?");
                break;
            }
            case 3004: {
                this.setTablesAndProjectionMapForData(qb, uri, projection, true);
                qb.appendWhere((CharSequence)" AND mimetype = 'vnd.android.cursor.item/phone_v2'");
                if (uri.getPathSegments().size() > 2) {
                    String filterParam = uri.getLastPathSegment();
                    StringBuilder sb = new StringBuilder();
                    sb.append(" AND (");
                    boolean hasCondition = false;
                    boolean orNeeded = false;
                    String normalizedName = NameNormalizer.normalize(filterParam);
                    if (normalizedName.length() > 0) {
                        sb.append("raw_contact_id IN ");
                        this.appendRawContactsByNormalizedNameFilter(sb, normalizedName, false);
                        orNeeded = true;
                        hasCondition = true;
                    }
                    if (this.isPhoneNumber(filterParam)) {
                        if (orNeeded) {
                            sb.append(" OR ");
                        }
                        String number = PhoneNumberUtils.convertKeypadLettersToDigits((String)filterParam);
                        String reversed = PhoneNumberUtils.getStrippedReversed((String)number);
                        sb.append("_id IN (SELECT data_id FROM phone_lookup WHERE normalized_number LIKE '%");
                        sb.append(reversed);
                        sb.append("')");
                        hasCondition = true;
                    }
                    if (!hasCondition) {
                        sb.append("0");
                    }
                    sb.append(")");
                    qb.appendWhere((CharSequence)sb);
                }
                groupBy = "data4,contact_id";
                if (sortOrder != null) break;
                sortOrder = "in_visible_group DESC, contact_id";
                break;
            }
            case 3005: {
                this.setTablesAndProjectionMapForData(qb, uri, projection, false);
                qb.appendWhere((CharSequence)" AND mimetype = 'vnd.android.cursor.item/email_v2'");
                break;
            }
            case 3006: {
                this.setTablesAndProjectionMapForData(qb, uri, projection, false);
                selectionArgs = this.insertSelectionArg(selectionArgs, uri.getLastPathSegment());
                qb.appendWhere((CharSequence)" AND mimetype = 'vnd.android.cursor.item/email_v2' AND _id=?");
                break;
            }
            case 3007: {
                this.setTablesAndProjectionMapForData(qb, uri, projection, false);
                qb.appendWhere((CharSequence)" AND mimetype = 'vnd.android.cursor.item/email_v2'");
                if (uri.getPathSegments().size() <= 2) break;
                String email = uri.getLastPathSegment();
                String address = this.mDbHelper.extractAddressFromEmailAddress(email);
                selectionArgs = this.insertSelectionArg(selectionArgs, address);
                qb.appendWhere((CharSequence)" AND UPPER(data1)=UPPER(?)");
                break;
            }
            case 3008: {
                this.setTablesAndProjectionMapForData(qb, uri, projection, true);
                String filterParam = null;
                if (uri.getPathSegments().size() > 3 && TextUtils.isEmpty((CharSequence)(filterParam = uri.getLastPathSegment()))) {
                    filterParam = null;
                }
                if (filterParam == null) {
                    qb.appendWhere((CharSequence)" AND 0");
                } else {
                    String normalizedName;
                    StringBuilder sb = new StringBuilder();
                    sb.append(" AND _id IN (");
                    sb.append("SELECT _id FROM data WHERE mimetype_id=" + this.mMimeTypeIdEmail + " AND " + "data1" + " LIKE ");
                    DatabaseUtils.appendEscapedSQLString((StringBuilder)sb, (String)(filterParam + '%'));
                    if (!filterParam.contains("@") && (normalizedName = NameNormalizer.normalize(filterParam)).length() > 0) {
                        sb.append(" UNION SELECT _id FROM data WHERE +mimetype_id=" + this.mMimeTypeIdEmail + " AND " + "raw_contact_id" + " IN ");
                        this.appendRawContactsByNormalizedNameFilter(sb, normalizedName, false);
                    }
                    sb.append(")");
                    qb.appendWhere((CharSequence)sb);
                }
                groupBy = "data1,contact_id";
                if (sortOrder != null) break;
                sortOrder = "in_visible_group DESC, contact_id";
                break;
            }
            case 3009: {
                this.setTablesAndProjectionMapForData(qb, uri, projection, false);
                qb.appendWhere((CharSequence)" AND mimetype = 'vnd.android.cursor.item/postal-address_v2'");
                break;
            }
            case 3010: {
                this.setTablesAndProjectionMapForData(qb, uri, projection, false);
                selectionArgs = this.insertSelectionArg(selectionArgs, uri.getLastPathSegment());
                qb.appendWhere((CharSequence)" AND mimetype = 'vnd.android.cursor.item/postal-address_v2'");
                qb.appendWhere((CharSequence)" AND _id=?");
                break;
            }
            case 2002: {
                this.setTablesAndProjectionMapForRawContacts(qb, uri);
                break;
            }
            case 2003: {
                long rawContactId = ContentUris.parseId((Uri)uri);
                this.setTablesAndProjectionMapForRawContacts(qb, uri);
                selectionArgs = this.insertSelectionArg(selectionArgs, String.valueOf(rawContactId));
                qb.appendWhere((CharSequence)" AND _id=?");
                break;
            }
            case 2004: {
                long rawContactId = Long.parseLong((String)uri.getPathSegments().get(1));
                this.setTablesAndProjectionMapForData(qb, uri, projection, false);
                selectionArgs = this.insertSelectionArg(selectionArgs, String.valueOf(rawContactId));
                qb.appendWhere((CharSequence)" AND raw_contact_id=?");
                break;
            }
            case 3000: {
                this.setTablesAndProjectionMapForData(qb, uri, projection, false);
                break;
            }
            case 3001: {
                this.setTablesAndProjectionMapForData(qb, uri, projection, false);
                selectionArgs = this.insertSelectionArg(selectionArgs, uri.getLastPathSegment());
                qb.appendWhere((CharSequence)" AND _id=?");
                break;
            }
            case 4000: {
                if (TextUtils.isEmpty((CharSequence)sortOrder)) {
                    sortOrder = "raw_contacts._id";
                }
                String number = uri.getPathSegments().size() > 1 ? uri.getLastPathSegment() : "";
                this.mDbHelper.buildPhoneLookupAndContactQuery(qb, number);
                qb.setProjectionMap(sPhoneLookupProjectionMap);
                selection = null;
                selectionArgs = null;
                break;
            }
            case 10000: {
                qb.setTables(this.mDbHelper.getGroupView());
                qb.setProjectionMap(sGroupsProjectionMap);
                this.appendAccountFromParameter(qb, uri);
                break;
            }
            case 10001: {
                qb.setTables(this.mDbHelper.getGroupView());
                qb.setProjectionMap(sGroupsProjectionMap);
                selectionArgs = this.insertSelectionArg(selectionArgs, uri.getLastPathSegment());
                qb.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 10003: {
                qb.setTables(this.mDbHelper.getGroupView() + " AS groups");
                qb.setProjectionMap(sGroupsSummaryProjectionMap);
                this.appendAccountFromParameter(qb, uri);
                groupBy = "_id";
                break;
            }
            case 6000: {
                qb.setTables("agg_exceptions");
                qb.setProjectionMap(sAggregationExceptionsProjectionMap);
                break;
            }
            case 8000: {
                long contactId = Long.parseLong((String)uri.getPathSegments().get(1));
                String filter = null;
                if (uri.getPathSegments().size() > 3) {
                    filter = (String)uri.getPathSegments().get(3);
                }
                int maxSuggestions = limit != null ? Integer.parseInt(limit) : 5;
                this.setTablesAndProjectionMapForContacts(qb, uri, projection);
                return this.mContactAggregator.queryAggregationSuggestions(qb, projection, contactId, maxSuggestions, filter);
            }
            case 9000: {
                qb.setTables("settings");
                qb.setProjectionMap(sSettingsProjectionMap);
                this.appendAccountFromParameter(qb, uri);
                String groupMembershipMimetypeId = Long.toString(this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/group_membership"));
                if (projection != null && projection.length != 0 && this.mDbHelper.isInProjection(projection, "summ_count")) {
                    selectionArgs = this.insertSelectionArg(selectionArgs, groupMembershipMimetypeId);
                }
                if (projection == null || projection.length == 0 || !this.mDbHelper.isInProjection(projection, "summ_phones")) break;
                selectionArgs = this.insertSelectionArg(selectionArgs, groupMembershipMimetypeId);
                break;
            }
            case 7000: {
                this.setTableAndProjectionMapForStatusUpdates(qb, projection);
                break;
            }
            case 7001: {
                this.setTableAndProjectionMapForStatusUpdates(qb, projection);
                selectionArgs = this.insertSelectionArg(selectionArgs, uri.getLastPathSegment());
                qb.appendWhere((CharSequence)"data._id=?");
                break;
            }
            case 12001: {
                return this.mGlobalSearchSupport.handleSearchSuggestionsQuery(db, uri, limit);
            }
            case 12002: {
                String lookupKey = uri.getLastPathSegment();
                return this.mGlobalSearchSupport.handleSearchShortcutRefresh(db, lookupKey, projection);
            }
            case 14000: {
                qb.setTables(this.mDbHelper.getContactView());
                qb.setProjectionMap(sLiveFoldersProjectionMap);
                break;
            }
            case 14001: {
                qb.setTables(this.mDbHelper.getContactView());
                qb.setProjectionMap(sLiveFoldersProjectionMap);
                qb.appendWhere((CharSequence)"has_phone_number=1");
                break;
            }
            case 14002: {
                qb.setTables(this.mDbHelper.getContactView());
                qb.setProjectionMap(sLiveFoldersProjectionMap);
                qb.appendWhere((CharSequence)"starred=1");
                break;
            }
            case 14003: {
                qb.setTables(this.mDbHelper.getContactView());
                qb.setProjectionMap(sLiveFoldersProjectionMap);
                qb.appendWhere((CharSequence)CONTACTS_IN_GROUP_SELECT);
                selectionArgs = this.insertSelectionArg(selectionArgs, uri.getLastPathSegment());
                break;
            }
            case 15001: {
                this.setTablesAndProjectionMapForRawContactsEntities(qb, uri);
                break;
            }
            case 2005: {
                long rawContactId = Long.parseLong((String)uri.getPathSegments().get(1));
                this.setTablesAndProjectionMapForRawContactsEntities(qb, uri);
                selectionArgs = this.insertSelectionArg(selectionArgs, String.valueOf(rawContactId));
                qb.appendWhere((CharSequence)" AND _id=?");
                break;
            }
            case 16001: {
                return this.queryProviderStatus(uri, projection);
            }
            default: {
                return this.mLegacyApiSupport.query(uri, projection, selection, selectionArgs, sortOrder, limit);
            }
        }
        qb.setStrictProjectionMap(true);
        Cursor cursor = this.query(db, qb, projection, selection, selectionArgs, sortOrder, groupBy, limit);
        if (ContactsProvider2.readBooleanQueryParameter(uri, "address_book_index_extras", false)) {
            cursor = this.bundleLetterCountExtras(cursor, db, qb, selection, selectionArgs, sortOrder);
        }
        return cursor;
    }

    private Cursor query(SQLiteDatabase db, SQLiteQueryBuilder qb, String[] projection, String selection, String[] selectionArgs, String sortOrder, String groupBy, String limit) {
        Cursor c;
        if (projection != null && projection.length == 1 && "_count".equals(projection[0])) {
            qb.setProjectionMap(sCountProjectionMap);
        }
        if ((c = qb.query(db, projection, selection, selectionArgs, groupBy, null, sortOrder, limit)) != null) {
            c.setNotificationUri(this.getContext().getContentResolver(), ContactsContract.AUTHORITY_URI);
        }
        return c;
    }

    private Cursor queryProviderStatus(Uri uri, String[] projection) {
        MatrixCursor cursor = new MatrixCursor(projection);
        MatrixCursor.RowBuilder row = cursor.newRow();
        for (int i = 0; i < projection.length; ++i) {
            if ("status".equals(projection[i])) {
                row.add((Object)this.mProviderStatus);
                continue;
            }
            if (!"data1".equals(projection[i])) continue;
            row.add((Object)this.mEstimatedStorageRequirement);
        }
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cursor bundleLetterCountExtras(Cursor cursor, SQLiteDatabase db, SQLiteQueryBuilder qb, String selection, String[] selectionArgs, String sortOrder) {
        String sortKey;
        String sortOrderSuffix = "";
        if (sortOrder != null) {
            int spaceIndex = sortOrder.indexOf(32);
            if (spaceIndex != -1) {
                sortKey = sortOrder.substring(0, spaceIndex);
                sortOrderSuffix = sortOrder.substring(spaceIndex);
            } else {
                sortKey = sortOrder;
            }
        } else {
            sortKey = "sort_key";
        }
        String locale = this.getLocale().toString();
        HashMap projectionMap = Maps.newHashMap();
        projectionMap.put("letter", "SUBSTR(" + sortKey + ",1,1) AS " + "letter");
        projectionMap.put("title", "GET_PHONEBOOK_INDEX(SUBSTR(" + sortKey + ",1,1),'" + locale + "')" + " AS " + "title");
        projectionMap.put("count", "COUNT(_id) AS count");
        qb.setProjectionMap((Map)projectionMap);
        Cursor indexCursor = qb.query(db, AddressBookIndexQuery.COLUMNS, selection, selectionArgs, "letter COLLATE PHONEBOOK", null, "letter COLLATE PHONEBOOK" + sortOrderSuffix);
        try {
            int groupCount = indexCursor.getCount();
            String[] titles = new String[groupCount];
            int[] counts = new int[groupCount];
            int indexCount = 0;
            String currentTitle = null;
            for (int i = 0; i < groupCount; ++i) {
                indexCursor.moveToNext();
                String title = indexCursor.getString(1);
                int count = indexCursor.getInt(2);
                if (indexCount == 0 || !TextUtils.equals((CharSequence)title, currentTitle)) {
                    titles[indexCount] = currentTitle = title;
                    counts[indexCount] = count;
                    ++indexCount;
                    continue;
                }
                int n = indexCount - 1;
                counts[n] = counts[n] + count;
            }
            if (indexCount < groupCount) {
                String[] newTitles = new String[indexCount];
                System.arraycopy(titles, 0, newTitles, 0, indexCount);
                titles = newTitles;
                int[] newCounts = new int[indexCount];
                System.arraycopy(counts, 0, newCounts, 0, indexCount);
                counts = newCounts;
            }
            final Bundle bundle = new Bundle();
            bundle.putStringArray("address_book_index_titles", titles);
            bundle.putIntArray("address_book_index_counts", counts);
            CursorWrapper cursorWrapper = new CursorWrapper(cursor){

                public Bundle getExtras() {
                    return bundle;
                }
            };
            return cursorWrapper;
        }
        finally {
            indexCursor.close();
        }
    }

    public long lookupContactIdByLookupKey(SQLiteDatabase db, String lookupKey) {
        ContactLookupKey key = new ContactLookupKey();
        ArrayList<ContactLookupKey.LookupKeySegment> segments = key.parse(lookupKey);
        long contactId = -1L;
        if (this.lookupKeyContainsType(segments, 0) && (contactId = this.lookupContactIdBySourceIds(db, segments)) != -1L) {
            return contactId;
        }
        boolean hasRawContactIds = this.lookupKeyContainsType(segments, 2);
        if (hasRawContactIds && (contactId = this.lookupContactIdByRawContactIds(db, segments)) != -1L) {
            return contactId;
        }
        if (hasRawContactIds || this.lookupKeyContainsType(segments, 1)) {
            contactId = this.lookupContactIdByDisplayNames(db, segments);
        }
        return contactId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lookupContactIdBySourceIds(SQLiteDatabase db, ArrayList<ContactLookupKey.LookupKeySegment> segments) {
        StringBuilder sb = new StringBuilder();
        sb.append("sourceid IN (");
        for (int i = 0; i < segments.size(); ++i) {
            ContactLookupKey.LookupKeySegment segment = segments.get(i);
            if (segment.lookupType != 0) continue;
            DatabaseUtils.appendEscapedSQLString((StringBuilder)sb, (String)segment.key);
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append(") AND contact_id NOT NULL");
        Cursor c = db.query("raw_contacts", LookupBySourceIdQuery.COLUMNS, sb.toString(), null, null, null, null);
        try {
            block4: while (c.moveToNext()) {
                String accountType = c.getString(1);
                String accountName = c.getString(2);
                int accountHashCode = ContactLookupKey.getAccountHashCode(accountType, accountName);
                String sourceId = c.getString(3);
                for (int i = 0; i < segments.size(); ++i) {
                    ContactLookupKey.LookupKeySegment segment = segments.get(i);
                    if (segment.lookupType != 0 || accountHashCode != segment.accountHashCode || !segment.key.equals(sourceId)) continue;
                    segment.contactId = c.getLong(0);
                    continue block4;
                }
            }
        }
        finally {
            c.close();
        }
        return this.getMostReferencedContactId(segments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lookupContactIdByRawContactIds(SQLiteDatabase db, ArrayList<ContactLookupKey.LookupKeySegment> segments) {
        StringBuilder sb = new StringBuilder();
        sb.append("_id IN (");
        for (int i = 0; i < segments.size(); ++i) {
            ContactLookupKey.LookupKeySegment segment = segments.get(i);
            if (segment.lookupType != 2) continue;
            sb.append(segment.rawContactId);
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append(") AND contact_id NOT NULL");
        Cursor c = db.query("raw_contacts", LookupByRawContactIdQuery.COLUMNS, sb.toString(), null, null, null, null);
        try {
            block4: while (c.moveToNext()) {
                String accountType = c.getString(1);
                String accountName = c.getString(2);
                int accountHashCode = ContactLookupKey.getAccountHashCode(accountType, accountName);
                String rawContactId = c.getString(3);
                for (int i = 0; i < segments.size(); ++i) {
                    ContactLookupKey.LookupKeySegment segment = segments.get(i);
                    if (segment.lookupType != 2 || accountHashCode != segment.accountHashCode || !segment.rawContactId.equals(rawContactId)) continue;
                    segment.contactId = c.getLong(0);
                    continue block4;
                }
            }
        }
        finally {
            c.close();
        }
        return this.getMostReferencedContactId(segments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lookupContactIdByDisplayNames(SQLiteDatabase db, ArrayList<ContactLookupKey.LookupKeySegment> segments) {
        StringBuilder sb = new StringBuilder();
        sb.append("normalized_name IN (");
        for (int i = 0; i < segments.size(); ++i) {
            ContactLookupKey.LookupKeySegment segment = segments.get(i);
            if (segment.lookupType != 1 && segment.lookupType != 2) continue;
            DatabaseUtils.appendEscapedSQLString((StringBuilder)sb, (String)segment.key);
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append(") AND name_type=2 AND contact_id NOT NULL");
        Cursor c = db.query("name_lookup INNER JOIN raw_contacts ON (name_lookup.raw_contact_id = raw_contacts._id)", LookupByDisplayNameQuery.COLUMNS, sb.toString(), null, null, null, null);
        try {
            block4: while (c.moveToNext()) {
                String accountType = c.getString(1);
                String accountName = c.getString(2);
                int accountHashCode = ContactLookupKey.getAccountHashCode(accountType, accountName);
                String name = c.getString(3);
                for (int i = 0; i < segments.size(); ++i) {
                    ContactLookupKey.LookupKeySegment segment = segments.get(i);
                    if (segment.lookupType != 1 && segment.lookupType != 2 || accountHashCode != segment.accountHashCode || !segment.key.equals(name)) continue;
                    segment.contactId = c.getLong(0);
                    continue block4;
                }
            }
        }
        finally {
            c.close();
        }
        return this.getMostReferencedContactId(segments);
    }

    private boolean lookupKeyContainsType(ArrayList<ContactLookupKey.LookupKeySegment> segments, int lookupType) {
        for (int i = 0; i < segments.size(); ++i) {
            ContactLookupKey.LookupKeySegment segment = segments.get(i);
            if (segment.lookupType != lookupType) continue;
            return true;
        }
        return false;
    }

    public void updateLookupKeyForRawContact(SQLiteDatabase db, long rawContactId) {
        this.mContactAggregator.updateLookupKeyForRawContact(db, rawContactId);
    }

    private long getMostReferencedContactId(ArrayList<ContactLookupKey.LookupKeySegment> segments) {
        Collections.sort(segments);
        long bestContactId = -1L;
        int bestRefCount = 0;
        long contactId = -1L;
        int count = 0;
        int segmentCount = segments.size();
        for (int i = 0; i < segmentCount; ++i) {
            ContactLookupKey.LookupKeySegment segment = segments.get(i);
            if (segment.contactId == -1L) continue;
            if (segment.contactId == contactId) {
                ++count;
                continue;
            }
            if (count > bestRefCount) {
                bestContactId = contactId;
                bestRefCount = count;
            }
            contactId = segment.contactId;
            count = 1;
        }
        if (count > bestRefCount) {
            return contactId;
        }
        return bestContactId;
    }

    private void setTablesAndProjectionMapForContacts(SQLiteQueryBuilder qb, Uri uri, String[] projection) {
        StringBuilder sb = new StringBuilder();
        this.appendContactsTables(sb, uri, projection);
        qb.setTables(sb.toString());
        qb.setProjectionMap(sContactsProjectionMap);
    }

    private void setTablesAndProjectionMapForContactsWithSnippet(SQLiteQueryBuilder qb, Uri uri, String[] projection, String filter) {
        StringBuilder sb = new StringBuilder();
        this.appendContactsTables(sb, uri, projection);
        sb.append(" JOIN (SELECT contact_id AS snippet_contact_id");
        if (this.mDbHelper.isInProjection(projection, "snippet_data_id")) {
            sb.append(", data._id AS snippet_data_id");
        }
        if (this.mDbHelper.isInProjection(projection, "snippet_data1")) {
            sb.append(", data1 AS snippet_data1");
        }
        if (this.mDbHelper.isInProjection(projection, "snippet_data2")) {
            sb.append(", data2 AS snippet_data2");
        }
        if (this.mDbHelper.isInProjection(projection, "snippet_data3")) {
            sb.append(", data3 AS snippet_data3");
        }
        if (this.mDbHelper.isInProjection(projection, "snippet_data4")) {
            sb.append(", data4 AS snippet_data4");
        }
        if (this.mDbHelper.isInProjection(projection, "snippet_mimetype")) {
            sb.append(", (SELECT mimetype FROM mimetypes WHERE _id=mimetype_id) AS snippet_mimetype");
        }
        sb.append(" FROM data JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id) WHERE data._id IN (");
        sb.append("SELECT MIN(name_lookup.data_id) FROM name_lookup JOIN raw_contacts ON (raw_contacts._id=name_lookup.raw_contact_id) WHERE normalized_name GLOB '");
        sb.append(NameNormalizer.normalize(filter));
        sb.append("*' AND name_type IN(2,4,3,6,5,7) GROUP BY raw_contacts.contact_id");
        sb.append(")) ON (_id=snippet_contact_id)");
        qb.setTables(sb.toString());
        qb.setProjectionMap(sContactsProjectionWithSnippetMap);
    }

    private void appendContactsTables(StringBuilder sb, Uri uri, String[] projection) {
        boolean excludeRestrictedData = false;
        String requestingPackage = ContactsProvider2.getQueryParameter(uri, "requesting_package");
        if (requestingPackage != null) {
            excludeRestrictedData = !this.mDbHelper.hasAccessToRestrictedData(requestingPackage);
        }
        sb.append(this.mDbHelper.getContactView(excludeRestrictedData));
        if (this.mDbHelper.isInProjection(projection, "contact_presence")) {
            sb.append(" LEFT OUTER JOIN agg_presence ON (_id = presence_contact_id)");
        }
        if (this.mDbHelper.isInProjection(projection, "contact_status", "contact_status_res_package", "contact_status_icon", "contact_status_label", "contact_status_ts")) {
            sb.append(" LEFT OUTER JOIN status_updates contacts_status_updates ON (status_update_id=contacts_status_updates.status_update_data_id)");
        }
    }

    private void setTablesAndProjectionMapForRawContacts(SQLiteQueryBuilder qb, Uri uri) {
        StringBuilder sb = new StringBuilder();
        boolean excludeRestrictedData = false;
        String requestingPackage = ContactsProvider2.getQueryParameter(uri, "requesting_package");
        if (requestingPackage != null) {
            excludeRestrictedData = !this.mDbHelper.hasAccessToRestrictedData(requestingPackage);
        }
        sb.append(this.mDbHelper.getRawContactView(excludeRestrictedData));
        qb.setTables(sb.toString());
        qb.setProjectionMap(sRawContactsProjectionMap);
        this.appendAccountFromParameter(qb, uri);
    }

    private void setTablesAndProjectionMapForRawContactsEntities(SQLiteQueryBuilder qb, Uri uri) {
        boolean excludeRestrictedData = ContactsProvider2.readBooleanQueryParameter(uri, "for_export_only", false);
        String requestingPackage = ContactsProvider2.getQueryParameter(uri, "requesting_package");
        if (requestingPackage != null) {
            excludeRestrictedData = excludeRestrictedData || !this.mDbHelper.hasAccessToRestrictedData(requestingPackage);
        }
        qb.setTables(this.mDbHelper.getContactEntitiesView(excludeRestrictedData));
        qb.setProjectionMap(sRawContactsEntityProjectionMap);
        this.appendAccountFromParameter(qb, uri);
    }

    private void setTablesAndProjectionMapForData(SQLiteQueryBuilder qb, Uri uri, String[] projection, boolean distinct) {
        StringBuilder sb = new StringBuilder();
        boolean excludeRestrictedData = ContactsProvider2.readBooleanQueryParameter(uri, "for_export_only", false);
        String requestingPackage = ContactsProvider2.getQueryParameter(uri, "requesting_package");
        if (requestingPackage != null) {
            excludeRestrictedData = excludeRestrictedData || !this.mDbHelper.hasAccessToRestrictedData(requestingPackage);
        }
        sb.append(this.mDbHelper.getDataView(excludeRestrictedData));
        sb.append(" data");
        if (this.mDbHelper.isInProjection(projection, "contact_presence")) {
            sb.append(" LEFT OUTER JOIN agg_presence ON (agg_presence.presence_contact_id=contact_id)");
        }
        if (this.mDbHelper.isInProjection(projection, "contact_status", "contact_status_res_package", "contact_status_icon", "contact_status_label", "contact_status_ts")) {
            sb.append(" LEFT OUTER JOIN status_updates contacts_status_updates ON (status_update_id=contacts_status_updates.status_update_data_id)");
        }
        if (this.mDbHelper.isInProjection(projection, "mode")) {
            sb.append(" LEFT OUTER JOIN presence ON (presence_data_id=data._id)");
        }
        if (this.mDbHelper.isInProjection(projection, "status", "status_res_package", "status_icon", "status_label", "status_ts")) {
            sb.append(" LEFT OUTER JOIN status_updates ON (status_updates.status_update_data_id=data._id)");
        }
        qb.setTables(sb.toString());
        qb.setProjectionMap(distinct ? sDistinctDataProjectionMap : sDataProjectionMap);
        this.appendAccountFromParameter(qb, uri);
    }

    private void setTableAndProjectionMapForStatusUpdates(SQLiteQueryBuilder qb, String[] projection) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mDbHelper.getDataView());
        sb.append(" data");
        if (this.mDbHelper.isInProjection(projection, "mode")) {
            sb.append(" LEFT OUTER JOIN presence ON(presence.presence_data_id=data._id)");
        }
        if (this.mDbHelper.isInProjection(projection, "status", "status_res_package", "status_icon", "status_label", "status_ts")) {
            sb.append(" LEFT OUTER JOIN status_updates ON(status_updates.status_update_data_id=data._id)");
        }
        qb.setTables(sb.toString());
        qb.setProjectionMap(sStatusUpdatesProjectionMap);
    }

    private void appendAccountFromParameter(SQLiteQueryBuilder qb, Uri uri) {
        boolean validAccount;
        String accountName = ContactsProvider2.getQueryParameter(uri, "account_name");
        String accountType = ContactsProvider2.getQueryParameter(uri, "account_type");
        boolean partialUri = TextUtils.isEmpty((CharSequence)accountName) ^ TextUtils.isEmpty((CharSequence)accountType);
        if (partialUri) {
            throw new IllegalArgumentException(this.mDbHelper.exceptionMessage("Must specify both or neither of ACCOUNT_NAME and ACCOUNT_TYPE", uri));
        }
        boolean bl = validAccount = !TextUtils.isEmpty((CharSequence)accountName);
        if (validAccount) {
            qb.appendWhere((CharSequence)("account_name=" + DatabaseUtils.sqlEscapeString((String)accountName) + " AND " + "account_type" + "=" + DatabaseUtils.sqlEscapeString((String)accountType)));
        } else {
            qb.appendWhere((CharSequence)"1");
        }
    }

    private String appendAccountToSelection(Uri uri, String selection) {
        boolean validAccount;
        String accountName = ContactsProvider2.getQueryParameter(uri, "account_name");
        String accountType = ContactsProvider2.getQueryParameter(uri, "account_type");
        boolean partialUri = TextUtils.isEmpty((CharSequence)accountName) ^ TextUtils.isEmpty((CharSequence)accountType);
        if (partialUri) {
            throw new IllegalArgumentException(this.mDbHelper.exceptionMessage("Must specify both or neither of ACCOUNT_NAME and ACCOUNT_TYPE", uri));
        }
        boolean bl = validAccount = !TextUtils.isEmpty((CharSequence)accountName);
        if (validAccount) {
            StringBuilder selectionSb = new StringBuilder("account_name=" + DatabaseUtils.sqlEscapeString((String)accountName) + " AND " + "account_type" + "=" + DatabaseUtils.sqlEscapeString((String)accountType));
            if (!TextUtils.isEmpty((CharSequence)selection)) {
                selectionSb.append(" AND (");
                selectionSb.append(selection);
                selectionSb.append(')');
            }
            return selectionSb.toString();
        }
        return selection;
    }

    private String getLimit(Uri uri) {
        String limitParam = ContactsProvider2.getQueryParameter(uri, "limit");
        if (limitParam == null) {
            return null;
        }
        try {
            int l = Integer.parseInt(limitParam);
            if (l < 0) {
                Log.w((String)TAG, (String)("Invalid limit parameter: " + limitParam));
                return null;
            }
            return String.valueOf(l);
        }
        catch (NumberFormatException ex) {
            Log.w((String)TAG, (String)("Invalid limit parameter: " + limitParam));
            return null;
        }
    }

    private boolean isPhoneNumber(CharSequence cons) {
        int len = cons.length();
        for (int i = 0; i < len; ++i) {
            char c = cons.charAt(i);
            if (c >= '0' && c <= '9' || c == ' ' || c == '-' || c == '(' || c == ')' || c == '.' || c == '+' || c == '#' || c == '*' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
            return false;
        }
        return true;
    }

    String getContactsRestrictions() {
        if (this.mDbHelper.hasAccessToRestrictedData()) {
            return "1";
        }
        return "raw_contacts.is_restricted=0";
    }

    public String getContactsRestrictionExceptionAsNestedQuery(String contactIdColumn) {
        if (this.mDbHelper.hasAccessToRestrictedData()) {
            return "1";
        }
        return "(SELECT is_restricted FROM raw_contacts WHERE raw_contacts._id=" + contactIdColumn + ")=0";
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String mode) throws FileNotFoundException {
        int match = sUriMatcher.match(uri);
        switch (match) {
            case 1009: {
                return this.openPhotoAssetFile(uri, mode, "_id=photo_id AND contact_id=?", new String[]{(String)uri.getPathSegments().get(1)});
            }
            case 3001: {
                return this.openPhotoAssetFile(uri, mode, "_id=? AND mimetype='vnd.android.cursor.item/photo'", new String[]{(String)uri.getPathSegments().get(1)});
            }
            case 1010: {
                String lookupKey = Uri.encode((String)((String)uri.getPathSegments().get(2)));
                this.mSelectionArgs1[0] = String.valueOf(this.lookupContactIdByLookupKey(this.mDb, lookupKey));
                String selection = "_id=?";
                ByteArrayOutputStream localStream = new ByteArrayOutputStream();
                this.outputRawContactsAsVCard(localStream, "_id=?", this.mSelectionArgs1);
                return this.buildAssetFileDescriptor(localStream);
            }
            case 1011: {
                String lookupKeys = (String)uri.getPathSegments().get(2);
                String[] loopupKeyList = lookupKeys.split(":");
                StringBuilder inBuilder = new StringBuilder();
                int index = 0;
                for (String lookupKey : loopupKeyList) {
                    if (index == 0) {
                        inBuilder.append("(");
                    } else {
                        inBuilder.append(",");
                    }
                    inBuilder.append(this.lookupContactIdByLookupKey(this.mDb, lookupKey));
                    ++index;
                }
                inBuilder.append(')');
                String selection = "_id IN " + inBuilder.toString();
                ByteArrayOutputStream localStream = new ByteArrayOutputStream();
                this.outputRawContactsAsVCard(localStream, selection, null);
                return this.buildAssetFileDescriptor(localStream);
            }
        }
        throw new FileNotFoundException(this.mDbHelper.exceptionMessage("File does not exist", uri));
    }

    private AssetFileDescriptor openPhotoAssetFile(Uri uri, String mode, String selection, String[] selectionArgs) throws FileNotFoundException {
        if (!"r".equals(mode)) {
            throw new FileNotFoundException(this.mDbHelper.exceptionMessage("Mode " + mode + " not supported.", uri));
        }
        String sql = "SELECT data15 FROM " + this.mDbHelper.getDataView() + " WHERE " + selection;
        SQLiteDatabase db = this.mDbHelper.getReadableDatabase();
        return SQLiteContentHelper.getBlobColumnAsAssetFile((SQLiteDatabase)db, (String)sql, (String[])selectionArgs);
    }

    private AssetFileDescriptor buildAssetFileDescriptor(ByteArrayOutputStream stream) {
        AssetFileDescriptor fd = null;
        try {
            stream.flush();
            byte[] byteData = stream.toByteArray();
            int size = byteData.length;
            MemoryFile memoryFile = new MemoryFile(CONTACT_MEMORY_FILE_NAME, size);
            memoryFile.writeBytes(byteData, 0, 0, size);
            memoryFile.deactivate();
            fd = AssetFileDescriptor.fromMemoryFile((MemoryFile)memoryFile);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)("Problem writing stream into an AssetFileDescriptor: " + e.toString()));
        }
        return fd;
    }

    private void outputRawContactsAsVCard(OutputStream stream, String selection, String[] selectionArgs) {
        VCardComposer composer;
        Context context = this.getContext();
        VCardComposer vCardComposer = composer = new VCardComposer(context, VCardConfig.VCARD_TYPE_DEFAULT, false);
        vCardComposer.getClass();
        composer.addHandler((VCardComposer.OneEntryHandler)new VCardComposer.HandlerForOutputStream(vCardComposer, stream));
        if (!composer.init(selection, selectionArgs)) {
            Log.w((String)TAG, (String)"Failed to init VCardComposer");
            return;
        }
        while (!composer.isAfterLast()) {
            if (composer.createOneEntry()) continue;
            Log.w((String)TAG, (String)"Failed to output a contact.");
        }
        composer.terminate();
    }

    public String getType(Uri uri) {
        int match = sUriMatcher.match(uri);
        switch (match) {
            case 1000: {
                return "vnd.android.cursor.dir/contact";
            }
            case 1001: 
            case 1002: 
            case 1003: {
                return "vnd.android.cursor.item/contact";
            }
            case 1010: 
            case 1011: {
                return "text/x-vcard";
            }
            case 2002: {
                return "vnd.android.cursor.dir/raw_contact";
            }
            case 2003: {
                return "vnd.android.cursor.item/raw_contact";
            }
            case 3000: {
                return "vnd.android.cursor.dir/data";
            }
            case 3001: {
                return this.mDbHelper.getDataMimeType(ContentUris.parseId((Uri)uri));
            }
            case 3002: {
                return "vnd.android.cursor.dir/phone_v2";
            }
            case 3003: {
                return "vnd.android.cursor.item/phone_v2";
            }
            case 4000: {
                return "vnd.android.cursor.dir/phone_lookup";
            }
            case 3005: {
                return "vnd.android.cursor.dir/email_v2";
            }
            case 3006: {
                return "vnd.android.cursor.item/email_v2";
            }
            case 3009: {
                return "vnd.android.cursor.dir/postal-address_v2";
            }
            case 3010: {
                return "vnd.android.cursor.item/postal-address_v2";
            }
            case 6000: {
                return "vnd.android.cursor.dir/aggregation_exception";
            }
            case 6001: {
                return "vnd.android.cursor.item/aggregation_exception";
            }
            case 9000: {
                return "vnd.android.cursor.dir/setting";
            }
            case 8000: {
                return "vnd.android.cursor.dir/contact";
            }
            case 12001: {
                return "vnd.android.cursor.dir/vnd.android.search.suggest";
            }
            case 12002: {
                return "vnd.android.cursor.item/vnd.android.search.suggest";
            }
        }
        return this.mLegacyApiSupport.getType(uri);
    }

    private void setDisplayName(long rawContactId, int displayNameSource, String displayNamePrimary, String displayNameAlternative, String phoneticName, int phoneticNameStyle, String sortKeyPrimary, String sortKeyAlternative) {
        this.mRawContactDisplayNameUpdate.bindLong(1, (long)displayNameSource);
        this.bindString(this.mRawContactDisplayNameUpdate, 2, displayNamePrimary);
        this.bindString(this.mRawContactDisplayNameUpdate, 3, displayNameAlternative);
        this.bindString(this.mRawContactDisplayNameUpdate, 4, phoneticName);
        this.mRawContactDisplayNameUpdate.bindLong(5, (long)phoneticNameStyle);
        this.bindString(this.mRawContactDisplayNameUpdate, 6, sortKeyPrimary);
        this.bindString(this.mRawContactDisplayNameUpdate, 7, sortKeyAlternative);
        this.mRawContactDisplayNameUpdate.bindLong(8, rawContactId);
        this.mRawContactDisplayNameUpdate.execute();
    }

    private void setRawContactDirty(long rawContactId) {
        this.mDirtyRawContacts.add(rawContactId);
    }

    private void setIsPrimary(long rawContactId, long dataId, long mimeTypeId) {
        this.mSetPrimaryStatement.bindLong(1, dataId);
        this.mSetPrimaryStatement.bindLong(2, mimeTypeId);
        this.mSetPrimaryStatement.bindLong(3, rawContactId);
        this.mSetPrimaryStatement.execute();
    }

    private void setIsSuperPrimary(long rawContactId, long dataId, long mimeTypeId) {
        this.mSetSuperPrimaryStatement.bindLong(1, dataId);
        this.mSetSuperPrimaryStatement.bindLong(2, mimeTypeId);
        this.mSetSuperPrimaryStatement.bindLong(3, rawContactId);
        this.mSetSuperPrimaryStatement.execute();
    }

    public String insertNameLookupForEmail(long rawContactId, long dataId, String email) {
        if (TextUtils.isEmpty((CharSequence)email)) {
            return null;
        }
        String address = this.mDbHelper.extractHandleFromEmailAddress(email);
        if (address == null) {
            return null;
        }
        this.insertNameLookup(rawContactId, dataId, 4, NameNormalizer.normalize(address));
        return address;
    }

    public void insertNameLookupForNickname(long rawContactId, long dataId, String nickname) {
        if (TextUtils.isEmpty((CharSequence)nickname)) {
            return;
        }
        this.insertNameLookup(rawContactId, dataId, 3, NameNormalizer.normalize(nickname));
    }

    public void insertNameLookupForOrganization(long rawContactId, long dataId, String company, String title) {
        if (!TextUtils.isEmpty((CharSequence)company)) {
            this.insertNameLookup(rawContactId, dataId, 5, NameNormalizer.normalize(company));
        }
        if (!TextUtils.isEmpty((CharSequence)title)) {
            this.insertNameLookup(rawContactId, dataId, 5, NameNormalizer.normalize(title));
        }
    }

    public void insertNameLookupForStructuredName(long rawContactId, long dataId, String name, int fullNameStyle) {
        this.mNameLookupBuilder.insertNameLookup(rawContactId, dataId, name, fullNameStyle);
    }

    public void insertNameLookupForPhoneticName(long rawContactId, long dataId, ContentValues values) {
        if (values.containsKey("data9") || values.containsKey("data7") || values.containsKey("data8")) {
            this.insertNameLookupForPhoneticName(rawContactId, dataId, values.getAsString("data9"), values.getAsString("data8"), values.getAsString("data7"));
        }
    }

    public void insertNameLookupForPhoneticName(long rawContactId, long dataId, String familyName, String middleName, String givenName) {
        this.mSb.setLength(0);
        if (familyName != null) {
            this.mSb.append(familyName.trim());
        }
        if (middleName != null) {
            this.mSb.append(middleName.trim());
        }
        if (givenName != null) {
            this.mSb.append(givenName.trim());
        }
        if (this.mSb.length() > 0) {
            this.insertNameLookup(rawContactId, dataId, 2, NameNormalizer.normalize(this.mSb.toString()));
        }
        if (givenName != null) {
            this.insertNameLookup(rawContactId, dataId, 6, NameNormalizer.normalize(givenName.trim()));
        }
    }

    public void insertNameLookup(long rawContactId, long dataId, int lookupType, String name) {
        this.mNameLookupInsert.bindLong(1, rawContactId);
        this.mNameLookupInsert.bindLong(2, dataId);
        this.mNameLookupInsert.bindLong(3, (long)lookupType);
        this.bindString(this.mNameLookupInsert, 4, name);
        this.mNameLookupInsert.executeInsert();
    }

    public void deleteNameLookup(long dataId) {
        this.mNameLookupDelete.bindLong(1, dataId);
        this.mNameLookupDelete.execute();
    }

    public void appendContactFilterAsNestedQuery(StringBuilder sb, String filterParam) {
        sb.append("(SELECT DISTINCT contact_id FROM raw_contacts JOIN name_lookup ON(raw_contacts._id=raw_contact_id) WHERE normalized_name GLOB '");
        sb.append(NameNormalizer.normalize(filterParam));
        sb.append("*' AND name_type IN(2,4,3,6,5,7))");
    }

    public String getRawContactsByFilterAsNestedQuery(String filterParam) {
        StringBuilder sb = new StringBuilder();
        this.appendRawContactsByFilterAsNestedQuery(sb, filterParam);
        return sb.toString();
    }

    public void appendRawContactsByFilterAsNestedQuery(StringBuilder sb, String filterParam) {
        this.appendRawContactsByNormalizedNameFilter(sb, NameNormalizer.normalize(filterParam), true);
    }

    private void appendRawContactsByNormalizedNameFilter(StringBuilder sb, String normalizedName, boolean allowEmailMatch) {
        sb.append("(SELECT raw_contact_id FROM name_lookup WHERE normalized_name GLOB '");
        sb.append(normalizedName);
        sb.append("*' AND name_type IN (2,3,6,5,7");
        if (allowEmailMatch) {
            sb.append(",4");
        }
        sb.append("))");
    }

    private String[] insertSelectionArg(String[] selectionArgs, String arg) {
        if (selectionArgs == null) {
            return new String[]{arg};
        }
        int newLength = selectionArgs.length + 1;
        String[] newSelectionArgs = new String[newLength];
        newSelectionArgs[0] = arg;
        System.arraycopy(selectionArgs, 0, newSelectionArgs, 1, selectionArgs.length);
        return newSelectionArgs;
    }

    private String[] appendProjectionArg(String[] projection, String arg) {
        if (projection == null) {
            return null;
        }
        int length = projection.length;
        String[] newProjection = new String[length + 1];
        System.arraycopy(projection, 0, newProjection, 0, length);
        newProjection[length] = arg;
        return newProjection;
    }

    protected Account getDefaultAccount() {
        AccountManager accountManager = AccountManager.get((Context)this.getContext());
        try {
            Account[] accounts = (Account[])accountManager.getAccountsByTypeAndFeatures(DEFAULT_ACCOUNT_TYPE, new String[]{FEATURE_LEGACY_HOSTED_OR_GOOGLE}, null, null).getResult();
            if (accounts != null && accounts.length > 0) {
                return accounts[0];
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"Cannot determine the default account for contacts compatibility", (Throwable)e);
        }
        return null;
    }

    protected boolean isWritableAccount(String accountType) {
        if (accountType == null) {
            return true;
        }
        Boolean writable = this.mAccountWritability.get(accountType);
        if (writable != null) {
            return writable;
        }
        IContentService contentService = ContentResolver.getContentService();
        try {
            for (SyncAdapterType sync : contentService.getSyncAdapterTypes()) {
                if (!"com.android.contacts".equals(sync.authority) || !accountType.equals(sync.accountType)) continue;
                writable = sync.supportsUploading();
                break;
            }
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Could not acquire sync adapter types");
        }
        if (writable == null) {
            writable = false;
        }
        this.mAccountWritability.put(accountType, writable);
        return writable;
    }

    static boolean readBooleanQueryParameter(Uri uri, String parameter, boolean defaultValue) {
        String query = uri.getEncodedQuery();
        if (query == null) {
            return defaultValue;
        }
        int index = query.indexOf(parameter);
        if (index == -1) {
            return defaultValue;
        }
        return !ContactsProvider2.matchQueryParameter(query, index += parameter.length(), "=0", false) && !ContactsProvider2.matchQueryParameter(query, index, "=false", true);
    }

    private static boolean matchQueryParameter(String query, int index, String value, boolean ignoreCase) {
        int length = value.length();
        return query.regionMatches(ignoreCase, index, value, 0, length) && (query.length() == index + length || query.charAt(index + length) == '&');
    }

    static String getQueryParameter(Uri uri, String parameter) {
        int ampIndex;
        String query = uri.getEncodedQuery();
        if (query == null) {
            return null;
        }
        int queryLength = query.length();
        int parameterLength = parameter.length();
        int index = 0;
        do {
            if ((index = query.indexOf(parameter, index)) == -1) {
                return null;
            }
            if (queryLength != (index += parameterLength)) continue;
            return null;
        } while (query.charAt(index) != '=');
        String value = (ampIndex = query.indexOf(38, ++index)) == -1 ? query.substring(index) : query.substring(index, ampIndex);
        return Uri.decode((String)value);
    }

    private void bindString(SQLiteStatement stmt, int index, String value) {
        if (value == null) {
            stmt.bindNull(index);
        } else {
            stmt.bindString(index, value);
        }
    }

    private void bindLong(SQLiteStatement stmt, int index, Number value) {
        if (value == null) {
            stmt.bindNull(index);
        } else {
            stmt.bindLong(index, value.longValue());
        }
    }

    protected boolean isAggregationUpgradeNeeded() {
        if (!this.mContactAggregator.isEnabled()) {
            return false;
        }
        int version = Integer.parseInt(this.mDbHelper.getProperty(PROPERTY_AGGREGATION_ALGORITHM, "2"));
        return version < 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upgradeAggregationAlgorithm() {
        Log.i((String)TAG, (String)"Upgrading aggregation algorithm");
        int count = 0;
        long start = SystemClock.currentThreadTimeMillis();
        try {
            this.mDb.beginTransaction();
            Cursor cursor = this.mDb.query(true, "raw_contacts r1 JOIN raw_contacts r2", new String[]{"r1._id"}, "r1._id!=r2._id AND r1.contact_id=r2.contact_id AND r1.account_name=r2.account_name AND r1.account_type=r2.account_type", null, null, null, null, null);
            try {
                while (cursor.moveToNext()) {
                    long rawContactId = cursor.getLong(0);
                    this.mContactAggregator.markForAggregation(rawContactId, 0, true);
                    ++count;
                }
            }
            finally {
                cursor.close();
            }
            this.mContactAggregator.aggregateInTransaction(this.mDb);
            this.mDb.setTransactionSuccessful();
            this.mDbHelper.setProperty(PROPERTY_AGGREGATION_ALGORITHM, String.valueOf(2));
        }
        finally {
            this.mDb.endTransaction();
            long end = SystemClock.currentThreadTimeMillis();
            Log.i((String)TAG, (String)("Aggregation algorithm upgraded for " + count + " contacts, in " + (end - start) + "ms"));
        }
    }

    static {
        EMPTY_STRING_ARRAY = new String[0];
        UriMatcher matcher = sUriMatcher;
        matcher.addURI("com.android.contacts", "contacts", 1000);
        matcher.addURI("com.android.contacts", "contacts/#", 1001);
        matcher.addURI("com.android.contacts", "contacts/#/data", 1004);
        matcher.addURI("com.android.contacts", "contacts/#/suggestions", 8000);
        matcher.addURI("com.android.contacts", "contacts/#/suggestions/*", 8000);
        matcher.addURI("com.android.contacts", "contacts/#/photo", 1009);
        matcher.addURI("com.android.contacts", "contacts/filter/*", 1005);
        matcher.addURI("com.android.contacts", "contacts/lookup/*", 1002);
        matcher.addURI("com.android.contacts", "contacts/lookup/*/#", 1003);
        matcher.addURI("com.android.contacts", "contacts/as_vcard/*", 1010);
        matcher.addURI("com.android.contacts", "contacts/as_multi_vcard/*", 1011);
        matcher.addURI("com.android.contacts", "contacts/strequent/", 1006);
        matcher.addURI("com.android.contacts", "contacts/strequent/filter/*", 1007);
        matcher.addURI("com.android.contacts", "contacts/group/*", 1008);
        matcher.addURI("com.android.contacts", "raw_contacts", 2002);
        matcher.addURI("com.android.contacts", "raw_contacts/#", 2003);
        matcher.addURI("com.android.contacts", "raw_contacts/#/data", 2004);
        matcher.addURI("com.android.contacts", "raw_contacts/#/entity", 2005);
        matcher.addURI("com.android.contacts", "raw_contact_entities", 15001);
        matcher.addURI("com.android.contacts", "data", 3000);
        matcher.addURI("com.android.contacts", "data/#", 3001);
        matcher.addURI("com.android.contacts", "data/phones", 3002);
        matcher.addURI("com.android.contacts", "data/phones/#", 3003);
        matcher.addURI("com.android.contacts", "data/phones/filter", 3004);
        matcher.addURI("com.android.contacts", "data/phones/filter/*", 3004);
        matcher.addURI("com.android.contacts", "data/emails", 3005);
        matcher.addURI("com.android.contacts", "data/emails/#", 3006);
        matcher.addURI("com.android.contacts", "data/emails/lookup/*", 3007);
        matcher.addURI("com.android.contacts", "data/emails/filter", 3008);
        matcher.addURI("com.android.contacts", "data/emails/filter/*", 3008);
        matcher.addURI("com.android.contacts", "data/postals", 3009);
        matcher.addURI("com.android.contacts", "data/postals/#", 3010);
        matcher.addURI("com.android.contacts", "groups", 10000);
        matcher.addURI("com.android.contacts", "groups/#", 10001);
        matcher.addURI("com.android.contacts", "groups_summary", 10003);
        matcher.addURI("com.android.contacts", "syncstate", 11000);
        matcher.addURI("com.android.contacts", "syncstate/#", 11001);
        matcher.addURI("com.android.contacts", "phone_lookup/*", 4000);
        matcher.addURI("com.android.contacts", "aggregation_exceptions", 6000);
        matcher.addURI("com.android.contacts", "aggregation_exceptions/*", 6001);
        matcher.addURI("com.android.contacts", "settings", 9000);
        matcher.addURI("com.android.contacts", "status_updates", 7000);
        matcher.addURI("com.android.contacts", "status_updates/#", 7001);
        matcher.addURI("com.android.contacts", "search_suggest_query", 12001);
        matcher.addURI("com.android.contacts", "search_suggest_query/*", 12001);
        matcher.addURI("com.android.contacts", "search_suggest_shortcut/*", 12002);
        matcher.addURI("com.android.contacts", "live_folders/contacts", 14000);
        matcher.addURI("com.android.contacts", "live_folders/contacts/*", 14003);
        matcher.addURI("com.android.contacts", "live_folders/contacts_with_phones", 14001);
        matcher.addURI("com.android.contacts", "live_folders/favorites", 14002);
        matcher.addURI("com.android.contacts", "provider_status", 16001);
        sCountProjectionMap = new HashMap();
        sCountProjectionMap.put("_count", "COUNT(*)");
        sContactsProjectionMap = new HashMap();
        sContactsProjectionMap.put("_id", "_id");
        sContactsProjectionMap.put("display_name", "display_name");
        sContactsProjectionMap.put("display_name_alt", "display_name_alt");
        sContactsProjectionMap.put("display_name_source", "display_name_source");
        sContactsProjectionMap.put("phonetic_name", "phonetic_name");
        sContactsProjectionMap.put("phonetic_name_style", "phonetic_name_style");
        sContactsProjectionMap.put("sort_key", "sort_key");
        sContactsProjectionMap.put("sort_key_alt", "sort_key_alt");
        sContactsProjectionMap.put("last_time_contacted", "last_time_contacted");
        sContactsProjectionMap.put("times_contacted", "times_contacted");
        sContactsProjectionMap.put("starred", "starred");
        sContactsProjectionMap.put("in_visible_group", "in_visible_group");
        sContactsProjectionMap.put("photo_id", "photo_id");
        sContactsProjectionMap.put("custom_ringtone", "custom_ringtone");
        sContactsProjectionMap.put("has_phone_number", "has_phone_number");
        sContactsProjectionMap.put("send_to_voicemail", "send_to_voicemail");
        sContactsProjectionMap.put("lookup", "lookup");
        ContactsProvider2.addProjection(sContactsProjectionMap, "contact_presence", "agg_presence.mode");
        ContactsProvider2.addProjection(sContactsProjectionMap, "contact_chat_capability", "agg_presence.chat_capability");
        ContactsProvider2.addProjection(sContactsProjectionMap, "contact_status", "contacts_status_updates.status");
        ContactsProvider2.addProjection(sContactsProjectionMap, "contact_status_ts", "contacts_status_updates.status_ts");
        ContactsProvider2.addProjection(sContactsProjectionMap, "contact_status_res_package", "contacts_status_updates.status_res_package");
        ContactsProvider2.addProjection(sContactsProjectionMap, "contact_status_label", "contacts_status_updates.status_label");
        ContactsProvider2.addProjection(sContactsProjectionMap, "contact_status_icon", "contacts_status_updates.status_icon");
        sContactsProjectionWithSnippetMap = new HashMap();
        sContactsProjectionWithSnippetMap.putAll(sContactsProjectionMap);
        sContactsProjectionWithSnippetMap.put("snippet_mimetype", "snippet_mimetype");
        sContactsProjectionWithSnippetMap.put("snippet_data_id", "snippet_data_id");
        sContactsProjectionWithSnippetMap.put("snippet_data1", "snippet_data1");
        sContactsProjectionWithSnippetMap.put("snippet_data2", "snippet_data2");
        sContactsProjectionWithSnippetMap.put("snippet_data3", "snippet_data3");
        sContactsProjectionWithSnippetMap.put("snippet_data4", "snippet_data4");
        sStrequentStarredProjectionMap = new HashMap<String, String>(sContactsProjectionMap);
        sStrequentStarredProjectionMap.put(TIMES_CONTACED_SORT_COLUMN, "9223372036854775807 AS times_contacted_sort");
        sStrequentFrequentProjectionMap = new HashMap<String, String>(sContactsProjectionMap);
        sStrequentFrequentProjectionMap.put(TIMES_CONTACED_SORT_COLUMN, "times_contacted AS times_contacted_sort");
        sContactsVCardProjectionMap = Maps.newHashMap();
        sContactsVCardProjectionMap.put("_display_name", "display_name || '.vcf' AS _display_name");
        sContactsVCardProjectionMap.put("_size", "NULL AS _size");
        sRawContactsProjectionMap = new HashMap();
        sRawContactsProjectionMap.put("_id", "_id");
        sRawContactsProjectionMap.put("contact_id", "contact_id");
        sRawContactsProjectionMap.put("account_name", "account_name");
        sRawContactsProjectionMap.put("account_type", "account_type");
        sRawContactsProjectionMap.put("sourceid", "sourceid");
        sRawContactsProjectionMap.put("version", "version");
        sRawContactsProjectionMap.put("dirty", "dirty");
        sRawContactsProjectionMap.put("deleted", "deleted");
        sRawContactsProjectionMap.put("display_name", "display_name");
        sRawContactsProjectionMap.put("display_name_alt", "display_name_alt");
        sRawContactsProjectionMap.put("display_name_source", "display_name_source");
        sRawContactsProjectionMap.put("phonetic_name", "phonetic_name");
        sRawContactsProjectionMap.put("phonetic_name_style", "phonetic_name_style");
        sRawContactsProjectionMap.put("name_verified", "name_verified");
        sRawContactsProjectionMap.put("sort_key", "sort_key");
        sRawContactsProjectionMap.put("sort_key_alt", "sort_key_alt");
        sRawContactsProjectionMap.put("times_contacted", "times_contacted");
        sRawContactsProjectionMap.put("last_time_contacted", "last_time_contacted");
        sRawContactsProjectionMap.put("custom_ringtone", "custom_ringtone");
        sRawContactsProjectionMap.put("send_to_voicemail", "send_to_voicemail");
        sRawContactsProjectionMap.put("starred", "starred");
        sRawContactsProjectionMap.put("aggregation_mode", "aggregation_mode");
        sRawContactsProjectionMap.put("sync1", "sync1");
        sRawContactsProjectionMap.put("sync2", "sync2");
        sRawContactsProjectionMap.put("sync3", "sync3");
        sRawContactsProjectionMap.put("sync4", "sync4");
        sDataProjectionMap = new HashMap();
        sDataProjectionMap.put("_id", "_id");
        sDataProjectionMap.put("raw_contact_id", "raw_contact_id");
        sDataProjectionMap.put("data_version", "data_version");
        sDataProjectionMap.put("is_primary", "is_primary");
        sDataProjectionMap.put("is_super_primary", "is_super_primary");
        sDataProjectionMap.put("res_package", "res_package");
        sDataProjectionMap.put("mimetype", "mimetype");
        sDataProjectionMap.put("data1", "data1");
        sDataProjectionMap.put("data2", "data2");
        sDataProjectionMap.put("data3", "data3");
        sDataProjectionMap.put("data4", "data4");
        sDataProjectionMap.put("data5", "data5");
        sDataProjectionMap.put("data6", "data6");
        sDataProjectionMap.put("data7", "data7");
        sDataProjectionMap.put("data8", "data8");
        sDataProjectionMap.put("data9", "data9");
        sDataProjectionMap.put("data10", "data10");
        sDataProjectionMap.put("data11", "data11");
        sDataProjectionMap.put("data12", "data12");
        sDataProjectionMap.put("data13", "data13");
        sDataProjectionMap.put("data14", "data14");
        sDataProjectionMap.put("data15", "data15");
        sDataProjectionMap.put("data_sync1", "data_sync1");
        sDataProjectionMap.put("data_sync2", "data_sync2");
        sDataProjectionMap.put("data_sync3", "data_sync3");
        sDataProjectionMap.put("data_sync4", "data_sync4");
        sDataProjectionMap.put("contact_id", "contact_id");
        sDataProjectionMap.put("account_name", "account_name");
        sDataProjectionMap.put("account_type", "account_type");
        sDataProjectionMap.put("sourceid", "sourceid");
        sDataProjectionMap.put("version", "version");
        sDataProjectionMap.put("dirty", "dirty");
        sDataProjectionMap.put("name_verified", "name_verified");
        sDataProjectionMap.put("lookup", "lookup");
        sDataProjectionMap.put("display_name", "display_name");
        sDataProjectionMap.put("display_name_alt", "display_name_alt");
        sDataProjectionMap.put("display_name_source", "display_name_source");
        sDataProjectionMap.put("phonetic_name", "phonetic_name");
        sDataProjectionMap.put("phonetic_name_style", "phonetic_name_style");
        sDataProjectionMap.put("sort_key", "sort_key");
        sDataProjectionMap.put("sort_key_alt", "sort_key_alt");
        sDataProjectionMap.put("custom_ringtone", "custom_ringtone");
        sDataProjectionMap.put("send_to_voicemail", "send_to_voicemail");
        sDataProjectionMap.put("last_time_contacted", "last_time_contacted");
        sDataProjectionMap.put("times_contacted", "times_contacted");
        sDataProjectionMap.put("starred", "starred");
        sDataProjectionMap.put("photo_id", "photo_id");
        sDataProjectionMap.put("in_visible_group", "in_visible_group");
        sDataProjectionMap.put("name_raw_contact_id", "name_raw_contact_id");
        sDataProjectionMap.put("group_sourceid", "group_sourceid");
        HashMap<String, String> columns = new HashMap<String, String>();
        columns.put("_id", "_id");
        columns.put("contact_id", "contact_id");
        columns.put("account_name", "account_name");
        columns.put("account_type", "account_type");
        columns.put("sourceid", "sourceid");
        columns.put("version", "version");
        columns.put("dirty", "dirty");
        columns.put("deleted", "deleted");
        columns.put("is_restricted", "is_restricted");
        columns.put("sync1", "sync1");
        columns.put("sync2", "sync2");
        columns.put("sync3", "sync3");
        columns.put("sync4", "sync4");
        columns.put("name_verified", "name_verified");
        columns.put("res_package", "res_package");
        columns.put("mimetype", "mimetype");
        columns.put("data1", "data1");
        columns.put("data2", "data2");
        columns.put("data3", "data3");
        columns.put("data4", "data4");
        columns.put("data5", "data5");
        columns.put("data6", "data6");
        columns.put("data7", "data7");
        columns.put("data8", "data8");
        columns.put("data9", "data9");
        columns.put("data10", "data10");
        columns.put("data11", "data11");
        columns.put("data12", "data12");
        columns.put("data13", "data13");
        columns.put("data14", "data14");
        columns.put("data15", "data15");
        columns.put("data_sync1", "data_sync1");
        columns.put("data_sync2", "data_sync2");
        columns.put("data_sync3", "data_sync3");
        columns.put("data_sync4", "data_sync4");
        columns.put("data_id", "data_id");
        columns.put("starred", "starred");
        columns.put("data_version", "data_version");
        columns.put("is_primary", "is_primary");
        columns.put("is_super_primary", "is_super_primary");
        columns.put("group_sourceid", "group_sourceid");
        sRawContactsEntityProjectionMap = columns;
        ContactsProvider2.addProjection(sDataProjectionMap, "contact_presence", "agg_presence.mode");
        ContactsProvider2.addProjection(sContactsProjectionMap, "contact_chat_capability", "agg_presence.chat_capability");
        ContactsProvider2.addProjection(sDataProjectionMap, "contact_status", "contacts_status_updates.status");
        ContactsProvider2.addProjection(sDataProjectionMap, "contact_status_ts", "contacts_status_updates.status_ts");
        ContactsProvider2.addProjection(sDataProjectionMap, "contact_status_res_package", "contacts_status_updates.status_res_package");
        ContactsProvider2.addProjection(sDataProjectionMap, "contact_status_label", "contacts_status_updates.status_label");
        ContactsProvider2.addProjection(sDataProjectionMap, "contact_status_icon", "contacts_status_updates.status_icon");
        ContactsProvider2.addProjection(sDataProjectionMap, "mode", "presence.mode");
        ContactsProvider2.addProjection(sDataProjectionMap, "contact_chat_capability", "agg_presence.chat_capability");
        ContactsProvider2.addProjection(sDataProjectionMap, "status", "status_updates.status");
        ContactsProvider2.addProjection(sDataProjectionMap, "status_ts", "status_updates.status_ts");
        ContactsProvider2.addProjection(sDataProjectionMap, "status_res_package", "status_updates.status_res_package");
        ContactsProvider2.addProjection(sDataProjectionMap, "status_label", "status_updates.status_label");
        ContactsProvider2.addProjection(sDataProjectionMap, "status_icon", "status_updates.status_icon");
        sDistinctDataProjectionMap = new HashMap();
        sDistinctDataProjectionMap.put("_id", "MIN(_id) AS _id");
        sDistinctDataProjectionMap.put("data_version", "data_version");
        sDistinctDataProjectionMap.put("is_primary", "is_primary");
        sDistinctDataProjectionMap.put("is_super_primary", "is_super_primary");
        sDistinctDataProjectionMap.put("res_package", "res_package");
        sDistinctDataProjectionMap.put("mimetype", "mimetype");
        sDistinctDataProjectionMap.put("data1", "data1");
        sDistinctDataProjectionMap.put("data2", "data2");
        sDistinctDataProjectionMap.put("data3", "data3");
        sDistinctDataProjectionMap.put("data4", "data4");
        sDistinctDataProjectionMap.put("data5", "data5");
        sDistinctDataProjectionMap.put("data6", "data6");
        sDistinctDataProjectionMap.put("data7", "data7");
        sDistinctDataProjectionMap.put("data8", "data8");
        sDistinctDataProjectionMap.put("data9", "data9");
        sDistinctDataProjectionMap.put("data10", "data10");
        sDistinctDataProjectionMap.put("data11", "data11");
        sDistinctDataProjectionMap.put("data12", "data12");
        sDistinctDataProjectionMap.put("data13", "data13");
        sDistinctDataProjectionMap.put("data14", "data14");
        sDistinctDataProjectionMap.put("data15", "data15");
        sDistinctDataProjectionMap.put("data_sync1", "data_sync1");
        sDistinctDataProjectionMap.put("data_sync2", "data_sync2");
        sDistinctDataProjectionMap.put("data_sync3", "data_sync3");
        sDistinctDataProjectionMap.put("data_sync4", "data_sync4");
        sDistinctDataProjectionMap.put("contact_id", "contact_id");
        sDistinctDataProjectionMap.put("lookup", "lookup");
        sDistinctDataProjectionMap.put("display_name", "display_name");
        sDistinctDataProjectionMap.put("display_name_alt", "display_name_alt");
        sDistinctDataProjectionMap.put("display_name_source", "display_name_source");
        sDistinctDataProjectionMap.put("phonetic_name", "phonetic_name");
        sDistinctDataProjectionMap.put("phonetic_name_style", "phonetic_name_style");
        sDistinctDataProjectionMap.put("sort_key", "sort_key");
        sDistinctDataProjectionMap.put("sort_key_alt", "sort_key_alt");
        sDistinctDataProjectionMap.put("custom_ringtone", "custom_ringtone");
        sDistinctDataProjectionMap.put("send_to_voicemail", "send_to_voicemail");
        sDistinctDataProjectionMap.put("last_time_contacted", "last_time_contacted");
        sDistinctDataProjectionMap.put("times_contacted", "times_contacted");
        sDistinctDataProjectionMap.put("starred", "starred");
        sDistinctDataProjectionMap.put("photo_id", "photo_id");
        sDistinctDataProjectionMap.put("in_visible_group", "in_visible_group");
        sDistinctDataProjectionMap.put("group_sourceid", "group_sourceid");
        ContactsProvider2.addProjection(sDistinctDataProjectionMap, "contact_presence", "agg_presence.mode");
        ContactsProvider2.addProjection(sDistinctDataProjectionMap, "contact_chat_capability", "agg_presence.chat_capability");
        ContactsProvider2.addProjection(sDistinctDataProjectionMap, "contact_status", "contacts_status_updates.status");
        ContactsProvider2.addProjection(sDistinctDataProjectionMap, "contact_status_ts", "contacts_status_updates.status_ts");
        ContactsProvider2.addProjection(sDistinctDataProjectionMap, "contact_status_res_package", "contacts_status_updates.status_res_package");
        ContactsProvider2.addProjection(sDistinctDataProjectionMap, "contact_status_label", "contacts_status_updates.status_label");
        ContactsProvider2.addProjection(sDistinctDataProjectionMap, "contact_status_icon", "contacts_status_updates.status_icon");
        ContactsProvider2.addProjection(sDistinctDataProjectionMap, "mode", "presence.mode");
        ContactsProvider2.addProjection(sDistinctDataProjectionMap, "chat_capability", "presence.chat_capability");
        ContactsProvider2.addProjection(sDistinctDataProjectionMap, "status", "status_updates.status");
        ContactsProvider2.addProjection(sDistinctDataProjectionMap, "status_ts", "status_updates.status_ts");
        ContactsProvider2.addProjection(sDistinctDataProjectionMap, "status_res_package", "status_updates.status_res_package");
        ContactsProvider2.addProjection(sDistinctDataProjectionMap, "status_label", "status_updates.status_label");
        ContactsProvider2.addProjection(sDistinctDataProjectionMap, "status_icon", "status_updates.status_icon");
        sPhoneLookupProjectionMap = new HashMap();
        sPhoneLookupProjectionMap.put("_id", "contacts_view._id AS _id");
        sPhoneLookupProjectionMap.put("lookup", "contacts_view.lookup AS lookup");
        sPhoneLookupProjectionMap.put("display_name", "contacts_view.display_name AS display_name");
        sPhoneLookupProjectionMap.put("last_time_contacted", "contacts_view.last_time_contacted AS last_time_contacted");
        sPhoneLookupProjectionMap.put("times_contacted", "contacts_view.times_contacted AS times_contacted");
        sPhoneLookupProjectionMap.put("starred", "contacts_view.starred AS starred");
        sPhoneLookupProjectionMap.put("in_visible_group", "contacts_view.in_visible_group AS in_visible_group");
        sPhoneLookupProjectionMap.put("photo_id", "contacts_view.photo_id AS photo_id");
        sPhoneLookupProjectionMap.put("custom_ringtone", "contacts_view.custom_ringtone AS custom_ringtone");
        sPhoneLookupProjectionMap.put("has_phone_number", "contacts_view.has_phone_number AS has_phone_number");
        sPhoneLookupProjectionMap.put("send_to_voicemail", "contacts_view.send_to_voicemail AS send_to_voicemail");
        sPhoneLookupProjectionMap.put("number", "data1 AS number");
        sPhoneLookupProjectionMap.put("type", "data2 AS type");
        sPhoneLookupProjectionMap.put("label", "data3 AS label");
        columns = new HashMap();
        columns.put("_id", "_id");
        columns.put("account_name", "account_name");
        columns.put("account_type", "account_type");
        columns.put("sourceid", "sourceid");
        columns.put("dirty", "dirty");
        columns.put("version", "version");
        columns.put("res_package", "res_package");
        columns.put("title", "title");
        columns.put("title_res", "title_res");
        columns.put("group_visible", "group_visible");
        columns.put("system_id", "system_id");
        columns.put("deleted", "deleted");
        columns.put("notes", "notes");
        columns.put("should_sync", "should_sync");
        columns.put("sync1", "sync1");
        columns.put("sync2", "sync2");
        columns.put("sync3", "sync3");
        columns.put("sync4", "sync4");
        sGroupsProjectionMap = columns;
        columns = new HashMap();
        columns.putAll(sGroupsProjectionMap);
        columns.put("summ_count", "(SELECT COUNT(DISTINCT contacts._id) FROM data JOIN mimetypes ON (data.mimetype_id = mimetypes._id) JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id) LEFT OUTER JOIN contacts ON (raw_contacts.contact_id = contacts._id) WHERE mimetypes.mimetype='vnd.android.cursor.item/group_membership' AND data.data1=groups._id) AS summ_count");
        columns.put("summ_phones", "(SELECT COUNT(DISTINCT contacts._id) FROM data JOIN mimetypes ON (data.mimetype_id = mimetypes._id) JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id) LEFT OUTER JOIN contacts ON (raw_contacts.contact_id = contacts._id) WHERE mimetypes.mimetype='vnd.android.cursor.item/group_membership' AND data.data1=groups._id AND has_phone_number) AS summ_phones");
        sGroupsSummaryProjectionMap = columns;
        columns = new HashMap();
        columns.put("_id", "agg_exceptions._id AS _id");
        columns.put("type", "type");
        columns.put("raw_contact_id1", "raw_contact_id1");
        columns.put("raw_contact_id2", "raw_contact_id2");
        sAggregationExceptionsProjectionMap = columns;
        columns = new HashMap();
        columns.put("account_name", "account_name");
        columns.put("account_type", "account_type");
        columns.put("ungrouped_visible", "ungrouped_visible");
        columns.put("should_sync", "should_sync");
        columns.put("any_unsynced", "(CASE WHEN MIN(should_sync,(SELECT (CASE WHEN MIN(should_sync) IS NULL THEN 1 ELSE MIN(should_sync) END) FROM groups WHERE groups.account_name=settings.account_name AND groups.account_type=settings.account_type))=0 THEN 1 ELSE 0 END) AS any_unsynced");
        columns.put("summ_count", "(SELECT COUNT(*) FROM (SELECT 1 FROM settings LEFT OUTER JOIN raw_contacts ON (raw_contacts.account_name = settings.account_name AND raw_contacts.account_type = settings.account_type) LEFT OUTER JOIN data ON (data.mimetype_id=? AND data.raw_contact_id = raw_contacts._id) LEFT OUTER JOIN contacts ON (raw_contacts.contact_id = contacts._id) GROUP BY settings.account_name,settings.account_type,contact_id HAVING COUNT(data.data1) == 0)) AS summ_count");
        columns.put("summ_phones", "(SELECT COUNT(*) FROM (SELECT 1 FROM settings LEFT OUTER JOIN raw_contacts ON (raw_contacts.account_name = settings.account_name AND raw_contacts.account_type = settings.account_type) LEFT OUTER JOIN data ON (data.mimetype_id=? AND data.raw_contact_id = raw_contacts._id) LEFT OUTER JOIN contacts ON (raw_contacts.contact_id = contacts._id) WHERE has_phone_number GROUP BY settings.account_name,settings.account_type,contact_id HAVING COUNT(data.data1) == 0)) AS summ_phones");
        sSettingsProjectionMap = columns;
        columns = new HashMap();
        columns.put("presence_raw_contact_id", "presence_raw_contact_id");
        columns.put("presence_data_id", "data._id AS presence_data_id");
        columns.put("im_account", "im_account");
        columns.put("im_handle", "im_handle");
        columns.put("protocol", "protocol");
        columns.put("custom_protocol", "(CASE WHEN custom_protocol='' THEN NULL ELSE custom_protocol END) AS custom_protocol");
        columns.put("mode", "mode");
        columns.put("chat_capability", "chat_capability");
        columns.put("status", "status");
        columns.put("status_ts", "status_ts");
        columns.put("status_res_package", "status_res_package");
        columns.put("status_icon", "status_icon");
        columns.put("status_label", "status_label");
        sStatusUpdatesProjectionMap = columns;
        sLiveFoldersProjectionMap = new HashMap();
        sLiveFoldersProjectionMap.put("_id", "_id AS _id");
        sLiveFoldersProjectionMap.put("name", "display_name AS name");
    }

    private class StructuredNameLookupBuilder
    extends NameLookupBuilder {
        public StructuredNameLookupBuilder(NameSplitter splitter) {
            super(splitter);
        }

        protected void insertNameLookup(long rawContactId, long dataId, int lookupType, String name) {
            ContactsProvider2.this.insertNameLookup(rawContactId, dataId, lookupType, name);
        }

        protected String[] getCommonNicknameClusters(String normalizedName) {
            return ContactsProvider2.this.mCommonNicknameCache.getCommonNicknameClusters(normalizedName);
        }
    }

    private static interface LookupByDisplayNameQuery {
        public static final String TABLE = "name_lookup INNER JOIN raw_contacts ON (name_lookup.raw_contact_id = raw_contacts._id)";
        public static final String[] COLUMNS = new String[]{"contact_id", "account_type", "account_name", "normalized_name"};
        public static final int CONTACT_ID = 0;
        public static final int ACCOUNT_TYPE = 1;
        public static final int ACCOUNT_NAME = 2;
        public static final int NORMALIZED_NAME = 3;
    }

    private static interface LookupByRawContactIdQuery {
        public static final String TABLE = "raw_contacts";
        public static final String[] COLUMNS = new String[]{"contact_id", "account_type", "account_name", "_id"};
        public static final int CONTACT_ID = 0;
        public static final int ACCOUNT_TYPE = 1;
        public static final int ACCOUNT_NAME = 2;
        public static final int ID = 3;
    }

    private static interface LookupBySourceIdQuery {
        public static final String TABLE = "raw_contacts";
        public static final String[] COLUMNS = new String[]{"contact_id", "account_type", "account_name", "sourceid"};
        public static final int CONTACT_ID = 0;
        public static final int ACCOUNT_TYPE = 1;
        public static final int ACCOUNT_NAME = 2;
        public static final int SOURCE_ID = 3;
    }

    private static final class AddressBookIndexQuery {
        public static final String LETTER = "letter";
        public static final String TITLE = "title";
        public static final String COUNT = "count";
        public static final String[] COLUMNS = new String[]{"letter", "title", "count"};
        public static final int COLUMN_LETTER = 0;
        public static final int COLUMN_TITLE = 1;
        public static final int COLUMN_COUNT = 2;
        public static final String ORDER_BY = "letter COLLATE PHONEBOOK";

        private AddressBookIndexQuery() {
        }
    }

    private static interface DisplayNameQuery {
        public static final String RAW_SQL = "SELECT mimetype_id,is_primary,data1,data2,data3,data4,data5,data6,data7,data8,data9,data10,data11 FROM data WHERE raw_contact_id=? AND (data1 NOT NULL OR data4 NOT NULL)";
        public static final int MIMETYPE = 0;
        public static final int IS_PRIMARY = 1;
        public static final int DATA1 = 2;
        public static final int GIVEN_NAME = 3;
        public static final int FAMILY_NAME = 4;
        public static final int PREFIX = 5;
        public static final int TITLE = 5;
        public static final int MIDDLE_NAME = 6;
        public static final int SUFFIX = 7;
        public static final int PHONETIC_GIVEN_NAME = 8;
        public static final int PHONETIC_MIDDLE_NAME = 9;
        public static final int ORGANIZATION_PHONETIC_NAME = 9;
        public static final int PHONETIC_FAMILY_NAME = 10;
        public static final int FULL_NAME_STYLE = 11;
        public static final int ORGANIZATION_PHONETIC_NAME_STYLE = 11;
        public static final int PHONETIC_NAME_STYLE = 12;
    }

    public class GroupIdCacheEntry {
        String accountType;
        String accountName;
        String sourceId;
        long groupId;
    }

    public class PhotoDataRowHandler
    extends DataRowHandler {
        public PhotoDataRowHandler() {
            super("vnd.android.cursor.item/photo");
        }

        public long insert(SQLiteDatabase db, long rawContactId, ContentValues values) {
            long dataId = super.insert(db, rawContactId, values);
            if (!ContactsProvider2.this.isNewRawContact(rawContactId)) {
                ContactsProvider2.this.mContactAggregator.updatePhotoId(db, rawContactId);
            }
            return dataId;
        }

        public boolean update(SQLiteDatabase db, ContentValues values, Cursor c, boolean callerIsSyncAdapter) {
            long rawContactId = c.getLong(1);
            if (!super.update(db, values, c, callerIsSyncAdapter)) {
                return false;
            }
            ContactsProvider2.this.mContactAggregator.updatePhotoId(db, rawContactId);
            return true;
        }

        public int delete(SQLiteDatabase db, Cursor c) {
            long rawContactId = c.getLong(2);
            int count = super.delete(db, c);
            ContactsProvider2.this.mContactAggregator.updatePhotoId(db, rawContactId);
            return count;
        }
    }

    public class GroupMembershipRowHandler
    extends DataRowHandler {
        public GroupMembershipRowHandler() {
            super("vnd.android.cursor.item/group_membership");
        }

        public long insert(SQLiteDatabase db, long rawContactId, ContentValues values) {
            this.resolveGroupSourceIdInValues(rawContactId, db, values, true);
            long dataId = super.insert(db, rawContactId, values);
            this.updateVisibility(rawContactId);
            return dataId;
        }

        public boolean update(SQLiteDatabase db, ContentValues values, Cursor c, boolean callerIsSyncAdapter) {
            long rawContactId = c.getLong(1);
            this.resolveGroupSourceIdInValues(rawContactId, db, values, false);
            if (!super.update(db, values, c, callerIsSyncAdapter)) {
                return false;
            }
            this.updateVisibility(rawContactId);
            return true;
        }

        public int delete(SQLiteDatabase db, Cursor c) {
            long rawContactId = c.getLong(2);
            int count = super.delete(db, c);
            this.updateVisibility(rawContactId);
            return count;
        }

        private void updateVisibility(long rawContactId) {
            long contactId = ContactsProvider2.this.mDbHelper.getContactId(rawContactId);
            if (contactId != 0L) {
                ContactsProvider2.this.mDbHelper.updateContactVisible(contactId);
            }
        }

        private void resolveGroupSourceIdInValues(long rawContactId, SQLiteDatabase db, ContentValues values, boolean isInsert) {
            boolean containsGroupSourceId = values.containsKey("group_sourceid");
            boolean containsGroupId = values.containsKey("data1");
            if (containsGroupSourceId && containsGroupId) {
                throw new IllegalArgumentException("you are not allowed to set both the GroupMembership.GROUP_SOURCE_ID and GroupMembership.GROUP_ROW_ID");
            }
            if (!containsGroupSourceId && !containsGroupId) {
                if (isInsert) {
                    throw new IllegalArgumentException("you must set exactly one of GroupMembership.GROUP_SOURCE_ID and GroupMembership.GROUP_ROW_ID");
                }
                return;
            }
            if (containsGroupSourceId) {
                String sourceId = values.getAsString("group_sourceid");
                long groupId = ContactsProvider2.this.getOrMakeGroup(db, rawContactId, sourceId, (Account)ContactsProvider2.this.mInsertedRawContacts.get(rawContactId));
                values.remove("group_sourceid");
                values.put("data1", Long.valueOf(groupId));
            }
        }
    }

    public class PhoneDataRowHandler
    extends CommonDataRowHandler {
        public PhoneDataRowHandler() {
            super("vnd.android.cursor.item/phone_v2", "data2", "data3");
        }

        public long insert(SQLiteDatabase db, long rawContactId, ContentValues values) {
            long dataId;
            if (values.containsKey("data1")) {
                String number = values.getAsString("data1");
                String normalizedNumber = this.computeNormalizedNumber(number);
                values.put("data4", normalizedNumber);
                dataId = super.insert(db, rawContactId, values);
                this.updatePhoneLookup(db, rawContactId, dataId, number, normalizedNumber);
                ContactsProvider2.this.mContactAggregator.updateHasPhoneNumber(db, rawContactId);
                this.fixRawContactDisplayName(db, rawContactId);
                if (normalizedNumber != null) {
                    ContactsProvider2.this.triggerAggregation(rawContactId);
                }
            } else {
                dataId = super.insert(db, rawContactId, values);
            }
            return dataId;
        }

        public boolean update(SQLiteDatabase db, ContentValues values, Cursor c, boolean callerIsSyncAdapter) {
            String number = null;
            String normalizedNumber = null;
            if (values.containsKey("data1")) {
                number = values.getAsString("data1");
                normalizedNumber = this.computeNormalizedNumber(number);
                values.put("data4", normalizedNumber);
            }
            if (!super.update(db, values, c, callerIsSyncAdapter)) {
                return false;
            }
            if (values.containsKey("data1")) {
                long dataId = c.getLong(0);
                long rawContactId = c.getLong(1);
                this.updatePhoneLookup(db, rawContactId, dataId, number, normalizedNumber);
                ContactsProvider2.this.mContactAggregator.updateHasPhoneNumber(db, rawContactId);
                this.fixRawContactDisplayName(db, rawContactId);
                ContactsProvider2.this.triggerAggregation(rawContactId);
            }
            return true;
        }

        public int delete(SQLiteDatabase db, Cursor c) {
            long dataId = c.getLong(0);
            long rawContactId = c.getLong(2);
            int count = super.delete(db, c);
            this.updatePhoneLookup(db, rawContactId, dataId, null, null);
            ContactsProvider2.this.mContactAggregator.updateHasPhoneNumber(db, rawContactId);
            this.fixRawContactDisplayName(db, rawContactId);
            ContactsProvider2.this.triggerAggregation(rawContactId);
            return count;
        }

        private String computeNormalizedNumber(String number) {
            String normalizedNumber = null;
            if (number != null) {
                normalizedNumber = PhoneNumberUtils.getStrippedReversed((String)number);
            }
            return normalizedNumber;
        }

        private void updatePhoneLookup(SQLiteDatabase db, long rawContactId, long dataId, String number, String normalizedNumber) {
            if (number != null) {
                ContentValues phoneValues = new ContentValues();
                phoneValues.put("raw_contact_id", Long.valueOf(rawContactId));
                phoneValues.put("data_id", Long.valueOf(dataId));
                phoneValues.put("normalized_number", normalizedNumber);
                phoneValues.put("min_match", PhoneNumberUtils.toCallerIDMinMatch((String)number));
                db.replace("phone_lookup", null, phoneValues);
            } else {
                ((ContactsProvider2)ContactsProvider2.this).mSelectionArgs1[0] = String.valueOf(dataId);
                db.delete("phone_lookup", "data_id=?", ContactsProvider2.this.mSelectionArgs1);
            }
        }

        protected int getTypeRank(int type) {
            switch (type) {
                case 2: {
                    return 0;
                }
                case 3: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 6: {
                    return 3;
                }
                case 0: {
                    return 4;
                }
                case 7: {
                    return 5;
                }
                case 4: {
                    return 6;
                }
                case 5: {
                    return 7;
                }
            }
            return 1000;
        }
    }

    public class NicknameDataRowHandler
    extends CommonDataRowHandler {
        public NicknameDataRowHandler() {
            super("vnd.android.cursor.item/nickname", "data2", "data3");
        }

        public long insert(SQLiteDatabase db, long rawContactId, ContentValues values) {
            String nickname = values.getAsString("data1");
            long dataId = super.insert(db, rawContactId, values);
            if (!TextUtils.isEmpty((CharSequence)nickname)) {
                this.fixRawContactDisplayName(db, rawContactId);
                ContactsProvider2.this.insertNameLookupForNickname(rawContactId, dataId, nickname);
                ContactsProvider2.this.triggerAggregation(rawContactId);
            }
            return dataId;
        }

        public boolean update(SQLiteDatabase db, ContentValues values, Cursor c, boolean callerIsSyncAdapter) {
            long dataId = c.getLong(0);
            long rawContactId = c.getLong(1);
            if (!super.update(db, values, c, callerIsSyncAdapter)) {
                return false;
            }
            if (values.containsKey("data1")) {
                String nickname = values.getAsString("data1");
                ContactsProvider2.this.deleteNameLookup(dataId);
                ContactsProvider2.this.insertNameLookupForNickname(rawContactId, dataId, nickname);
                this.fixRawContactDisplayName(db, rawContactId);
                ContactsProvider2.this.triggerAggregation(rawContactId);
            }
            return true;
        }

        public int delete(SQLiteDatabase db, Cursor c) {
            long dataId = c.getLong(0);
            long rawContactId = c.getLong(2);
            int count = super.delete(db, c);
            ContactsProvider2.this.deleteNameLookup(dataId);
            this.fixRawContactDisplayName(db, rawContactId);
            ContactsProvider2.this.triggerAggregation(rawContactId);
            return count;
        }
    }

    public class EmailDataRowHandler
    extends CommonDataRowHandler {
        public EmailDataRowHandler() {
            super("vnd.android.cursor.item/email_v2", "data2", "data3");
        }

        public long insert(SQLiteDatabase db, long rawContactId, ContentValues values) {
            String email = values.getAsString("data1");
            long dataId = super.insert(db, rawContactId, values);
            this.fixRawContactDisplayName(db, rawContactId);
            String address = ContactsProvider2.this.insertNameLookupForEmail(rawContactId, dataId, email);
            if (address != null) {
                ContactsProvider2.this.triggerAggregation(rawContactId);
            }
            return dataId;
        }

        public boolean update(SQLiteDatabase db, ContentValues values, Cursor c, boolean callerIsSyncAdapter) {
            if (!super.update(db, values, c, callerIsSyncAdapter)) {
                return false;
            }
            if (values.containsKey("data1")) {
                long dataId = c.getLong(0);
                long rawContactId = c.getLong(1);
                String address = values.getAsString("data1");
                ContactsProvider2.this.deleteNameLookup(dataId);
                ContactsProvider2.this.insertNameLookupForEmail(rawContactId, dataId, address);
                this.fixRawContactDisplayName(db, rawContactId);
                ContactsProvider2.this.triggerAggregation(rawContactId);
            }
            return true;
        }

        public int delete(SQLiteDatabase db, Cursor c) {
            long dataId = c.getLong(0);
            long rawContactId = c.getLong(2);
            int count = super.delete(db, c);
            ContactsProvider2.this.deleteNameLookup(dataId);
            this.fixRawContactDisplayName(db, rawContactId);
            ContactsProvider2.this.triggerAggregation(rawContactId);
            return count;
        }

        protected int getTypeRank(int type) {
            switch (type) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 0: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            return 1000;
        }
    }

    public class OrganizationDataRowHandler
    extends CommonDataRowHandler {
        public OrganizationDataRowHandler() {
            super("vnd.android.cursor.item/organization", "data2", "data3");
        }

        public long insert(SQLiteDatabase db, long rawContactId, ContentValues values) {
            String company = values.getAsString("data1");
            String title = values.getAsString("data4");
            long dataId = super.insert(db, rawContactId, values);
            this.fixRawContactDisplayName(db, rawContactId);
            ContactsProvider2.this.insertNameLookupForOrganization(rawContactId, dataId, company, title);
            return dataId;
        }

        public boolean update(SQLiteDatabase db, ContentValues values, Cursor c, boolean callerIsSyncAdapter) {
            if (!super.update(db, values, c, callerIsSyncAdapter)) {
                return false;
            }
            boolean containsCompany = values.containsKey("data1");
            boolean containsTitle = values.containsKey("data4");
            if (containsCompany || containsTitle) {
                String title;
                String company;
                long dataId = c.getLong(0);
                long rawContactId = c.getLong(1);
                if (containsCompany) {
                    company = values.getAsString("data1");
                } else {
                    ((ContactsProvider2)ContactsProvider2.this).mSelectionArgs1[0] = String.valueOf(dataId);
                    company = DatabaseUtils.stringForQuery((SQLiteDatabase)db, (String)"SELECT data1 FROM data WHERE _id=?", (String[])ContactsProvider2.this.mSelectionArgs1);
                }
                if (containsTitle) {
                    title = values.getAsString("data4");
                } else {
                    ((ContactsProvider2)ContactsProvider2.this).mSelectionArgs1[0] = String.valueOf(dataId);
                    title = DatabaseUtils.stringForQuery((SQLiteDatabase)db, (String)"SELECT data4 FROM data WHERE _id=?", (String[])ContactsProvider2.this.mSelectionArgs1);
                }
                ContactsProvider2.this.deleteNameLookup(dataId);
                ContactsProvider2.this.insertNameLookupForOrganization(rawContactId, dataId, company, title);
                this.fixRawContactDisplayName(db, rawContactId);
            }
            return true;
        }

        public int delete(SQLiteDatabase db, Cursor c) {
            long dataId = c.getLong(0);
            long rawContactId = c.getLong(2);
            int count = super.delete(db, c);
            this.fixRawContactDisplayName(db, rawContactId);
            ContactsProvider2.this.deleteNameLookup(dataId);
            return count;
        }

        protected int getTypeRank(int type) {
            switch (type) {
                case 1: {
                    return 0;
                }
                case 0: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
            }
            return 1000;
        }
    }

    public class CommonDataRowHandler
    extends DataRowHandler {
        private final String mTypeColumn;
        private final String mLabelColumn;

        public CommonDataRowHandler(String mimetype, String typeColumn, String labelColumn) {
            super(mimetype);
            this.mTypeColumn = typeColumn;
            this.mLabelColumn = labelColumn;
        }

        public long insert(SQLiteDatabase db, long rawContactId, ContentValues values) {
            this.enforceTypeAndLabel(values, values);
            return super.insert(db, rawContactId, values);
        }

        public boolean update(SQLiteDatabase db, ContentValues values, Cursor c, boolean callerIsSyncAdapter) {
            long dataId = c.getLong(0);
            ContentValues augmented = this.getAugmentedValues(db, dataId, values);
            if (augmented == null) {
                return false;
            }
            this.enforceTypeAndLabel(augmented, values);
            return super.update(db, values, c, callerIsSyncAdapter);
        }

        private void enforceTypeAndLabel(ContentValues augmented, ContentValues update) {
            boolean hasLabel;
            boolean hasType = !TextUtils.isEmpty((CharSequence)augmented.getAsString(this.mTypeColumn));
            boolean bl = hasLabel = !TextUtils.isEmpty((CharSequence)augmented.getAsString(this.mLabelColumn));
            if (hasLabel && !hasType) {
                throw new IllegalArgumentException(this.mTypeColumn + " must be specified when " + this.mLabelColumn + " is defined.");
            }
        }
    }

    public class StructuredPostalRowHandler
    extends DataRowHandler {
        private PostalSplitter mSplitter;
        private final String[] STRUCTURED_FIELDS;

        public StructuredPostalRowHandler(PostalSplitter splitter) {
            super("vnd.android.cursor.item/postal-address_v2");
            this.STRUCTURED_FIELDS = new String[]{"data4", "data5", "data6", "data7", "data8", "data9", "data10"};
            this.mSplitter = splitter;
        }

        public long insert(SQLiteDatabase db, long rawContactId, ContentValues values) {
            this.fixStructuredPostalComponents(values, values);
            return super.insert(db, rawContactId, values);
        }

        public boolean update(SQLiteDatabase db, ContentValues values, Cursor c, boolean callerIsSyncAdapter) {
            long dataId = c.getLong(0);
            ContentValues augmented = this.getAugmentedValues(db, dataId, values);
            if (augmented == null) {
                return false;
            }
            this.fixStructuredPostalComponents(augmented, values);
            super.update(db, values, c, callerIsSyncAdapter);
            return true;
        }

        private void fixStructuredPostalComponents(ContentValues augmented, ContentValues update) {
            String unstruct = update.getAsString("data1");
            boolean touchedUnstruct = !TextUtils.isEmpty((CharSequence)unstruct);
            boolean touchedStruct = !ContactsProvider2.areAllEmpty(update, this.STRUCTURED_FIELDS);
            PostalSplitter.Postal postal = new PostalSplitter.Postal();
            if (touchedUnstruct && !touchedStruct) {
                this.mSplitter.split(postal, unstruct);
                postal.toValues(update);
            } else if (!touchedUnstruct && (touchedStruct || ContactsProvider2.areAnySpecified(update, this.STRUCTURED_FIELDS))) {
                postal.fromValues(augmented);
                String joined = this.mSplitter.join(postal);
                update.put("data1", joined);
            }
        }
    }

    public class StructuredNameRowHandler
    extends DataRowHandler {
        private final NameSplitter mSplitter;
        private final String[] STRUCTURED_FIELDS;

        public StructuredNameRowHandler(NameSplitter splitter) {
            super("vnd.android.cursor.item/name");
            this.STRUCTURED_FIELDS = new String[]{"data4", "data2", "data5", "data3", "data6"};
            this.mSplitter = splitter;
        }

        public long insert(SQLiteDatabase db, long rawContactId, ContentValues values) {
            this.fixStructuredNameComponents(values, values);
            long dataId = super.insert(db, rawContactId, values);
            String name = values.getAsString("data1");
            Integer fullNameStyle = values.getAsInteger("data10");
            ContactsProvider2.this.insertNameLookupForStructuredName(rawContactId, dataId, name, fullNameStyle != null ? ContactsProvider2.this.mNameSplitter.getAdjustedFullNameStyle(fullNameStyle) : 0);
            ContactsProvider2.this.insertNameLookupForPhoneticName(rawContactId, dataId, values);
            this.fixRawContactDisplayName(db, rawContactId);
            ContactsProvider2.this.triggerAggregation(rawContactId);
            return dataId;
        }

        public boolean update(SQLiteDatabase db, ContentValues values, Cursor c, boolean callerIsSyncAdapter) {
            long dataId = c.getLong(0);
            long rawContactId = c.getLong(1);
            ContentValues augmented = this.getAugmentedValues(db, dataId, values);
            if (augmented == null) {
                return false;
            }
            this.fixStructuredNameComponents(augmented, values);
            super.update(db, values, c, callerIsSyncAdapter);
            if (values.containsKey("data1") || values.containsKey("data9") || values.containsKey("data8") || values.containsKey("data7")) {
                augmented.putAll(values);
                String name = augmented.getAsString("data1");
                ContactsProvider2.this.deleteNameLookup(dataId);
                Integer fullNameStyle = augmented.getAsInteger("data10");
                ContactsProvider2.this.insertNameLookupForStructuredName(rawContactId, dataId, name, fullNameStyle != null ? ContactsProvider2.this.mNameSplitter.getAdjustedFullNameStyle(fullNameStyle) : 0);
                ContactsProvider2.this.insertNameLookupForPhoneticName(rawContactId, dataId, augmented);
            }
            this.fixRawContactDisplayName(db, rawContactId);
            ContactsProvider2.this.triggerAggregation(rawContactId);
            return true;
        }

        public int delete(SQLiteDatabase db, Cursor c) {
            long dataId = c.getLong(0);
            long rawContactId = c.getLong(2);
            int count = super.delete(db, c);
            ContactsProvider2.this.deleteNameLookup(dataId);
            this.fixRawContactDisplayName(db, rawContactId);
            ContactsProvider2.this.triggerAggregation(rawContactId);
            return count;
        }

        private void fixStructuredNameComponents(ContentValues augmented, ContentValues update) {
            boolean touchedStruct;
            String unstruct = update.getAsString("data1");
            boolean touchedUnstruct = !TextUtils.isEmpty((CharSequence)unstruct);
            boolean bl = touchedStruct = !ContactsProvider2.areAllEmpty(update, this.STRUCTURED_FIELDS);
            if (touchedUnstruct && !touchedStruct) {
                NameSplitter.Name name = new NameSplitter.Name();
                this.mSplitter.split(name, unstruct);
                name.toValues(update);
            } else if (!touchedUnstruct && (touchedStruct || ContactsProvider2.areAnySpecified(update, this.STRUCTURED_FIELDS))) {
                NameSplitter.Name name = new NameSplitter.Name();
                name.fromValues(augmented);
                name.fullNameStyle = 0;
                this.mSplitter.guessNameStyle(name);
                int unadjustedFullNameStyle = name.fullNameStyle;
                name.fullNameStyle = this.mSplitter.getAdjustedFullNameStyle(name.fullNameStyle);
                String joined = this.mSplitter.join(name, true);
                update.put("data1", joined);
                update.put("data10", Integer.valueOf(unadjustedFullNameStyle));
                update.put("data11", Integer.valueOf(name.phoneticNameStyle));
            } else if (touchedUnstruct && touchedStruct) {
                if (!update.containsKey("data10")) {
                    update.put("data10", Integer.valueOf(this.mSplitter.guessFullNameStyle(unstruct)));
                }
                if (!update.containsKey("data11")) {
                    update.put("data11", Integer.valueOf(this.mSplitter.guessPhoneticNameStyle(unstruct)));
                }
            }
        }
    }

    public class CustomDataRowHandler
    extends DataRowHandler {
        public CustomDataRowHandler(String mimetype) {
            super(mimetype);
        }
    }

    private abstract class DataRowHandler {
        protected final String mMimetype;
        protected long mMimetypeId;

        public DataRowHandler(String mimetype) {
            this.mMimetype = mimetype;
        }

        protected long getMimeTypeId() {
            if (this.mMimetypeId == 0L) {
                this.mMimetypeId = ContactsProvider2.this.mDbHelper.getMimeTypeId(this.mMimetype);
            }
            return this.mMimetypeId;
        }

        public long insert(SQLiteDatabase db, long rawContactId, ContentValues values) {
            long dataId = db.insert("data", null, values);
            Integer primary = values.getAsInteger("is_primary");
            if (primary != null && primary != 0) {
                ContactsProvider2.this.setIsPrimary(rawContactId, dataId, this.getMimeTypeId());
            }
            return dataId;
        }

        public boolean update(SQLiteDatabase db, ContentValues values, Cursor c, boolean callerIsSyncAdapter) {
            long dataId = c.getLong(0);
            long rawContactId = c.getLong(1);
            if (values.containsKey("is_super_primary")) {
                long mimeTypeId = this.getMimeTypeId();
                ContactsProvider2.this.setIsSuperPrimary(rawContactId, dataId, mimeTypeId);
                ContactsProvider2.this.setIsPrimary(rawContactId, dataId, mimeTypeId);
                values.remove("is_super_primary");
                values.remove("is_primary");
            } else if (values.containsKey("is_primary")) {
                ContactsProvider2.this.setIsPrimary(rawContactId, dataId, this.getMimeTypeId());
                values.remove("is_primary");
            }
            if (values.size() > 0) {
                ((ContactsProvider2)ContactsProvider2.this).mSelectionArgs1[0] = String.valueOf(dataId);
                ContactsProvider2.this.mDb.update("data", values, "_id =?", ContactsProvider2.this.mSelectionArgs1);
            }
            if (!callerIsSyncAdapter) {
                ContactsProvider2.this.setRawContactDirty(rawContactId);
            }
            return true;
        }

        public int delete(SQLiteDatabase db, Cursor c) {
            long dataId = c.getLong(0);
            long rawContactId = c.getLong(2);
            boolean primary = c.getInt(3) != 0;
            ((ContactsProvider2)ContactsProvider2.this).mSelectionArgs1[0] = String.valueOf(dataId);
            int count = db.delete("data", "_id=?", ContactsProvider2.this.mSelectionArgs1);
            ((ContactsProvider2)ContactsProvider2.this).mSelectionArgs1[0] = String.valueOf(rawContactId);
            db.delete("presence", "presence_raw_contact_id=?", ContactsProvider2.this.mSelectionArgs1);
            if (count != 0 && primary) {
                this.fixPrimary(db, rawContactId);
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fixPrimary(SQLiteDatabase db, long rawContactId) {
            long mimeTypeId = this.getMimeTypeId();
            long primaryId = -1L;
            int primaryType = -1;
            ((ContactsProvider2)ContactsProvider2.this).mSelectionArgs1[0] = String.valueOf(rawContactId);
            Cursor c = db.query("data JOIN mimetypes ON (data.mimetype_id = mimetypes._id)", DataDeleteQuery.CONCRETE_COLUMNS, "raw_contact_id=? AND mimetype_id=" + mimeTypeId, ContactsProvider2.this.mSelectionArgs1, null, null, null);
            try {
                while (c.moveToNext()) {
                    long dataId = c.getLong(0);
                    int type = c.getInt(4);
                    if (primaryType != -1 && this.getTypeRank(type) >= this.getTypeRank(primaryType)) continue;
                    primaryId = dataId;
                    primaryType = type;
                }
            }
            finally {
                c.close();
            }
            if (primaryId != -1L) {
                ContactsProvider2.this.setIsPrimary(rawContactId, primaryId, mimeTypeId);
            }
        }

        protected int getTypeRank(int type) {
            return 0;
        }

        protected void fixRawContactDisplayName(SQLiteDatabase db, long rawContactId) {
            if (!ContactsProvider2.this.isNewRawContact(rawContactId)) {
                ContactsProvider2.this.updateRawContactDisplayName(db, rawContactId);
                ContactsProvider2.this.mContactAggregator.updateDisplayNameForRawContact(db, rawContactId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ContentValues getAugmentedValues(SQLiteDatabase db, long dataId, ContentValues update) {
            boolean changing = false;
            ContentValues values = new ContentValues();
            ((ContactsProvider2)ContactsProvider2.this).mSelectionArgs1[0] = String.valueOf(dataId);
            Cursor cursor = db.query("data", null, "_id=?", ContactsProvider2.this.mSelectionArgs1, null, null, null);
            try {
                if (cursor.moveToFirst()) {
                    for (int i = 0; i < cursor.getColumnCount(); ++i) {
                        String key = cursor.getColumnName(i);
                        String value = cursor.getString(i);
                        if (!changing && update.containsKey(key)) {
                            Object newValue = update.get(key);
                            String newString = newValue == null ? null : newValue.toString();
                            changing |= !TextUtils.equals((CharSequence)newString, (CharSequence)value);
                        }
                        values.put(key, value);
                    }
                }
            }
            finally {
                cursor.close();
            }
            if (!changing) {
                return null;
            }
            values.putAll(update);
            return values;
        }
    }

    private static interface RawContactsQuery {
        public static final String TABLE = "raw_contacts";
        public static final String[] COLUMNS = new String[]{"deleted", "account_type", "account_name"};
        public static final int DELETED = 0;
        public static final int ACCOUNT_TYPE = 1;
        public static final int ACCOUNT_NAME = 2;
    }

    private static interface DataUpdateQuery {
        public static final String[] COLUMNS = new String[]{"_id", "raw_contact_id", "mimetype"};
        public static final int _ID = 0;
        public static final int RAW_CONTACT_ID = 1;
        public static final int MIMETYPE = 2;
    }

    private static interface DataDeleteQuery {
        public static final String TABLE = "data JOIN mimetypes ON (data.mimetype_id = mimetypes._id)";
        public static final String[] CONCRETE_COLUMNS = new String[]{"data._id", "mimetype", "raw_contact_id", "is_primary", "data1"};
        public static final String[] COLUMNS = new String[]{"_id", "mimetype", "raw_contact_id", "is_primary", "data1"};
        public static final int _ID = 0;
        public static final int MIMETYPE = 1;
        public static final int RAW_CONTACT_ID = 2;
        public static final int IS_PRIMARY = 3;
        public static final int DATA1 = 4;
    }

    private static interface DataContactsQuery {
        public static final String TABLE = "data JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id) JOIN contacts ON (raw_contacts.contact_id = contacts._id)";
        public static final String[] PROJECTION = new String[]{"raw_contacts._id", "data._id", "contacts._id"};
        public static final int RAW_CONTACT_ID = 0;
        public static final int DATA_ID = 1;
        public static final int CONTACT_ID = 2;
    }
}

