/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteQueryBuilder;
import android.database.sqlite.SQLiteStatement;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.SystemClock;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.text.util.Rfc822Token;
import android.text.util.Rfc822Tokenizer;
import android.util.Log;
import com.android.internal.content.SyncStateContentProviderHelper;
import com.android.providers.contacts.CommonNicknameCache;
import com.android.providers.contacts.ContactLocaleUtils;
import com.android.providers.contacts.ContactLookupKey;
import com.android.providers.contacts.ContactsProvider2;
import com.android.providers.contacts.LegacyApiSupport;
import com.android.providers.contacts.NameLookupBuilder;
import com.android.providers.contacts.NameNormalizer;
import com.android.providers.contacts.NameSplitter;
import java.util.HashMap;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContactsDatabaseHelper
extends SQLiteOpenHelper {
    private static final String TAG = "ContactsDatabaseHelper";
    static final int DATABASE_VERSION = 353;
    private static final String DATABASE_NAME = "contacts2.db";
    private static final String DATABASE_PRESENCE = "presence_db";
    private final HashMap<String, Long> mMimetypeCache = new HashMap();
    private final HashMap<String, Long> mPackageCache = new HashMap();
    private SQLiteStatement mMimetypeQuery;
    private SQLiteStatement mPackageQuery;
    private SQLiteStatement mContactIdQuery;
    private SQLiteStatement mAggregationModeQuery;
    private SQLiteStatement mMimetypeInsert;
    private SQLiteStatement mPackageInsert;
    private SQLiteStatement mDataMimetypeQuery;
    private SQLiteStatement mActivitiesMimetypeQuery;
    private final Context mContext;
    private final SyncStateContentProviderHelper mSyncState;
    private SQLiteStatement mVisibleSpecificUpdate;
    private SQLiteStatement mVisibleUpdateRawContacts;
    private SQLiteStatement mVisibleSpecificUpdateRawContacts;
    private boolean mReopenDatabase = false;
    private static ContactsDatabaseHelper sSingleton = null;
    private boolean mUseStrictPhoneNumberComparison;
    private String[] mUnrestrictedPackages;

    public static synchronized ContactsDatabaseHelper getInstance(Context context) {
        if (sSingleton == null) {
            sSingleton = new ContactsDatabaseHelper(context);
        }
        return sSingleton;
    }

    ContactsDatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, 353);
        Resources resources = context.getResources();
        this.mContext = context;
        this.mSyncState = new SyncStateContentProviderHelper();
        this.mUseStrictPhoneNumberComparison = resources.getBoolean(17629196);
        int resourceId = resources.getIdentifier("unrestricted_packages", "array", context.getPackageName());
        this.mUnrestrictedPackages = resourceId != 0 ? resources.getStringArray(resourceId) : new String[0];
    }

    public void onOpen(SQLiteDatabase db) {
        this.mSyncState.onDatabaseOpened(db);
        this.mMimetypeQuery = db.compileStatement("SELECT _id FROM mimetypes WHERE mimetype=?");
        this.mPackageQuery = db.compileStatement("SELECT _id FROM packages WHERE package=?");
        this.mContactIdQuery = db.compileStatement("SELECT contact_id FROM raw_contacts WHERE _id=?");
        this.mAggregationModeQuery = db.compileStatement("SELECT aggregation_mode FROM raw_contacts WHERE _id=?");
        this.mMimetypeInsert = db.compileStatement("INSERT INTO mimetypes(mimetype) VALUES (?)");
        this.mPackageInsert = db.compileStatement("INSERT INTO packages(package) VALUES (?)");
        this.mDataMimetypeQuery = db.compileStatement("SELECT mimetype FROM data JOIN mimetypes ON (data.mimetype_id = mimetypes._id) WHERE data._id=?");
        this.mActivitiesMimetypeQuery = db.compileStatement("SELECT mimetype FROM activities LEFT OUTER JOIN mimetypes ON (activities.mimetype_id = mimetypes._id) WHERE activities._id=?");
        this.mVisibleSpecificUpdate = db.compileStatement("UPDATE contacts SET in_visible_group=(SELECT MAX((SELECT (CASE WHEN (CASE WHEN raw_contacts.account_name IS NULL AND raw_contacts.account_type IS NULL THEN 1  WHEN COUNT(groups._id)=0 THEN ungrouped_visible ELSE MAX(group_visible)END)=1 THEN 1 ELSE 0 END) FROM raw_contacts LEFT OUTER JOIN settings ON (raw_contacts.account_name = settings.account_name AND raw_contacts.account_type = settings.account_type) LEFT OUTER JOIN data ON (data.mimetype_id=? AND data.raw_contact_id = raw_contacts._id) LEFT OUTER JOIN groups ON (groups._id = data.data1) WHERE raw_contacts._id=outer_raw_contacts._id)) FROM raw_contacts AS outer_raw_contacts WHERE contact_id=contacts._id GROUP BY contact_id) WHERE contacts._id=?");
        String contactVisibility = "SELECT in_visible_group FROM contacts WHERE _id=contact_id";
        this.mVisibleUpdateRawContacts = db.compileStatement("UPDATE raw_contacts SET contact_in_visible_group=(CASE WHEN (" + contactVisibility + ")=1 THEN 1 ELSE 0 END)" + " WHERE " + "deleted" + "=0" + " AND " + "contact_in_visible_group" + "!=(" + contactVisibility + ")=1");
        this.mVisibleSpecificUpdateRawContacts = db.compileStatement("UPDATE raw_contacts SET contact_in_visible_group=(" + contactVisibility + ")" + " WHERE " + "deleted" + "=0 AND " + "contact_id" + "=?");
        db.execSQL("ATTACH DATABASE ':memory:' AS presence_db;");
        db.execSQL("CREATE TABLE IF NOT EXISTS presence_db.presence (presence_data_id INTEGER PRIMARY KEY REFERENCES data(_id),protocol INTEGER NOT NULL,custom_protocol TEXT,im_handle TEXT,im_account TEXT,presence_contact_id INTEGER REFERENCES contacts(_id),presence_raw_contact_id INTEGER REFERENCES raw_contacts(_id),mode INTEGER,chat_capability INTEGER NOT NULL DEFAULT 0,UNIQUE(protocol, custom_protocol, im_handle, im_account));");
        db.execSQL("CREATE INDEX IF NOT EXISTS presence_db.presenceIndex ON presence (presence_raw_contact_id);");
        db.execSQL("CREATE INDEX IF NOT EXISTS presence_db.presenceIndex2 ON presence (presence_contact_id);");
        db.execSQL("CREATE TABLE IF NOT EXISTS presence_db.agg_presence (presence_contact_id INTEGER PRIMARY KEY REFERENCES contacts(_id),mode INTEGER,chat_capability INTEGER NOT NULL DEFAULT 0);");
        db.execSQL("CREATE TRIGGER presence_db.presence_deleted BEFORE DELETE ON presence_db.presence BEGIN    DELETE FROM agg_presence     WHERE presence_contact_id = (SELECT presence_contact_id FROM presence WHERE presence_raw_contact_id=OLD.presence_raw_contact_id AND NOT EXISTS(SELECT presence_raw_contact_id FROM presence WHERE presence_contact_id=OLD.presence_contact_id AND presence_raw_contact_id!=OLD.presence_raw_contact_id)); END");
        String replaceAggregatePresenceSql = "INSERT OR REPLACE INTO agg_presence(presence_contact_id, mode, chat_capability) SELECT presence_contact_id,mode,chat_capability FROM presence WHERE  (ifnull(mode,0)  * 10 + ifnull(chat_capability, 0)) = (SELECT MAX (ifnull(mode,0)  * 10 + ifnull(chat_capability, 0)) FROM presence WHERE presence_contact_id=NEW.presence_contact_id) AND presence_contact_id=NEW.presence_contact_id;";
        db.execSQL("CREATE TRIGGER presence_db.presence_inserted AFTER INSERT ON presence_db.presence BEGIN INSERT OR REPLACE INTO agg_presence(presence_contact_id, mode, chat_capability) SELECT presence_contact_id,mode,chat_capability FROM presence WHERE  (ifnull(mode,0)  * 10 + ifnull(chat_capability, 0)) = (SELECT MAX (ifnull(mode,0)  * 10 + ifnull(chat_capability, 0)) FROM presence WHERE presence_contact_id=NEW.presence_contact_id) AND presence_contact_id=NEW.presence_contact_id; END");
        db.execSQL("CREATE TRIGGER presence_db.presence_updated AFTER UPDATE ON presence_db.presence BEGIN INSERT OR REPLACE INTO agg_presence(presence_contact_id, mode, chat_capability) SELECT presence_contact_id,mode,chat_capability FROM presence WHERE  (ifnull(mode,0)  * 10 + ifnull(chat_capability, 0)) = (SELECT MAX (ifnull(mode,0)  * 10 + ifnull(chat_capability, 0)) FROM presence WHERE presence_contact_id=NEW.presence_contact_id) AND presence_contact_id=NEW.presence_contact_id; END");
    }

    public void onCreate(SQLiteDatabase db) {
        Log.i((String)TAG, (String)"Bootstrapping database");
        this.mSyncState.createDatabase(db);
        db.execSQL("CREATE TABLE contacts (_id INTEGER PRIMARY KEY AUTOINCREMENT,name_raw_contact_id INTEGER REFERENCES raw_contacts(_id),photo_id INTEGER REFERENCES data(_id),custom_ringtone TEXT,send_to_voicemail INTEGER NOT NULL DEFAULT 0,times_contacted INTEGER NOT NULL DEFAULT 0,last_time_contacted INTEGER,starred INTEGER NOT NULL DEFAULT 0,in_visible_group INTEGER NOT NULL DEFAULT 1,has_phone_number INTEGER NOT NULL DEFAULT 0,lookup TEXT,status_update_id INTEGER REFERENCES data(_id),single_is_restricted INTEGER NOT NULL DEFAULT 0);");
        db.execSQL("CREATE INDEX contacts_visible_index ON contacts (in_visible_group);");
        db.execSQL("CREATE INDEX contacts_has_phone_index ON contacts (has_phone_number);");
        db.execSQL("CREATE INDEX contacts_restricted_index ON contacts (single_is_restricted);");
        db.execSQL("CREATE INDEX contacts_name_raw_contact_id_index ON contacts (name_raw_contact_id);");
        db.execSQL("CREATE TABLE raw_contacts (_id INTEGER PRIMARY KEY AUTOINCREMENT,is_restricted INTEGER DEFAULT 0,account_name STRING DEFAULT NULL, account_type STRING DEFAULT NULL, sourceid TEXT,version INTEGER NOT NULL DEFAULT 1,dirty INTEGER NOT NULL DEFAULT 0,deleted INTEGER NOT NULL DEFAULT 0,contact_id INTEGER REFERENCES contacts(_id),aggregation_mode INTEGER NOT NULL DEFAULT 0,aggregation_needed INTEGER NOT NULL DEFAULT 1,custom_ringtone TEXT,send_to_voicemail INTEGER NOT NULL DEFAULT 0,times_contacted INTEGER NOT NULL DEFAULT 0,last_time_contacted INTEGER,starred INTEGER NOT NULL DEFAULT 0,display_name TEXT,display_name_alt TEXT,display_name_source INTEGER NOT NULL DEFAULT 0,phonetic_name TEXT,phonetic_name_style TEXT,sort_key TEXT COLLATE PHONEBOOK,sort_key_alt TEXT COLLATE PHONEBOOK,name_verified INTEGER NOT NULL DEFAULT 0,contact_in_visible_group INTEGER NOT NULL DEFAULT 0,sync1 TEXT, sync2 TEXT, sync3 TEXT, sync4 TEXT );");
        db.execSQL("CREATE INDEX raw_contacts_contact_id_index ON raw_contacts (contact_id);");
        db.execSQL("CREATE INDEX raw_contacts_source_id_index ON raw_contacts (sourceid, account_type, account_name);");
        db.execSQL("CREATE TABLE packages (_id INTEGER PRIMARY KEY AUTOINCREMENT,package TEXT NOT NULL);");
        db.execSQL("CREATE TABLE mimetypes (_id INTEGER PRIMARY KEY AUTOINCREMENT,mimetype TEXT NOT NULL);");
        db.execSQL("CREATE UNIQUE INDEX mime_type ON mimetypes (mimetype);");
        db.execSQL("CREATE TABLE data (_id INTEGER PRIMARY KEY AUTOINCREMENT,package_id INTEGER REFERENCES package(_id),mimetype_id INTEGER REFERENCES mimetype(_id) NOT NULL,raw_contact_id INTEGER REFERENCES raw_contacts(_id) NOT NULL,is_primary INTEGER NOT NULL DEFAULT 0,is_super_primary INTEGER NOT NULL DEFAULT 0,data_version INTEGER NOT NULL DEFAULT 0,data1 TEXT,data2 TEXT,data3 TEXT,data4 TEXT,data5 TEXT,data6 TEXT,data7 TEXT,data8 TEXT,data9 TEXT,data10 TEXT,data11 TEXT,data12 TEXT,data13 TEXT,data14 TEXT,data15 TEXT,data_sync1 TEXT, data_sync2 TEXT, data_sync3 TEXT, data_sync4 TEXT );");
        db.execSQL("CREATE INDEX data_raw_contact_id ON data (raw_contact_id);");
        db.execSQL("CREATE INDEX data_mimetype_data1_index ON data (mimetype_id,data1);");
        db.execSQL("CREATE TABLE phone_lookup (data_id INTEGER PRIMARY KEY REFERENCES data(_id) NOT NULL,raw_contact_id INTEGER REFERENCES raw_contacts(_id) NOT NULL,normalized_number TEXT NOT NULL,min_match TEXT NOT NULL);");
        db.execSQL("CREATE INDEX phone_lookup_index ON phone_lookup (normalized_number,raw_contact_id,data_id);");
        db.execSQL("CREATE INDEX phone_lookup_min_match_index ON phone_lookup (min_match,raw_contact_id,data_id);");
        db.execSQL("CREATE TABLE name_lookup (data_id INTEGER REFERENCES data(_id) NOT NULL,raw_contact_id INTEGER REFERENCES raw_contacts(_id) NOT NULL,normalized_name TEXT NOT NULL,name_type INTEGER NOT NULL,PRIMARY KEY (data_id, normalized_name, name_type));");
        db.execSQL("CREATE INDEX name_lookup_raw_contact_id_index ON name_lookup (raw_contact_id);");
        db.execSQL("CREATE TABLE nickname_lookup (name TEXT,cluster TEXT);");
        db.execSQL("CREATE UNIQUE INDEX nickname_lookup_index ON nickname_lookup (name, cluster);");
        db.execSQL("CREATE TABLE groups (_id INTEGER PRIMARY KEY AUTOINCREMENT,package_id INTEGER REFERENCES package(_id),account_name STRING DEFAULT NULL, account_type STRING DEFAULT NULL, sourceid TEXT,version INTEGER NOT NULL DEFAULT 1,dirty INTEGER NOT NULL DEFAULT 0,title TEXT,title_res INTEGER,notes TEXT,system_id TEXT,deleted INTEGER NOT NULL DEFAULT 0,group_visible INTEGER NOT NULL DEFAULT 0,should_sync INTEGER NOT NULL DEFAULT 1,sync1 TEXT, sync2 TEXT, sync3 TEXT, sync4 TEXT );");
        db.execSQL("CREATE INDEX groups_source_id_index ON groups (sourceid, account_type, account_name);");
        db.execSQL("CREATE TABLE IF NOT EXISTS agg_exceptions (_id INTEGER PRIMARY KEY AUTOINCREMENT,type INTEGER NOT NULL, raw_contact_id1 INTEGER REFERENCES raw_contacts(_id), raw_contact_id2 INTEGER REFERENCES raw_contacts(_id));");
        db.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS aggregation_exception_index1 ON agg_exceptions (raw_contact_id1, raw_contact_id2);");
        db.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS aggregation_exception_index2 ON agg_exceptions (raw_contact_id2, raw_contact_id1);");
        db.execSQL("CREATE TABLE IF NOT EXISTS settings (account_name STRING NOT NULL,account_type STRING NOT NULL,ungrouped_visible INTEGER NOT NULL DEFAULT 0,should_sync INTEGER NOT NULL DEFAULT 1, PRIMARY KEY (account_name, account_type) ON CONFLICT REPLACE);");
        db.execSQL("CREATE TABLE calls (_id INTEGER PRIMARY KEY AUTOINCREMENT,number TEXT,date INTEGER,duration INTEGER,type INTEGER,new INTEGER,name TEXT,numbertype INTEGER,numberlabel TEXT);");
        db.execSQL("CREATE TABLE activities (_id INTEGER PRIMARY KEY AUTOINCREMENT,package_id INTEGER REFERENCES package(_id),mimetype_id INTEGER REFERENCES mimetype(_id) NOT NULL,raw_id TEXT,in_reply_to TEXT,author_contact_id INTEGER REFERENCES raw_contacts(_id),target_contact_id INTEGER REFERENCES raw_contacts(_id),published INTEGER NOT NULL,thread_published INTEGER NOT NULL,title TEXT NOT NULL,summary TEXT,link TEXT, thumbnail BLOB);");
        db.execSQL("CREATE TABLE status_updates (status_update_data_id INTEGER PRIMARY KEY REFERENCES data(_id),status TEXT,status_ts INTEGER,status_res_package TEXT, status_label INTEGER, status_icon INTEGER);");
        db.execSQL("CREATE TABLE properties (property_key TEXT PRIMARY KEY, property_value TEXT );");
        db.execSQL("CREATE TABLE accounts (account_name TEXT, account_type TEXT );");
        db.execSQL("INSERT INTO accounts VALUES(NULL, NULL)");
        ContactsDatabaseHelper.createContactsViews(db);
        ContactsDatabaseHelper.createGroupsView(db);
        ContactsDatabaseHelper.createContactEntitiesView(db);
        ContactsDatabaseHelper.createContactsTriggers(db);
        ContactsDatabaseHelper.createContactsIndexes(db);
        this.loadNicknameLookupTable(db);
        LegacyApiSupport.createDatabase(db);
        db.execSQL("ANALYZE;");
        this.updateSqliteStats(db);
        this.mReopenDatabase = true;
        ContentResolver.requestSync(null, (String)"com.android.contacts", (Bundle)new Bundle());
    }

    private static void createContactsTriggers(SQLiteDatabase db) {
        db.execSQL("DROP TRIGGER IF EXISTS raw_contacts_deleted;");
        db.execSQL("CREATE TRIGGER raw_contacts_deleted    BEFORE DELETE ON raw_contacts BEGIN    DELETE FROM data     WHERE raw_contact_id=OLD._id;   DELETE FROM agg_exceptions     WHERE raw_contact_id1=OLD._id        OR raw_contact_id2=OLD._id;   DELETE FROM contacts     WHERE _id=OLD.contact_id       AND (SELECT COUNT(*) FROM raw_contacts            WHERE contact_id=OLD.contact_id           )=1; END");
        db.execSQL("DROP TRIGGER IF EXISTS contacts_times_contacted;");
        db.execSQL("DROP TRIGGER IF EXISTS raw_contacts_times_contacted;");
        db.execSQL("DROP TRIGGER IF EXISTS raw_contacts_marked_deleted;");
        db.execSQL("CREATE TRIGGER raw_contacts_marked_deleted    AFTER UPDATE ON raw_contacts BEGIN    UPDATE raw_contacts     SET version=OLD.version+1      WHERE _id=OLD._id       AND NEW.deleted!= OLD.deleted; END");
        db.execSQL("DROP TRIGGER IF EXISTS data_updated;");
        db.execSQL("CREATE TRIGGER data_updated AFTER UPDATE ON data BEGIN    UPDATE data     SET data_version=OLD.data_version+1      WHERE _id=OLD._id;   UPDATE raw_contacts     SET version=version+1      WHERE _id=OLD.raw_contact_id; END");
        db.execSQL("DROP TRIGGER IF EXISTS data_deleted;");
        db.execSQL("CREATE TRIGGER data_deleted BEFORE DELETE ON data BEGIN    UPDATE raw_contacts     SET version=version+1      WHERE _id=OLD.raw_contact_id;   DELETE FROM phone_lookup     WHERE data_id=OLD._id;   DELETE FROM status_updates     WHERE status_update_data_id=OLD._id;   DELETE FROM name_lookup     WHERE data_id=OLD._id; END");
        db.execSQL("DROP TRIGGER IF EXISTS groups_updated1;");
        db.execSQL("CREATE TRIGGER groups_updated1    AFTER UPDATE ON groups BEGIN    UPDATE groups     SET version=OLD.version+1     WHERE _id=OLD._id; END");
    }

    private static void createContactsIndexes(SQLiteDatabase db) {
        db.execSQL("DROP INDEX IF EXISTS name_lookup_index");
        db.execSQL("CREATE INDEX name_lookup_index ON name_lookup (normalized_name,name_type, raw_contact_id, data_id);");
        db.execSQL("DROP INDEX IF EXISTS raw_contact_sort_key1_index");
        db.execSQL("CREATE INDEX raw_contact_sort_key1_index ON raw_contacts (contact_in_visible_group,sort_key);");
        db.execSQL("DROP INDEX IF EXISTS raw_contact_sort_key2_index");
        db.execSQL("CREATE INDEX raw_contact_sort_key2_index ON raw_contacts (contact_in_visible_group,sort_key_alt);");
    }

    private static void createContactsViews(SQLiteDatabase db) {
        db.execSQL("DROP VIEW IF EXISTS view_contacts;");
        db.execSQL("DROP VIEW IF EXISTS view_contacts_restricted;");
        db.execSQL("DROP VIEW IF EXISTS view_data;");
        db.execSQL("DROP VIEW IF EXISTS view_data_restricted;");
        db.execSQL("DROP VIEW IF EXISTS view_raw_contacts;");
        db.execSQL("DROP VIEW IF EXISTS view_raw_contacts_restricted;");
        String dataColumns = "is_primary, is_super_primary, data_version, package AS res_package,mimetype AS mimetype, data1, data2, data3, data4, data5, data6, data7, data8, data9, data10, data11, data12, data13, data14, data15, data_sync1, data_sync2, data_sync3, data_sync4";
        String syncColumns = "raw_contacts.account_name AS account_name,raw_contacts.account_type AS account_type,raw_contacts.sourceid AS sourceid,raw_contacts.name_verified AS name_verified,raw_contacts.version AS version,raw_contacts.dirty AS dirty,raw_contacts.sync1 AS sync1,raw_contacts.sync2 AS sync2,raw_contacts.sync3 AS sync3,raw_contacts.sync4 AS sync4";
        String contactOptionColumns = "contacts.custom_ringtone AS custom_ringtone,contacts.send_to_voicemail AS send_to_voicemail,contacts.last_time_contacted AS last_time_contacted,contacts.times_contacted AS times_contacted,contacts.starred AS starred";
        String contactNameColumns = "name_raw_contact.display_name_source AS display_name_source, name_raw_contact.display_name AS display_name, name_raw_contact.display_name_alt AS display_name_alt, name_raw_contact.phonetic_name AS phonetic_name, name_raw_contact.phonetic_name_style AS phonetic_name_style, name_raw_contact.sort_key AS sort_key, name_raw_contact.sort_key_alt AS sort_key_alt, name_raw_contact.contact_in_visible_group AS in_visible_group";
        String dataSelect = "SELECT data._id AS _id,raw_contact_id, raw_contacts.contact_id AS contact_id, " + syncColumns + ", " + dataColumns + ", " + contactOptionColumns + ", " + contactNameColumns + ", " + "lookup" + ", " + "photo_id" + ", " + "name_raw_contact_id" + "," + "status_update_id" + ", " + "groups" + "." + "sourceid" + " AS " + "group_sourceid" + " FROM " + "data" + " JOIN " + "mimetypes" + " ON (" + "data.mimetype_id" + "=" + "mimetypes._id" + ")" + " JOIN " + "raw_contacts" + " ON (" + "data.raw_contact_id" + "=" + "raw_contacts._id" + ")" + " JOIN " + "contacts" + " ON (" + "raw_contacts.contact_id" + "=" + "contacts._id" + ")" + " JOIN " + "raw_contacts" + " AS name_raw_contact ON(" + "name_raw_contact_id" + "=name_raw_contact." + "_id" + ")" + " LEFT OUTER JOIN " + "packages" + " ON (" + "data.package_id" + "=" + "packages._id" + ")" + " LEFT OUTER JOIN " + "groups" + " ON (" + "mimetypes.mimetype" + "='" + "vnd.android.cursor.item/group_membership" + "' AND " + "groups._id" + "=" + "data" + "." + "data1" + ")";
        db.execSQL("CREATE VIEW view_data AS " + dataSelect);
        db.execSQL("CREATE VIEW view_data_restricted AS " + dataSelect + " WHERE " + "raw_contacts.is_restricted" + "=0");
        String rawContactOptionColumns = "custom_ringtone,send_to_voicemail,last_time_contacted,times_contacted,starred";
        String rawContactsSelect = "SELECT raw_contacts._id AS _id,contact_id, aggregation_mode, deleted, display_name_source, display_name, display_name_alt, phonetic_name, phonetic_name_style, sort_key, sort_key_alt, " + rawContactOptionColumns + ", " + syncColumns + " FROM " + "raw_contacts";
        db.execSQL("CREATE VIEW view_raw_contacts AS " + rawContactsSelect);
        db.execSQL("CREATE VIEW view_raw_contacts_restricted AS " + rawContactsSelect + " WHERE " + "is_restricted" + "=0");
        String contactsColumns = "contacts.custom_ringtone AS custom_ringtone, " + contactNameColumns + ", " + "has_phone_number" + ", " + "lookup" + ", " + "photo_id" + ", " + "contacts.last_time_contacted" + " AS " + "last_time_contacted" + ", " + "contacts.send_to_voicemail" + " AS " + "send_to_voicemail" + ", " + "contacts.starred" + " AS " + "starred" + ", " + "contacts.times_contacted" + " AS " + "times_contacted" + ", " + "status_update_id";
        String contactsSelect = "SELECT contacts._id AS _id," + contactsColumns + " FROM " + "contacts" + " JOIN " + "raw_contacts" + " AS name_raw_contact ON(" + "name_raw_contact_id" + "=name_raw_contact." + "_id" + ")";
        db.execSQL("CREATE VIEW view_contacts AS " + contactsSelect);
        db.execSQL("CREATE VIEW view_contacts_restricted AS " + contactsSelect + " WHERE " + "single_is_restricted" + "=0");
    }

    private static void createGroupsView(SQLiteDatabase db) {
        db.execSQL("DROP VIEW IF EXISTS view_groups;");
        String groupsColumns = "account_name,account_type,sourceid,version,dirty,title,title_res,notes,system_id,deleted,group_visible,should_sync,sync1,sync2,sync3,sync4,package AS res_package";
        String groupsSelect = "SELECT groups._id AS _id," + groupsColumns + " FROM " + "groups LEFT OUTER JOIN packages ON (groups.package_id = packages._id)";
        db.execSQL("CREATE VIEW view_groups AS " + groupsSelect);
    }

    private static void createContactEntitiesView(SQLiteDatabase db) {
        db.execSQL("DROP VIEW IF EXISTS contact_entities_view;");
        db.execSQL("DROP VIEW IF EXISTS contact_entities_view_restricted;");
        String contactEntitiesSelect = "SELECT raw_contacts.account_name AS account_name,raw_contacts.account_type AS account_type,raw_contacts.sourceid AS sourceid,raw_contacts.version AS version,raw_contacts.dirty AS dirty,raw_contacts.deleted AS deleted,raw_contacts.name_verified AS name_verified,package AS res_package,contact_id, raw_contacts.sync1 AS sync1, raw_contacts.sync2 AS sync2, raw_contacts.sync3 AS sync3, raw_contacts.sync4 AS sync4, mimetype, data1, data2, data3, data4, data5, data6, data7, data8, data9, data10, data11, data12, data13, data14, data15, data_sync1, data_sync2, data_sync3, data_sync4, raw_contacts._id AS _id, is_primary, is_super_primary, data_version, data._id AS data_id,raw_contacts.starred AS starred,raw_contacts.is_restricted AS is_restricted,groups.sourceid AS group_sourceid FROM raw_contacts LEFT OUTER JOIN data ON (data.raw_contact_id=raw_contacts._id) LEFT OUTER JOIN packages ON (data.package_id=packages._id) LEFT OUTER JOIN mimetypes ON (data.mimetype_id=mimetypes._id) LEFT OUTER JOIN groups ON (mimetypes.mimetype='vnd.android.cursor.item/group_membership' AND groups._id=data.data1)";
        db.execSQL("CREATE VIEW contact_entities_view AS " + contactEntitiesSelect);
        db.execSQL("CREATE VIEW contact_entities_view_restricted AS " + contactEntitiesSelect + " WHERE " + "is_restricted" + "=0");
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion < 99) {
            Log.i((String)TAG, (String)("Upgrading from version " + oldVersion + " to " + newVersion + ", data will be lost!"));
            db.execSQL("DROP TABLE IF EXISTS contacts;");
            db.execSQL("DROP TABLE IF EXISTS raw_contacts;");
            db.execSQL("DROP TABLE IF EXISTS packages;");
            db.execSQL("DROP TABLE IF EXISTS mimetypes;");
            db.execSQL("DROP TABLE IF EXISTS data;");
            db.execSQL("DROP TABLE IF EXISTS phone_lookup;");
            db.execSQL("DROP TABLE IF EXISTS name_lookup;");
            db.execSQL("DROP TABLE IF EXISTS nickname_lookup;");
            db.execSQL("DROP TABLE IF EXISTS groups;");
            db.execSQL("DROP TABLE IF EXISTS activities;");
            db.execSQL("DROP TABLE IF EXISTS calls;");
            db.execSQL("DROP TABLE IF EXISTS settings;");
            db.execSQL("DROP TABLE IF EXISTS status_updates;");
            db.execSQL("DROP TABLE IF EXISTS agg_exceptions;");
            this.onCreate(db);
            return;
        }
        Log.i((String)TAG, (String)("Upgrading from version " + oldVersion + " to " + newVersion));
        boolean upgradeViewsAndTriggers = false;
        boolean upgradeNameLookup = false;
        if (oldVersion == 99) {
            upgradeViewsAndTriggers = true;
            ++oldVersion;
        }
        if (oldVersion == 100) {
            db.execSQL("CREATE INDEX IF NOT EXISTS mimetypes_mimetype_index ON mimetypes (mimetype,_id);");
            this.updateIndexStats(db, "mimetypes", "mimetypes_mimetype_index", "50 1 1");
            upgradeViewsAndTriggers = true;
            ++oldVersion;
        }
        if (oldVersion == 101) {
            upgradeViewsAndTriggers = true;
            ++oldVersion;
        }
        if (oldVersion == 102) {
            upgradeViewsAndTriggers = true;
            ++oldVersion;
        }
        if (oldVersion == 103) {
            upgradeViewsAndTriggers = true;
            ++oldVersion;
        }
        if (oldVersion == 104 || oldVersion == 201) {
            LegacyApiSupport.createSettingsTable(db);
            upgradeViewsAndTriggers = true;
            ++oldVersion;
        }
        if (oldVersion == 105) {
            this.upgradeToVersion202(db);
            upgradeNameLookup = true;
            oldVersion = 202;
        }
        if (oldVersion == 202) {
            this.upgradeToVersion203(db);
            upgradeViewsAndTriggers = true;
            ++oldVersion;
        }
        if (oldVersion == 203) {
            upgradeViewsAndTriggers = true;
            ++oldVersion;
        }
        if (oldVersion == 204) {
            this.upgradeToVersion205(db);
            upgradeViewsAndTriggers = true;
            ++oldVersion;
        }
        if (oldVersion == 205) {
            this.upgrateToVersion206(db);
            upgradeViewsAndTriggers = true;
            ++oldVersion;
        }
        if (oldVersion == 206) {
            this.upgradeToVersion300(db);
            oldVersion = 300;
        }
        if (oldVersion == 300) {
            upgradeViewsAndTriggers = true;
            oldVersion = 301;
        }
        if (oldVersion == 301) {
            upgradeViewsAndTriggers = true;
            oldVersion = 302;
        }
        if (oldVersion == 302) {
            this.upgradeEmailToVersion303(db);
            this.upgradeNicknameToVersion303(db);
            oldVersion = 303;
        }
        if (oldVersion == 303) {
            this.upgradeToVersion304(db);
            oldVersion = 304;
        }
        if (oldVersion == 304) {
            upgradeNameLookup = true;
            oldVersion = 305;
        }
        if (oldVersion == 305) {
            this.upgradeToVersion306(db);
            oldVersion = 306;
        }
        if (oldVersion == 306) {
            this.upgradeToVersion307(db);
            oldVersion = 307;
        }
        if (oldVersion == 307) {
            this.upgradeToVersion308(db);
            oldVersion = 308;
        }
        if (oldVersion < 350) {
            upgradeViewsAndTriggers = true;
            oldVersion = 351;
        }
        if (oldVersion == 351) {
            upgradeNameLookup = true;
            oldVersion = 352;
        }
        if (oldVersion == 352) {
            this.upgradeToVersion353(db);
            oldVersion = 353;
        }
        if (upgradeViewsAndTriggers) {
            ContactsDatabaseHelper.createContactsViews(db);
            ContactsDatabaseHelper.createGroupsView(db);
            ContactsDatabaseHelper.createContactEntitiesView(db);
            ContactsDatabaseHelper.createContactsTriggers(db);
            ContactsDatabaseHelper.createContactsIndexes(db);
            LegacyApiSupport.createViews(db);
            this.updateSqliteStats(db);
            this.mReopenDatabase = true;
        }
        if (upgradeNameLookup) {
            this.rebuildNameLookup(db);
        }
        if (oldVersion != newVersion) {
            throw new IllegalStateException("error upgrading the database to version " + newVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeToVersion202(SQLiteDatabase db) {
        db.execSQL("ALTER TABLE phone_lookup ADD min_match TEXT;");
        db.execSQL("CREATE INDEX phone_lookup_min_match_index ON phone_lookup (min_match,raw_contact_id,data_id);");
        this.updateIndexStats(db, "phone_lookup", "phone_lookup_min_match_index", "10000 2 2 1");
        SQLiteStatement update = db.compileStatement("UPDATE phone_lookup SET min_match=? WHERE data_id=?");
        Cursor c = db.query("phone_lookup JOIN data ON (data_id=data._id)", new String[]{"_id", "data1"}, null, null, null, null, null);
        try {
            while (c.moveToNext()) {
                long dataId = c.getLong(0);
                String number = c.getString(1);
                if (TextUtils.isEmpty((CharSequence)number)) continue;
                update.bindString(1, PhoneNumberUtils.toCallerIDMinMatch((String)number));
                update.bindLong(2, dataId);
                update.execute();
            }
        }
        finally {
            c.close();
        }
    }

    private void upgradeToVersion203(SQLiteDatabase db) {
        db.execSQL("DELETE FROM raw_contacts WHERE contact_id NOT NULL AND contact_id NOT IN (SELECT _id FROM contacts)");
        db.execSQL("ALTER TABLE contacts ADD name_raw_contact_id INTEGER REFERENCES raw_contacts(_id)");
        db.execSQL("ALTER TABLE raw_contacts ADD contact_in_visible_group INTEGER NOT NULL DEFAULT 0");
        db.execSQL("UPDATE contacts SET name_raw_contact_id=( SELECT _id FROM raw_contacts WHERE contact_id=contacts._id AND raw_contacts.display_name=contacts.display_name ORDER BY _id LIMIT 1)");
        db.execSQL("CREATE INDEX contacts_name_raw_contact_id_index ON contacts (name_raw_contact_id);");
        db.execSQL("UPDATE contacts SET name_raw_contact_id=( SELECT _id FROM raw_contacts WHERE contact_id=contacts._id ORDER BY _id LIMIT 1) WHERE name_raw_contact_id IS NULL");
        db.execSQL("UPDATE contacts SET display_name=NULL");
        db.execSQL("UPDATE raw_contacts SET contact_in_visible_group=(SELECT in_visible_group FROM contacts WHERE _id=contact_id) WHERE contact_id NOT NULL");
        db.execSQL("CREATE INDEX raw_contact_sort_key1_index ON raw_contacts (contact_in_visible_group,display_name COLLATE LOCALIZED ASC);");
        db.execSQL("DROP INDEX contacts_visible_index");
        db.execSQL("CREATE INDEX contacts_visible_index ON contacts (in_visible_group);");
    }

    private void upgradeToVersion205(SQLiteDatabase db) {
        db.execSQL("ALTER TABLE raw_contacts ADD display_name_alt TEXT;");
        db.execSQL("ALTER TABLE raw_contacts ADD phonetic_name TEXT;");
        db.execSQL("ALTER TABLE raw_contacts ADD phonetic_name_style INTEGER;");
        db.execSQL("ALTER TABLE raw_contacts ADD sort_key TEXT COLLATE PHONEBOOK;");
        db.execSQL("ALTER TABLE raw_contacts ADD sort_key_alt TEXT COLLATE PHONEBOOK;");
        Locale locale = Locale.getDefault();
        NameSplitter splitter = this.createNameSplitter();
        SQLiteStatement rawContactUpdate = db.compileStatement("UPDATE raw_contacts SET display_name=?,display_name_alt=?,phonetic_name=?,phonetic_name_style=?,sort_key=?,sort_key_alt=? WHERE _id=?");
        this.upgradeStructuredNamesToVersion205(db, rawContactUpdate, splitter);
        this.upgradeOrganizationsToVersion205(db, rawContactUpdate, splitter);
        db.execSQL("DROP INDEX raw_contact_sort_key1_index");
        db.execSQL("CREATE INDEX raw_contact_sort_key1_index ON raw_contacts (contact_in_visible_group,sort_key);");
        db.execSQL("CREATE INDEX raw_contact_sort_key2_index ON raw_contacts (contact_in_visible_group,sort_key_alt);");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeStructuredNamesToVersion205(SQLiteDatabase db, SQLiteStatement rawContactUpdate, NameSplitter splitter) {
        long mMimeType;
        try {
            mMimeType = DatabaseUtils.longForQuery((SQLiteDatabase)db, (String)"SELECT _id FROM mimetypes WHERE mimetype='vnd.android.cursor.item/name'", null);
        }
        catch (SQLiteDoneException e) {
            return;
        }
        SQLiteStatement structuredNameUpdate = db.compileStatement("UPDATE data SET data10=?,data1=?,data11=? WHERE _id=?");
        NameSplitter.Name name = new NameSplitter.Name();
        StringBuilder sb = new StringBuilder();
        Cursor cursor = db.query("data JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id)", StructName205Query.COLUMNS, "mimetype_id=" + mMimeType, null, null, null, null);
        try {
            while (cursor.moveToNext()) {
                long dataId = cursor.getLong(0);
                long rawContactId = cursor.getLong(1);
                int displayNameSource = cursor.getInt(2);
                String displayName = cursor.getString(3);
                name.clear();
                name.prefix = cursor.getString(4);
                name.givenNames = cursor.getString(5);
                name.middleName = cursor.getString(6);
                name.familyName = cursor.getString(7);
                name.suffix = cursor.getString(8);
                name.phoneticFamilyName = cursor.getString(9);
                name.phoneticMiddleName = cursor.getString(10);
                name.phoneticGivenName = cursor.getString(11);
                this.upgradeNameToVersion205(dataId, rawContactId, displayNameSource, displayName, name, structuredNameUpdate, rawContactUpdate, splitter, sb);
            }
        }
        finally {
            cursor.close();
        }
    }

    private void upgradeNameToVersion205(long dataId, long rawContactId, int displayNameSource, String currentDisplayName, NameSplitter.Name name, SQLiteStatement structuredNameUpdate, SQLiteStatement rawContactUpdate, NameSplitter splitter, StringBuilder sb) {
        splitter.guessNameStyle(name);
        int unadjustedFullNameStyle = name.fullNameStyle;
        name.fullNameStyle = splitter.getAdjustedFullNameStyle(name.fullNameStyle);
        String displayName = splitter.join(name, true);
        structuredNameUpdate.bindLong(1, (long)unadjustedFullNameStyle);
        DatabaseUtils.bindObjectToProgram((SQLiteProgram)structuredNameUpdate, (int)2, (Object)displayName);
        structuredNameUpdate.bindLong(3, (long)name.phoneticNameStyle);
        structuredNameUpdate.bindLong(4, dataId);
        structuredNameUpdate.execute();
        if (displayNameSource == 40) {
            String displayNameAlternative = splitter.join(name, false);
            String phoneticName = splitter.joinPhoneticName(name);
            String sortKey = null;
            String sortKeyAlternative = null;
            if (phoneticName != null) {
                sortKey = sortKeyAlternative = phoneticName;
            } else if (name.fullNameStyle == 3 || name.fullNameStyle == 2) {
                sortKey = sortKeyAlternative = ContactLocaleUtils.getIntance().getSortKey(displayName, name.fullNameStyle);
            }
            if (sortKey == null) {
                sortKey = displayName;
                sortKeyAlternative = displayNameAlternative;
            }
            this.updateRawContact205(rawContactUpdate, rawContactId, displayName, displayNameAlternative, name.phoneticNameStyle, phoneticName, sortKey, sortKeyAlternative);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeOrganizationsToVersion205(SQLiteDatabase db, SQLiteStatement rawContactUpdate, NameSplitter splitter) {
        long mimeType = this.lookupMimeTypeId(db, "vnd.android.cursor.item/organization");
        SQLiteStatement organizationUpdate = db.compileStatement("UPDATE data SET data10=? WHERE _id=?");
        Cursor cursor = db.query("data JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id)", Organization205Query.COLUMNS, "mimetype_id=" + mimeType + " AND " + "display_name_source" + "=" + 30, null, null, null, null);
        try {
            while (cursor.moveToNext()) {
                long dataId = cursor.getLong(0);
                long rawContactId = cursor.getLong(1);
                String company = cursor.getString(2);
                String phoneticName = cursor.getString(3);
                int phoneticNameStyle = splitter.guessPhoneticNameStyle(phoneticName);
                organizationUpdate.bindLong(1, (long)phoneticNameStyle);
                organizationUpdate.bindLong(2, dataId);
                organizationUpdate.execute();
                String sortKey = null;
                if (phoneticName == null && company != null) {
                    int nameStyle = splitter.guessFullNameStyle(company);
                    if ((nameStyle = splitter.getAdjustedFullNameStyle(nameStyle)) == 3 || nameStyle == 2) {
                        sortKey = ContactLocaleUtils.getIntance().getSortKey(company, nameStyle);
                    }
                }
                if (sortKey == null) {
                    sortKey = company;
                }
                this.updateRawContact205(rawContactUpdate, rawContactId, company, company, phoneticNameStyle, phoneticName, sortKey, sortKey);
            }
        }
        finally {
            cursor.close();
        }
    }

    private void updateRawContact205(SQLiteStatement rawContactUpdate, long rawContactId, String displayName, String displayNameAlternative, int phoneticNameStyle, String phoneticName, String sortKeyPrimary, String sortKeyAlternative) {
        this.bindString(rawContactUpdate, 1, displayName);
        this.bindString(rawContactUpdate, 2, displayNameAlternative);
        this.bindString(rawContactUpdate, 3, phoneticName);
        rawContactUpdate.bindLong(4, (long)phoneticNameStyle);
        this.bindString(rawContactUpdate, 5, sortKeyPrimary);
        this.bindString(rawContactUpdate, 6, sortKeyAlternative);
        rawContactUpdate.bindLong(7, rawContactId);
        rawContactUpdate.execute();
    }

    private void upgrateToVersion206(SQLiteDatabase db) {
        db.execSQL("ALTER TABLE raw_contacts ADD name_verified INTEGER NOT NULL DEFAULT 0;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeToVersion300(SQLiteDatabase db) {
        long mimeType = this.lookupMimeTypeId(db, "vnd.android.cursor.item/organization");
        if (mimeType == -1L) {
            return;
        }
        ContentValues values = new ContentValues();
        Cursor cursor = db.query("data", Organization300Query.COLUMNS, "mimetype_id=?", new String[]{String.valueOf(mimeType)}, null, null, null);
        try {
            while (cursor.moveToNext()) {
                long dataId = cursor.getLong(0);
                long rawContactId = cursor.getLong(1);
                String company = cursor.getString(2);
                String title = cursor.getString(3);
                db.delete("name_lookup", "data_id=?", new String[]{String.valueOf(dataId)});
                values.put("data_id", Long.valueOf(dataId));
                values.put("raw_contact_id", Long.valueOf(rawContactId));
                values.put("name_type", Integer.valueOf(5));
                if (!TextUtils.isEmpty((CharSequence)company)) {
                    values.put("normalized_name", NameNormalizer.normalize(company));
                    db.insert("name_lookup", null, values);
                }
                if (TextUtils.isEmpty((CharSequence)title)) continue;
                values.put("normalized_name", NameNormalizer.normalize(title));
                db.insert("name_lookup", null, values);
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeEmailToVersion303(SQLiteDatabase db) {
        long mimeTypeId = this.lookupMimeTypeId(db, "vnd.android.cursor.item/email_v2");
        if (mimeTypeId == -1L) {
            return;
        }
        ContentValues values = new ContentValues();
        Cursor cursor = db.query("data", Upgrade303Query.COLUMNS, "mimetype_id=? AND _id NOT IN (SELECT data_id FROM name_lookup) AND data1 NOT NULL", new String[]{String.valueOf(mimeTypeId)}, null, null, null);
        try {
            while (cursor.moveToNext()) {
                long dataId = cursor.getLong(0);
                long rawContactId = cursor.getLong(1);
                String value = cursor.getString(2);
                if ((value = this.extractHandleFromEmailAddress(value)) == null) continue;
                values.put("data_id", Long.valueOf(dataId));
                values.put("raw_contact_id", Long.valueOf(rawContactId));
                values.put("name_type", Integer.valueOf(4));
                values.put("normalized_name", NameNormalizer.normalize(value));
                db.insert("name_lookup", null, values);
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeNicknameToVersion303(SQLiteDatabase db) {
        long mimeTypeId = this.lookupMimeTypeId(db, "vnd.android.cursor.item/nickname");
        if (mimeTypeId == -1L) {
            return;
        }
        ContentValues values = new ContentValues();
        Cursor cursor = db.query("data", Upgrade303Query.COLUMNS, "mimetype_id=? AND _id NOT IN (SELECT data_id FROM name_lookup) AND data1 NOT NULL", new String[]{String.valueOf(mimeTypeId)}, null, null, null);
        try {
            while (cursor.moveToNext()) {
                long dataId = cursor.getLong(0);
                long rawContactId = cursor.getLong(1);
                String value = cursor.getString(2);
                values.put("data_id", Long.valueOf(dataId));
                values.put("raw_contact_id", Long.valueOf(rawContactId));
                values.put("name_type", Integer.valueOf(3));
                values.put("normalized_name", NameNormalizer.normalize(value));
                db.insert("name_lookup", null, values);
            }
        }
        finally {
            cursor.close();
        }
    }

    private void upgradeToVersion304(SQLiteDatabase db) {
        db.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS mime_type ON mimetypes (mimetype);");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeToVersion306(SQLiteDatabase db) {
        StringBuilder lookupKeyBuilder = new StringBuilder();
        SQLiteStatement updateStatement = db.compileStatement("UPDATE contacts SET lookup=? WHERE _id=?");
        Cursor contactIdCursor = db.rawQuery("SELECT DISTINCT contact_id FROM raw_contacts WHERE deleted=0 AND account_type='com.android.exchange'", null);
        try {
            while (contactIdCursor.moveToNext()) {
                long contactId = contactIdCursor.getLong(0);
                lookupKeyBuilder.setLength(0);
                Cursor c = db.rawQuery("SELECT account_type, account_name, _id, sourceid, display_name FROM raw_contacts WHERE contact_id=? ORDER BY _id", new String[]{String.valueOf(contactId)});
                try {
                    while (c.moveToNext()) {
                        ContactLookupKey.appendToLookupKey(lookupKeyBuilder, c.getString(0), c.getString(1), c.getLong(2), c.getString(3), c.getString(4));
                    }
                }
                finally {
                    c.close();
                }
                if (lookupKeyBuilder.length() == 0) {
                    updateStatement.bindNull(1);
                } else {
                    updateStatement.bindString(1, Uri.encode((String)lookupKeyBuilder.toString()));
                }
                updateStatement.bindLong(2, contactId);
                updateStatement.execute();
            }
        }
        finally {
            updateStatement.close();
            contactIdCursor.close();
        }
    }

    private void upgradeToVersion307(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE properties (property_key TEXT PRIMARY_KEY, property_value TEXT);");
    }

    private void upgradeToVersion308(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE accounts (account_name TEXT, account_type TEXT );");
        db.execSQL("INSERT INTO accounts SELECT DISTINCT account_name, account_type FROM raw_contacts");
    }

    private void upgradeToVersion353(SQLiteDatabase db) {
        db.execSQL("DELETE FROM contacts WHERE NOT EXISTS (SELECT 1 FROM raw_contacts WHERE contact_id=contacts._id)");
    }

    private void rebuildNameLookup(SQLiteDatabase db) {
        db.execSQL("DROP INDEX IF EXISTS name_lookup_index");
        this.insertNameLookup(db);
        ContactsDatabaseHelper.createContactsIndexes(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(ContactsProvider2 provider, Locale locale) {
        Log.i((String)TAG, (String)("Switching to locale " + locale));
        long start = SystemClock.uptimeMillis();
        SQLiteDatabase db = this.getWritableDatabase();
        db.setLocale(locale);
        db.beginTransaction();
        try {
            db.execSQL("DROP INDEX raw_contact_sort_key1_index");
            db.execSQL("DROP INDEX raw_contact_sort_key2_index");
            db.execSQL("DROP INDEX IF EXISTS name_lookup_index");
            this.loadNicknameLookupTable(db);
            this.insertNameLookup(db);
            this.rebuildSortKeys(db, provider);
            ContactsDatabaseHelper.createContactsIndexes(db);
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
        Log.i((String)TAG, (String)("Locale change completed in " + (SystemClock.uptimeMillis() - start) + "ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildSortKeys(SQLiteDatabase db, ContactsProvider2 provider) {
        Cursor cursor = db.query("raw_contacts", new String[]{"_id"}, null, null, null, null, null);
        try {
            while (cursor.moveToNext()) {
                long rawContactId = cursor.getLong(0);
                provider.updateRawContactDisplayName(db, rawContactId);
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNameLookup(SQLiteDatabase db) {
        db.execSQL("DELETE FROM name_lookup");
        SQLiteStatement nameLookupInsert = db.compileStatement("INSERT OR IGNORE INTO name_lookup(raw_contact_id,data_id,name_type,normalized_name) VALUES (?,?,?,?)");
        try {
            this.insertStructuredNameLookup(db, nameLookupInsert);
            this.insertOrganizationLookup(db, nameLookupInsert);
            this.insertEmailLookup(db, nameLookupInsert);
            this.insertNicknameLookup(db, nameLookupInsert);
        }
        finally {
            nameLookupInsert.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertStructuredNameLookup(SQLiteDatabase db, SQLiteStatement nameLookupInsert) {
        NameSplitter nameSplitter = this.createNameSplitter();
        StructuredNameLookupBuilder nameLookupBuilder = new StructuredNameLookupBuilder(nameSplitter, new CommonNicknameCache(db), nameLookupInsert);
        long mimeTypeId = this.lookupMimeTypeId(db, "vnd.android.cursor.item/name");
        Cursor cursor = db.query("data", StructuredNameQuery.COLUMNS, "mimetype_id=? AND data1 NOT NULL", new String[]{String.valueOf(mimeTypeId)}, null, null, null);
        try {
            while (cursor.moveToNext()) {
                long dataId = cursor.getLong(0);
                long rawContactId = cursor.getLong(1);
                String name = cursor.getString(2);
                int fullNameStyle = nameSplitter.guessFullNameStyle(name);
                fullNameStyle = nameSplitter.getAdjustedFullNameStyle(fullNameStyle);
                nameLookupBuilder.insertNameLookup(rawContactId, dataId, name, fullNameStyle);
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertOrganizationLookup(SQLiteDatabase db, SQLiteStatement nameLookupInsert) {
        long mimeTypeId = this.lookupMimeTypeId(db, "vnd.android.cursor.item/organization");
        Cursor cursor = db.query("data", OrganizationQuery.COLUMNS, "mimetype_id=? AND data1 NOT NULL", new String[]{String.valueOf(mimeTypeId)}, null, null, null);
        try {
            while (cursor.moveToNext()) {
                long dataId = cursor.getLong(0);
                long rawContactId = cursor.getLong(1);
                String organization = cursor.getString(2);
                String title = cursor.getString(3);
                this.insertNameLookup(nameLookupInsert, rawContactId, dataId, 5, organization);
                this.insertNameLookup(nameLookupInsert, rawContactId, dataId, 5, title);
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertEmailLookup(SQLiteDatabase db, SQLiteStatement nameLookupInsert) {
        long mimeTypeId = this.lookupMimeTypeId(db, "vnd.android.cursor.item/email_v2");
        Cursor cursor = db.query("data", EmailQuery.COLUMNS, "mimetype_id=? AND data1 NOT NULL", new String[]{String.valueOf(mimeTypeId)}, null, null, null);
        try {
            while (cursor.moveToNext()) {
                long dataId = cursor.getLong(0);
                long rawContactId = cursor.getLong(1);
                String address = cursor.getString(2);
                address = this.extractHandleFromEmailAddress(address);
                this.insertNameLookup(nameLookupInsert, rawContactId, dataId, 4, address);
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNicknameLookup(SQLiteDatabase db, SQLiteStatement nameLookupInsert) {
        long mimeTypeId = this.lookupMimeTypeId(db, "vnd.android.cursor.item/nickname");
        Cursor cursor = db.query("data", NicknameQuery.COLUMNS, "mimetype_id=? AND data1 NOT NULL", new String[]{String.valueOf(mimeTypeId)}, null, null, null);
        try {
            while (cursor.moveToNext()) {
                long dataId = cursor.getLong(0);
                long rawContactId = cursor.getLong(1);
                String nickname = cursor.getString(2);
                this.insertNameLookup(nameLookupInsert, rawContactId, dataId, 3, nickname);
            }
        }
        finally {
            cursor.close();
        }
    }

    public void insertNameLookup(SQLiteStatement stmt, long rawContactId, long dataId, int lookupType, String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return;
        }
        String normalized = NameNormalizer.normalize(name);
        if (TextUtils.isEmpty((CharSequence)normalized)) {
            return;
        }
        this.insertNormalizedNameLookup(stmt, rawContactId, dataId, lookupType, normalized);
    }

    private void insertNormalizedNameLookup(SQLiteStatement stmt, long rawContactId, long dataId, int lookupType, String normalizedName) {
        stmt.bindLong(1, rawContactId);
        stmt.bindLong(2, dataId);
        stmt.bindLong(3, (long)lookupType);
        stmt.bindString(4, normalizedName);
        stmt.executeInsert();
    }

    public String extractHandleFromEmailAddress(String email) {
        Rfc822Token[] tokens = Rfc822Tokenizer.tokenize((CharSequence)email);
        if (tokens.length == 0) {
            return null;
        }
        String address = tokens[0].getAddress();
        int at = address.indexOf(64);
        if (at != -1) {
            return address.substring(0, at);
        }
        return null;
    }

    public String extractAddressFromEmailAddress(String email) {
        Rfc822Token[] tokens = Rfc822Tokenizer.tokenize((CharSequence)email);
        if (tokens.length == 0) {
            return null;
        }
        return tokens[0].getAddress();
    }

    private long lookupMimeTypeId(SQLiteDatabase db, String mimeType) {
        try {
            return DatabaseUtils.longForQuery((SQLiteDatabase)db, (String)("SELECT _id FROM mimetypes WHERE mimetype='" + mimeType + "'"), null);
        }
        catch (SQLiteDoneException e) {
            return -1L;
        }
    }

    private void bindString(SQLiteStatement stmt, int index, String value) {
        if (value == null) {
            stmt.bindNull(index);
        } else {
            stmt.bindString(index, value);
        }
    }

    private void updateSqliteStats(SQLiteDatabase db) {
        try {
            this.updateIndexStats(db, "contacts", "contacts_restricted_index", "10000 9000");
            this.updateIndexStats(db, "contacts", "contacts_has_phone_index", "10000 500");
            this.updateIndexStats(db, "contacts", "contacts_visible_index", "10000 500 1");
            this.updateIndexStats(db, "raw_contacts", "raw_contacts_source_id_index", "10000 1 1 1");
            this.updateIndexStats(db, "raw_contacts", "raw_contacts_contact_id_index", "10000 2");
            this.updateIndexStats(db, "name_lookup", "name_lookup_raw_contact_id_index", "10000 3");
            this.updateIndexStats(db, "name_lookup", "name_lookup_index", "10000 3 2 2 1");
            this.updateIndexStats(db, "name_lookup", "sqlite_autoindex_name_lookup_1", "10000 3 2 1");
            this.updateIndexStats(db, "phone_lookup", "phone_lookup_index", "10000 2 2 1");
            this.updateIndexStats(db, "phone_lookup", "phone_lookup_min_match_index", "10000 2 2 1");
            this.updateIndexStats(db, "data", "data_mimetype_data1_index", "60000 5000 2");
            this.updateIndexStats(db, "data", "data_raw_contact_id", "60000 10");
            this.updateIndexStats(db, "groups", "groups_source_id_index", "50 1 1 1");
            this.updateIndexStats(db, "nickname_lookup", "sqlite_autoindex_name_lookup_1", "500 2 1");
        }
        catch (SQLException e) {
            Log.e((String)TAG, (String)"Could not update index stats", (Throwable)e);
        }
    }

    private void updateIndexStats(SQLiteDatabase db, String table, String index, String stats) {
        db.execSQL("DELETE FROM sqlite_stat1 WHERE tbl='" + table + "' AND idx='" + index + "';");
        db.execSQL("INSERT INTO sqlite_stat1 (tbl,idx,stat) VALUES ('" + table + "','" + index + "','" + stats + "');");
    }

    public synchronized SQLiteDatabase getWritableDatabase() {
        SQLiteDatabase db = super.getWritableDatabase();
        if (this.mReopenDatabase) {
            this.mReopenDatabase = false;
            this.close();
            db = super.getWritableDatabase();
        }
        return db;
    }

    public void wipeData() {
        SQLiteDatabase db = this.getWritableDatabase();
        db.execSQL("DELETE FROM accounts;");
        db.execSQL("INSERT INTO accounts VALUES(NULL, NULL)");
        db.execSQL("DELETE FROM contacts;");
        db.execSQL("DELETE FROM raw_contacts;");
        db.execSQL("DELETE FROM data;");
        db.execSQL("DELETE FROM phone_lookup;");
        db.execSQL("DELETE FROM name_lookup;");
        db.execSQL("DELETE FROM groups;");
        db.execSQL("DELETE FROM agg_exceptions;");
        db.execSQL("DELETE FROM settings;");
        db.execSQL("DELETE FROM activities;");
        db.execSQL("DELETE FROM calls;");
    }

    public NameSplitter createNameSplitter() {
        return new NameSplitter(this.mContext.getString(17039529), this.mContext.getString(17039531), this.mContext.getString(17039530), this.mContext.getString(17039532), Locale.getDefault());
    }

    public static int getUidForPackageName(PackageManager pm, String packageName) {
        try {
            ApplicationInfo clientInfo = pm.getApplicationInfo(packageName, 0);
            return clientInfo.uid;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private long getCachedId(SQLiteStatement query, SQLiteStatement insert, String value, HashMap<String, Long> cache) {
        if (cache.containsKey(value)) {
            return cache.get(value);
        }
        long id = -1L;
        try {
            DatabaseUtils.bindObjectToProgram((SQLiteProgram)query, (int)1, (Object)value);
            id = query.simpleQueryForLong();
        }
        catch (SQLiteDoneException e) {
            DatabaseUtils.bindObjectToProgram((SQLiteProgram)insert, (int)1, (Object)value);
            id = insert.executeInsert();
        }
        if (id != -1L) {
            cache.put(value, id);
            return id;
        }
        throw new IllegalStateException("Couldn't find or create internal lookup table entry for value " + value);
    }

    public long getPackageId(String packageName) {
        this.getReadableDatabase();
        return this.getCachedId(this.mPackageQuery, this.mPackageInsert, packageName, this.mPackageCache);
    }

    public long getMimeTypeId(String mimetype) {
        this.getReadableDatabase();
        return this.getMimeTypeIdNoDbCheck(mimetype);
    }

    private long getMimeTypeIdNoDbCheck(String mimetype) {
        return this.getCachedId(this.mMimetypeQuery, this.mMimetypeInsert, mimetype, this.mMimetypeCache);
    }

    public String getDataMimeType(long dataId) {
        this.getReadableDatabase();
        try {
            DatabaseUtils.bindObjectToProgram((SQLiteProgram)this.mDataMimetypeQuery, (int)1, (Object)dataId);
            String mimetype = this.mDataMimetypeQuery.simpleQueryForString();
            return mimetype;
        }
        catch (SQLiteDoneException e) {
            return null;
        }
    }

    public String getActivityMimeType(long activityId) {
        this.getReadableDatabase();
        try {
            DatabaseUtils.bindObjectToProgram((SQLiteProgram)this.mActivitiesMimetypeQuery, (int)1, (Object)activityId);
            String mimetype = this.mActivitiesMimetypeQuery.simpleQueryForString();
            return mimetype;
        }
        catch (SQLiteDoneException e) {
            return null;
        }
    }

    public void updateAllVisible() {
        SQLiteDatabase db = this.getWritableDatabase();
        long groupMembershipMimetypeId = this.getMimeTypeId("vnd.android.cursor.item/group_membership");
        String[] selectionArgs = new String[]{String.valueOf(groupMembershipMimetypeId)};
        ContentValues values = new ContentValues();
        values.put("in_visible_group", Integer.valueOf(1));
        int countMadeVisible = db.update("contacts", values, "in_visible_group=0 AND (SELECT MAX((SELECT (CASE WHEN (CASE WHEN raw_contacts.account_name IS NULL AND raw_contacts.account_type IS NULL THEN 1  WHEN COUNT(groups._id)=0 THEN ungrouped_visible ELSE MAX(group_visible)END)=1 THEN 1 ELSE 0 END) FROM raw_contacts LEFT OUTER JOIN settings ON (raw_contacts.account_name = settings.account_name AND raw_contacts.account_type = settings.account_type) LEFT OUTER JOIN data ON (data.mimetype_id=? AND data.raw_contact_id = raw_contacts._id) LEFT OUTER JOIN groups ON (groups._id = data.data1) WHERE raw_contacts._id=outer_raw_contacts._id)) FROM raw_contacts AS outer_raw_contacts WHERE contact_id=contacts._id GROUP BY contact_id)=1", selectionArgs);
        values.put("in_visible_group", Integer.valueOf(0));
        int countMadeInvisible = db.update("contacts", values, "in_visible_group=1 AND (SELECT MAX((SELECT (CASE WHEN (CASE WHEN raw_contacts.account_name IS NULL AND raw_contacts.account_type IS NULL THEN 1  WHEN COUNT(groups._id)=0 THEN ungrouped_visible ELSE MAX(group_visible)END)=1 THEN 1 ELSE 0 END) FROM raw_contacts LEFT OUTER JOIN settings ON (raw_contacts.account_name = settings.account_name AND raw_contacts.account_type = settings.account_type) LEFT OUTER JOIN data ON (data.mimetype_id=? AND data.raw_contact_id = raw_contacts._id) LEFT OUTER JOIN groups ON (groups._id = data.data1) WHERE raw_contacts._id=outer_raw_contacts._id)) FROM raw_contacts AS outer_raw_contacts WHERE contact_id=contacts._id GROUP BY contact_id)=0", selectionArgs);
        if (countMadeVisible != 0 || countMadeInvisible != 0) {
            this.mVisibleUpdateRawContacts.execute();
        }
    }

    public void updateContactVisible(long contactId) {
        long groupMembershipMimetypeId = this.getMimeTypeId("vnd.android.cursor.item/group_membership");
        this.mVisibleSpecificUpdate.bindLong(1, groupMembershipMimetypeId);
        this.mVisibleSpecificUpdate.bindLong(2, contactId);
        this.mVisibleSpecificUpdate.execute();
        this.mVisibleSpecificUpdateRawContacts.bindLong(1, contactId);
        this.mVisibleSpecificUpdateRawContacts.execute();
    }

    public long getContactId(long rawContactId) {
        this.getReadableDatabase();
        try {
            DatabaseUtils.bindObjectToProgram((SQLiteProgram)this.mContactIdQuery, (int)1, (Object)rawContactId);
            return this.mContactIdQuery.simpleQueryForLong();
        }
        catch (SQLiteDoneException e) {
            return 0L;
        }
    }

    public int getAggregationMode(long rawContactId) {
        this.getReadableDatabase();
        try {
            DatabaseUtils.bindObjectToProgram((SQLiteProgram)this.mAggregationModeQuery, (int)1, (Object)rawContactId);
            return (int)this.mAggregationModeQuery.simpleQueryForLong();
        }
        catch (SQLiteDoneException e) {
            return 3;
        }
    }

    public void buildPhoneLookupAndRawContactQuery(SQLiteQueryBuilder qb, String number) {
        String minMatch = PhoneNumberUtils.toCallerIDMinMatch((String)number);
        qb.setTables("data JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id) JOIN phone_lookup ON(data._id=data_id)");
        StringBuilder sb = new StringBuilder();
        sb.append("min_match='");
        sb.append(minMatch);
        sb.append("' AND PHONE_NUMBERS_EQUAL(data.data1, ");
        DatabaseUtils.appendEscapedSQLString((StringBuilder)sb, (String)number);
        sb.append(this.mUseStrictPhoneNumberComparison ? ", 1)" : ", 0)");
        qb.appendWhere((CharSequence)sb.toString());
    }

    public void buildPhoneLookupAndContactQuery(SQLiteQueryBuilder qb, String number) {
        String minMatch = PhoneNumberUtils.toCallerIDMinMatch((String)number);
        StringBuilder sb = new StringBuilder();
        this.appendPhoneLookupTables(sb, minMatch, true);
        qb.setTables(sb.toString());
        sb = new StringBuilder();
        this.appendPhoneLookupSelection(sb, number);
        qb.appendWhere((CharSequence)sb.toString());
    }

    public String buildPhoneLookupAsNestedQuery(String number) {
        StringBuilder sb = new StringBuilder();
        String minMatch = PhoneNumberUtils.toCallerIDMinMatch((String)number);
        sb.append("(SELECT DISTINCT raw_contact_id FROM ");
        this.appendPhoneLookupTables(sb, minMatch, false);
        sb.append(" WHERE ");
        this.appendPhoneLookupSelection(sb, number);
        sb.append(")");
        return sb.toString();
    }

    private void appendPhoneLookupTables(StringBuilder sb, String minMatch, boolean joinContacts) {
        sb.append("raw_contacts");
        if (joinContacts) {
            sb.append(" JOIN " + this.getContactView() + " contacts_view" + " ON (contacts_view._id = raw_contacts.contact_id)");
        }
        sb.append(", (SELECT data_id FROM phone_lookup WHERE (phone_lookup.min_match = '");
        sb.append(minMatch);
        sb.append("')) AS lookup, data");
    }

    private void appendPhoneLookupSelection(StringBuilder sb, String number) {
        sb.append("lookup.data_id=data._id AND data.raw_contact_id=raw_contacts._id AND PHONE_NUMBERS_EQUAL(data.data1, ");
        DatabaseUtils.appendEscapedSQLString((StringBuilder)sb, (String)number);
        sb.append(this.mUseStrictPhoneNumberComparison ? ", 1)" : ", 0)");
    }

    public String getUseStrictPhoneNumberComparisonParameter() {
        return this.mUseStrictPhoneNumberComparison ? "1" : "0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNicknameLookupTable(SQLiteDatabase db) {
        db.execSQL("DELETE FROM nickname_lookup");
        String[] strings = this.mContext.getResources().getStringArray(17235997);
        if (strings == null || strings.length == 0) {
            return;
        }
        SQLiteStatement nicknameLookupInsert = db.compileStatement("INSERT INTO nickname_lookup(name,cluster) VALUES (?,?)");
        try {
            for (int clusterId = 0; clusterId < strings.length; ++clusterId) {
                String[] names = strings[clusterId].split(",");
                for (int j = 0; j < names.length; ++j) {
                    String name = NameNormalizer.normalize(names[j]);
                    try {
                        DatabaseUtils.bindObjectToProgram((SQLiteProgram)nicknameLookupInsert, (int)1, (Object)name);
                        DatabaseUtils.bindObjectToProgram((SQLiteProgram)nicknameLookupInsert, (int)2, (Object)String.valueOf(clusterId));
                        nicknameLookupInsert.executeInsert();
                        continue;
                    }
                    catch (SQLiteException e) {
                        Log.e((String)TAG, (String)("Cannot insert nickname: " + names[j]), (Throwable)e);
                    }
                }
            }
        }
        finally {
            nicknameLookupInsert.close();
        }
    }

    public static void copyStringValue(ContentValues toValues, String toKey, ContentValues fromValues, String fromKey) {
        if (fromValues.containsKey(fromKey)) {
            toValues.put(toKey, fromValues.getAsString(fromKey));
        }
    }

    public static void copyLongValue(ContentValues toValues, String toKey, ContentValues fromValues, String fromKey) {
        if (fromValues.containsKey(fromKey)) {
            Object value = fromValues.get(fromKey);
            long longValue = value instanceof Boolean ? (((Boolean)value).booleanValue() ? 1L : 0L) : (value instanceof String ? Long.parseLong((String)value) : ((Number)value).longValue());
            toValues.put(toKey, Long.valueOf(longValue));
        }
    }

    public SyncStateContentProviderHelper getSyncState() {
        return this.mSyncState;
    }

    public void removeContactIfSingleton(long rawContactId) {
        SQLiteDatabase db = this.getWritableDatabase();
        String contactIdFromRawContactId = "(SELECT contact_id FROM raw_contacts WHERE _id=" + rawContactId + ")";
        String otherRawContacts = "(SELECT contacts1._id FROM raw_contacts contacts1 JOIN raw_contacts contacts2 ON (contacts1.contact_id=contacts2.contact_id) WHERE contacts1._id!=" + rawContactId + "" + " AND contacts2." + "_id" + "=" + rawContactId + ")";
        db.execSQL("DELETE FROM contacts WHERE _id=" + contactIdFromRawContactId + " AND NOT EXISTS " + otherRawContacts + ";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String key, String defaultValue) {
        Cursor cursor = this.getReadableDatabase().query("properties", new String[]{"property_value"}, "property_key=?", new String[]{key}, null, null, null);
        String value = null;
        try {
            if (cursor.moveToFirst()) {
                value = cursor.getString(0);
            }
        }
        finally {
            cursor.close();
        }
        return value != null ? value : defaultValue;
    }

    public void setProperty(String key, String value) {
        ContentValues values = new ContentValues();
        values.put("property_key", key);
        values.put("property_value", value);
        this.getWritableDatabase().replace("properties", null, values);
    }

    boolean hasAccessToRestrictedData() {
        String[] callerPackages;
        PackageManager pm = this.mContext.getPackageManager();
        for (String callerPackage : callerPackages = pm.getPackagesForUid(Binder.getCallingUid())) {
            if (!this.hasAccessToRestrictedData(callerPackage)) continue;
            return true;
        }
        return false;
    }

    boolean hasAccessToRestrictedData(String requestingPackage) {
        if (this.mUnrestrictedPackages != null) {
            for (String allowedPackage : this.mUnrestrictedPackages) {
                if (!allowedPackage.equals(requestingPackage)) continue;
                return true;
            }
        }
        return false;
    }

    public String getDataView() {
        return this.getDataView(false);
    }

    public String getDataView(boolean requireRestrictedView) {
        return this.hasAccessToRestrictedData() && !requireRestrictedView ? "view_data" : "view_data_restricted";
    }

    public String getRawContactView() {
        return this.getRawContactView(false);
    }

    public String getRawContactView(boolean requireRestrictedView) {
        return this.hasAccessToRestrictedData() && !requireRestrictedView ? "view_raw_contacts" : "view_raw_contacts_restricted";
    }

    public String getContactView() {
        return this.getContactView(false);
    }

    public String getContactView(boolean requireRestrictedView) {
        return this.hasAccessToRestrictedData() && !requireRestrictedView ? "view_contacts" : "view_contacts_restricted";
    }

    public String getGroupView() {
        return "view_groups";
    }

    public String getContactEntitiesView() {
        return this.getContactEntitiesView(false);
    }

    public String getContactEntitiesView(boolean requireRestrictedView) {
        return this.hasAccessToRestrictedData() && !requireRestrictedView ? "contact_entities_view" : "contact_entities_view_restricted";
    }

    public boolean isInProjection(String[] projection, String ... columns) {
        if (projection == null) {
            return true;
        }
        if (columns.length == 1) {
            String column = columns[0];
            for (String test : projection) {
                if (!column.equals(test)) continue;
                return true;
            }
        } else {
            for (String test : projection) {
                for (String column : columns) {
                    if (!column.equals(test)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String exceptionMessage(Uri uri) {
        return this.exceptionMessage(null, uri);
    }

    public String exceptionMessage(String message, Uri uri) {
        StringBuilder sb = new StringBuilder();
        if (message != null) {
            sb.append(message).append("; ");
        }
        sb.append("URI: ").append(uri);
        PackageManager pm = this.mContext.getPackageManager();
        int callingUid = Binder.getCallingUid();
        sb.append(", calling user: ");
        String userName = pm.getNameForUid(callingUid);
        if (userName != null) {
            sb.append(userName);
        } else {
            sb.append(callingUid);
        }
        String[] callerPackages = pm.getPackagesForUid(callingUid);
        if (callerPackages != null && callerPackages.length > 0) {
            if (callerPackages.length == 1) {
                sb.append(", calling package:");
                sb.append(callerPackages[0]);
            } else {
                sb.append(", calling package is one of: [");
                for (int i = 0; i < callerPackages.length; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(callerPackages[i]);
                }
                sb.append("]");
            }
        }
        return sb.toString();
    }

    private static final class NicknameQuery {
        public static final String TABLE = "data";
        public static final String SELECTION = "mimetype_id=? AND data1 NOT NULL";
        public static final String[] COLUMNS = new String[]{"_id", "raw_contact_id", "data1"};
        public static final int ID = 0;
        public static final int RAW_CONTACT_ID = 1;
        public static final int NAME = 2;

        private NicknameQuery() {
        }
    }

    private static final class EmailQuery {
        public static final String TABLE = "data";
        public static final String SELECTION = "mimetype_id=? AND data1 NOT NULL";
        public static final String[] COLUMNS = new String[]{"_id", "raw_contact_id", "data1"};
        public static final int ID = 0;
        public static final int RAW_CONTACT_ID = 1;
        public static final int ADDRESS = 2;

        private EmailQuery() {
        }
    }

    private static final class OrganizationQuery {
        public static final String TABLE = "data";
        public static final String SELECTION = "mimetype_id=? AND data1 NOT NULL";
        public static final String[] COLUMNS = new String[]{"_id", "raw_contact_id", "data1", "data4"};
        public static final int ID = 0;
        public static final int RAW_CONTACT_ID = 1;
        public static final int COMPANY = 2;
        public static final int TITLE = 3;

        private OrganizationQuery() {
        }
    }

    private class StructuredNameLookupBuilder
    extends NameLookupBuilder {
        private final SQLiteStatement mNameLookupInsert;
        private final CommonNicknameCache mCommonNicknameCache;

        public StructuredNameLookupBuilder(NameSplitter splitter, CommonNicknameCache commonNicknameCache, SQLiteStatement nameLookupInsert) {
            super(splitter);
            this.mCommonNicknameCache = commonNicknameCache;
            this.mNameLookupInsert = nameLookupInsert;
        }

        protected void insertNameLookup(long rawContactId, long dataId, int lookupType, String name) {
            if (!TextUtils.isEmpty((CharSequence)name)) {
                ContactsDatabaseHelper.this.insertNormalizedNameLookup(this.mNameLookupInsert, rawContactId, dataId, lookupType, name);
            }
        }

        protected String[] getCommonNicknameClusters(String normalizedName) {
            return this.mCommonNicknameCache.getCommonNicknameClusters(normalizedName);
        }
    }

    private static final class StructuredNameQuery {
        public static final String TABLE = "data";
        public static final String SELECTION = "mimetype_id=? AND data1 NOT NULL";
        public static final String[] COLUMNS = new String[]{"_id", "raw_contact_id", "data1"};
        public static final int ID = 0;
        public static final int RAW_CONTACT_ID = 1;
        public static final int DISPLAY_NAME = 2;

        private StructuredNameQuery() {
        }
    }

    private static final class Upgrade303Query {
        public static final String TABLE = "data";
        public static final String SELECTION = "mimetype_id=? AND _id NOT IN (SELECT data_id FROM name_lookup) AND data1 NOT NULL";
        public static final String[] COLUMNS = new String[]{"_id", "raw_contact_id", "data1"};
        public static final int ID = 0;
        public static final int RAW_CONTACT_ID = 1;
        public static final int DATA1 = 2;

        private Upgrade303Query() {
        }
    }

    private static interface Organization300Query {
        public static final String TABLE = "data";
        public static final String SELECTION = "mimetype_id=?";
        public static final String[] COLUMNS = new String[]{"_id", "raw_contact_id", "data1", "data4"};
        public static final int ID = 0;
        public static final int RAW_CONTACT_ID = 1;
        public static final int COMPANY = 2;
        public static final int TITLE = 3;
    }

    private static interface Organization205Query {
        public static final String TABLE = "data JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id)";
        public static final String[] COLUMNS = new String[]{"data._id", "raw_contact_id", "data1", "data8"};
        public static final int ID = 0;
        public static final int RAW_CONTACT_ID = 1;
        public static final int COMPANY = 2;
        public static final int PHONETIC_NAME = 3;
    }

    private static interface StructName205Query {
        public static final String TABLE = "data JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id)";
        public static final String[] COLUMNS = new String[]{"data._id", "raw_contact_id", "display_name_source", "display_name", "data4", "data2", "data5", "data3", "data6", "data9", "data8", "data7"};
        public static final int ID = 0;
        public static final int RAW_CONTACT_ID = 1;
        public static final int DISPLAY_NAME_SOURCE = 2;
        public static final int DISPLAY_NAME = 3;
        public static final int PREFIX = 4;
        public static final int GIVEN_NAME = 5;
        public static final int MIDDLE_NAME = 6;
        public static final int FAMILY_NAME = 7;
        public static final int SUFFIX = 8;
        public static final int PHONETIC_FAMILY_NAME = 9;
        public static final int PHONETIC_MIDDLE_NAME = 10;
        public static final int PHONETIC_GIVEN_NAME = 11;
    }

    public static interface PropertiesColumns {
        public static final String PROPERTY_KEY = "property_key";
        public static final String PROPERTY_VALUE = "property_value";
    }

    public static interface ContactsStatusUpdatesColumns {
        public static final String ALIAS = "contacts_status_updates";
        public static final String CONCRETE_DATA_ID = "contacts_status_updates.status_update_data_id";
        public static final String CONCRETE_PRESENCE = "contacts_status_updates.mode";
        public static final String CONCRETE_STATUS = "contacts_status_updates.status";
        public static final String CONCRETE_STATUS_TIMESTAMP = "contacts_status_updates.status_ts";
        public static final String CONCRETE_STATUS_RES_PACKAGE = "contacts_status_updates.status_res_package";
        public static final String CONCRETE_STATUS_LABEL = "contacts_status_updates.status_label";
        public static final String CONCRETE_STATUS_ICON = "contacts_status_updates.status_icon";
    }

    public static interface StatusUpdatesColumns {
        public static final String DATA_ID = "status_update_data_id";
        public static final String CONCRETE_DATA_ID = "status_updates.status_update_data_id";
        public static final String CONCRETE_PRESENCE = "status_updates.mode";
        public static final String CONCRETE_STATUS = "status_updates.status";
        public static final String CONCRETE_STATUS_TIMESTAMP = "status_updates.status_ts";
        public static final String CONCRETE_STATUS_RES_PACKAGE = "status_updates.status_res_package";
        public static final String CONCRETE_STATUS_LABEL = "status_updates.status_label";
        public static final String CONCRETE_STATUS_ICON = "status_updates.status_icon";
    }

    public static interface AggregatedPresenceColumns {
        public static final String CONTACT_ID = "presence_contact_id";
        public static final String CONCRETE_CONTACT_ID = "agg_presence.presence_contact_id";
    }

    public static interface PresenceColumns {
        public static final String RAW_CONTACT_ID = "presence_raw_contact_id";
        public static final String CONTACT_ID = "presence_contact_id";
    }

    public static interface SettingsColumns {
        public static final String CONCRETE_ACCOUNT_NAME = "settings.account_name";
        public static final String CONCRETE_ACCOUNT_TYPE = "settings.account_type";
    }

    public static interface NicknameLookupColumns {
        public static final String NAME = "name";
        public static final String CLUSTER = "cluster";
    }

    public static interface AggregationExceptionColumns {
        public static final String _ID = "_id";
    }

    public static interface MimetypesColumns {
        public static final String _ID = "_id";
        public static final String MIMETYPE = "mimetype";
        public static final String CONCRETE_ID = "mimetypes._id";
        public static final String CONCRETE_MIMETYPE = "mimetypes.mimetype";
    }

    public static interface PackagesColumns {
        public static final String _ID = "_id";
        public static final String PACKAGE = "package";
        public static final String CONCRETE_ID = "packages._id";
    }

    public static final class NameLookupType {
        public static final int NAME_EXACT = 0;
        public static final int NAME_VARIANT = 1;
        public static final int NAME_COLLATION_KEY = 2;
        public static final int NICKNAME = 3;
        public static final int EMAIL_BASED_NICKNAME = 4;
        public static final int ORGANIZATION = 5;
        public static final int NAME_SHORTHAND = 6;
        public static final int NAME_CONSONANTS = 7;
        public static final int TYPE_COUNT = 8;

        public static boolean isBasedOnStructuredName(int nameLookupType) {
            return nameLookupType == 0 || nameLookupType == 1 || nameLookupType == 2;
        }
    }

    public static interface NameLookupColumns {
        public static final String RAW_CONTACT_ID = "raw_contact_id";
        public static final String DATA_ID = "data_id";
        public static final String NORMALIZED_NAME = "normalized_name";
        public static final String NAME_TYPE = "name_type";
    }

    public static interface PhoneLookupColumns {
        public static final String _ID = "_id";
        public static final String DATA_ID = "data_id";
        public static final String RAW_CONTACT_ID = "raw_contact_id";
        public static final String NORMALIZED_NUMBER = "normalized_number";
        public static final String MIN_MATCH = "min_match";
    }

    public static interface ActivitiesColumns {
        public static final String PACKAGE_ID = "package_id";
        public static final String MIMETYPE_ID = "mimetype_id";
    }

    public static interface GroupsColumns {
        public static final String PACKAGE_ID = "package_id";
        public static final String CONCRETE_ID = "groups._id";
        public static final String CONCRETE_SOURCE_ID = "groups.sourceid";
        public static final String CONCRETE_ACCOUNT_NAME = "groups.account_name";
        public static final String CONCRETE_ACCOUNT_TYPE = "groups.account_type";
    }

    public static interface PhoneColumns {
        public static final String NORMALIZED_NUMBER = "data4";
        public static final String CONCRETE_NORMALIZED_NUMBER = "data.data4";
    }

    public static interface GroupMembershipColumns {
        public static final String RAW_CONTACT_ID = "raw_contact_id";
        public static final String GROUP_ROW_ID = "data1";
    }

    public static interface ExtensionsColumns {
        public static final String NAME = "data1";
        public static final String VALUE = "data2";
    }

    public static interface DataColumns {
        public static final String PACKAGE_ID = "package_id";
        public static final String MIMETYPE_ID = "mimetype_id";
        public static final String CONCRETE_ID = "data._id";
        public static final String CONCRETE_MIMETYPE_ID = "data.mimetype_id";
        public static final String CONCRETE_RAW_CONTACT_ID = "data.raw_contact_id";
        public static final String CONCRETE_GROUP_ID = "data.data1";
        public static final String CONCRETE_DATA1 = "data.data1";
        public static final String CONCRETE_DATA2 = "data.data2";
        public static final String CONCRETE_DATA3 = "data.data3";
        public static final String CONCRETE_DATA4 = "data.data4";
        public static final String CONCRETE_DATA5 = "data.data5";
        public static final String CONCRETE_DATA6 = "data.data6";
        public static final String CONCRETE_DATA7 = "data.data7";
        public static final String CONCRETE_DATA8 = "data.data8";
        public static final String CONCRETE_DATA9 = "data.data9";
        public static final String CONCRETE_DATA10 = "data.data10";
        public static final String CONCRETE_DATA11 = "data.data11";
        public static final String CONCRETE_DATA12 = "data.data12";
        public static final String CONCRETE_DATA13 = "data.data13";
        public static final String CONCRETE_DATA14 = "data.data14";
        public static final String CONCRETE_DATA15 = "data.data15";
        public static final String CONCRETE_IS_PRIMARY = "data.is_primary";
        public static final String CONCRETE_PACKAGE_ID = "data.package_id";
    }

    public static interface RawContactsColumns {
        public static final String CONCRETE_ID = "raw_contacts._id";
        public static final String CONCRETE_ACCOUNT_NAME = "raw_contacts.account_name";
        public static final String CONCRETE_ACCOUNT_TYPE = "raw_contacts.account_type";
        public static final String CONCRETE_SOURCE_ID = "raw_contacts.sourceid";
        public static final String CONCRETE_VERSION = "raw_contacts.version";
        public static final String CONCRETE_DIRTY = "raw_contacts.dirty";
        public static final String CONCRETE_DELETED = "raw_contacts.deleted";
        public static final String CONCRETE_SYNC1 = "raw_contacts.sync1";
        public static final String CONCRETE_SYNC2 = "raw_contacts.sync2";
        public static final String CONCRETE_SYNC3 = "raw_contacts.sync3";
        public static final String CONCRETE_SYNC4 = "raw_contacts.sync4";
        public static final String CONCRETE_STARRED = "raw_contacts.starred";
        public static final String CONCRETE_IS_RESTRICTED = "raw_contacts.is_restricted";
        public static final String DISPLAY_NAME = "display_name";
        public static final String DISPLAY_NAME_SOURCE = "display_name_source";
        public static final String AGGREGATION_NEEDED = "aggregation_needed";
        public static final String CONTACT_IN_VISIBLE_GROUP = "contact_in_visible_group";
        public static final String CONCRETE_DISPLAY_NAME = "raw_contacts.display_name";
        public static final String CONCRETE_CONTACT_ID = "raw_contacts.contact_id";
        public static final String CONCRETE_NAME_VERIFIED = "raw_contacts.name_verified";
    }

    public static interface ContactsColumns {
        public static final String SINGLE_IS_RESTRICTED = "single_is_restricted";
        public static final String LAST_STATUS_UPDATE_ID = "status_update_id";
        public static final String CONCRETE_ID = "contacts._id";
        public static final String CONCRETE_TIMES_CONTACTED = "contacts.times_contacted";
        public static final String CONCRETE_LAST_TIME_CONTACTED = "contacts.last_time_contacted";
        public static final String CONCRETE_STARRED = "contacts.starred";
        public static final String CONCRETE_CUSTOM_RINGTONE = "contacts.custom_ringtone";
        public static final String CONCRETE_SEND_TO_VOICEMAIL = "contacts.send_to_voicemail";
        public static final String CONCRETE_LOOKUP_KEY = "contacts.lookup";
    }

    public static interface Clauses {
        public static final String MIMETYPE_IS_GROUP_MEMBERSHIP = "mimetypes.mimetype='vnd.android.cursor.item/group_membership'";
        public static final String BELONGS_TO_GROUP = "data.data1=groups._id";
        public static final String HAVING_NO_GROUPS = "COUNT(data.data1) == 0";
        public static final String GROUP_BY_ACCOUNT_CONTACT_ID = "settings.account_name,settings.account_type,contact_id";
        public static final String RAW_CONTACT_IS_LOCAL = "raw_contacts.account_name IS NULL AND raw_contacts.account_type IS NULL";
        public static final String ZERO_GROUP_MEMBERSHIPS = "COUNT(groups._id)=0";
        public static final String OUTER_RAW_CONTACTS = "outer_raw_contacts";
        public static final String OUTER_RAW_CONTACTS_ID = "outer_raw_contacts._id";
        public static final String CONTACT_IS_VISIBLE = "SELECT MAX((SELECT (CASE WHEN (CASE WHEN raw_contacts.account_name IS NULL AND raw_contacts.account_type IS NULL THEN 1  WHEN COUNT(groups._id)=0 THEN ungrouped_visible ELSE MAX(group_visible)END)=1 THEN 1 ELSE 0 END) FROM raw_contacts LEFT OUTER JOIN settings ON (raw_contacts.account_name = settings.account_name AND raw_contacts.account_type = settings.account_type) LEFT OUTER JOIN data ON (data.mimetype_id=? AND data.raw_contact_id = raw_contacts._id) LEFT OUTER JOIN groups ON (groups._id = data.data1) WHERE raw_contacts._id=outer_raw_contacts._id)) FROM raw_contacts AS outer_raw_contacts WHERE contact_id=contacts._id GROUP BY contact_id";
        public static final String GROUP_HAS_ACCOUNT_AND_SOURCE_ID = "sourceid=? AND account_name=? AND account_type=?";
    }

    public static interface Views {
        public static final String DATA_ALL = "view_data";
        public static final String DATA_RESTRICTED = "view_data_restricted";
        public static final String RAW_CONTACTS_ALL = "view_raw_contacts";
        public static final String RAW_CONTACTS_RESTRICTED = "view_raw_contacts_restricted";
        public static final String CONTACTS_ALL = "view_contacts";
        public static final String CONTACTS_RESTRICTED = "view_contacts_restricted";
        public static final String GROUPS_ALL = "view_groups";
    }

    public static interface Tables {
        public static final String CONTACTS = "contacts";
        public static final String RAW_CONTACTS = "raw_contacts";
        public static final String PACKAGES = "packages";
        public static final String MIMETYPES = "mimetypes";
        public static final String PHONE_LOOKUP = "phone_lookup";
        public static final String NAME_LOOKUP = "name_lookup";
        public static final String AGGREGATION_EXCEPTIONS = "agg_exceptions";
        public static final String SETTINGS = "settings";
        public static final String DATA = "data";
        public static final String GROUPS = "groups";
        public static final String PRESENCE = "presence";
        public static final String AGGREGATED_PRESENCE = "agg_presence";
        public static final String NICKNAME_LOOKUP = "nickname_lookup";
        public static final String CALLS = "calls";
        public static final String CONTACT_ENTITIES = "contact_entities_view";
        public static final String CONTACT_ENTITIES_RESTRICTED = "contact_entities_view_restricted";
        public static final String STATUS_UPDATES = "status_updates";
        public static final String PROPERTIES = "properties";
        public static final String ACCOUNTS = "accounts";
        public static final String DATA_JOIN_MIMETYPES = "data JOIN mimetypes ON (data.mimetype_id = mimetypes._id)";
        public static final String DATA_JOIN_RAW_CONTACTS = "data JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id)";
        public static final String DATA_JOIN_MIMETYPE_RAW_CONTACTS = "data JOIN mimetypes ON (data.mimetype_id = mimetypes._id) JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id)";
        public static final String RAW_CONTACTS_JOIN_SETTINGS_DATA_GROUPS = "raw_contacts LEFT OUTER JOIN settings ON (raw_contacts.account_name = settings.account_name AND raw_contacts.account_type = settings.account_type) LEFT OUTER JOIN data ON (data.mimetype_id=? AND data.raw_contact_id = raw_contacts._id) LEFT OUTER JOIN groups ON (groups._id = data.data1)";
        public static final String SETTINGS_JOIN_RAW_CONTACTS_DATA_MIMETYPES_CONTACTS = "settings LEFT OUTER JOIN raw_contacts ON (raw_contacts.account_name = settings.account_name AND raw_contacts.account_type = settings.account_type) LEFT OUTER JOIN data ON (data.mimetype_id=? AND data.raw_contact_id = raw_contacts._id) LEFT OUTER JOIN contacts ON (raw_contacts.contact_id = contacts._id)";
        public static final String DATA_JOIN_MIMETYPES_RAW_CONTACTS_CONTACTS = "data JOIN mimetypes ON (data.mimetype_id = mimetypes._id) JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id) LEFT OUTER JOIN contacts ON (raw_contacts.contact_id = contacts._id)";
        public static final String DATA_JOIN_PACKAGES_MIMETYPES_RAW_CONTACTS_GROUPS = "data JOIN mimetypes ON (data.mimetype_id = mimetypes._id) JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id) LEFT OUTER JOIN packages ON (data.package_id = packages._id) LEFT OUTER JOIN groups   ON (mimetypes.mimetype='vnd.android.cursor.item/group_membership'       AND groups._id = data.data1) ";
        public static final String GROUPS_JOIN_PACKAGES = "groups LEFT OUTER JOIN packages ON (groups.package_id = packages._id)";
        public static final String ACTIVITIES = "activities";
        public static final String ACTIVITIES_JOIN_MIMETYPES = "activities LEFT OUTER JOIN mimetypes ON (activities.mimetype_id = mimetypes._id)";
        public static final String ACTIVITIES_JOIN_PACKAGES_MIMETYPES_RAW_CONTACTS_CONTACTS = "activities LEFT OUTER JOIN packages ON (activities.package_id = packages._id) LEFT OUTER JOIN mimetypes ON (activities.mimetype_id = mimetypes._id) LEFT OUTER JOIN raw_contacts ON (activities.author_contact_id = raw_contacts._id) LEFT OUTER JOIN contacts ON (raw_contacts.contact_id = contacts._id)";
        public static final String NAME_LOOKUP_JOIN_RAW_CONTACTS = "name_lookup INNER JOIN raw_contacts ON (name_lookup.raw_contact_id = raw_contacts._id)";
    }
}

