/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import com.android.providers.contacts.Hex;
import com.android.providers.contacts.NameDistance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactMatcher {
    public static final int MAX_SCORE = 100;
    public static final int SCORE_THRESHOLD_SUGGEST = 50;
    public static final int SCORE_THRESHOLD_PRIMARY = 70;
    public static final int SCORE_THRESHOLD_SECONDARY = 50;
    private static final int NO_DATA_SCORE = -1;
    private static final int PHONE_MATCH_SCORE = 71;
    private static final int EMAIL_MATCH_SCORE = 71;
    private static final int NICKNAME_MATCH_SCORE = 71;
    private static final int MAX_MATCHED_NAME_LENGTH = 30;
    private static final int SCORE_SCALE = 1000;
    public static final int MATCHING_ALGORITHM_EXACT = 0;
    public static final int MATCHING_ALGORITHM_CONSERVATIVE = 1;
    public static final int MATCHING_ALGORITHM_APPROXIMATE = 2;
    public static final float APPROXIMATE_MATCH_THRESHOLD = 0.82f;
    public static final float APPROXIMATE_MATCH_THRESHOLD_FOR_EMAIL = 0.95f;
    public static final long MULTIPLE_MATCHES = -2L;
    private static int[] sMinScore = new int[64];
    private static int[] sMaxScore = new int[64];
    private final HashMap<Long, MatchScore> mScores = new HashMap();
    private final ArrayList<MatchScore> mScoreList = new ArrayList();
    private int mScoreCount = 0;
    private final NameDistance mNameDistanceConservative = new NameDistance();
    private final NameDistance mNameDistanceApproximate = new NameDistance(30);

    private static void setScoreRange(int candidateNameType, int nameType, int scoreFrom, int scoreTo) {
        int index = nameType * 8 + candidateNameType;
        ContactMatcher.sMinScore[index] = scoreFrom;
        ContactMatcher.sMaxScore[index] = scoreTo;
    }

    private static int getMinScore(int candidateNameType, int nameType) {
        int index = nameType * 8 + candidateNameType;
        return sMinScore[index];
    }

    private static int getMaxScore(int candidateNameType, int nameType) {
        int index = nameType * 8 + candidateNameType;
        return sMaxScore[index];
    }

    private MatchScore getMatchingScore(long contactId) {
        MatchScore matchingScore = this.mScores.get(contactId);
        if (matchingScore == null) {
            if (this.mScoreList.size() > this.mScoreCount) {
                matchingScore = this.mScoreList.get(this.mScoreCount);
                matchingScore.reset(contactId);
            } else {
                matchingScore = new MatchScore(contactId);
                this.mScoreList.add(matchingScore);
            }
            ++this.mScoreCount;
            this.mScores.put(contactId, matchingScore);
        }
        return matchingScore;
    }

    public void matchName(long contactId, int candidateNameType, String candidateName, int nameType, String name, int algorithm) {
        int maxScore = ContactMatcher.getMaxScore(candidateNameType, nameType);
        if (maxScore == 0) {
            return;
        }
        if (candidateName.equals(name)) {
            this.updatePrimaryScore(contactId, maxScore);
            return;
        }
        if (algorithm == 0) {
            return;
        }
        int minScore = ContactMatcher.getMinScore(candidateNameType, nameType);
        if (minScore == maxScore) {
            return;
        }
        byte[] decodedCandidateName = Hex.decodeHex(candidateName);
        byte[] decodedName = Hex.decodeHex(name);
        NameDistance nameDistance = algorithm == 1 ? this.mNameDistanceConservative : this.mNameDistanceApproximate;
        float distance = nameDistance.getDistance(decodedCandidateName, decodedName);
        boolean emailBased = candidateNameType == 4 || nameType == 4;
        float threshold = emailBased ? 0.95f : 0.82f;
        int score = distance > threshold ? (int)((float)minScore + (float)(maxScore - minScore) * (1.0f - distance)) : 0;
        this.updatePrimaryScore(contactId, score);
    }

    public void updateScoreWithPhoneNumberMatch(long contactId) {
        this.updateSecondaryScore(contactId, 71);
    }

    public void updateScoreWithEmailMatch(long contactId) {
        this.updateSecondaryScore(contactId, 71);
    }

    public void updateScoreWithNicknameMatch(long contactId) {
        this.updateSecondaryScore(contactId, 71);
    }

    private void updatePrimaryScore(long contactId, int score) {
        this.getMatchingScore(contactId).updatePrimaryScore(score);
    }

    private void updateSecondaryScore(long contactId, int score) {
        this.getMatchingScore(contactId).updateSecondaryScore(score);
    }

    public void keepIn(long contactId) {
        this.getMatchingScore(contactId).keepIn();
    }

    public void keepOut(long contactId) {
        this.getMatchingScore(contactId).keepOut();
    }

    public void clear() {
        this.mScores.clear();
        this.mScoreCount = 0;
    }

    public List<Long> prepareSecondaryMatchCandidates(int threshold) {
        ArrayList<Long> contactIds = null;
        for (int i = 0; i < this.mScoreCount; ++i) {
            MatchScore score = this.mScoreList.get(i);
            if (score.mKeepOut) continue;
            int s = score.mSecondaryScore;
            if (s >= threshold) {
                if (contactIds == null) {
                    contactIds = new ArrayList<Long>();
                }
                contactIds.add(score.mContactId);
            }
            score.mPrimaryScore = -1;
        }
        return contactIds;
    }

    public long pickBestMatch(int threshold, boolean allowMultipleMatches) {
        long contactId = -1L;
        int maxScore = 0;
        for (int i = 0; i < this.mScoreCount; ++i) {
            MatchScore score = this.mScoreList.get(i);
            if (score.mKeepOut) continue;
            if (score.mKeepIn) {
                return score.mContactId;
            }
            int s = score.mPrimaryScore;
            if (s == -1) {
                s = score.mSecondaryScore;
            }
            if (s < threshold) continue;
            if (contactId != -1L && !allowMultipleMatches) {
                return -2L;
            }
            if (s <= maxScore) continue;
            contactId = score.mContactId;
            maxScore = s;
        }
        return contactId;
    }

    public List<MatchScore> pickBestMatches(int threshold) {
        MatchScore matchScore;
        int scaledThreshold = threshold * 1000;
        List<MatchScore> matches = this.mScoreList.subList(0, this.mScoreCount);
        Collections.sort(matches);
        int count = 0;
        for (int i = 0; i < this.mScoreCount && (matchScore = matches.get(i)).getScore() >= scaledThreshold; ++i) {
            ++count;
        }
        return matches.subList(0, count);
    }

    public String toString() {
        return this.mScoreList.toString();
    }

    static {
        ContactMatcher.setScoreRange(0, 0, 99, 99);
        ContactMatcher.setScoreRange(1, 1, 90, 90);
        ContactMatcher.setScoreRange(2, 2, 50, 80);
        ContactMatcher.setScoreRange(2, 4, 30, 60);
        ContactMatcher.setScoreRange(2, 3, 50, 60);
        ContactMatcher.setScoreRange(4, 4, 50, 60);
        ContactMatcher.setScoreRange(4, 2, 50, 60);
        ContactMatcher.setScoreRange(4, 3, 50, 60);
        ContactMatcher.setScoreRange(3, 3, 50, 60);
        ContactMatcher.setScoreRange(3, 2, 50, 60);
        ContactMatcher.setScoreRange(3, 4, 50, 60);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MatchScore
    implements Comparable<MatchScore> {
        private long mContactId;
        private boolean mKeepIn;
        private boolean mKeepOut;
        private int mPrimaryScore;
        private int mSecondaryScore;
        private int mMatchCount;

        public MatchScore(long contactId) {
            this.mContactId = contactId;
        }

        public void reset(long contactId) {
            this.mContactId = contactId;
            this.mKeepIn = false;
            this.mKeepOut = false;
            this.mPrimaryScore = 0;
            this.mSecondaryScore = 0;
            this.mMatchCount = 0;
        }

        public long getContactId() {
            return this.mContactId;
        }

        public void updatePrimaryScore(int score) {
            if (score > this.mPrimaryScore) {
                this.mPrimaryScore = score;
            }
            ++this.mMatchCount;
        }

        public void updateSecondaryScore(int score) {
            if (score > this.mSecondaryScore) {
                this.mSecondaryScore = score;
            }
            ++this.mMatchCount;
        }

        public void keepIn() {
            this.mKeepIn = true;
        }

        public void keepOut() {
            this.mKeepOut = true;
        }

        public int getScore() {
            if (this.mKeepOut) {
                return 0;
            }
            if (this.mKeepIn) {
                return 100;
            }
            int score = this.mPrimaryScore > this.mSecondaryScore ? this.mPrimaryScore : this.mSecondaryScore;
            return score * 1000 + this.mMatchCount;
        }

        @Override
        public int compareTo(MatchScore another) {
            return another.getScore() - this.getScore();
        }

        public String toString() {
            return this.mContactId + ": " + this.mPrimaryScore + "/" + this.mSecondaryScore + "(" + this.mMatchCount + ")";
        }
    }
}

