/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import android.net.Uri;
import com.android.providers.contacts.NameNormalizer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactLookupKey {
    public static final int LOOKUP_TYPE_SOURCE_ID = 0;
    public static final int LOOKUP_TYPE_DISPLAY_NAME = 1;
    public static final int LOOKUP_TYPE_RAW_CONTACT_ID = 2;

    public static int getAccountHashCode(String accountType, String accountName) {
        if (accountType == null || accountName == null) {
            return 0;
        }
        return (accountType.hashCode() ^ accountName.hashCode()) & 0xFFF;
    }

    public static void appendToLookupKey(StringBuilder lookupKey, String accountType, String accountName, long rawContactId, String sourceId, String displayName) {
        if (displayName == null) {
            displayName = "";
        }
        if (lookupKey.length() != 0) {
            lookupKey.append(".");
        }
        lookupKey.append(ContactLookupKey.getAccountHashCode(accountType, accountName));
        if (sourceId == null) {
            lookupKey.append('r').append(rawContactId).append('-').append(NameNormalizer.normalize(displayName));
        } else {
            int pos = lookupKey.length();
            lookupKey.append('i');
            if (ContactLookupKey.appendEscapedSourceId(lookupKey, sourceId)) {
                lookupKey.setCharAt(pos, 'e');
            }
        }
    }

    private static boolean appendEscapedSourceId(StringBuilder sb, String sourceId) {
        boolean escaped = false;
        int start = 0;
        while (true) {
            int index;
            if ((index = sourceId.indexOf(46, start)) == -1) break;
            escaped = true;
            sb.append(sourceId, start, index);
            sb.append("..");
            start = index + 1;
        }
        sb.append(sourceId, start, sourceId.length());
        return escaped;
    }

    public ArrayList<LookupKeySegment> parse(String lookupKey) {
        ArrayList<LookupKeySegment> list = new ArrayList<LookupKeySegment>();
        String string2 = Uri.decode((String)lookupKey);
        int offset = 0;
        int length = string2.length();
        int hashCode = 0;
        int lookupType = -1;
        boolean escaped = false;
        String rawContactId = null;
        while (offset < length) {
            String key;
            char c = '\u0000';
            hashCode = 0;
            while (offset < length && (c = (char)string2.charAt(offset++)) >= '0' && c <= '9') {
                hashCode = hashCode * 10 + (c - 48);
            }
            if (c == 'i') {
                lookupType = 0;
                escaped = false;
            } else if (c == 'e') {
                lookupType = 0;
                escaped = true;
            } else if (c == 'n') {
                lookupType = 1;
            } else if (c == 'r') {
                lookupType = 2;
            } else {
                throw new IllegalArgumentException("Invalid lookup id: " + lookupKey);
            }
            switch (lookupType) {
                case 0: {
                    if (escaped) {
                        StringBuffer sb = new StringBuffer();
                        while (offset < length) {
                            if ((c = (char)string2.charAt(offset++)) == '.') {
                                if (offset == length) {
                                    throw new IllegalArgumentException("Invalid lookup id: " + lookupKey);
                                }
                                c = string2.charAt(offset);
                                if (c != 46) break;
                                sb.append('.');
                                ++offset;
                                continue;
                            }
                            sb.append(c);
                        }
                        key = sb.toString();
                        break;
                    }
                    int start = offset;
                    while (offset < length && (c = (char)string2.charAt(offset++)) != '.') {
                    }
                    if (offset == length) {
                        key = string2.substring(start);
                        break;
                    }
                    key = string2.substring(start, offset - 1);
                    break;
                }
                case 1: {
                    int start = offset;
                    while (offset < length && (c = (char)string2.charAt(offset++)) != '.') {
                    }
                    if (offset == length) {
                        key = string2.substring(start);
                        break;
                    }
                    key = string2.substring(start, offset - 1);
                    break;
                }
                case 2: {
                    int dash = -1;
                    int start = offset;
                    while (offset < length) {
                        c = string2.charAt(offset);
                        if (c == '-' && dash == -1) {
                            dash = offset;
                        }
                        ++offset;
                        if (c != 46) continue;
                    }
                    if (dash != -1) {
                        rawContactId = string2.substring(start, dash);
                        start = dash + 1;
                    }
                    if (offset == length) {
                        key = string2.substring(start);
                        break;
                    }
                    key = string2.substring(start, offset - 1);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            LookupKeySegment segment = new LookupKeySegment();
            segment.accountHashCode = hashCode;
            segment.lookupType = lookupType;
            segment.rawContactId = rawContactId;
            segment.key = key;
            segment.contactId = -1L;
            list.add(segment);
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LookupKeySegment
    implements Comparable<LookupKeySegment> {
        public int accountHashCode;
        public int lookupType;
        public String rawContactId;
        public String key;
        public long contactId;

        @Override
        public int compareTo(LookupKeySegment another) {
            if (this.contactId > another.contactId) {
                return -1;
            }
            if (this.contactId < another.contactId) {
                return 1;
            }
            return 0;
        }
    }
}

