/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import com.android.internal.util.HanziToPinyin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactLocaleUtils {
    private static final String CHINESE_LANGUAGE = Locale.CHINESE.getLanguage().toLowerCase();
    private static final String JAPANESE_LANGUAGE = Locale.JAPANESE.getLanguage().toLowerCase();
    private static final String KOREAN_LANGUAGE = Locale.KOREAN.getLanguage().toLowerCase();
    private static ContactLocaleUtils sSingleton;
    private HashMap<Integer, ContactLocaleUtilsBase> mUtils = new HashMap();
    private ContactLocaleUtilsBase mBase = new ContactLocaleUtilsBase();
    private String mLanguage;

    private ContactLocaleUtils() {
        this.setLocale(null);
    }

    public void setLocale(Locale currentLocale) {
        this.mLanguage = currentLocale == null ? Locale.getDefault().getLanguage().toLowerCase() : currentLocale.getLanguage().toLowerCase();
    }

    public String getSortKey(String displayName, int nameStyle) {
        return this.getForSort(nameStyle).getSortKey(displayName);
    }

    public Iterator<String> getNameLookupKeys(String name, int nameStyle) {
        return this.getForNameLookup(nameStyle).getNameLookupKeys(name);
    }

    private ContactLocaleUtilsBase getForNameLookup(Integer nameStyle) {
        int nameStyleInt = nameStyle;
        Integer adjustedUtil = this.getAdjustedStyle(nameStyleInt);
        if (CHINESE_LANGUAGE.equals(this.mLanguage) && nameStyleInt == 1) {
            adjustedUtil = 3;
        }
        return this.get(adjustedUtil);
    }

    private synchronized ContactLocaleUtilsBase get(Integer nameStyle) {
        ContactLocaleUtilsBase utils = this.mUtils.get(nameStyle);
        if (utils == null && nameStyle == 3) {
            utils = new ChineseContactUtils();
            this.mUtils.put(nameStyle, utils);
        }
        return utils == null ? this.mBase : utils;
    }

    private ContactLocaleUtilsBase getForSort(Integer nameStyle) {
        return this.get(this.getAdjustedStyle(nameStyle));
    }

    public static synchronized ContactLocaleUtils getIntance() {
        if (sSingleton == null) {
            sSingleton = new ContactLocaleUtils();
        }
        return sSingleton;
    }

    private int getAdjustedStyle(int nameStyle) {
        if (nameStyle == 2 && !JAPANESE_LANGUAGE.equals(this.mLanguage) && !KOREAN_LANGUAGE.equals(this.mLanguage)) {
            return 3;
        }
        return nameStyle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChineseContactUtils
    extends ContactLocaleUtilsBase {
        private ChineseContactUtils() {
        }

        @Override
        public String getSortKey(String displayName) {
            ArrayList tokens = HanziToPinyin.getInstance().get(displayName);
            if (tokens != null && tokens.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (HanziToPinyin.Token token : tokens) {
                    if (2 == token.type) {
                        if (sb.length() > 0) {
                            sb.append(' ');
                        }
                        sb.append(token.target);
                        sb.append(' ');
                        sb.append(token.source);
                        continue;
                    }
                    if (sb.length() > 0) {
                        sb.append(' ');
                    }
                    sb.append(token.source);
                }
                return sb.toString();
            }
            return super.getSortKey(displayName);
        }

        @Override
        public Iterator<String> getNameLookupKeys(String name) {
            HashSet<String> keys = new HashSet<String>();
            ArrayList tokens = HanziToPinyin.getInstance().get(name);
            int tokenCount = tokens.size();
            StringBuilder keyPinyin = new StringBuilder();
            StringBuilder keyInitial = new StringBuilder();
            StringBuilder keyOrignal = new StringBuilder();
            for (int i = tokenCount - 1; i >= 0; --i) {
                HanziToPinyin.Token token = (HanziToPinyin.Token)tokens.get(i);
                if (2 == token.type) {
                    keyPinyin.insert(0, token.target);
                    keyInitial.insert(0, token.target.charAt(0));
                } else if (1 == token.type) {
                    if (keyPinyin.length() > 0) {
                        keyPinyin.insert(0, ' ');
                    }
                    if (keyOrignal.length() > 0) {
                        keyOrignal.insert(0, ' ');
                    }
                    keyPinyin.insert(0, token.source);
                    keyInitial.insert(0, token.source.charAt(0));
                }
                keyOrignal.insert(0, token.source);
                keys.add(keyOrignal.toString());
                keys.add(keyPinyin.toString());
                keys.add(keyInitial.toString());
            }
            return keys.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ContactLocaleUtilsBase {
        public String getSortKey(String displayName) {
            return displayName;
        }

        public Iterator<String> getNameLookupKeys(String name) {
            return null;
        }
    }
}

