/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteQueryBuilder;
import android.database.sqlite.SQLiteStatement;
import android.net.Uri;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import com.android.providers.contacts.ContactLookupKey;
import com.android.providers.contacts.ContactMatcher;
import com.android.providers.contacts.ContactsDatabaseHelper;
import com.android.providers.contacts.ContactsProvider2;
import com.android.providers.contacts.NameNormalizer;
import com.android.providers.contacts.PhotoPriorityResolver;
import com.android.providers.contacts.ReorderingCursorWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactAggregator {
    private static final String TAG = "ContactAggregator";
    private static final boolean VERBOSE_LOGGING = Log.isLoggable((String)"ContactAggregator", (int)2);
    private static final String STRUCTURED_NAME_BASED_LOOKUP_SQL = "name_type IN (0,1,2)";
    public static final int LOG_SYNC_CONTACTS_AGGREGATION = 2747;
    private static final int PRIMARY_HIT_LIMIT = 15;
    private static final String PRIMARY_HIT_LIMIT_STRING = String.valueOf(15);
    private static final int SECONDARY_HIT_LIMIT = 20;
    private static final String SECONDARY_HIT_LIMIT_STRING = String.valueOf(20);
    private static final int FIRST_LETTER_SUGGESTION_HIT_LIMIT = 100;
    private final ContactsProvider2 mContactsProvider;
    private final ContactsDatabaseHelper mDbHelper;
    private PhotoPriorityResolver mPhotoPriorityResolver;
    private boolean mEnabled = true;
    private SQLiteStatement mAggregatedPresenceReplace;
    private SQLiteStatement mPresenceContactIdUpdate;
    private SQLiteStatement mRawContactCountQuery;
    private SQLiteStatement mContactDelete;
    private SQLiteStatement mAggregatedPresenceDelete;
    private SQLiteStatement mMarkForAggregation;
    private SQLiteStatement mPhotoIdUpdate;
    private SQLiteStatement mDisplayNameUpdate;
    private SQLiteStatement mHasPhoneNumberUpdate;
    private SQLiteStatement mLookupKeyUpdate;
    private SQLiteStatement mStarredUpdate;
    private SQLiteStatement mContactIdAndMarkAggregatedUpdate;
    private SQLiteStatement mContactIdUpdate;
    private SQLiteStatement mMarkAggregatedUpdate;
    private SQLiteStatement mContactUpdate;
    private SQLiteStatement mContactInsert;
    private HashMap<Long, Integer> mRawContactsMarkedForAggregation = new HashMap();
    private String[] mSelectionArgs1 = new String[1];
    private String[] mSelectionArgs2 = new String[2];
    private String[] mSelectionArgs3 = new String[3];
    private long mMimeTypeIdEmail;
    private long mMimeTypeIdPhoto;
    private long mMimeTypeIdPhone;
    private String mRawContactsQueryByRawContactId;
    private String mRawContactsQueryByContactId;
    private StringBuilder mSb = new StringBuilder();
    private MatchCandidateList mCandidates = new MatchCandidateList();
    private ContactMatcher mMatcher = new ContactMatcher();
    private ContentValues mValues = new ContentValues();
    private DisplayNameCandidate mDisplayNameCandidate = new DisplayNameCandidate();
    private final HashSet<Long> mAggregationExceptionIds = new HashSet();
    private boolean mAggregationExceptionIdsValid;

    public ContactAggregator(ContactsProvider2 contactsProvider, ContactsDatabaseHelper contactsDatabaseHelper, PhotoPriorityResolver photoPriorityResolver) {
        this.mContactsProvider = contactsProvider;
        this.mDbHelper = contactsDatabaseHelper;
        this.mPhotoPriorityResolver = photoPriorityResolver;
        SQLiteDatabase db = this.mDbHelper.getReadableDatabase();
        String replaceAggregatePresenceSql = "INSERT OR REPLACE INTO agg_presence(presence_contact_id, mode, chat_capability) SELECT presence_contact_id,mode,chat_capability FROM presence WHERE  (mode * 10 + chat_capability) = (SELECT MAX (mode * 10 + chat_capability) FROM presence WHERE presence_contact_id=?) AND presence_contact_id=?;";
        this.mAggregatedPresenceReplace = db.compileStatement("INSERT OR REPLACE INTO agg_presence(presence_contact_id, mode, chat_capability) SELECT presence_contact_id,mode,chat_capability FROM presence WHERE  (mode * 10 + chat_capability) = (SELECT MAX (mode * 10 + chat_capability) FROM presence WHERE presence_contact_id=?) AND presence_contact_id=?;");
        this.mRawContactCountQuery = db.compileStatement("SELECT COUNT(_id) FROM raw_contacts WHERE contact_id=? AND _id<>?");
        this.mContactDelete = db.compileStatement("DELETE FROM contacts WHERE _id=?");
        this.mAggregatedPresenceDelete = db.compileStatement("DELETE FROM agg_presence WHERE presence_contact_id=?");
        this.mMarkForAggregation = db.compileStatement("UPDATE raw_contacts SET aggregation_needed=1 WHERE _id=? AND aggregation_needed=0");
        this.mPhotoIdUpdate = db.compileStatement("UPDATE contacts SET photo_id=?  WHERE _id=?");
        this.mDisplayNameUpdate = db.compileStatement("UPDATE contacts SET name_raw_contact_id=?  WHERE _id=?");
        this.mLookupKeyUpdate = db.compileStatement("UPDATE contacts SET lookup=?  WHERE _id=?");
        this.mHasPhoneNumberUpdate = db.compileStatement("UPDATE contacts SET has_phone_number=(SELECT (CASE WHEN COUNT(*)=0 THEN 0 ELSE 1 END) FROM data JOIN raw_contacts ON (data.raw_contact_id = raw_contacts._id) WHERE mimetype_id=? AND data1 NOT NULL AND contact_id=?) WHERE _id=?");
        this.mStarredUpdate = db.compileStatement("UPDATE contacts SET starred=(SELECT (CASE WHEN COUNT(starred)=0 THEN 0 ELSE 1 END) FROM raw_contacts WHERE contact_id=contacts._id AND starred=1) WHERE _id=?");
        this.mContactIdAndMarkAggregatedUpdate = db.compileStatement("UPDATE raw_contacts SET contact_id=?, aggregation_needed=0 WHERE _id=?");
        this.mContactIdUpdate = db.compileStatement("UPDATE raw_contacts SET contact_id=? WHERE _id=?");
        this.mMarkAggregatedUpdate = db.compileStatement("UPDATE raw_contacts SET aggregation_needed=0 WHERE _id=?");
        this.mPresenceContactIdUpdate = db.compileStatement("UPDATE presence SET presence_contact_id=? WHERE presence_raw_contact_id=?");
        this.mContactUpdate = db.compileStatement("UPDATE contacts SET name_raw_contact_id=?, photo_id=?, send_to_voicemail=?, custom_ringtone=?, last_time_contacted=?, times_contacted=?, starred=?, has_phone_number=?, single_is_restricted=?, lookup=?  WHERE _id=?");
        this.mContactInsert = db.compileStatement("INSERT INTO contacts (name_raw_contact_id, photo_id, send_to_voicemail, custom_ringtone, last_time_contacted, times_contacted, starred, has_phone_number, single_is_restricted, lookup, in_visible_group)  VALUES (?,?,?,?,?,?,?,?,?,?,0)");
        this.mMimeTypeIdEmail = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/email_v2");
        this.mMimeTypeIdPhoto = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/photo");
        this.mMimeTypeIdPhone = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/phone_v2");
        this.mRawContactsQueryByRawContactId = String.format("SELECT raw_contacts._id,display_name,display_name_source,account_type,account_name,sourceid,custom_ringtone,send_to_voicemail,last_time_contacted,times_contacted,starred,is_restricted,name_verified,data._id,data.mimetype_id,is_super_primary FROM raw_contacts LEFT OUTER JOIN data ON (data.raw_contact_id=raw_contacts._id AND ((mimetype_id=%d AND data15 NOT NULL) OR (mimetype_id=%d AND data1 NOT NULL))) WHERE raw_contacts._id=?", this.mMimeTypeIdPhoto, this.mMimeTypeIdPhone);
        this.mRawContactsQueryByContactId = String.format("SELECT raw_contacts._id,display_name,display_name_source,account_type,account_name,sourceid,custom_ringtone,send_to_voicemail,last_time_contacted,times_contacted,starred,is_restricted,name_verified,data._id,data.mimetype_id,is_super_primary FROM raw_contacts LEFT OUTER JOIN data ON (data.raw_contact_id=raw_contacts._id AND ((mimetype_id=%d AND data15 NOT NULL) OR (mimetype_id=%d AND data1 NOT NULL))) WHERE contact_id=? AND deleted=0", this.mMimeTypeIdPhoto, this.mMimeTypeIdPhone);
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregateInTransaction(SQLiteDatabase db) {
        int count = this.mRawContactsMarkedForAggregation.size();
        if (count == 0) {
            return;
        }
        long start = System.currentTimeMillis();
        if (VERBOSE_LOGGING) {
            Log.v((String)TAG, (String)("Contact aggregation: " + count));
        }
        EventLog.writeEvent((int)2747, (Object[])new Object[]{start, -count});
        String[] selectionArgs = new String[count];
        int index = 0;
        this.mSb.setLength(0);
        this.mSb.append("SELECT _id,contact_id, account_type,account_name FROM raw_contacts WHERE _id IN(");
        for (long rawContactId : this.mRawContactsMarkedForAggregation.keySet()) {
            if (index > 0) {
                this.mSb.append(',');
            }
            this.mSb.append('?');
            selectionArgs[index++] = String.valueOf(rawContactId);
        }
        this.mSb.append(')');
        long[] rawContactIds = new long[count];
        long[] contactIds = new long[count];
        String[] accountTypes = new String[count];
        String[] accountNames = new String[count];
        Cursor c = db.rawQuery(this.mSb.toString(), selectionArgs);
        try {
            count = c.getCount();
            index = 0;
            while (c.moveToNext()) {
                rawContactIds[index] = c.getLong(0);
                contactIds[index] = c.getLong(1);
                accountTypes[index] = c.getString(2);
                accountNames[index] = c.getString(3);
                ++index;
            }
        }
        finally {
            c.close();
        }
        for (int i = 0; i < count; ++i) {
            this.aggregateContact(db, rawContactIds[i], accountTypes[i], accountNames[i], contactIds[i], this.mCandidates, this.mMatcher, this.mValues);
        }
        long elapsedTime = System.currentTimeMillis() - start;
        EventLog.writeEvent((int)2747, (Object[])new Object[]{elapsedTime, count});
        if (VERBOSE_LOGGING) {
            String performance = count == 0 ? "" : ", " + elapsedTime / (long)count + " ms per contact";
            Log.i((String)TAG, (String)("Contact aggregation complete: " + count + performance));
        }
    }

    public void clearPendingAggregations() {
        this.mRawContactsMarkedForAggregation.clear();
    }

    public void markNewForAggregation(long rawContactId, int aggregationMode) {
        this.mRawContactsMarkedForAggregation.put(rawContactId, aggregationMode);
    }

    public void markForAggregation(long rawContactId, int aggregationMode, boolean force) {
        if (!force && this.mRawContactsMarkedForAggregation.containsKey(rawContactId)) {
            if (aggregationMode == 0) {
                aggregationMode = this.mRawContactsMarkedForAggregation.get(rawContactId);
            }
        } else {
            this.mMarkForAggregation.bindLong(1, rawContactId);
            this.mMarkForAggregation.execute();
        }
        this.mRawContactsMarkedForAggregation.put(rawContactId, aggregationMode);
    }

    public void onRawContactInsert(SQLiteDatabase db, long rawContactId) {
        this.mSelectionArgs1[0] = String.valueOf(rawContactId);
        this.computeAggregateData(db, this.mRawContactsQueryByRawContactId, this.mSelectionArgs1, this.mContactInsert);
        long contactId = this.mContactInsert.executeInsert();
        this.setContactId(rawContactId, contactId);
        this.mDbHelper.updateContactVisible(contactId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregateContact(SQLiteDatabase db, long rawContactId) {
        long contactId = 0L;
        String accountName = null;
        String accountType = null;
        this.mSelectionArgs1[0] = String.valueOf(rawContactId);
        Cursor cursor = db.query("raw_contacts", RawContactIdAndAccountQuery.COLUMNS, "_id=?", this.mSelectionArgs1, null, null, null);
        try {
            if (cursor.moveToFirst()) {
                contactId = cursor.getLong(0);
                accountType = cursor.getString(1);
                accountName = cursor.getString(2);
            }
        }
        finally {
            cursor.close();
        }
        this.aggregateContact(db, rawContactId, accountType, accountName, contactId);
    }

    public void aggregateContact(SQLiteDatabase db, long rawContactId, String accountType, String accountName, long currentContactId) {
        if (!this.mEnabled) {
            return;
        }
        MatchCandidateList candidates = new MatchCandidateList();
        ContactMatcher matcher = new ContactMatcher();
        ContentValues values = new ContentValues();
        this.aggregateContact(db, rawContactId, accountType, accountName, currentContactId, candidates, matcher, values);
    }

    public void updateAggregateData(long contactId) {
        if (!this.mEnabled) {
            return;
        }
        SQLiteDatabase db = this.mDbHelper.getWritableDatabase();
        this.computeAggregateData(db, contactId, this.mContactUpdate);
        this.mContactUpdate.bindLong(11, contactId);
        this.mContactUpdate.execute();
        this.mDbHelper.updateContactVisible(contactId);
        this.updateAggregatedPresence(contactId);
    }

    private void updateAggregatedPresence(long contactId) {
        this.mAggregatedPresenceReplace.bindLong(1, contactId);
        this.mAggregatedPresenceReplace.bindLong(2, contactId);
        this.mAggregatedPresenceReplace.execute();
    }

    private synchronized void aggregateContact(SQLiteDatabase db, long rawContactId, String accountType, String accountName, long currentContactId, MatchCandidateList candidates, ContactMatcher matcher, ContentValues values) {
        int aggregationMode = 0;
        Integer aggModeObject = this.mRawContactsMarkedForAggregation.remove(rawContactId);
        if (aggModeObject != null) {
            aggregationMode = aggModeObject;
        }
        long contactId = -1L;
        long contactIdToSplit = -1L;
        if (aggregationMode == 0) {
            candidates.clear();
            matcher.clear();
            contactId = this.pickBestMatchBasedOnExceptions(db, rawContactId, matcher);
            if (contactId == -1L && (contactId = this.pickBestMatchBasedOnData(db, rawContactId, candidates, matcher)) != -1L && contactId != currentContactId && this.containsRawContactsFromAccount(db, contactId, accountType, accountName)) {
                contactIdToSplit = contactId;
                contactId = -1L;
            }
        } else if (aggregationMode == 3) {
            return;
        }
        long currentContactContentsCount = 0L;
        if (currentContactId != 0L) {
            this.mRawContactCountQuery.bindLong(1, currentContactId);
            this.mRawContactCountQuery.bindLong(2, rawContactId);
            currentContactContentsCount = this.mRawContactCountQuery.simpleQueryForLong();
        }
        if (contactId == -1L && currentContactId != 0L && (currentContactContentsCount == 0L || aggregationMode == 2)) {
            contactId = currentContactId;
        }
        if (contactId == currentContactId) {
            this.markAggregated(rawContactId);
        } else if (contactId == -1L) {
            this.createNewContactForRawContact(db, rawContactId);
            if (currentContactContentsCount > 0L) {
                this.updateAggregateData(currentContactId);
            }
        } else {
            if (currentContactContentsCount == 0L) {
                this.mContactDelete.bindLong(1, currentContactId);
                this.mContactDelete.execute();
                this.mAggregatedPresenceDelete.bindLong(1, currentContactId);
                this.mAggregatedPresenceDelete.execute();
            }
            this.setContactIdAndMarkAggregated(rawContactId, contactId);
            this.computeAggregateData(db, contactId, this.mContactUpdate);
            this.mContactUpdate.bindLong(11, contactId);
            this.mContactUpdate.execute();
            this.mDbHelper.updateContactVisible(contactId);
            this.updateAggregatedPresence(contactId);
        }
        if (contactIdToSplit != -1L) {
            this.splitAutomaticallyAggregatedRawContacts(db, contactIdToSplit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsRawContactsFromAccount(SQLiteDatabase db, long contactId, String accountType, String accountName) {
        String[] args;
        String query;
        if (accountType == null) {
            query = "SELECT count(_id) FROM raw_contacts WHERE contact_id=? AND account_type IS NULL  AND account_name IS NULL ";
            args = this.mSelectionArgs1;
            args[0] = String.valueOf(contactId);
        } else {
            query = "SELECT count(_id) FROM raw_contacts WHERE contact_id=? AND account_type=? AND account_name=?";
            args = this.mSelectionArgs3;
            args[0] = String.valueOf(contactId);
            args[1] = accountType;
            args[2] = accountName;
        }
        Cursor cursor = db.rawQuery(query, args);
        try {
            cursor.moveToFirst();
            boolean bl = cursor.getInt(0) != 0;
            return bl;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitAutomaticallyAggregatedRawContacts(SQLiteDatabase db, long contactId) {
        this.mSelectionArgs1[0] = String.valueOf(contactId);
        int count = (int)DatabaseUtils.longForQuery((SQLiteDatabase)db, (String)"SELECT COUNT(_id) FROM raw_contacts WHERE contact_id=?", (String[])this.mSelectionArgs1);
        if (count < 2) {
            return;
        }
        String query = "SELECT _id FROM raw_contacts WHERE contact_id=?   AND _id NOT IN (SELECT raw_contact_id1 FROM agg_exceptions WHERE type=1 UNION SELECT raw_contact_id2 FROM agg_exceptions WHERE type=1)";
        Cursor cursor = db.rawQuery(query, this.mSelectionArgs1);
        try {
            for (int i = 0; i < count - 1; ++i) {
                if (!cursor.moveToNext()) {
                    break;
                }
                long rawContactId = cursor.getLong(0);
                this.createNewContactForRawContact(db, rawContactId);
            }
        }
        finally {
            cursor.close();
        }
        if (contactId > 0L) {
            this.updateAggregateData(contactId);
        }
    }

    private void createNewContactForRawContact(SQLiteDatabase db, long rawContactId) {
        this.mSelectionArgs1[0] = String.valueOf(rawContactId);
        this.computeAggregateData(db, this.mRawContactsQueryByRawContactId, this.mSelectionArgs1, this.mContactInsert);
        long contactId = this.mContactInsert.executeInsert();
        this.setContactIdAndMarkAggregated(rawContactId, contactId);
        this.mDbHelper.updateContactVisible(contactId);
        this.setPresenceContactId(rawContactId, contactId);
        this.updateAggregatedPresence(contactId);
    }

    private void setContactId(long rawContactId, long contactId) {
        this.mContactIdUpdate.bindLong(1, contactId);
        this.mContactIdUpdate.bindLong(2, rawContactId);
        this.mContactIdUpdate.execute();
    }

    private void markAggregated(long rawContactId) {
        this.mMarkAggregatedUpdate.bindLong(1, rawContactId);
        this.mMarkAggregatedUpdate.execute();
    }

    private void setContactIdAndMarkAggregated(long rawContactId, long contactId) {
        this.mContactIdAndMarkAggregatedUpdate.bindLong(1, contactId);
        this.mContactIdAndMarkAggregatedUpdate.bindLong(2, rawContactId);
        this.mContactIdAndMarkAggregatedUpdate.execute();
    }

    private void setPresenceContactId(long rawContactId, long contactId) {
        this.mPresenceContactIdUpdate.bindLong(1, contactId);
        this.mPresenceContactIdUpdate.bindLong(2, rawContactId);
        this.mPresenceContactIdUpdate.execute();
    }

    public void invalidateAggregationExceptionCache() {
        this.mAggregationExceptionIdsValid = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prefetchAggregationExceptionIds(SQLiteDatabase db) {
        this.mAggregationExceptionIds.clear();
        Cursor c = db.query("agg_exceptions", AggregateExceptionPrefetchQuery.COLUMNS, null, null, null, null, null);
        try {
            while (c.moveToNext()) {
                long rawContactId1 = c.getLong(0);
                long rawContactId2 = c.getLong(1);
                this.mAggregationExceptionIds.add(rawContactId1);
                this.mAggregationExceptionIds.add(rawContactId2);
            }
        }
        finally {
            c.close();
        }
        this.mAggregationExceptionIdsValid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long pickBestMatchBasedOnExceptions(SQLiteDatabase db, long rawContactId, ContactMatcher matcher) {
        if (!this.mAggregationExceptionIdsValid) {
            this.prefetchAggregationExceptionIds(db);
        }
        if (!this.mAggregationExceptionIds.contains(rawContactId)) {
            return -1L;
        }
        Cursor c = db.query("agg_exceptions JOIN raw_contacts raw_contacts1  ON (agg_exceptions.raw_contact_id1 = raw_contacts1._id)  JOIN raw_contacts raw_contacts2  ON (agg_exceptions.raw_contact_id2 = raw_contacts2._id) ", AggregateExceptionQuery.COLUMNS, "raw_contact_id1=" + rawContactId + " OR " + "raw_contact_id2" + "=" + rawContactId, null, null, null, null);
        try {
            while (c.moveToNext()) {
                int type = c.getInt(0);
                long rawContactId1 = c.getLong(1);
                long contactId = -1L;
                if (rawContactId == rawContactId1) {
                    if (c.getInt(5) == 0 && !c.isNull(4)) {
                        contactId = c.getLong(4);
                    }
                } else if (c.getInt(3) == 0 && !c.isNull(2)) {
                    contactId = c.getLong(2);
                }
                if (contactId == -1L) continue;
                if (type == 1) {
                    matcher.keepIn(contactId);
                    continue;
                }
                matcher.keepOut(contactId);
            }
        }
        finally {
            c.close();
        }
        return matcher.pickBestMatch(100, true);
    }

    private long pickBestMatchBasedOnData(SQLiteDatabase db, long rawContactId, MatchCandidateList candidates, ContactMatcher matcher) {
        long bestMatch = this.updateMatchScoresBasedOnDataMatches(db, rawContactId, candidates, matcher);
        if (bestMatch == -2L) {
            return -1L;
        }
        if (bestMatch == -1L && (bestMatch = this.pickBestMatchBasedOnSecondaryData(db, rawContactId, candidates, matcher)) == -2L) {
            return -1L;
        }
        return bestMatch;
    }

    private long pickBestMatchBasedOnSecondaryData(SQLiteDatabase db, long rawContactId, MatchCandidateList candidates, ContactMatcher matcher) {
        List<Long> secondaryContactIds = matcher.prepareSecondaryMatchCandidates(70);
        if (secondaryContactIds == null || secondaryContactIds.size() > 20) {
            return -1L;
        }
        this.loadNameMatchCandidates(db, rawContactId, candidates, true);
        this.mSb.setLength(0);
        this.mSb.append("contact_id").append(" IN (");
        for (int i = 0; i < secondaryContactIds.size(); ++i) {
            if (i != 0) {
                this.mSb.append(',');
            }
            this.mSb.append(secondaryContactIds.get(i));
        }
        this.mSb.append(") AND name_type IN (0,1,2)");
        this.matchAllCandidates(db, this.mSb.toString(), candidates, matcher, 1, null);
        return matcher.pickBestMatch(50, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNameMatchCandidates(SQLiteDatabase db, long rawContactId, MatchCandidateList candidates, boolean structuredNameBased) {
        candidates.clear();
        this.mSelectionArgs1[0] = String.valueOf(rawContactId);
        Cursor c = db.query("name_lookup", NameLookupQuery.COLUMNS, structuredNameBased ? "raw_contact_id=? AND name_type IN (0,1,2)" : "raw_contact_id=?", this.mSelectionArgs1, null, null, null);
        try {
            while (c.moveToNext()) {
                String normalizedName = c.getString(0);
                int type = c.getInt(1);
                candidates.add(normalizedName, type);
            }
        }
        finally {
            c.close();
        }
    }

    private long updateMatchScoresBasedOnDataMatches(SQLiteDatabase db, long rawContactId, MatchCandidateList candidates, ContactMatcher matcher) {
        this.updateMatchScoresBasedOnNameMatches(db, rawContactId, matcher);
        long bestMatch = matcher.pickBestMatch(70, false);
        if (bestMatch != -1L) {
            return bestMatch;
        }
        this.updateMatchScoresBasedOnEmailMatches(db, rawContactId, matcher);
        this.updateMatchScoresBasedOnPhoneMatches(db, rawContactId, matcher);
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMatchScoresBasedOnNameMatches(SQLiteDatabase db, long rawContactId, ContactMatcher matcher) {
        this.mSelectionArgs1[0] = String.valueOf(rawContactId);
        Cursor c = db.query("name_lookup nameA JOIN name_lookup nameB ON (nameA.normalized_name=nameB.normalized_name) JOIN raw_contacts ON (nameB.raw_contact_id = raw_contacts._id)", NameLookupMatchQuery.COLUMNS, "nameA.raw_contact_id=? AND aggregation_needed=0", this.mSelectionArgs1, null, null, null, PRIMARY_HIT_LIMIT_STRING);
        try {
            while (c.moveToNext()) {
                long contactId = c.getLong(0);
                String name = c.getString(1);
                int nameTypeA = c.getInt(2);
                int nameTypeB = c.getInt(3);
                matcher.matchName(contactId, nameTypeA, name, nameTypeB, name, 0);
                if (nameTypeA != 3 || nameTypeB != 3) continue;
                matcher.updateScoreWithNicknameMatch(contactId);
            }
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMatchScoresBasedOnEmailMatches(SQLiteDatabase db, long rawContactId, ContactMatcher matcher) {
        this.mSelectionArgs3[0] = String.valueOf(rawContactId);
        this.mSelectionArgs3[1] = this.mSelectionArgs3[2] = String.valueOf(this.mMimeTypeIdEmail);
        Cursor c = db.query("data dataA JOIN data dataB ON (dataA.data1=dataB.data1) JOIN raw_contacts ON (dataB.raw_contact_id = raw_contacts._id)", EmailLookupQuery.COLUMNS, "dataA.raw_contact_id=? AND dataA.mimetype_id=? AND dataA.data1 NOT NULL AND dataB.mimetype_id=? AND aggregation_needed=0", this.mSelectionArgs3, null, null, null, SECONDARY_HIT_LIMIT_STRING);
        try {
            while (c.moveToNext()) {
                long contactId = c.getLong(0);
                matcher.updateScoreWithEmailMatch(contactId);
            }
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMatchScoresBasedOnPhoneMatches(SQLiteDatabase db, long rawContactId, ContactMatcher matcher) {
        this.mSelectionArgs2[0] = String.valueOf(rawContactId);
        this.mSelectionArgs2[1] = this.mDbHelper.getUseStrictPhoneNumberComparisonParameter();
        Cursor c = db.query("phone_lookup phoneA JOIN data dataA ON (dataA._id=phoneA.data_id) JOIN phone_lookup phoneB ON (phoneA.min_match=phoneB.min_match) JOIN data dataB ON (dataB._id=phoneB.data_id) JOIN raw_contacts ON (dataB.raw_contact_id = raw_contacts._id)", PhoneLookupQuery.COLUMNS, "dataA.raw_contact_id=? AND PHONE_NUMBERS_EQUAL(dataA.data1, dataB.data1,?) AND aggregation_needed=0", this.mSelectionArgs2, null, null, null, SECONDARY_HIT_LIMIT_STRING);
        try {
            while (c.moveToNext()) {
                long contactId = c.getLong(0);
                matcher.updateScoreWithPhoneNumberMatch(contactId);
            }
        }
        finally {
            c.close();
        }
    }

    private void lookupApproximateNameMatches(SQLiteDatabase db, MatchCandidateList candidates, ContactMatcher matcher) {
        HashSet<String> firstLetters = new HashSet<String>();
        for (int i = 0; i < candidates.mCount; ++i) {
            String firstLetter;
            NameMatchCandidate candidate = (NameMatchCandidate)candidates.mList.get(i);
            if (candidate.mName.length() < 2 || firstLetters.contains(firstLetter = candidate.mName.substring(0, 2))) continue;
            firstLetters.add(firstLetter);
            String selection = "(normalized_name GLOB '" + firstLetter + "*') AND " + "name_type" + " IN(" + 2 + "," + 4 + "," + 3 + ")";
            this.matchAllCandidates(db, selection, candidates, matcher, 2, String.valueOf(100));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void matchAllCandidates(SQLiteDatabase db, String selection, MatchCandidateList candidates, ContactMatcher matcher, int algorithm, String limit) {
        Cursor c = db.query("name_lookup INNER JOIN raw_contacts ON (name_lookup.raw_contact_id = raw_contacts._id)", ContactNameLookupQuery.COLUMNS, selection, null, null, null, null, limit);
        try {
            while (c.moveToNext()) {
                Long contactId = c.getLong(0);
                String name = c.getString(1);
                int nameType = c.getInt(2);
                for (int i = 0; i < candidates.mCount; ++i) {
                    NameMatchCandidate candidate = (NameMatchCandidate)candidates.mList.get(i);
                    matcher.matchName(contactId, candidate.mLookupType, candidate.mName, nameType, name, algorithm);
                }
            }
        }
        finally {
            c.close();
        }
    }

    private void computeAggregateData(SQLiteDatabase db, long contactId, SQLiteStatement statement) {
        this.mSelectionArgs1[0] = String.valueOf(contactId);
        this.computeAggregateData(db, this.mRawContactsQueryByContactId, this.mSelectionArgs1, statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeAggregateData(SQLiteDatabase db, String sql, String[] sqlArgs, SQLiteStatement statement) {
        long currentRawContactId = -1L;
        long bestPhotoId = -1L;
        boolean foundSuperPrimaryPhoto = false;
        int photoPriority = -1;
        int totalRowCount = 0;
        int contactSendToVoicemail = 0;
        String contactCustomRingtone = null;
        long contactLastTimeContacted = 0L;
        int contactTimesContacted = 0;
        int contactStarred = 0;
        int singleIsRestricted = 1;
        int hasPhoneNumber = 0;
        this.mDisplayNameCandidate.clear();
        this.mSb.setLength(0);
        Cursor c = db.rawQuery(sql, sqlArgs);
        try {
            while (c.moveToNext()) {
                boolean superPrimary;
                long rawContactId = c.getLong(0);
                if (rawContactId != currentRawContactId) {
                    int timesContacted;
                    long lastTimeContacted;
                    currentRawContactId = rawContactId;
                    ++totalRowCount;
                    String displayName = c.getString(1);
                    int displayNameSource = c.getInt(2);
                    int nameVerified = c.getInt(12);
                    String accountType = c.getString(3);
                    this.processDisplayNameCanditate(rawContactId, displayName, displayNameSource, this.mContactsProvider.isWritableAccount(accountType), nameVerified != 0);
                    if (!c.isNull(7)) {
                        boolean sendToVoicemail;
                        boolean bl = sendToVoicemail = c.getInt(7) != 0;
                        if (sendToVoicemail) {
                            ++contactSendToVoicemail;
                        }
                    }
                    if (contactCustomRingtone == null && !c.isNull(6)) {
                        contactCustomRingtone = c.getString(6);
                    }
                    if ((lastTimeContacted = c.getLong(8)) > contactLastTimeContacted) {
                        contactLastTimeContacted = lastTimeContacted;
                    }
                    if ((timesContacted = c.getInt(9)) > contactTimesContacted) {
                        contactTimesContacted = timesContacted;
                    }
                    if (c.getInt(10) != 0) {
                        contactStarred = 1;
                    }
                    if (totalRowCount > 1) {
                        singleIsRestricted = 0;
                    } else {
                        int isRestricted = c.getInt(11);
                        if (isRestricted == 0) {
                            singleIsRestricted = 0;
                        }
                    }
                    ContactLookupKey.appendToLookupKey(this.mSb, c.getString(3), c.getString(4), rawContactId, c.getString(5), displayName);
                }
                if (c.isNull(13)) continue;
                long dataId = c.getLong(13);
                int mimetypeId = c.getInt(14);
                boolean bl = superPrimary = c.getInt(15) != 0;
                if ((long)mimetypeId == this.mMimeTypeIdPhoto) {
                    if (foundSuperPrimaryPhoto) continue;
                    String accountType = c.getString(3);
                    int priority = this.mPhotoPriorityResolver.getPhotoPriority(accountType);
                    if (!superPrimary && priority <= photoPriority) continue;
                    photoPriority = priority;
                    bestPhotoId = dataId;
                    foundSuperPrimaryPhoto |= superPrimary;
                    continue;
                }
                if ((long)mimetypeId != this.mMimeTypeIdPhone) continue;
                hasPhoneNumber = 1;
            }
        }
        finally {
            c.close();
        }
        statement.bindLong(1, this.mDisplayNameCandidate.rawContactId);
        if (bestPhotoId != -1L) {
            statement.bindLong(2, bestPhotoId);
        } else {
            statement.bindNull(2);
        }
        statement.bindLong(3, totalRowCount == contactSendToVoicemail ? 1L : 0L);
        DatabaseUtils.bindObjectToProgram((SQLiteProgram)statement, (int)4, contactCustomRingtone);
        statement.bindLong(5, contactLastTimeContacted);
        statement.bindLong(6, (long)contactTimesContacted);
        statement.bindLong(7, (long)contactStarred);
        statement.bindLong(8, (long)hasPhoneNumber);
        statement.bindLong(9, (long)singleIsRestricted);
        statement.bindString(10, Uri.encode((String)this.mSb.toString()));
    }

    private void processDisplayNameCanditate(long rawContactId, String displayName, int displayNameSource, boolean writableAccount, boolean verified) {
        boolean replace = false;
        if (this.mDisplayNameCandidate.rawContactId == -1L) {
            replace = true;
        } else if (!TextUtils.isEmpty((CharSequence)displayName)) {
            if (!this.mDisplayNameCandidate.verified && verified) {
                replace = true;
            } else if (this.mDisplayNameCandidate.verified == verified) {
                if (this.mDisplayNameCandidate.displayNameSource < displayNameSource) {
                    replace = true;
                } else if (this.mDisplayNameCandidate.displayNameSource == displayNameSource) {
                    if (!this.mDisplayNameCandidate.writableAccount && writableAccount) {
                        replace = true;
                    } else if (this.mDisplayNameCandidate.writableAccount == writableAccount && NameNormalizer.compareComplexity(displayName, this.mDisplayNameCandidate.displayName) > 0) {
                        replace = true;
                    }
                }
            }
        }
        if (replace) {
            this.mDisplayNameCandidate.rawContactId = rawContactId;
            this.mDisplayNameCandidate.displayName = displayName;
            this.mDisplayNameCandidate.displayNameSource = displayNameSource;
            this.mDisplayNameCandidate.verified = verified;
            this.mDisplayNameCandidate.writableAccount = writableAccount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePhotoId(SQLiteDatabase db, long rawContactId) {
        long contactId = this.mDbHelper.getContactId(rawContactId);
        if (contactId == 0L) {
            return;
        }
        long bestPhotoId = -1L;
        int photoPriority = -1;
        long photoMimeType = this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/photo");
        String tables = "raw_contacts JOIN data ON(data.raw_contact_id=raw_contacts._id AND (mimetype_id=" + photoMimeType + " AND " + "data15" + " NOT NULL))";
        this.mSelectionArgs1[0] = String.valueOf(contactId);
        Cursor c = db.query(tables, PhotoIdQuery.COLUMNS, "contact_id=?", this.mSelectionArgs1, null, null, null);
        try {
            while (c.moveToNext()) {
                boolean superprimary;
                long dataId = c.getLong(1);
                boolean bl = superprimary = c.getInt(2) != 0;
                if (superprimary) {
                    bestPhotoId = dataId;
                    break;
                }
                String accountType = c.getString(0);
                int priority = this.mPhotoPriorityResolver.getPhotoPriority(accountType);
                if (priority <= photoPriority) continue;
                photoPriority = priority;
                bestPhotoId = dataId;
            }
        }
        finally {
            c.close();
        }
        if (bestPhotoId == -1L) {
            this.mPhotoIdUpdate.bindNull(1);
        } else {
            this.mPhotoIdUpdate.bindLong(1, bestPhotoId);
        }
        this.mPhotoIdUpdate.bindLong(2, contactId);
        this.mPhotoIdUpdate.execute();
    }

    public void updateDisplayNameForRawContact(SQLiteDatabase db, long rawContactId) {
        long contactId = this.mDbHelper.getContactId(rawContactId);
        if (contactId == 0L) {
            return;
        }
        this.updateDisplayNameForContact(db, contactId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDisplayNameForContact(SQLiteDatabase db, long contactId) {
        boolean lookupKeyUpdateNeeded = false;
        this.mDisplayNameCandidate.clear();
        this.mSelectionArgs1[0] = String.valueOf(contactId);
        Cursor c = db.query("raw_contacts", DisplayNameQuery.COLUMNS, "contact_id=?", this.mSelectionArgs1, null, null, null);
        try {
            while (c.moveToNext()) {
                long rawContactId = c.getLong(0);
                String displayName = c.getString(1);
                int displayNameSource = c.getInt(2);
                int nameVerified = c.getInt(3);
                String accountType = c.getString(5);
                this.processDisplayNameCanditate(rawContactId, displayName, displayNameSource, this.mContactsProvider.isWritableAccount(accountType), nameVerified != 0);
                lookupKeyUpdateNeeded |= c.isNull(4);
            }
        }
        finally {
            c.close();
        }
        if (this.mDisplayNameCandidate.rawContactId != -1L) {
            this.mDisplayNameUpdate.bindLong(1, this.mDisplayNameCandidate.rawContactId);
            this.mDisplayNameUpdate.bindLong(2, contactId);
            this.mDisplayNameUpdate.execute();
        }
        if (lookupKeyUpdateNeeded) {
            this.updateLookupKeyForContact(db, contactId);
        }
    }

    public void updateHasPhoneNumber(SQLiteDatabase db, long rawContactId) {
        long contactId = this.mDbHelper.getContactId(rawContactId);
        if (contactId == 0L) {
            return;
        }
        this.mHasPhoneNumberUpdate.bindLong(1, this.mDbHelper.getMimeTypeId("vnd.android.cursor.item/phone_v2"));
        this.mHasPhoneNumberUpdate.bindLong(2, contactId);
        this.mHasPhoneNumberUpdate.bindLong(3, contactId);
        this.mHasPhoneNumberUpdate.execute();
    }

    public void updateLookupKeyForRawContact(SQLiteDatabase db, long rawContactId) {
        long contactId = this.mDbHelper.getContactId(rawContactId);
        if (contactId == 0L) {
            return;
        }
        this.updateLookupKeyForContact(db, contactId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLookupKeyForContact(SQLiteDatabase db, long contactId) {
        this.mSb.setLength(0);
        this.mSelectionArgs1[0] = String.valueOf(contactId);
        Cursor c = db.query("raw_contacts", LookupKeyQuery.COLUMNS, "contact_id=?", this.mSelectionArgs1, null, null, "_id");
        try {
            while (c.moveToNext()) {
                ContactLookupKey.appendToLookupKey(this.mSb, c.getString(2), c.getString(3), c.getLong(0), c.getString(4), c.getString(1));
            }
        }
        finally {
            c.close();
        }
        if (this.mSb.length() == 0) {
            this.mLookupKeyUpdate.bindNull(1);
        } else {
            this.mLookupKeyUpdate.bindString(1, Uri.encode((String)this.mSb.toString()));
        }
        this.mLookupKeyUpdate.bindLong(2, contactId);
        this.mLookupKeyUpdate.execute();
    }

    protected void updateStarred(long rawContactId) {
        long contactId = this.mDbHelper.getContactId(rawContactId);
        if (contactId == 0L) {
            return;
        }
        this.mStarredUpdate.bindLong(1, contactId);
        this.mStarredUpdate.execute();
    }

    public Cursor queryAggregationSuggestions(SQLiteQueryBuilder qb, String[] projection, long contactId, int maxSuggestions, String filter) {
        SQLiteDatabase db = this.mDbHelper.getReadableDatabase();
        List<ContactMatcher.MatchScore> bestMatches = this.findMatchingContacts(db, contactId);
        return this.queryMatchingContacts(qb, db, contactId, projection, bestMatches, maxSuggestions, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cursor queryMatchingContacts(SQLiteQueryBuilder qb, SQLiteDatabase db, long contactId, String[] projection, List<ContactMatcher.MatchScore> bestMatches, int maxSuggestions, String filter) {
        StringBuilder sb = new StringBuilder();
        sb.append("_id");
        sb.append(" IN (");
        for (int i = 0; i < bestMatches.size(); ++i) {
            ContactMatcher.MatchScore matchScore = bestMatches.get(i);
            if (i != 0) {
                sb.append(",");
            }
            sb.append(matchScore.getContactId());
        }
        sb.append(")");
        if (!TextUtils.isEmpty((CharSequence)filter)) {
            sb.append(" AND _id IN ");
            this.mContactsProvider.appendContactFilterAsNestedQuery(sb, filter);
        }
        HashSet<Long> foundIds = new HashSet<Long>();
        Cursor cursor = db.query(qb.getTables(), ContactIdQuery.COLUMNS, sb.toString(), null, null, null, null);
        try {
            while (cursor.moveToNext()) {
                foundIds.add(cursor.getLong(0));
            }
        }
        finally {
            cursor.close();
        }
        Iterator<ContactMatcher.MatchScore> iter = bestMatches.iterator();
        while (iter.hasNext()) {
            long id = iter.next().getContactId();
            if (foundIds.contains(id)) continue;
            iter.remove();
        }
        if (bestMatches.size() > maxSuggestions) {
            bestMatches = bestMatches.subList(0, maxSuggestions);
        }
        sb.setLength(0);
        sb.append("_id");
        sb.append(" IN (");
        for (int i = 0; i < bestMatches.size(); ++i) {
            ContactMatcher.MatchScore matchScore = bestMatches.get(i);
            if (i != 0) {
                sb.append(",");
            }
            sb.append(matchScore.getContactId());
        }
        sb.append(")");
        cursor = qb.query(db, projection, sb.toString(), null, null, null, "_id");
        ArrayList<Long> sortedContactIds = new ArrayList<Long>(bestMatches.size());
        for (ContactMatcher.MatchScore matchScore : bestMatches) {
            sortedContactIds.add(matchScore.getContactId());
        }
        Collections.sort(sortedContactIds);
        int[] positionMap = new int[bestMatches.size()];
        for (int i = 0; i < positionMap.length; ++i) {
            long id = bestMatches.get(i).getContactId();
            positionMap[i] = sortedContactIds.indexOf(id);
        }
        return new ReorderingCursorWrapper(cursor, positionMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ContactMatcher.MatchScore> findMatchingContacts(SQLiteDatabase db, long contactId) {
        MatchCandidateList candidates = new MatchCandidateList();
        ContactMatcher matcher = new ContactMatcher();
        matcher.keepOut(contactId);
        Cursor c = db.query("raw_contacts", RawContactIdQuery.COLUMNS, "contact_id=" + contactId, null, null, null, null);
        try {
            while (c.moveToNext()) {
                long rawContactId = c.getLong(0);
                this.updateMatchScoresForSuggestionsBasedOnDataMatches(db, rawContactId, candidates, matcher);
            }
        }
        finally {
            c.close();
        }
        return matcher.pickBestMatches(50);
    }

    private void updateMatchScoresForSuggestionsBasedOnDataMatches(SQLiteDatabase db, long rawContactId, MatchCandidateList candidates, ContactMatcher matcher) {
        this.updateMatchScoresBasedOnNameMatches(db, rawContactId, matcher);
        this.updateMatchScoresBasedOnEmailMatches(db, rawContactId, matcher);
        this.updateMatchScoresBasedOnPhoneMatches(db, rawContactId, matcher);
        this.loadNameMatchCandidates(db, rawContactId, candidates, false);
        this.lookupApproximateNameMatches(db, candidates, matcher);
    }

    private static interface RawContactIdQuery {
        public static final String TABLE = "raw_contacts";
        public static final String[] COLUMNS = new String[]{"_id"};
        public static final int _ID = 0;
    }

    private static interface ContactIdQuery {
        public static final String[] COLUMNS = new String[]{"_id"};
        public static final int _ID = 0;
    }

    private static interface LookupKeyQuery {
        public static final String[] COLUMNS = new String[]{"_id", "display_name", "account_type", "account_name", "sourceid"};
        public static final int ID = 0;
        public static final int DISPLAY_NAME = 1;
        public static final int ACCOUNT_TYPE = 2;
        public static final int ACCOUNT_NAME = 3;
        public static final int SOURCE_ID = 4;
    }

    private static interface DisplayNameQuery {
        public static final String[] COLUMNS = new String[]{"_id", "display_name", "display_name_source", "name_verified", "sourceid", "account_type"};
        public static final int _ID = 0;
        public static final int DISPLAY_NAME = 1;
        public static final int DISPLAY_NAME_SOURCE = 2;
        public static final int NAME_VERIFIED = 3;
        public static final int SOURCE_ID = 4;
        public static final int ACCOUNT_TYPE = 5;
    }

    private static interface PhotoIdQuery {
        public static final String[] COLUMNS = new String[]{"account_type", "data._id", "is_super_primary"};
        public static final int ACCOUNT_TYPE = 0;
        public static final int DATA_ID = 1;
        public static final int IS_SUPER_PRIMARY = 2;
    }

    private static interface ContactReplaceSqlStatement {
        public static final String UPDATE_SQL = "UPDATE contacts SET name_raw_contact_id=?, photo_id=?, send_to_voicemail=?, custom_ringtone=?, last_time_contacted=?, times_contacted=?, starred=?, has_phone_number=?, single_is_restricted=?, lookup=?  WHERE _id=?";
        public static final String INSERT_SQL = "INSERT INTO contacts (name_raw_contact_id, photo_id, send_to_voicemail, custom_ringtone, last_time_contacted, times_contacted, starred, has_phone_number, single_is_restricted, lookup, in_visible_group)  VALUES (?,?,?,?,?,?,?,?,?,?,0)";
        public static final int NAME_RAW_CONTACT_ID = 1;
        public static final int PHOTO_ID = 2;
        public static final int SEND_TO_VOICEMAIL = 3;
        public static final int CUSTOM_RINGTONE = 4;
        public static final int LAST_TIME_CONTACTED = 5;
        public static final int TIMES_CONTACTED = 6;
        public static final int STARRED = 7;
        public static final int HAS_PHONE_NUMBER = 8;
        public static final int SINGLE_IS_RESTRICTED = 9;
        public static final int LOOKUP_KEY = 10;
        public static final int CONTACT_ID = 11;
    }

    private static interface RawContactsQuery {
        public static final String SQL_FORMAT = "SELECT raw_contacts._id,display_name,display_name_source,account_type,account_name,sourceid,custom_ringtone,send_to_voicemail,last_time_contacted,times_contacted,starred,is_restricted,name_verified,data._id,data.mimetype_id,is_super_primary FROM raw_contacts LEFT OUTER JOIN data ON (data.raw_contact_id=raw_contacts._id AND ((mimetype_id=%d AND data15 NOT NULL) OR (mimetype_id=%d AND data1 NOT NULL)))";
        public static final String SQL_FORMAT_BY_RAW_CONTACT_ID = "SELECT raw_contacts._id,display_name,display_name_source,account_type,account_name,sourceid,custom_ringtone,send_to_voicemail,last_time_contacted,times_contacted,starred,is_restricted,name_verified,data._id,data.mimetype_id,is_super_primary FROM raw_contacts LEFT OUTER JOIN data ON (data.raw_contact_id=raw_contacts._id AND ((mimetype_id=%d AND data15 NOT NULL) OR (mimetype_id=%d AND data1 NOT NULL))) WHERE raw_contacts._id=?";
        public static final String SQL_FORMAT_BY_CONTACT_ID = "SELECT raw_contacts._id,display_name,display_name_source,account_type,account_name,sourceid,custom_ringtone,send_to_voicemail,last_time_contacted,times_contacted,starred,is_restricted,name_verified,data._id,data.mimetype_id,is_super_primary FROM raw_contacts LEFT OUTER JOIN data ON (data.raw_contact_id=raw_contacts._id AND ((mimetype_id=%d AND data15 NOT NULL) OR (mimetype_id=%d AND data1 NOT NULL))) WHERE contact_id=? AND deleted=0";
        public static final int RAW_CONTACT_ID = 0;
        public static final int DISPLAY_NAME = 1;
        public static final int DISPLAY_NAME_SOURCE = 2;
        public static final int ACCOUNT_TYPE = 3;
        public static final int ACCOUNT_NAME = 4;
        public static final int SOURCE_ID = 5;
        public static final int CUSTOM_RINGTONE = 6;
        public static final int SEND_TO_VOICEMAIL = 7;
        public static final int LAST_TIME_CONTACTED = 8;
        public static final int TIMES_CONTACTED = 9;
        public static final int STARRED = 10;
        public static final int IS_RESTRICTED = 11;
        public static final int NAME_VERIFIED = 12;
        public static final int DATA_ID = 13;
        public static final int MIMETYPE_ID = 14;
        public static final int IS_SUPER_PRIMARY = 15;
    }

    private static interface ContactNameLookupQuery {
        public static final String TABLE = "name_lookup INNER JOIN raw_contacts ON (name_lookup.raw_contact_id = raw_contacts._id)";
        public static final String[] COLUMNS = new String[]{"contact_id", "normalized_name", "name_type"};
        public static final int CONTACT_ID = 0;
        public static final int NORMALIZED_NAME = 1;
        public static final int NAME_TYPE = 2;
    }

    private static interface PhoneLookupQuery {
        public static final String TABLE = "phone_lookup phoneA JOIN data dataA ON (dataA._id=phoneA.data_id) JOIN phone_lookup phoneB ON (phoneA.min_match=phoneB.min_match) JOIN data dataB ON (dataB._id=phoneB.data_id) JOIN raw_contacts ON (dataB.raw_contact_id = raw_contacts._id)";
        public static final String SELECTION = "dataA.raw_contact_id=? AND PHONE_NUMBERS_EQUAL(dataA.data1, dataB.data1,?) AND aggregation_needed=0";
        public static final String[] COLUMNS = new String[]{"contact_id"};
        public static final int CONTACT_ID = 0;
    }

    private static interface EmailLookupQuery {
        public static final String TABLE = "data dataA JOIN data dataB ON (dataA.data1=dataB.data1) JOIN raw_contacts ON (dataB.raw_contact_id = raw_contacts._id)";
        public static final String SELECTION = "dataA.raw_contact_id=? AND dataA.mimetype_id=? AND dataA.data1 NOT NULL AND dataB.mimetype_id=? AND aggregation_needed=0";
        public static final String[] COLUMNS = new String[]{"contact_id"};
        public static final int CONTACT_ID = 0;
    }

    private static interface NameLookupMatchQuery {
        public static final String TABLE = "name_lookup nameA JOIN name_lookup nameB ON (nameA.normalized_name=nameB.normalized_name) JOIN raw_contacts ON (nameB.raw_contact_id = raw_contacts._id)";
        public static final String SELECTION = "nameA.raw_contact_id=? AND aggregation_needed=0";
        public static final String[] COLUMNS = new String[]{"contact_id", "nameA.normalized_name", "nameA.name_type", "nameB.name_type"};
        public static final int CONTACT_ID = 0;
        public static final int NAME = 1;
        public static final int NAME_TYPE_A = 2;
        public static final int NAME_TYPE_B = 3;
    }

    private static interface NameLookupQuery {
        public static final String TABLE = "name_lookup";
        public static final String SELECTION = "raw_contact_id=?";
        public static final String SELECTION_STRUCTURED_NAME_BASED = "raw_contact_id=? AND name_type IN (0,1,2)";
        public static final String[] COLUMNS = new String[]{"normalized_name", "name_type"};
        public static final int NORMALIZED_NAME = 0;
        public static final int NAME_TYPE = 1;
    }

    static interface AggregateExceptionQuery {
        public static final String TABLE = "agg_exceptions JOIN raw_contacts raw_contacts1  ON (agg_exceptions.raw_contact_id1 = raw_contacts1._id)  JOIN raw_contacts raw_contacts2  ON (agg_exceptions.raw_contact_id2 = raw_contacts2._id) ";
        public static final String[] COLUMNS = new String[]{"type", "raw_contact_id1", "raw_contacts1.contact_id", "raw_contacts1.aggregation_needed", "raw_contacts2.contact_id", "raw_contacts2.aggregation_needed"};
        public static final int TYPE = 0;
        public static final int RAW_CONTACT_ID1 = 1;
        public static final int CONTACT_ID1 = 2;
        public static final int AGGREGATION_NEEDED_1 = 3;
        public static final int CONTACT_ID2 = 4;
        public static final int AGGREGATION_NEEDED_2 = 5;
    }

    static interface AggregateExceptionPrefetchQuery {
        public static final String TABLE = "agg_exceptions";
        public static final String[] COLUMNS = new String[]{"raw_contact_id1", "raw_contact_id2"};
        public static final int RAW_CONTACT_ID1 = 0;
        public static final int RAW_CONTACT_ID2 = 1;
    }

    private static final class RawContactIdAndAccountQuery {
        public static final String TABLE = "raw_contacts";
        public static final String[] COLUMNS = new String[]{"contact_id", "account_type", "account_name"};
        public static final String SELECTION = "_id=?";
        public static final int CONTACT_ID = 0;
        public static final int ACCOUNT_TYPE = 1;
        public static final int ACCOUNT_NAME = 2;

        private RawContactIdAndAccountQuery() {
        }
    }

    private static interface AggregationQuery {
        public static final String SQL = "SELECT _id,contact_id, account_type,account_name FROM raw_contacts WHERE _id IN(";
        public static final int _ID = 0;
        public static final int CONTACT_ID = 1;
        public static final int ACCOUNT_TYPE = 2;
        public static final int ACCOUNT_NAME = 3;
    }

    private static class DisplayNameCandidate {
        long rawContactId;
        String displayName;
        int displayNameSource;
        boolean verified;
        boolean writableAccount;

        public DisplayNameCandidate() {
            this.clear();
        }

        public void clear() {
            this.rawContactId = -1L;
            this.displayName = null;
            this.displayNameSource = 0;
            this.verified = false;
            this.writableAccount = false;
        }
    }

    private static class MatchCandidateList {
        private final ArrayList<NameMatchCandidate> mList = new ArrayList();
        private int mCount;

        private MatchCandidateList() {
        }

        public void add(String name, int nameLookupType) {
            if (this.mCount >= this.mList.size()) {
                this.mList.add(new NameMatchCandidate(name, nameLookupType));
            } else {
                NameMatchCandidate candidate = this.mList.get(this.mCount);
                candidate.mName = name;
                candidate.mLookupType = nameLookupType;
            }
            ++this.mCount;
        }

        public void clear() {
            this.mCount = 0;
        }
    }

    private static class NameMatchCandidate {
        String mName;
        int mLookupType;

        public NameMatchCandidate(String name, int nameLookupType) {
            this.mName = name;
            this.mLookupType = nameLookupType;
        }
    }
}

