/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.google.android.collect.Maps;
import java.lang.ref.SoftReference;
import java.util.BitSet;
import java.util.HashMap;

public class CommonNicknameCache {
    private static final int NICKNAME_BLOOM_FILTER_SIZE = 8191;
    private BitSet mNicknameBloomFilter;
    private HashMap<String, SoftReference<String[]>> mNicknameClusterCache = Maps.newHashMap();
    private final SQLiteDatabase mDb;

    public CommonNicknameCache(SQLiteDatabase db) {
        this.mDb = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preloadNicknameBloomFilter() {
        this.mNicknameBloomFilter = new BitSet(8192);
        Cursor cursor = this.mDb.query("nickname_lookup", NicknameLookupPreloadQuery.COLUMNS, null, null, null, null, null);
        try {
            int count = cursor.getCount();
            for (int i = 0; i < count; ++i) {
                cursor.moveToNext();
                String normalizedName = cursor.getString(0);
                int hashCode = normalizedName.hashCode();
                this.mNicknameBloomFilter.set(hashCode & 0x1FFF);
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getCommonNicknameClusters(String normalizedName) {
        SoftReference<String[]> ref;
        int hashCode;
        if (this.mNicknameBloomFilter == null) {
            this.preloadNicknameBloomFilter();
        }
        if (!this.mNicknameBloomFilter.get((hashCode = normalizedName.hashCode()) & 0x1FFF)) {
            return null;
        }
        String[] clusters = null;
        HashMap<String, SoftReference<String[]>> hashMap = this.mNicknameClusterCache;
        synchronized (hashMap) {
            if (this.mNicknameClusterCache.containsKey(normalizedName)) {
                ref = this.mNicknameClusterCache.get(normalizedName);
                if (ref == null) {
                    return null;
                }
                clusters = ref.get();
            }
        }
        if (clusters == null) {
            clusters = this.loadNicknameClusters(normalizedName);
            ref = clusters == null ? null : new SoftReference<String[]>(clusters);
            hashMap = this.mNicknameClusterCache;
            synchronized (hashMap) {
                this.mNicknameClusterCache.put(normalizedName, ref);
            }
        }
        return clusters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] loadNicknameClusters(String normalizedName) {
        String[] clusters = null;
        Cursor cursor = this.mDb.query("nickname_lookup", NicknameLookupQuery.COLUMNS, "name=?", new String[]{normalizedName}, null, null, null);
        try {
            int count = cursor.getCount();
            if (count > 0) {
                clusters = new String[count];
                for (int i = 0; i < count; ++i) {
                    cursor.moveToNext();
                    clusters[i] = cursor.getString(0);
                }
            }
        }
        finally {
            cursor.close();
        }
        return clusters;
    }

    private static interface NicknameLookupQuery {
        public static final String TABLE = "nickname_lookup";
        public static final String[] COLUMNS = new String[]{"cluster"};
        public static final int CLUSTER = 0;
    }

    private static final class NicknameLookupPreloadQuery {
        public static final String TABLE = "nickname_lookup";
        public static final String[] COLUMNS = new String[]{"name"};
        public static final int NAME = 0;

        private NicknameLookupPreloadQuery() {
        }
    }
}

