/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.contacts;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.provider.CallLog;
import com.android.providers.contacts.ContactsDatabaseHelper;
import java.util.HashMap;

public class CallLogProvider
extends ContentProvider {
    private static final int CALLS = 1;
    private static final int CALLS_ID = 2;
    private static final int CALLS_FILTER = 3;
    private static final UriMatcher sURIMatcher = new UriMatcher(-1);
    private static final HashMap<String, String> sCallsProjectionMap;
    private ContactsDatabaseHelper mDbHelper;
    private DatabaseUtils.InsertHelper mCallsInserter;
    private boolean mUseStrictPhoneNumberComparation;

    public boolean onCreate() {
        Context context = this.getContext();
        this.mDbHelper = this.getDatabaseHelper(context);
        SQLiteDatabase db = this.mDbHelper.getWritableDatabase();
        this.mCallsInserter = new DatabaseUtils.InsertHelper(db, "calls");
        this.mUseStrictPhoneNumberComparation = context.getResources().getBoolean(17629196);
        return true;
    }

    protected ContactsDatabaseHelper getDatabaseHelper(Context context) {
        return ContactsDatabaseHelper.getInstance(context);
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        int match = sURIMatcher.match(uri);
        switch (match) {
            case 1: {
                qb.setTables("calls");
                qb.setProjectionMap(sCallsProjectionMap);
                break;
            }
            case 2: {
                qb.setTables("calls");
                qb.setProjectionMap(sCallsProjectionMap);
                qb.appendWhere((CharSequence)"calls._id=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                break;
            }
            case 3: {
                qb.setTables("calls");
                qb.setProjectionMap(sCallsProjectionMap);
                String phoneNumber = (String)uri.getPathSegments().get(2);
                qb.appendWhere((CharSequence)"PHONE_NUMBERS_EQUAL(number, ");
                qb.appendWhereEscapeString(phoneNumber);
                qb.appendWhere((CharSequence)(this.mUseStrictPhoneNumberComparation ? ", 1)" : ", 0)"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URL " + uri);
            }
        }
        SQLiteDatabase db = this.mDbHelper.getReadableDatabase();
        Cursor c = qb.query(db, projection, selection, selectionArgs, null, null, sortOrder, null);
        if (c != null) {
            c.setNotificationUri(this.getContext().getContentResolver(), CallLog.CONTENT_URI);
        }
        return c;
    }

    public String getType(Uri uri) {
        int match = sURIMatcher.match(uri);
        switch (match) {
            case 1: {
                return "vnd.android.cursor.dir/calls";
            }
            case 2: {
                return "vnd.android.cursor.item/calls";
            }
            case 3: {
                return "vnd.android.cursor.dir/calls";
            }
        }
        throw new IllegalArgumentException("Unknown URI: " + uri);
    }

    public Uri insert(Uri uri, ContentValues values) {
        long rowId = this.mCallsInserter.insert(values);
        if (rowId > 0L) {
            this.notifyChange();
            return ContentUris.withAppendedId((Uri)uri, (long)rowId);
        }
        return null;
    }

    public int update(Uri url, ContentValues values, String selection, String[] selectionArgs) {
        String where;
        SQLiteDatabase db = this.mDbHelper.getWritableDatabase();
        int matchedUriId = sURIMatcher.match(url);
        switch (matchedUriId) {
            case 1: {
                where = selection;
                break;
            }
            case 2: {
                where = DatabaseUtils.concatenateWhere((String)selection, (String)("_id=" + (String)url.getPathSegments().get(1)));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot update URL: " + url);
            }
        }
        int count = db.update("calls", values, where, selectionArgs);
        if (count > 0) {
            this.notifyChange();
        }
        return count;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        SQLiteDatabase db = this.mDbHelper.getWritableDatabase();
        int matchedUriId = sURIMatcher.match(uri);
        switch (matchedUriId) {
            case 1: {
                int count = db.delete("calls", selection, selectionArgs);
                if (count > 0) {
                    this.notifyChange();
                }
                return count;
            }
        }
        throw new UnsupportedOperationException("Cannot delete that URL: " + uri);
    }

    protected void notifyChange() {
        this.getContext().getContentResolver().notifyChange(CallLog.CONTENT_URI, null, false);
    }

    static {
        sURIMatcher.addURI("call_log", "calls", 1);
        sURIMatcher.addURI("call_log", "calls/#", 2);
        sURIMatcher.addURI("call_log", "calls/filter/*", 3);
        sCallsProjectionMap = new HashMap();
        sCallsProjectionMap.put("_id", "_id");
        sCallsProjectionMap.put("number", "number");
        sCallsProjectionMap.put("date", "date");
        sCallsProjectionMap.put("duration", "duration");
        sCallsProjectionMap.put("type", "type");
        sCallsProjectionMap.put("new", "new");
        sCallsProjectionMap.put("name", "name");
        sCallsProjectionMap.put("numbertype", "numbertype");
        sCallsProjectionMap.put("numberlabel", "numberlabel");
    }
}

