/*
 * Decompiled with CFR 0.152.
 */
package com.android.common;

import android.content.SharedPreferences;
import android.net.http.AndroidHttpClient;
import android.text.format.Time;
import com.android.common.SharedPreferencesCompat;
import java.util.TreeSet;

public class OperationScheduler {
    private static final String PREFIX = "OperationScheduler_";
    private final SharedPreferences mStorage;

    public OperationScheduler(SharedPreferences storage) {
        this.mStorage = storage;
    }

    public static Options parseOptions(String spec, Options options) throws IllegalArgumentException {
        for (String param : spec.split(" +")) {
            if (param.length() == 0) continue;
            if (param.startsWith("backoff=")) {
                int plus = param.indexOf(43, 8);
                if (plus < 0) {
                    options.backoffFixedMillis = OperationScheduler.parseSeconds(param.substring(8));
                    continue;
                }
                if (plus > 8) {
                    options.backoffFixedMillis = OperationScheduler.parseSeconds(param.substring(8, plus));
                }
                options.backoffIncrementalMillis = OperationScheduler.parseSeconds(param.substring(plus + 1));
                continue;
            }
            if (param.startsWith("max=")) {
                options.maxMoratoriumMillis = OperationScheduler.parseSeconds(param.substring(4));
                continue;
            }
            if (param.startsWith("min=")) {
                options.minTriggerMillis = OperationScheduler.parseSeconds(param.substring(4));
                continue;
            }
            options.periodicIntervalMillis = param.startsWith("period=") ? OperationScheduler.parseSeconds(param.substring(7)) : OperationScheduler.parseSeconds(param);
        }
        return options;
    }

    private static long parseSeconds(String param) throws NumberFormatException {
        return (long)(Float.parseFloat(param) * 1000.0f);
    }

    public long getNextTimeMillis(Options options) {
        boolean enabledState = this.mStorage.getBoolean("OperationScheduler_enabledState", true);
        if (!enabledState) {
            return Long.MAX_VALUE;
        }
        boolean permanentError = this.mStorage.getBoolean("OperationScheduler_permanentError", false);
        if (permanentError) {
            return Long.MAX_VALUE;
        }
        int errorCount = this.mStorage.getInt("OperationScheduler_errorCount", 0);
        long now = this.currentTimeMillis();
        long lastSuccessTimeMillis = this.getTimeBefore("OperationScheduler_lastSuccessTimeMillis", now);
        long lastErrorTimeMillis = this.getTimeBefore("OperationScheduler_lastErrorTimeMillis", now);
        long triggerTimeMillis = this.mStorage.getLong("OperationScheduler_triggerTimeMillis", Long.MAX_VALUE);
        long moratoriumSetMillis = this.getTimeBefore("OperationScheduler_moratoriumSetTimeMillis", now);
        long moratoriumTimeMillis = this.getTimeBefore("OperationScheduler_moratoriumTimeMillis", moratoriumSetMillis + options.maxMoratoriumMillis);
        long time = triggerTimeMillis;
        if (options.periodicIntervalMillis > 0L) {
            time = Math.min(time, lastSuccessTimeMillis + options.periodicIntervalMillis);
        }
        time = Math.max(time, moratoriumTimeMillis);
        time = Math.max(time, lastSuccessTimeMillis + options.minTriggerMillis);
        if (errorCount > 0) {
            time = Math.max(time, lastErrorTimeMillis + options.backoffFixedMillis + options.backoffIncrementalMillis * (long)errorCount);
        }
        return time;
    }

    public long getLastSuccessTimeMillis() {
        return this.mStorage.getLong("OperationScheduler_lastSuccessTimeMillis", 0L);
    }

    public long getLastAttemptTimeMillis() {
        return Math.max(this.mStorage.getLong("OperationScheduler_lastSuccessTimeMillis", 0L), this.mStorage.getLong("OperationScheduler_lastErrorTimeMillis", 0L));
    }

    private long getTimeBefore(String name, long max) {
        long time = this.mStorage.getLong(name, 0L);
        if (time > max) {
            time = max;
            SharedPreferencesCompat.apply(this.mStorage.edit().putLong(name, time));
        }
        return time;
    }

    public void setTriggerTimeMillis(long millis) {
        SharedPreferencesCompat.apply(this.mStorage.edit().putLong("OperationScheduler_triggerTimeMillis", millis));
    }

    public void setMoratoriumTimeMillis(long millis) {
        SharedPreferencesCompat.apply(this.mStorage.edit().putLong("OperationScheduler_moratoriumTimeMillis", millis).putLong("OperationScheduler_moratoriumSetTimeMillis", this.currentTimeMillis()));
    }

    public boolean setMoratoriumTimeHttp(String retryAfter) {
        try {
            long ms = Long.valueOf(retryAfter) * 1000L;
            this.setMoratoriumTimeMillis(ms + this.currentTimeMillis());
            return true;
        }
        catch (NumberFormatException nfe) {
            try {
                this.setMoratoriumTimeMillis(AndroidHttpClient.parseDate((String)retryAfter));
                return true;
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
    }

    public void setEnabledState(boolean enabled) {
        SharedPreferencesCompat.apply(this.mStorage.edit().putBoolean("OperationScheduler_enabledState", enabled));
    }

    public void onSuccess() {
        this.resetTransientError();
        this.resetPermanentError();
        SharedPreferencesCompat.apply(this.mStorage.edit().remove("OperationScheduler_errorCount").remove("OperationScheduler_lastErrorTimeMillis").remove("OperationScheduler_permanentError").remove("OperationScheduler_triggerTimeMillis").putLong("OperationScheduler_lastSuccessTimeMillis", this.currentTimeMillis()));
    }

    public void onTransientError() {
        SharedPreferences.Editor editor = this.mStorage.edit();
        editor.putLong("OperationScheduler_lastErrorTimeMillis", this.currentTimeMillis());
        editor.putInt("OperationScheduler_errorCount", this.mStorage.getInt("OperationScheduler_errorCount", 0) + 1);
        SharedPreferencesCompat.apply(editor);
    }

    public void resetTransientError() {
        SharedPreferencesCompat.apply(this.mStorage.edit().remove("OperationScheduler_errorCount"));
    }

    public void onPermanentError() {
        SharedPreferencesCompat.apply(this.mStorage.edit().putBoolean("OperationScheduler_permanentError", true));
    }

    public void resetPermanentError() {
        SharedPreferencesCompat.apply(this.mStorage.edit().remove("OperationScheduler_permanentError"));
    }

    public String toString() {
        StringBuilder out = new StringBuilder("[OperationScheduler:");
        for (String key : new TreeSet(this.mStorage.getAll().keySet())) {
            if (!key.startsWith(PREFIX)) continue;
            if (key.endsWith("TimeMillis")) {
                Time time = new Time();
                time.set(this.mStorage.getLong(key, 0L));
                out.append(" ").append(key.substring(PREFIX.length(), key.length() - 10));
                out.append("=").append(time.format("%Y-%m-%d/%H:%M:%S"));
                continue;
            }
            out.append(" ").append(key.substring(PREFIX.length()));
            out.append("=").append(this.mStorage.getAll().get(key).toString());
        }
        return out.append("]").toString();
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static class Options {
        public long backoffFixedMillis = 0L;
        public long backoffIncrementalMillis = 5000L;
        public long maxMoratoriumMillis = 86400000L;
        public long minTriggerMillis = 0L;
        public long periodicIntervalMillis = 0L;

        public String toString() {
            return String.format("OperationScheduler.Options[backoff=%.1f+%.1f max=%.1f min=%.1f period=%.1f]", (double)this.backoffFixedMillis / 1000.0, (double)this.backoffIncrementalMillis / 1000.0, (double)this.maxMoratoriumMillis / 1000.0, (double)this.minTriggerMillis / 1000.0, (double)this.periodicIntervalMillis / 1000.0);
        }
    }
}

