/*
 * Decompiled with CFR 0.152.
 */
package com.android.cellbroadcastreceiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.cellbroadcastreceiver.CellBroadcastAlertService;
import com.android.cellbroadcastreceiver.CellBroadcastConfigService;
import com.android.internal.telephony.ITelephony;

public class CellBroadcastReceiver
extends BroadcastReceiver {
    private static final String TAG = "CellBroadcastReceiver";
    static final boolean DBG = true;

    public void onReceive(Context context, Intent intent) {
        this.onReceiveWithPrivilege(context, intent, false);
    }

    protected void onReceiveWithPrivilege(Context context, Intent intent, boolean privileged) {
        Log.d((String)TAG, (String)("onReceive " + intent));
        String action = intent.getAction();
        if ("android.intent.action.BOOT_COMPLETED".equals(action)) {
            CellBroadcastReceiver.startConfigService(context);
        } else if ("android.intent.action.AIRPLANE_MODE".equals(action)) {
            boolean airplaneModeOn = intent.getBooleanExtra("state", false);
            if (!airplaneModeOn) {
                CellBroadcastReceiver.startConfigService(context);
            }
        } else if ("android.provider.Telephony.SMS_EMERGENCY_CB_RECEIVED".equals(action) || "android.provider.Telephony.SMS_CB_RECEIVED".equals(action)) {
            if (privileged) {
                intent.setClass(context, CellBroadcastAlertService.class);
                context.startService(intent);
            } else {
                Log.e((String)TAG, (String)("ignoring unprivileged action received " + action));
            }
        } else {
            Log.w((String)TAG, (String)("onReceive() unexpected action " + action));
        }
    }

    static void startConfigService(Context context) {
        if (CellBroadcastReceiver.phoneIsCdma()) {
            Log.d((String)TAG, (String)"CDMA phone detected; doing nothing");
        } else {
            Intent serviceIntent = new Intent("ACTION_ENABLE_CHANNELS", null, context, CellBroadcastConfigService.class);
            context.startService(serviceIntent);
        }
    }

    private static boolean phoneIsCdma() {
        boolean isCdma = false;
        try {
            ITelephony phone = ITelephony.Stub.asInterface((IBinder)ServiceManager.checkService((String)"phone"));
            if (phone != null) {
                isCdma = phone.getActivePhoneType() == 2;
            }
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)"phone.getActivePhoneType() failed", (Throwable)e);
        }
        return isCdma;
    }
}

