/*
 * Decompiled with CFR 0.152.
 */
package com.android.cellbroadcastreceiver;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.SmsCbMessage;
import android.text.format.DateUtils;
import com.android.internal.telephony.gsm.SmsCbHeader;

public class CellBroadcastMessage
implements Parcelable {
    public static final String SMS_CB_MESSAGE_EXTRA = "com.android.cellbroadcastreceiver.SMS_CB_MESSAGE";
    private final int mGeographicalScope;
    private final int mSerialNumber;
    private final int mMessageCode;
    private final int mMessageIdentifier;
    private final String mLanguageCode;
    private final String mMessageBody;
    private final long mDeliveryTime;
    private boolean mIsRead;
    public static final Parcelable.Creator<CellBroadcastMessage> CREATOR = new Parcelable.Creator<CellBroadcastMessage>(){

        public CellBroadcastMessage createFromParcel(Parcel in) {
            return new CellBroadcastMessage(in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readString(), in.readString(), in.readLong(), in.readInt() != 0);
        }

        public CellBroadcastMessage[] newArray(int size) {
            return new CellBroadcastMessage[size];
        }
    };

    public CellBroadcastMessage(SmsCbMessage message) {
        this.mGeographicalScope = message.getGeographicalScope();
        this.mSerialNumber = message.getUpdateNumber();
        this.mMessageCode = message.getMessageCode();
        this.mMessageIdentifier = message.getMessageIdentifier();
        this.mLanguageCode = message.getLanguageCode();
        this.mMessageBody = message.getMessageBody();
        this.mDeliveryTime = System.currentTimeMillis();
        this.mIsRead = false;
    }

    private CellBroadcastMessage(int geoScope, int serialNumber, int messageCode, int messageId, String languageCode, String messageBody, long deliveryTime, boolean isRead) {
        this.mGeographicalScope = geoScope;
        this.mSerialNumber = serialNumber;
        this.mMessageCode = messageCode;
        this.mMessageIdentifier = messageId;
        this.mLanguageCode = languageCode;
        this.mMessageBody = messageBody;
        this.mDeliveryTime = deliveryTime;
        this.mIsRead = isRead;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mGeographicalScope);
        out.writeInt(this.mSerialNumber);
        out.writeInt(this.mMessageCode);
        out.writeInt(this.mMessageIdentifier);
        out.writeString(this.mLanguageCode);
        out.writeString(this.mMessageBody);
        out.writeLong(this.mDeliveryTime);
        out.writeInt(this.mIsRead ? 1 : 0);
    }

    public static CellBroadcastMessage createFromCursor(Cursor cursor) {
        int geoScope = cursor.getInt(1);
        int serialNum = cursor.getInt(2);
        int messageCode = cursor.getInt(3);
        int messageId = cursor.getInt(4);
        String language = cursor.getString(5);
        String body = cursor.getString(6);
        long deliveryTime = cursor.getLong(7);
        boolean isRead = cursor.getInt(8) != 0;
        return new CellBroadcastMessage(geoScope, serialNum, messageCode, messageId, language, body, deliveryTime, isRead);
    }

    public ContentValues getContentValues() {
        ContentValues cv = new ContentValues(8);
        cv.put("geo_scope", Integer.valueOf(this.mGeographicalScope));
        cv.put("serial_number", Integer.valueOf(this.mSerialNumber));
        cv.put("message_code", Integer.valueOf(this.mMessageCode));
        cv.put("message_id", Integer.valueOf(this.mMessageIdentifier));
        cv.put("language", this.mLanguageCode);
        cv.put("body", this.mMessageBody);
        cv.put("date", Long.valueOf(this.mDeliveryTime));
        cv.put("read", Boolean.valueOf(this.mIsRead));
        return cv;
    }

    public void setIsRead(boolean isRead) {
        this.mIsRead = isRead;
    }

    public int getGeographicalScope() {
        return this.mGeographicalScope;
    }

    public int getSerialNumber() {
        return this.mSerialNumber;
    }

    public int getMessageCode() {
        return this.mMessageCode;
    }

    public int getMessageIdentifier() {
        return this.mMessageIdentifier;
    }

    public String getLanguageCode() {
        return this.mLanguageCode;
    }

    public long getDeliveryTime() {
        return this.mDeliveryTime;
    }

    public String getMessageBody() {
        return this.mMessageBody;
    }

    public boolean isRead() {
        return this.mIsRead;
    }

    public boolean isPublicAlertMessage() {
        return SmsCbHeader.isEmergencyMessage((int)this.mMessageIdentifier);
    }

    public boolean isEmergencyAlertMessage() {
        int id2 = this.mMessageIdentifier;
        return SmsCbHeader.isEmergencyMessage((int)id2) && id2 != 4379;
    }

    public boolean isEtwsMessage() {
        return SmsCbHeader.isEtwsMessage((int)this.mMessageIdentifier);
    }

    public boolean isCmasMessage() {
        return SmsCbHeader.isCmasMessage((int)this.mMessageIdentifier);
    }

    public boolean isEtwsPopupAlert() {
        return SmsCbHeader.isEtwsMessage((int)this.mMessageIdentifier) && SmsCbHeader.isEtwsPopupAlert((int)this.mMessageCode);
    }

    public boolean isEtwsEmergencyUserAlert() {
        return SmsCbHeader.isEtwsMessage((int)this.mMessageIdentifier) && SmsCbHeader.isEtwsEmergencyUserAlert((int)this.mMessageCode);
    }

    public int getDialogTitleResource() {
        switch (this.mMessageIdentifier) {
            case 4352: {
                return 2131230732;
            }
            case 4353: {
                return 2131230733;
            }
            case 4354: {
                return 2131230734;
            }
            case 4355: {
                return 2131230735;
            }
            case 4356: {
                return 2131230736;
            }
            case 4370: {
                return 2131230737;
            }
            case 4371: 
            case 4372: 
            case 4373: 
            case 4374: {
                return 2131230738;
            }
            case 4375: 
            case 4376: 
            case 4377: 
            case 4378: {
                return 2131230739;
            }
            case 4379: {
                return 2131230740;
            }
            case 4380: {
                return 2131230741;
            }
            case 4381: {
                return 2131230742;
            }
            case 4382: {
                return 2131230743;
            }
        }
        if (SmsCbHeader.isEmergencyMessage((int)this.mMessageIdentifier)) {
            return 2131230744;
        }
        return 2131230745;
    }

    String getDateString(Context context) {
        int flags = 527121;
        return DateUtils.formatDateTime((Context)context, (long)this.mDeliveryTime, (int)flags);
    }

    String getSpokenDateString(Context context) {
        int flags = 17;
        return DateUtils.formatDateTime((Context)context, (long)this.mDeliveryTime, (int)flags);
    }
}

