/*
 * Decompiled with CFR 0.152.
 */
package com.android.cellbroadcastreceiver;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import android.util.AttributeSet;
import android.view.accessibility.AccessibilityEvent;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.android.cellbroadcastreceiver.CellBroadcastMessage;

public class CellBroadcastListItem
extends RelativeLayout {
    private static final String TAG = "CellBroadcastListItem";
    private static final boolean DEBUG = false;
    private CellBroadcastMessage mCbMessage;
    private TextView mChannelView;
    private TextView mMessageView;
    private TextView mDateView;
    private static final StyleSpan STYLE_BOLD = new StyleSpan(1);

    public CellBroadcastListItem(Context context) {
        super(context);
    }

    public CellBroadcastListItem(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    CellBroadcastMessage getMessage() {
        return this.mCbMessage;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mChannelView = (TextView)this.findViewById(2131361792);
        this.mDateView = (TextView)this.findViewById(2131361793);
        this.mMessageView = (TextView)this.findViewById(2131361794);
    }

    public void bind(CellBroadcastMessage message) {
        this.mCbMessage = message;
        Drawable background = message.isRead() ? this.getResources().getDrawable(2130837506) : this.getResources().getDrawable(2130837507);
        this.setBackgroundDrawable(background);
        this.mChannelView.setText(message.getDialogTitleResource());
        this.mDateView.setText((CharSequence)message.getDateString(this.getContext()));
        this.mMessageView.setText(CellBroadcastListItem.formatMessage(message));
    }

    private static CharSequence formatMessage(CellBroadcastMessage message) {
        String body = message.getMessageBody();
        SpannableStringBuilder buf = new SpannableStringBuilder((CharSequence)body);
        if (!message.isRead()) {
            buf.setSpan((Object)STYLE_BOLD, 0, buf.length(), 17);
        }
        return buf;
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        event.getText().add(this.mCbMessage.getSpokenDateString(this.getContext()));
        this.mChannelView.dispatchPopulateAccessibilityEvent(event);
        this.mMessageView.dispatchPopulateAccessibilityEvent(event);
        return true;
    }
}

