/*
 * Decompiled with CFR 0.152.
 */
package com.android.cellbroadcastreceiver;

import android.app.AlertDialog;
import android.app.ListActivity;
import android.app.NotificationManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.android.cellbroadcastreceiver.CellBroadcastAlertDialog;
import com.android.cellbroadcastreceiver.CellBroadcastDatabase;
import com.android.cellbroadcastreceiver.CellBroadcastDatabaseService;
import com.android.cellbroadcastreceiver.CellBroadcastListAdapter;
import com.android.cellbroadcastreceiver.CellBroadcastMessage;
import com.android.cellbroadcastreceiver.CellBroadcastSettings;

public class CellBroadcastListActivity
extends ListActivity {
    private static final String TAG = "CellBroadcastListActivity";
    public static final int MENU_DELETE_ALL = 3;
    public static final int MENU_PREFERENCES = 4;
    public static final int MENU_DELETE = 0;
    public static final int MENU_VIEW = 1;
    private CellBroadcastListAdapter mListAdapter;
    private SQLiteDatabase mBroadcastDb;
    private Cursor mAdapterCursor;
    private final View.OnCreateContextMenuListener mOnCreateContextMenuListener = new View.OnCreateContextMenuListener(){

        public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
            menu.add(0, 1, 0, 2131230725);
            menu.add(0, 0, 0, 2131230726);
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903041);
        ListView listView = this.getListView();
        listView.setOnCreateContextMenuListener(this.mOnCreateContextMenuListener);
        if (this.mBroadcastDb == null) {
            CellBroadcastDatabase.DatabaseHelper helper = new CellBroadcastDatabase.DatabaseHelper((Context)this);
            this.mBroadcastDb = helper.getReadableDatabase();
        }
        if (this.mAdapterCursor == null) {
            this.mAdapterCursor = CellBroadcastDatabase.getCursor(this.mBroadcastDb);
        }
        this.mListAdapter = new CellBroadcastListAdapter((Context)this, this.mAdapterCursor);
        this.setListAdapter((ListAdapter)this.mListAdapter);
        CellBroadcastDatabaseService.setActiveListActivity(this);
        this.parseIntent(this.getIntent());
    }

    protected void onDestroy() {
        if (this.mAdapterCursor != null) {
            this.mAdapterCursor.close();
            this.mAdapterCursor = null;
        }
        if (this.mBroadcastDb != null) {
            this.mBroadcastDb.close();
            this.mBroadcastDb = null;
        }
        CellBroadcastDatabaseService.setActiveListActivity(null);
        super.onDestroy();
    }

    void databaseContentChanged() {
        this.runOnUiThread(new Runnable(){

            public void run() {
                CellBroadcastListActivity.this.mAdapterCursor.requery();
            }
        });
    }

    protected void onNewIntent(Intent intent) {
        this.parseIntent(intent);
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        menu.clear();
        if (this.mListAdapter.getCount() > 0) {
            menu.add(0, 3, 0, 2131230724).setIcon(17301564);
        }
        menu.add(0, 4, 0, 2131230723).setIcon(17301577);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 3: {
                this.confirmDeleteThread(-1L);
                break;
            }
            case 4: {
                Intent intent = new Intent((Context)this, CellBroadcastSettings.class);
                this.startActivityIfNeeded(intent, -1);
                break;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        Cursor cursor = this.mListAdapter.getCursor();
        if (cursor != null && cursor.getPosition() >= 0) {
            this.showDialogAndMarkRead(cursor);
        }
    }

    public boolean onContextItemSelected(MenuItem item) {
        Cursor cursor = this.mListAdapter.getCursor();
        if (cursor != null && cursor.getPosition() >= 0) {
            switch (item.getItemId()) {
                case 0: {
                    this.confirmDeleteThread(cursor.getLong(0));
                    break;
                }
                case 1: {
                    this.showDialogAndMarkRead(cursor);
                    break;
                }
            }
        }
        return super.onContextItemSelected(item);
    }

    private void showDialogAndMarkRead(Cursor cursor) {
        CellBroadcastMessage cbm = CellBroadcastMessage.createFromCursor(cursor);
        CellBroadcastAlertDialog dialog = new CellBroadcastAlertDialog((Context)this, cbm.getDialogTitleResource(), cbm.getMessageBody(), cbm.isPublicAlertMessage(), cbm.getDeliveryTime());
        dialog.show();
    }

    public void confirmDeleteThread(long rowId) {
        DeleteThreadListener listener = new DeleteThreadListener(rowId);
        CellBroadcastListActivity.confirmDeleteThreadDialog(listener, rowId == -1L, (Context)this);
    }

    public static void confirmDeleteThreadDialog(DeleteThreadListener listener, boolean deleteAll, Context context) {
        View contents = View.inflate((Context)context, (int)2130903042, null);
        TextView msg = (TextView)contents.findViewById(2131361794);
        msg.setText(deleteAll ? 2131230729 : 2131230728);
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(2131230727).setIcon(17301543).setCancelable(true).setPositiveButton(2131230730, (DialogInterface.OnClickListener)listener).setNegativeButton(2131230731, null).setView(contents).show();
    }

    private void parseIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        Bundle extras = intent.getExtras();
        if (extras == null) {
            return;
        }
        CellBroadcastMessage cbm = (CellBroadcastMessage)extras.getParcelable("com.android.cellbroadcastreceiver.SMS_CB_MESSAGE");
        int notificationId = extras.getInt("com.android.cellbroadcastreceiver.SMS_CB_NOTIFICATION_ID");
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        notificationManager.cancel(notificationId);
        boolean isEmergencyAlert = cbm.isPublicAlertMessage();
        CellBroadcastAlertDialog dialog = new CellBroadcastAlertDialog((Context)this, cbm.getDialogTitleResource(), cbm.getMessageBody(), isEmergencyAlert, cbm.getDeliveryTime());
        dialog.show();
    }

    public class DeleteThreadListener
    implements DialogInterface.OnClickListener {
        private final long mRowId;

        public DeleteThreadListener(long rowId) {
            this.mRowId = rowId;
        }

        public void onClick(DialogInterface dialog, int whichButton) {
            if (this.mRowId != -1L) {
                Intent dbWriteIntent = new Intent((Context)CellBroadcastListActivity.this, CellBroadcastDatabaseService.class);
                dbWriteIntent.setAction("ACTION_DELETE_BROADCAST");
                dbWriteIntent.putExtra("com.android.cellbroadcastreceiver.DATABASE_ROW_ID", this.mRowId);
                CellBroadcastListActivity.this.startService(dbWriteIntent);
            } else {
                Intent dbWriteIntent = new Intent((Context)CellBroadcastListActivity.this, CellBroadcastDatabaseService.class);
                dbWriteIntent.setAction("ACTION_DELETE_ALL_BROADCASTS");
                CellBroadcastListActivity.this.startService(dbWriteIntent);
            }
            dialog.dismiss();
        }
    }
}

