/*
 * Decompiled with CFR 0.152.
 */
package com.android.cellbroadcastreceiver;

import android.app.IntentService;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.android.cellbroadcastreceiver.CellBroadcastDatabase;
import com.android.cellbroadcastreceiver.CellBroadcastListActivity;
import com.android.cellbroadcastreceiver.CellBroadcastMessage;

public class CellBroadcastDatabaseService
extends IntentService {
    private static final String TAG = "CellBroadcastDatabaseService";
    static final String ACTION_INSERT_NEW_BROADCAST = "ACTION_INSERT_NEW_BROADCAST";
    static final String ACTION_DELETE_BROADCAST = "ACTION_DELETE_BROADCAST";
    static final String ACTION_MARK_BROADCAST_READ = "ACTION_MARK_BROADCAST_READ";
    static final String ACTION_DELETE_ALL_BROADCASTS = "ACTION_DELETE_ALL_BROADCASTS";
    public static final String DATABASE_ROW_ID_EXTRA = "com.android.cellbroadcastreceiver.DATABASE_ROW_ID";
    public static final String DATABASE_DELIVERY_TIME_EXTRA = "com.android.cellbroadcastreceiver.DATABASE_DELIVERY_TIME";
    private SQLiteDatabase mBroadcastDb;
    private static CellBroadcastListActivity sActiveListActivity;

    public CellBroadcastDatabaseService() {
        super(TAG);
    }

    public void onCreate() {
        super.onCreate();
        if (this.mBroadcastDb == null) {
            CellBroadcastDatabase.DatabaseHelper helper = new CellBroadcastDatabase.DatabaseHelper((Context)this);
            this.mBroadcastDb = helper.getWritableDatabase();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mBroadcastDb != null) {
            this.mBroadcastDb.close();
            this.mBroadcastDb = null;
        }
    }

    static void setActiveListActivity(CellBroadcastListActivity activity) {
        sActiveListActivity = activity;
    }

    public void onHandleIntent(Intent intent) {
        String action = intent.getAction();
        boolean notifyActiveListActivity = false;
        if (ACTION_INSERT_NEW_BROADCAST.equals(action)) {
            CellBroadcastMessage cbm = (CellBroadcastMessage)intent.getParcelableExtra("com.android.cellbroadcastreceiver.SMS_CB_MESSAGE");
            if (cbm == null) {
                Log.e((String)TAG, (String)"ACTION_INSERT_NEW_BROADCAST with no CB message extra");
                return;
            }
            ContentValues cv = cbm.getContentValues();
            long rowId = this.mBroadcastDb.insert("broadcasts", null, cv);
            if (rowId == -1L) {
                Log.e((String)TAG, (String)"failed to insert new broadcast into database!");
            } else {
                notifyActiveListActivity = true;
            }
        } else if (ACTION_DELETE_BROADCAST.equals(action)) {
            long rowId = intent.getLongExtra(DATABASE_ROW_ID_EXTRA, -1L);
            if (rowId == -1L) {
                Log.e((String)TAG, (String)"ACTION_DELETE_BROADCAST missing row ID to delete");
                return;
            }
            int rowCount = this.mBroadcastDb.delete("broadcasts", "_id=?", new String[]{Long.toString(rowId)});
            if (rowCount != 0) {
                notifyActiveListActivity = true;
            }
        } else if (ACTION_DELETE_ALL_BROADCASTS.equals(action)) {
            this.mBroadcastDb.delete("broadcasts", null, null);
            notifyActiveListActivity = true;
        } else if (ACTION_MARK_BROADCAST_READ.equals(action)) {
            long rowId = intent.getLongExtra(DATABASE_ROW_ID_EXTRA, -1L);
            long deliveryTime = intent.getLongExtra(DATABASE_DELIVERY_TIME_EXTRA, -1L);
            if (rowId == -1L && deliveryTime == -1L) {
                Log.e((String)TAG, (String)"ACTION_MARK_BROADCAST_READ missing row ID or delivery time");
                return;
            }
            ContentValues cv = new ContentValues(1);
            cv.put("read", Integer.valueOf(1));
            int rowCount = rowId != -1L ? this.mBroadcastDb.update("broadcasts", cv, "_id=?", new String[]{Long.toString(rowId)}) : this.mBroadcastDb.update("broadcasts", cv, "date=?", new String[]{Long.toString(deliveryTime)});
            if (rowCount != 0) {
                notifyActiveListActivity = true;
            }
        } else {
            Log.e((String)TAG, (String)("ignoring unexpected Intent with action " + action));
        }
        if (notifyActiveListActivity && sActiveListActivity != null) {
            sActiveListActivity.databaseContentChanged();
        }
    }
}

