/*
 * Decompiled with CFR 0.152.
 */
package com.android.cellbroadcastreceiver;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.preference.PreferenceManager;
import android.telephony.SmsManager;
import android.util.Log;

public class CellBroadcastConfigService
extends IntentService {
    private static final String TAG = "CellBroadcastConfigService";
    static final String ACTION_ENABLE_CHANNELS = "ACTION_ENABLE_CHANNELS";

    public CellBroadcastConfigService() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        if (ACTION_ENABLE_CHANNELS.equals(intent.getAction())) {
            try {
                SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
                Resources res = this.getResources();
                boolean enableEmergencyAlerts = prefs.getBoolean("enable_emergency_alerts", true);
                boolean enableChannel50Alerts = res.getBoolean(2131165186) && prefs.getBoolean("enable_channel_50_alerts", true);
                SmsManager manager = SmsManager.getDefault();
                if (enableEmergencyAlerts) {
                    Log.d((String)TAG, (String)"enabling emergency cell broadcast channels");
                    manager.enableCellBroadcastRange(4352, 6399);
                    Log.d((String)TAG, (String)"enabled emergency cell broadcast channels");
                } else {
                    Log.d((String)TAG, (String)"disabling emergency cell broadcast channels");
                    manager.disableCellBroadcastRange(4352, 6399);
                    Log.d((String)TAG, (String)"disabled emergency cell broadcast channels");
                }
                if (enableChannel50Alerts) {
                    Log.d((String)TAG, (String)"enabling cell broadcast channel 50");
                    manager.enableCellBroadcast(50);
                    Log.d((String)TAG, (String)"enabled cell broadcast channel 50");
                } else {
                    Log.d((String)TAG, (String)"disabling cell broadcast channel 50");
                    manager.disableCellBroadcast(50);
                    Log.d((String)TAG, (String)"disabled cell broadcast channel 50");
                }
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)"exception enabling cell broadcast channels", (Throwable)ex);
            }
        }
    }
}

