/*
 * Decompiled with CFR 0.152.
 */
package com.android.cellbroadcastreceiver;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.telephony.SmsCbMessage;
import android.util.Log;
import com.android.cellbroadcastreceiver.CellBroadcastAlertAudio;
import com.android.cellbroadcastreceiver.CellBroadcastDatabaseService;
import com.android.cellbroadcastreceiver.CellBroadcastListActivity;
import com.android.cellbroadcastreceiver.CellBroadcastMessage;
import com.android.cellbroadcastreceiver.CellBroadcastReceiverApp;

public class CellBroadcastAlertService
extends Service {
    private static final String TAG = "CellBroadcastAlertService";
    public static final String SMS_CB_NOTIFICATION_ID_EXTRA = "com.android.cellbroadcastreceiver.SMS_CB_NOTIFICATION_ID";

    public int onStartCommand(Intent intent, int flags, int startId) {
        String action = intent.getAction();
        if ("android.provider.Telephony.SMS_EMERGENCY_CB_RECEIVED".equals(action) || "android.provider.Telephony.SMS_CB_RECEIVED".equals(action)) {
            this.handleCellBroadcastIntent(intent);
        } else {
            Log.e((String)TAG, (String)("Unrecognized intent action: " + action));
        }
        this.stopSelf();
        return 2;
    }

    private void handleCellBroadcastIntent(Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras == null) {
            Log.e((String)TAG, (String)"received SMS_CB_RECEIVED_ACTION with no extras!");
            return;
        }
        Object[] pdus = (Object[])extras.get("pdus");
        if (pdus == null || pdus.length < 1) {
            Log.e((String)TAG, (String)"received SMS_CB_RECEIVED_ACTION with no pdus");
            return;
        }
        SmsCbMessage message = SmsCbMessage.createFromPdu((byte[])((byte[])pdus[0]));
        if (message == null) {
            Log.e((String)TAG, (String)("failed to create SmsCbMessage from PDU: " + pdus[0]));
            return;
        }
        for (int i = 1; i < pdus.length; ++i) {
            SmsCbMessage nextPage = SmsCbMessage.createFromPdu((byte[])((byte[])pdus[i]));
            if (nextPage != null) {
                message.appendToBody(nextPage.getMessageBody());
                continue;
            }
            Log.w((String)TAG, (String)("failed to append to SmsCbMessage from PDU: " + pdus[i]));
        }
        CellBroadcastMessage cbm = new CellBroadcastMessage(message);
        if (!this.isMessageEnabledByUser(cbm)) {
            Log.d((String)TAG, (String)("ignoring alert of type " + cbm.getMessageIdentifier() + " by user preference"));
            return;
        }
        this.addToNotificationBar(cbm);
        if (cbm.isEmergencyAlertMessage()) {
            Intent audioIntent = new Intent((Context)this, CellBroadcastAlertAudio.class);
            audioIntent.setAction("ACTION_START_ALERT_AUDIO");
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
            String duration = prefs.getString("alert_sound_duration", "4");
            audioIntent.putExtra("com.android.cellbroadcastreceiver.ALERT_AUDIO_DURATION", Integer.parseInt(duration));
            if (prefs.getBoolean("enable_alert_speech", true)) {
                audioIntent.putExtra("com.android.cellbroadcastreceiver.ALERT_AUDIO_MESSAGE_BODY", cbm.getMessageBody());
                String language = cbm.getLanguageCode();
                if (cbm.isEtwsMessage() && !"ja".equals(language)) {
                    Log.w((String)TAG, (String)"bad language code for ETWS - using Japanese TTS");
                    language = "ja";
                } else if (cbm.isCmasMessage() && !"en".equals(language)) {
                    Log.w((String)TAG, (String)"bad language code for CMAS - using English TTS");
                    language = "en";
                }
                audioIntent.putExtra("com.android.cellbroadcastreceiver.ALERT_AUDIO_MESSAGE_LANGUAGE", language);
            }
            this.startService(audioIntent);
        }
        Intent dbWriteIntent = new Intent((Context)this, CellBroadcastDatabaseService.class);
        dbWriteIntent.setAction("ACTION_INSERT_NEW_BROADCAST");
        dbWriteIntent.putExtra("com.android.cellbroadcastreceiver.SMS_CB_MESSAGE", (Parcelable)cbm);
        this.startService(dbWriteIntent);
    }

    private boolean isMessageEnabledByUser(CellBroadcastMessage message) {
        switch (message.getMessageIdentifier()) {
            case 4355: {
                return PreferenceManager.getDefaultSharedPreferences((Context)this).getBoolean("enable_etws_test_alerts", false);
            }
            case 4371: 
            case 4372: 
            case 4373: 
            case 4374: 
            case 4375: 
            case 4376: 
            case 4377: 
            case 4378: {
                return PreferenceManager.getDefaultSharedPreferences((Context)this).getBoolean("enable_cmas_imminent_threat_alerts", true);
            }
            case 4379: {
                return PreferenceManager.getDefaultSharedPreferences((Context)this).getBoolean("enable_cmas_amber_alerts", false);
            }
            case 4380: {
                return PreferenceManager.getDefaultSharedPreferences((Context)this).getBoolean("enable_cmas_test_alerts", false);
            }
        }
        return true;
    }

    private void addToNotificationBar(CellBroadcastMessage message) {
        int channelTitleId = message.getDialogTitleResource();
        CharSequence channelName = this.getText(channelTitleId);
        String messageBody = message.getMessageBody();
        Notification notification = new Notification(2130837508, channelName, System.currentTimeMillis());
        int notificationId = CellBroadcastReceiverApp.getCellBroadcastReceiverApp().getNextNotificationId();
        PendingIntent pi = PendingIntent.getActivity((Context)this, (int)0, (Intent)CellBroadcastAlertService.createDisplayMessageIntent((Context)this, message, notificationId), (int)0);
        notification.setLatestEventInfo((Context)this, channelName, (CharSequence)messageBody, pi);
        if (message.isEmergencyAlertMessage()) {
            notification.fullScreenIntent = pi;
            notification.defaults = 4;
        } else {
            notification.defaults = -1;
        }
        Log.i((String)TAG, (String)("addToNotificationBar notificationId: " + notificationId));
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        notificationManager.notify(notificationId, notification);
    }

    static Intent createDisplayMessageIntent(Context context, CellBroadcastMessage message, int notificationId) {
        Intent intent = new Intent(context, CellBroadcastListActivity.class);
        intent.putExtra("com.android.cellbroadcastreceiver.SMS_CB_MESSAGE", (Parcelable)message);
        intent.putExtra(SMS_CB_NOTIFICATION_ID_EXTRA, notificationId);
        intent.setType(Integer.toString(notificationId));
        return intent;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }
}

