/*
 * Decompiled with CFR 0.152.
 */
package com.android.cellbroadcastreceiver;

import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.widget.ImageView;
import com.android.cellbroadcastreceiver.CellBroadcastAlertAudio;
import com.android.cellbroadcastreceiver.CellBroadcastDatabaseService;

public class CellBroadcastAlertDialog
extends AlertDialog {
    private final boolean mShowWarningIcon;
    private final long mDeliveryTime;
    private static final int WARNING_ICON_ON_DURATION_MSEC = 800;
    private static final int WARNING_ICON_OFF_DURATION_MSEC = 800;
    private boolean mIconAnimationState;
    private boolean mStopAnimation;
    private Drawable mWarningIcon;
    private ImageView mWarningIconView;
    private KeyguardManager.KeyguardLock mKeyguardLock;
    private final Handler mAnimationHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (CellBroadcastAlertDialog.this.mIconAnimationState) {
                CellBroadcastAlertDialog.this.mWarningIconView.setAlpha(255);
                if (!CellBroadcastAlertDialog.this.mStopAnimation) {
                    CellBroadcastAlertDialog.this.mAnimationHandler.sendEmptyMessageDelayed(0, 800L);
                }
            } else {
                CellBroadcastAlertDialog.this.mWarningIconView.setAlpha(0);
                if (!CellBroadcastAlertDialog.this.mStopAnimation) {
                    CellBroadcastAlertDialog.this.mAnimationHandler.sendEmptyMessageDelayed(0, 800L);
                }
            }
            CellBroadcastAlertDialog.this.mIconAnimationState = !CellBroadcastAlertDialog.this.mIconAnimationState;
            CellBroadcastAlertDialog.this.mWarningIconView.invalidateDrawable(CellBroadcastAlertDialog.this.mWarningIcon);
        }
    };

    public CellBroadcastAlertDialog(Context context, int titleId, CharSequence body, boolean showWarningIcon, long deliveryTime) {
        super(context);
        this.mShowWarningIcon = showWarningIcon;
        this.mDeliveryTime = deliveryTime;
        this.setTitle(titleId);
        this.setMessage(body);
        this.setCancelable(true);
        this.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                dialog.dismiss();
            }
        });
        this.setButton(-3, context.getText(2131230722), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                dialog.dismiss();
            }
        });
        if (this.mShowWarningIcon) {
            this.mWarningIcon = this.getContext().getResources().getDrawable(2130837505);
            this.setIcon(this.mWarningIcon);
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        if (this.mShowWarningIcon) {
            this.getWindow().addFlags(6815873);
        }
        super.onCreate(savedInstanceState);
        if (this.mShowWarningIcon) {
            KeyguardManager km = (KeyguardManager)this.getContext().getSystemService("keyguard");
            this.mKeyguardLock = km.newKeyguardLock("CellBroadcastReceiver");
            this.mWarningIconView = (ImageView)this.findViewById(16908294);
        }
    }

    protected void onStart() {
        if (this.mShowWarningIcon) {
            this.mKeyguardLock.disableKeyguard();
            this.mAnimationHandler.sendEmptyMessageDelayed(0, 800L);
        }
    }

    protected void onStop() {
        Context context = this.getContext();
        context.stopService(new Intent(context, CellBroadcastAlertAudio.class));
        Intent intent = new Intent(context, CellBroadcastDatabaseService.class);
        intent.setAction("ACTION_MARK_BROADCAST_READ");
        intent.putExtra("com.android.cellbroadcastreceiver.DATABASE_DELIVERY_TIME", this.mDeliveryTime);
        context.startService(intent);
        if (this.mShowWarningIcon) {
            this.mKeyguardLock.reenableKeyguard();
            this.mStopAnimation = true;
        }
    }

    public void onBackPressed() {
        if (!this.mShowWarningIcon) {
            super.onBackPressed();
        }
    }
}

