/*
 * Decompiled with CFR 0.152.
 */
package com.android.cellbroadcastreceiver;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Vibrator;
import android.speech.tts.TextToSpeech;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.cellbroadcastreceiver.CellBroadcastAlertWakeLock;
import java.io.IOException;
import java.util.Locale;

public class CellBroadcastAlertAudio
extends Service
implements TextToSpeech.OnInitListener,
TextToSpeech.OnUtteranceCompletedListener {
    private static final String TAG = "CellBroadcastAlertAudio";
    static final String ACTION_START_ALERT_AUDIO = "ACTION_START_ALERT_AUDIO";
    public static final String ALERT_AUDIO_DURATION_EXTRA = "com.android.cellbroadcastreceiver.ALERT_AUDIO_DURATION";
    public static final String ALERT_AUDIO_MESSAGE_BODY = "com.android.cellbroadcastreceiver.ALERT_AUDIO_MESSAGE_BODY";
    public static final String ALERT_AUDIO_MESSAGE_LANGUAGE = "com.android.cellbroadcastreceiver.ALERT_AUDIO_MESSAGE_LANGUAGE";
    private static final int PAUSE_DURATION_BEFORE_SPEAKING_MSEC = 1000;
    private static final long[] sVibratePattern = new long[]{0L, 2000L, 500L, 1000L, 500L, 1000L, 500L};
    private static final int STATE_IDLE = 0;
    private static final int STATE_ALERTING = 1;
    private static final int STATE_PAUSING = 2;
    private static final int STATE_SPEAKING = 3;
    private int mState;
    private TextToSpeech mTts;
    private boolean mTtsEngineReady;
    private String mMessageBody;
    private String mMessageLanguage;
    private boolean mTtsLanguageSupported;
    private Vibrator mVibrator;
    private MediaPlayer mMediaPlayer;
    private AudioManager mAudioManager;
    private TelephonyManager mTelephonyManager;
    private int mInitialCallState;
    private static final int ALERT_SOUND_FINISHED = 1000;
    private static final int ALERT_PAUSE_FINISHED = 1001;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1000: {
                    Log.v((String)CellBroadcastAlertAudio.TAG, (String)"ALERT_SOUND_FINISHED");
                    CellBroadcastAlertAudio.this.stop();
                    if (CellBroadcastAlertAudio.this.mMessageBody != null && CellBroadcastAlertAudio.this.mTtsEngineReady && CellBroadcastAlertAudio.this.mTtsLanguageSupported) {
                        CellBroadcastAlertAudio.this.mHandler.sendMessageDelayed(CellBroadcastAlertAudio.this.mHandler.obtainMessage(1001), 1000L);
                        CellBroadcastAlertAudio.this.mState = 2;
                        break;
                    }
                    CellBroadcastAlertAudio.this.stopSelf();
                    CellBroadcastAlertAudio.this.mState = 0;
                    break;
                }
                case 1001: {
                    Log.v((String)CellBroadcastAlertAudio.TAG, (String)"ALERT_PAUSE_FINISHED");
                    if (CellBroadcastAlertAudio.this.mMessageBody != null && CellBroadcastAlertAudio.this.mTtsEngineReady && CellBroadcastAlertAudio.this.mTtsLanguageSupported) {
                        Log.v((String)CellBroadcastAlertAudio.TAG, (String)("Speaking broadcast text: " + CellBroadcastAlertAudio.this.mMessageBody));
                        CellBroadcastAlertAudio.this.mTts.speak(CellBroadcastAlertAudio.this.mMessageBody, 0, null);
                        CellBroadcastAlertAudio.this.mState = 3;
                        break;
                    }
                    Log.w((String)CellBroadcastAlertAudio.TAG, (String)"TTS engine not ready or language not supported");
                    CellBroadcastAlertAudio.this.stopSelf();
                    CellBroadcastAlertAudio.this.mState = 0;
                    break;
                }
                default: {
                    Log.e((String)CellBroadcastAlertAudio.TAG, (String)("Handler received unknown message, what=" + msg.what));
                }
            }
        }
    };
    private final PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        public void onCallStateChanged(int state, String ignored) {
            if (state != 0 && state != CellBroadcastAlertAudio.this.mInitialCallState) {
                CellBroadcastAlertAudio.this.stopSelf();
            }
        }
    };
    private static final float IN_CALL_VOLUME = 0.125f;

    public void onInit(int status) {
        Log.v((String)TAG, (String)("onInit() TTS engine status: " + status));
        if (status == 0) {
            this.mTtsEngineReady = true;
            this.setTtsLanguage();
        } else {
            this.mTtsEngineReady = false;
            this.mTts = null;
            Log.e((String)TAG, (String)("onInit() TTS engine error: " + status));
        }
    }

    private void setTtsLanguage() {
        if (this.mMessageLanguage != null) {
            Log.v((String)TAG, (String)("Setting TTS language to '" + this.mMessageLanguage + '\''));
            int result = this.mTts.setLanguage(new Locale(this.mMessageLanguage));
            Log.v((String)TAG, (String)("TTS setLanguage() returned: " + result));
            this.mTtsLanguageSupported = result >= 0;
        } else {
            Log.v((String)TAG, (String)"No language specified in broadcast: using default");
            this.mTtsLanguageSupported = true;
        }
    }

    public void onUtteranceCompleted(String utteranceId) {
        this.stopSelf();
    }

    public void onCreate() {
        this.mVibrator = (Vibrator)this.getSystemService("vibrator");
        this.mAudioManager = (AudioManager)this.getSystemService("audio");
        this.mTelephonyManager = (TelephonyManager)this.getSystemService("phone");
        this.mTelephonyManager.listen(this.mPhoneStateListener, 32);
        CellBroadcastAlertWakeLock.acquireCpuWakeLock((Context)this);
    }

    public void onDestroy() {
        this.stop();
        this.mTelephonyManager.listen(this.mPhoneStateListener, 0);
        CellBroadcastAlertWakeLock.releaseCpuLock();
        if (this.mTts != null) {
            this.mTts.stop();
            this.mTts.shutdown();
        }
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null) {
            this.stopSelf();
            return 2;
        }
        int duration = intent.getIntExtra(ALERT_AUDIO_DURATION_EXTRA, 4);
        this.mMessageBody = intent.getStringExtra(ALERT_AUDIO_MESSAGE_BODY);
        this.mMessageLanguage = intent.getStringExtra(ALERT_AUDIO_MESSAGE_LANGUAGE);
        if (this.mMessageBody != null) {
            if (this.mTts == null) {
                this.mTts = new TextToSpeech((Context)this, (TextToSpeech.OnInitListener)this);
            } else if (this.mTtsEngineReady) {
                this.setTtsLanguage();
            }
        }
        this.play(duration * 1000);
        this.mInitialCallState = this.mTelephonyManager.getCallState();
        return 1;
    }

    private void play(int duration) {
        this.stop();
        Log.v((String)TAG, (String)"play()");
        this.mMediaPlayer = new MediaPlayer();
        this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                Log.e((String)CellBroadcastAlertAudio.TAG, (String)"Error occurred while playing audio.");
                mp.stop();
                mp.release();
                CellBroadcastAlertAudio.this.mMediaPlayer = null;
                return true;
            }
        });
        try {
            if (this.mTelephonyManager.getCallState() != 0) {
                Log.v((String)TAG, (String)"in call: reducing volume");
                this.mMediaPlayer.setVolume(0.125f, 0.125f);
            }
            CellBroadcastAlertAudio.setDataSourceFromResource(this.getResources(), this.mMediaPlayer, 2131034112);
            this.mAudioManager.requestAudioFocus(null, 4, 2);
            CellBroadcastAlertAudio.startAlarm(this.mMediaPlayer);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Failed to play alert sound", (Throwable)ex);
        }
        this.mVibrator.vibrate(sVibratePattern, 1);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1000), (long)duration);
        this.mState = 1;
    }

    private static void startAlarm(MediaPlayer player) throws IOException, IllegalArgumentException, IllegalStateException {
        player.setAudioStreamType(4);
        player.setLooping(true);
        player.prepare();
        player.start();
    }

    private static void setDataSourceFromResource(Resources resources, MediaPlayer player, int res) throws IOException {
        AssetFileDescriptor afd = resources.openRawResourceFd(res);
        if (afd != null) {
            player.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
            afd.close();
        }
    }

    public void stop() {
        Log.v((String)TAG, (String)"stop()");
        this.mHandler.removeMessages(1000);
        this.mHandler.removeMessages(1001);
        if (this.mState == 1) {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.stop();
                this.mMediaPlayer.release();
                this.mMediaPlayer = null;
            }
            this.mVibrator.cancel();
        } else if (this.mState == 3 && this.mTts != null) {
            this.mTts.stop();
        }
        this.mAudioManager.abandonAudioFocus(null);
        this.mState = 0;
    }
}

