/*
 * Decompiled with CFR 0.152.
 */
package com.android.cellbroadcastreceiver.tests;

import android.app.Activity;
import android.content.Intent;
import android.util.Log;
import com.android.internal.telephony.EncodeException;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.IccUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class SendTestMessages {
    private static String TAG = "SendTestMessages";
    private static final int DCS_7BIT_ENGLISH = 1;
    private static final int DCS_16BIT_UCS2 = 72;
    private static final byte[] etwsMessageNormal = IccUtils.hexStringToBytes((String)"0000110011010D0A5BAE57CE770C531790E85C716CBF3044573065B9306757309707767A751F30025F37304463FA308C306B5099304830664E0B30553044FF086C178C615E81FF090000000000000000000000000000");
    private static final byte[] etwsMessageCancel = IccUtils.hexStringToBytes((String)"0000110011010D0A5148307B3069002800310030003A003500320029306E7DCA602557309707901F5831309253D66D883057307E3059FF086C178C615E81FF0900000000000000000000000000000000000000000000");
    private static final byte[] etwsMessageTest = IccUtils.hexStringToBytes((String)"0000110311010D0A5BAE57CE770C531790E85C716CBF3044573065B9306757309707300263FA308C306B5099304830664E0B30553044FF086C178C615E81FF0900000000000000000000000000000000000000000000");
    private static final byte[] gsm7BitTest = new byte[]{-64, 0, 0, 50, 64, 17, 65, -48, 113, -38, 4, -111, -53, -26, 112, -99, 77, 7, -123, -39, 112, 116, 88, 92, -90, -125, -38, -27, -7, 60, 124, 46, -125, -18, 105, 58, 26, 52, 14, -53, -27, -23, -16, -71, 12, -110, -105, -23, 117, -71, 27, 4, 15, -109, -55, 105, -9, -71, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 0};
    private static final byte[] gsm7BitTestUmts = new byte[]{1, 0, 50, -64, 0, 64, 1, 65, -48, 113, -38, 4, -111, -53, -26, 112, -99, 77, 7, -123, -39, 112, 116, 88, 92, -90, -125, -38, -27, -7, 60, 124, 46, -125, -18, 105, 58, 26, 52, 14, -53, -27, -23, -16, -71, 12, -110, -105, -23, 117, -71, 27, 4, 15, -109, -55, 105, -9, -71, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 0, 52};
    private static final byte[] gsm7BitTestMultipageUmts = new byte[]{1, 0, 1, -64, 0, 64, 2, -58, -76, 124, 78, 7, -63, -61, -25, -14, -86, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 0, 10, -45, -14, -8, -19, 38, -125, -32, -31, 115, -71, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 0, 10};
    private static final byte[] gsm7BitTestMultipage1 = new byte[]{1, 0, 1, -64, 0, 64, -58, -76, 124, 78, 7, -63, -61, -25, -14, -86, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 0};
    private static final byte[] gsm7BitTestMultipage2 = new byte[]{1, 0, 1, -64, 0, 64, -45, -14, -8, -19, 38, -125, -32, -31, 115, -71, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 0};
    private static final byte[] gsm7BitTestNoPadding = new byte[]{-64, 0, 0, 50, 64, 17, 65, -48, 113, -38, 4, -111, -53, -26, 112, -99, 77, 7, -123, -39, 112, 116, 88, 92, -90, -125, -38, -27, -7, 60, 124, 46, -125, -60, -27, -76, -5, 12, 42, -29, -61, 99, 58, 59, 15, -54, -51, 64, 99, 116, 88, 30, 30, -45, -53, -14, 57, -120, -3, 118, -97, 89, -96, 118, 57, -20, 78, -69, -49, 32, 58, -70, 44, 47, -125, -46, 115, -112, -5, 13, -126, -121, -55, -28, -76, -5, 28, 2};
    private static final byte[] gsm7BitTestNoPaddingUmts = new byte[]{1, 0, 50, -64, 0, 64, 1, 65, -48, 113, -38, 4, -111, -53, -26, 112, -99, 77, 7, -123, -39, 112, 116, 88, 92, -90, -125, -38, -27, -7, 60, 124, 46, -125, -60, -27, -76, -5, 12, 42, -29, -61, 99, 58, 59, 15, -54, -51, 64, 99, 116, 88, 30, 30, -45, -53, -14, 57, -120, -3, 118, -97, 89, -96, 118, 57, -20, 78, -69, -49, 32, 58, -70, 44, 47, -125, -46, 115, -112, -5, 13, -126, -121, -55, -28, -76, -5, 28, 2, 82};
    private static final byte[] gsm7BitTestWithLanguage = new byte[]{-64, 0, 0, 50, 4, 17, 65, -48, 113, -38, 4, -111, -53, -26, 112, -99, 77, 7, -123, -39, 112, 116, 88, 92, -90, -125, -38, -27, -7, 60, 124, 46, -125, -18, 105, 58, 26, 52, 14, -53, -27, -23, -16, -71, 12, -110, -105, -23, 117, -71, 27, 4, 15, -109, -55, 105, -9, -71, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 0};
    private static final byte[] gsm7BitTestWithLanguageInBody = new byte[]{-64, 0, 0, 50, 16, 17, 115, 123, 35, 8, 58, 78, -101, 32, 114, -39, 28, -82, -77, -23, -96, 48, 27, -114, 14, -117, -53, 116, 80, -69, 60, -97, -121, -49, 101, -48, 61, 77, 71, -125, -58, 97, -71, 60, 29, 62, -105, 65, -14, 50, -67, 46, 119, -125, -32, 97, 50, 57, -19, 62, 55, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 0};
    private static final byte[] gsm7BitTestWithLanguageInBodyUmts = new byte[]{1, 0, 50, -64, 0, 16, 1, 115, 123, 35, 8, 58, 78, -101, 32, 114, -39, 28, -82, -77, -23, -96, 48, 27, -114, 14, -117, -53, 116, 80, -69, 60, -97, -121, -49, 101, -48, 61, 77, 71, -125, -58, 97, -71, 60, 29, 62, -105, 65, -14, 50, -67, 46, 119, -125, -32, 97, 50, 57, -19, 62, 55, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 104, 52, 26, -115, 70, -93, -47, 0, 55};
    private static final byte[] gsmUcs2Test = new byte[]{-64, 0, 0, 50, 72, 17, 0, 65, 0, 32, 0, 85, 0, 67, 0, 83, 0, 50, 0, 32, 0, 109, 0, 101, 0, 115, 0, 115, 0, 97, 0, 103, 0, 101, 0, 32, 0, 99, 0, 111, 0, 110, 0, 116, 0, 97, 0, 105, 0, 110, 0, 105, 0, 110, 0, 103, 0, 32, 0, 97, 0, 32, 4, 52, 0, 32, 0, 99, 0, 104, 0, 97, 0, 114, 0, 97, 0, 99, 0, 116, 0, 101, 0, 114, 0, 13, 0, 13};
    private static final byte[] gsmUcs2TestUmts = new byte[]{1, 0, 50, -64, 0, 72, 1, 0, 65, 0, 32, 0, 85, 0, 67, 0, 83, 0, 50, 0, 32, 0, 109, 0, 101, 0, 115, 0, 115, 0, 97, 0, 103, 0, 101, 0, 32, 0, 99, 0, 111, 0, 110, 0, 116, 0, 97, 0, 105, 0, 110, 0, 105, 0, 110, 0, 103, 0, 32, 0, 97, 0, 32, 4, 52, 0, 32, 0, 99, 0, 104, 0, 97, 0, 114, 0, 97, 0, 99, 0, 116, 0, 101, 0, 114, 0, 13, 0, 13, 78};
    private static final byte[] gsmUcs2TestMultipageUmts = new byte[]{1, 0, 50, -64, 0, 72, 2, 0, 65, 0, 65, 0, 65, 0, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 6, 0, 66, 0, 66, 0, 66, 0, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 6};
    private static final byte[] gsmUcs2TestWithLanguageInBody = new byte[]{-64, 0, 0, 50, 17, 17, 120, 60, 0, 65, 0, 32, 0, 85, 0, 67, 0, 83, 0, 50, 0, 32, 0, 109, 0, 101, 0, 115, 0, 115, 0, 97, 0, 103, 0, 101, 0, 32, 0, 99, 0, 111, 0, 110, 0, 116, 0, 97, 0, 105, 0, 110, 0, 105, 0, 110, 0, 103, 0, 32, 0, 97, 0, 32, 4, 52, 0, 32, 0, 99, 0, 104, 0, 97, 0, 114, 0, 97, 0, 99, 0, 116, 0, 101, 0, 114, 0, 13};
    private static final byte[] gsmUcs2TestWithLanguageInBodyUmts = new byte[]{1, 0, 50, -64, 0, 17, 1, 120, 60, 0, 65, 0, 32, 0, 85, 0, 67, 0, 83, 0, 50, 0, 32, 0, 109, 0, 101, 0, 115, 0, 115, 0, 97, 0, 103, 0, 101, 0, 32, 0, 99, 0, 111, 0, 110, 0, 116, 0, 97, 0, 105, 0, 110, 0, 105, 0, 110, 0, 103, 0, 32, 0, 97, 0, 32, 4, 52, 0, 32, 0, 99, 0, 104, 0, 97, 0, 114, 0, 97, 0, 99, 0, 116, 0, 101, 0, 114, 0, 13, 80};

    static byte[] encodeCellBroadcast(int serialNumber, int messageId, int dcs, String message) {
        byte[] pdu = new byte[88];
        pdu[0] = (byte)(serialNumber >> 8 & 0xFF);
        pdu[1] = (byte)(serialNumber & 0xFF);
        pdu[2] = (byte)(messageId >> 8 & 0xFF);
        pdu[3] = (byte)(messageId & 0xFF);
        pdu[4] = (byte)(dcs & 0xFF);
        pdu[5] = 17;
        try {
            if (dcs == 72) {
                byte[] encodedString = message.getBytes("UTF-16");
                System.arraycopy(encodedString, 0, pdu, 6, encodedString.length);
            } else {
                byte[] encodedString = GsmAlphabet.stringToGsm7BitPacked((String)message);
                System.arraycopy(encodedString, 1, pdu, 6, encodedString.length - 1);
            }
            return pdu;
        }
        catch (EncodeException e) {
            Log.e((String)TAG, (String)"Encode Exception");
            return null;
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)"Unsupported encoding exception for UTF-16");
            return null;
        }
    }

    public static void testSendMessage7bit(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        byte[][] pdus = new byte[][]{gsm7BitTest};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public static void testSendMessage7bitUmts(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        byte[][] pdus = new byte[][]{gsm7BitTestUmts};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public static void testSendMessage7bitNoPadding(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        byte[][] pdus = new byte[][]{gsm7BitTestNoPadding};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public static void testSendMessage7bitNoPaddingUmts(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        byte[][] pdus = new byte[][]{gsm7BitTestNoPaddingUmts};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public static void testSendMessage7bitMultipageGsm(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        byte[][] pdus = new byte[][]{gsm7BitTestMultipage1, gsm7BitTestMultipage2};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public static void testSendMessage7bitMultipageUmts(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        byte[][] pdus = new byte[][]{gsm7BitTestMultipageUmts};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public static void testSendMessage7bitWithLanguage(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        byte[][] pdus = new byte[][]{gsm7BitTestWithLanguage};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public static void testSendMessage7bitWithLanguageInBody(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        byte[][] pdus = new byte[][]{gsm7BitTestWithLanguageInBody};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public static void testSendMessage7bitWithLanguageInBodyUmts(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        byte[][] pdus = new byte[][]{gsm7BitTestWithLanguageInBodyUmts};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public static void testSendMessageUcs2(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        byte[][] pdus = new byte[][]{gsmUcs2Test};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public static void testSendMessageUcs2Umts(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        byte[][] pdus = new byte[][]{gsmUcs2TestUmts};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public static void testSendMessageUcs2MultipageUmts(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        byte[][] pdus = new byte[][]{gsmUcs2TestMultipageUmts};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public static void testSendMessageUcs2WithLanguageInBody(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        byte[][] pdus = new byte[][]{gsmUcs2TestWithLanguageInBody};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public static void testSendMessageUcs2WithLanguageUmts(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        byte[][] pdus = new byte[][]{gsmUcs2TestWithLanguageInBodyUmts};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public static void testSendEtwsMessageNormal(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_EMERGENCY_CB_RECEIVED");
        byte[][] pdus = new byte[][]{etwsMessageNormal};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_EMERGENCY_BROADCAST");
    }

    public static void testSendEtwsMessageCancel(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_EMERGENCY_CB_RECEIVED");
        byte[][] pdus = new byte[][]{etwsMessageCancel};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_EMERGENCY_BROADCAST");
    }

    public static void testSendEtwsMessageTest(Activity activity) {
        Intent intent = new Intent("android.provider.Telephony.SMS_EMERGENCY_CB_RECEIVED");
        byte[][] pdus = new byte[][]{etwsMessageTest};
        intent.putExtra("pdus", (Serializable)pdus);
        activity.sendOrderedBroadcast(intent, "android.permission.RECEIVE_EMERGENCY_BROADCAST");
    }
}

