/*
 * Decompiled with CFR 0.152.
 */
package com.android.cellbroadcastreceiver;

import android.content.Intent;
import android.test.ActivityInstrumentationTestCase2;
import android.util.Log;
import com.android.cellbroadcastreceiver.CellBroadcastListActivity;
import com.android.internal.telephony.EncodeException;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.IccUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogSmsDisplayTests
extends ActivityInstrumentationTestCase2<CellBroadcastListActivity> {
    public static final String ACTION_SMS_SENT = "com.android.basicsmsreceiver.tests.SMS_SENT_ACTION";
    private static String TAG = "DialogSmsDisplayTests";
    private static final int DCS_7BIT_ENGLISH = 1;
    private static final int DCS_16BIT_UCS2 = 72;
    private static final byte[] etwsMessageNormal = IccUtils.hexStringToBytes((String)"000011001101EA307DCA602557309707901F58310D0A5BAE57CE770C531790E85C716CBF3044573065B9306757309707767A751F30025F37304463FA308C306B5099304830664E0B30553044FF086C178C615E81FF09");
    private static final byte[] etwsMessageCancel = IccUtils.hexStringToBytes((String)"000011001101EA307DCA602557309707901F5831002853D66D8800290D0A5148307B3069002800310030003A003500320029306E7DCA602557309707901F5831309253D66D883057307E3059FF086C178C615E81FF09");
    private static final byte[] etwsMessageTest = IccUtils.hexStringToBytes((String)"000011031101EA3030108A137DF430117DCA602557309707573058310D0A5BAE57CE770C531790E85C716CBF3044573065B9306757309707300263FA308C306B5099304830664E0B30553044FF086C178C615E81FF09");

    public DialogSmsDisplayTests() {
        super(CellBroadcastListActivity.class);
        Log.i((String)TAG, (String)"DialogSmsDisplayTests");
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    byte[] encodeCellBroadcast(int serialNumber, int messageId, int dcs, String message) {
        byte[] pdu = new byte[88];
        pdu[0] = (byte)(serialNumber >> 8 & 0xFF);
        pdu[1] = (byte)(serialNumber & 0xFF);
        pdu[2] = (byte)(messageId >> 8 & 0xFF);
        pdu[3] = (byte)(messageId & 0xFF);
        pdu[4] = (byte)(dcs & 0xFF);
        pdu[5] = 17;
        try {
            if (dcs == 72) {
                byte[] encodedString = message.getBytes("UTF-16");
                System.arraycopy(encodedString, 0, pdu, 6, encodedString.length);
            } else {
                byte[] encodedString = GsmAlphabet.stringToGsm7BitPacked((String)message);
                System.arraycopy(encodedString, 1, pdu, 6, encodedString.length - 1);
            }
            return pdu;
        }
        catch (EncodeException e) {
            Log.e((String)TAG, (String)"Encode Exception");
            return null;
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)"Unsupported encoding exception for UTF-16");
            return null;
        }
    }

    public void testSendMessage7bit() throws Exception {
        Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        byte[][] pdus = new byte[][]{this.encodeCellBroadcast(0, 0, 1, "Hello in GSM 7 bit")};
        intent.putExtra("pdus", (Serializable)pdus);
        ((CellBroadcastListActivity)this.getActivity()).sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public void testSendMessageUCS2() throws Exception {
        Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        byte[][] pdus = new byte[][]{this.encodeCellBroadcast(0, 0, 72, "Hello in UCS2")};
        intent.putExtra("pdus", (Serializable)pdus);
        ((CellBroadcastListActivity)this.getActivity()).sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public void testSendEtwsMessageNormal() throws Exception {
        Intent intent = new Intent("android.provider.Telephony.SMS_EMERGENCY_CB_RECEIVED");
        byte[][] pdus = new byte[][]{etwsMessageNormal};
        intent.putExtra("pdus", (Serializable)pdus);
        ((CellBroadcastListActivity)this.getActivity()).sendOrderedBroadcast(intent, "android.permission.RECEIVE_EMERGENCY_BROADCAST");
    }

    public void testSendEtwsMessageCancel() throws Exception {
        Intent intent = new Intent("android.provider.Telephony.SMS_EMERGENCY_CB_RECEIVED");
        byte[][] pdus = new byte[][]{etwsMessageCancel};
        intent.putExtra("pdus", (Serializable)pdus);
        ((CellBroadcastListActivity)this.getActivity()).sendOrderedBroadcast(intent, "android.permission.RECEIVE_EMERGENCY_BROADCAST");
    }

    public void testSendEtwsMessageTest() throws Exception {
        Intent intent = new Intent("android.provider.Telephony.SMS_EMERGENCY_CB_RECEIVED");
        byte[][] pdus = new byte[][]{etwsMessageTest};
        intent.putExtra("pdus", (Serializable)pdus);
        ((CellBroadcastListActivity)this.getActivity()).sendOrderedBroadcast(intent, "android.permission.RECEIVE_EMERGENCY_BROADCAST");
    }
}

