/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.content.Context;
import com.android.camera.ui.AbstractIndicator;
import com.android.camera.ui.BitmapTexture;
import com.android.camera.ui.ColorTexture;
import com.android.camera.ui.GLOptionHeader;
import com.android.camera.ui.GLRootView;
import com.android.camera.ui.GLView;
import com.android.camera.ui.LinearLayout;
import com.android.camera.ui.MeasureHelper;
import com.android.camera.ui.StringTexture;
import com.android.camera.ui.ZoomController;
import com.android.camera.ui.ZoomControllerListener;
import java.text.DecimalFormat;

class ZoomIndicator
extends AbstractIndicator {
    private static final DecimalFormat sZoomFormat = new DecimalFormat("#.#x");
    private static final float FONT_SIZE = 18.0f;
    private static final int FONT_COLOR = -1459617793;
    private static final int COLOR_OPTION_HEADER = -13948117;
    protected static final String TAG = "ZoomIndicator";
    private final float mFontSize;
    private ZoomController mZoomController;
    private LinearLayout mPopupContent;
    private ZoomControllerListener mZoomListener;
    private int mZoomIndex = 0;
    private int mDrawIndex = -1;
    private float[] mZoomRatios;
    private StringTexture mTitle;

    public ZoomIndicator(Context context) {
        super(context);
        this.mFontSize = GLRootView.dpToPixel(context, 18.0f);
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        int maxWidth = 0;
        int maxHeight = 0;
        int n = this.mZoomRatios == null ? 0 : this.mZoomRatios.length;
        for (int i = 0; i < n; ++i) {
            float value = this.mZoomRatios[i];
            StringTexture tex = StringTexture.newInstance(sZoomFormat.format(value), this.mFontSize, -1459617793);
            if (maxWidth < tex.getWidth()) {
                maxWidth = tex.getWidth();
            }
            if (maxHeight >= tex.getHeight()) continue;
            maxHeight = tex.getHeight();
        }
        new MeasureHelper(this).setPreferredContentSize(maxWidth, maxHeight).measure(widthSpec, heightSpec);
    }

    protected BitmapTexture getIcon() {
        if (this.mDrawIndex != this.mZoomIndex) {
            this.mDrawIndex = this.mZoomIndex;
            if (this.mTitle != null) {
                this.mTitle.deleteFromGL();
            }
            float value = this.mZoomRatios[this.mZoomIndex];
            this.mTitle = StringTexture.newInstance(sZoomFormat.format(value), this.mFontSize, -1459617793);
        }
        return this.mTitle;
    }

    public GLView getPopupContent() {
        if (this.mZoomController == null) {
            Context context = this.getGLRootView().getContext();
            this.mZoomController = new ZoomController(context);
            this.mZoomController.setAvailableZoomRatios(this.mZoomRatios);
            this.mZoomController.setPaddings(15, 6, 15, 6);
            this.mPopupContent = new LinearLayout();
            GLOptionHeader header = new GLOptionHeader(context, context.getString(2131296361));
            header.setBackground(new ColorTexture(-13948117));
            header.setPaddings(6, 3, 6, 3);
            this.mPopupContent.addComponent(header);
            this.mPopupContent.addComponent(this.mZoomController);
            this.mZoomController.setZoomListener(new MyZoomListener());
            this.mZoomController.setZoomIndex(this.mZoomIndex);
        }
        return this.mPopupContent;
    }

    public void overrideSettings(String key, String settings) {
    }

    public void reloadPreferences() {
    }

    public void setZoomRatios(float[] ratios) {
        this.mZoomRatios = ratios;
        this.mDrawIndex = -1;
        this.invalidate();
    }

    private void onZoomIndexChanged(int index) {
        if (this.mZoomIndex == index) {
            return;
        }
        this.mZoomIndex = index;
        this.invalidate();
    }

    public void setZoomListener(ZoomControllerListener listener) {
        this.mZoomListener = listener;
    }

    public void setZoomIndex(int index) {
        if (this.mZoomIndex == index) {
            return;
        }
        if (this.mZoomController != null) {
            this.mZoomController.setZoomIndex(index);
        } else {
            this.onZoomIndexChanged(index);
        }
    }

    private class MyZoomListener
    implements ZoomControllerListener {
        private MyZoomListener() {
        }

        public void onZoomChanged(int index, float value, boolean isMoving) {
            if (ZoomIndicator.this.mZoomListener != null) {
                ZoomIndicator.this.mZoomListener.onZoomChanged(index, value, isMoving);
            }
            if (ZoomIndicator.this.mZoomIndex != index) {
                ZoomIndicator.this.onZoomIndexChanged(index);
            }
        }
    }
}

