/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.android.camera.ui.CanvasTexture;

class StringTexture
extends CanvasTexture {
    private static int DEFAULT_PADDING = 1;
    private final String mText;
    private final Paint mPaint;
    private final Paint.FontMetricsInt mMetrics;

    public StringTexture(String text, Paint paint, Paint.FontMetricsInt metrics, int width, int height) {
        super(width, height);
        this.mText = text;
        this.mPaint = paint;
        this.mMetrics = metrics;
    }

    public static StringTexture newInstance(String text, Paint paint) {
        Paint.FontMetricsInt metrics = paint.getFontMetricsInt();
        int width = (int)(0.5f + paint.measureText(text)) + DEFAULT_PADDING * 2;
        int height = metrics.bottom - metrics.top + DEFAULT_PADDING * 2;
        return new StringTexture(text, paint, metrics, width, height);
    }

    public static StringTexture newInstance(String text, float textSize, int color2) {
        Paint paint = new Paint();
        paint.setTextSize(textSize);
        paint.setAntiAlias(true);
        paint.setColor(color2);
        return StringTexture.newInstance(text, paint);
    }

    protected void onDraw(Canvas canvas, Bitmap backing) {
        canvas.translate((float)DEFAULT_PADDING, (float)(DEFAULT_PADDING - this.mMetrics.ascent));
        canvas.drawText(this.mText, 0.0f, 0.0f, this.mPaint);
    }
}

