/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.FrameLayout;
import android.widget.TextView;

public class RotateRecordingTime
extends FrameLayout {
    private static final String TAG = "RotateRecordingTime";
    private float mTextSize;
    private int mOrientation;

    public RotateRecordingTime(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        TextView v = (TextView)this.findViewById(2131427348);
        this.mTextSize = v.getTextSize();
    }

    public void setOrientation(int degrees) {
        if (degrees % 90 == 0) {
            this.mOrientation = degrees % 360;
            if (this.mOrientation < 0) {
                this.mOrientation += 360;
            }
        } else {
            Log.e((String)TAG, (String)("Invalid orientation=" + degrees));
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        canvas.save();
        float width = this.getWidth();
        float height = this.getHeight();
        if (this.mOrientation == 0 || this.mOrientation == 180) {
            canvas.translate(0.0f, height / 2.0f - this.mTextSize / 2.0f);
        } else {
            canvas.translate(-width / 2.0f + this.mTextSize / 2.0f, 0.0f);
        }
        canvas.rotate((float)(-this.mOrientation), width / 2.0f, height / 2.0f);
        super.dispatchDraw(canvas);
        canvas.restore();
    }
}

