/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.content.Context;
import android.graphics.Rect;
import com.android.camera.ui.GLRootView;
import com.android.camera.ui.GLView;
import com.android.camera.ui.MeasureHelper;
import com.android.camera.ui.StringTexture;
import javax.microedition.khronos.opengles.GL11;

class RestoreSettingsItem
extends GLView {
    private static final int FONT_COLOR = -1;
    private static final float FONT_SIZE = 18.0f;
    private static final int LEFT_PADDING = 20;
    private static final int RIGHT_PADDING = 4;
    private static final int TOP_PADDING = 2;
    private static final int BOTTOM_PADDING = 2;
    private static int sLeftPadding = -1;
    private static int sRightPadding;
    private static int sTopPadding;
    private static int sBottomPadding;
    private static float sFontSize;
    private final StringTexture mText;

    private static void initializeStaticVariables(Context context) {
        if (sLeftPadding >= 0) {
            return;
        }
        sLeftPadding = GLRootView.dpToPixel(context, 20);
        sRightPadding = GLRootView.dpToPixel(context, 4);
        sTopPadding = GLRootView.dpToPixel(context, 2);
        sBottomPadding = GLRootView.dpToPixel(context, 2);
        sFontSize = GLRootView.dpToPixel(context, 18.0f);
    }

    public RestoreSettingsItem(Context context, String title) {
        RestoreSettingsItem.initializeStaticVariables(context);
        this.mText = StringTexture.newInstance(title, sFontSize, -1);
        this.setPaddings(sLeftPadding, sTopPadding, sRightPadding, sBottomPadding);
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        new MeasureHelper(this).setPreferredContentSize(this.mText.getWidth(), this.mText.getHeight()).measure(widthSpec, heightSpec);
    }

    protected void render(GLRootView root, GL11 gl) {
        Rect p = this.mPaddings;
        int height = this.getHeight() - p.top - p.bottom;
        StringTexture title = this.mText;
        title.draw(root, p.left, p.top + (height - title.getHeight()) / 2);
    }
}

