/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.android.camera.Util;
import com.android.camera.ui.BitmapTexture;

class ResourceTexture
extends BitmapTexture {
    protected final Context mContext;
    protected final int mResId;
    protected Bitmap mBitmap;

    public ResourceTexture(Context context, int resId) {
        this.mContext = Util.checkNotNull(context);
        this.mResId = resId;
    }

    protected Bitmap getBitmap() {
        if (this.mBitmap != null) {
            return this.mBitmap;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        this.mBitmap = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)this.mResId, (BitmapFactory.Options)options);
        this.setSize(this.mBitmap.getWidth(), this.mBitmap.getHeight());
        return this.mBitmap;
    }

    protected void freeBitmap(Bitmap bitmap) {
        Util.Assert(bitmap == this.mBitmap);
        bitmap.recycle();
        this.mBitmap = null;
    }
}

