/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.content.Context;
import com.android.camera.ListPreference;
import com.android.camera.ui.AbstractIndicator;
import com.android.camera.ui.ColorTexture;
import com.android.camera.ui.GLListView;
import com.android.camera.ui.GLOptionHeader;
import com.android.camera.ui.GLView;
import com.android.camera.ui.NinePatchTexture;
import com.android.camera.ui.PreferenceAdapter;
import com.android.camera.ui.ResourceTexture;
import com.android.camera.ui.RestoreSettingsItem;
import java.util.HashMap;

class OtherSettingsIndicator
extends AbstractIndicator {
    private static final int COLOR_OPTION_ITEM_HIGHLIGHT = -15198184;
    private final ListPreference[] mPreference;
    private final GLListView.Model[] mAdapters;
    private ResourceTexture mIcon;
    private GLListView mPopupContent;
    private Runnable mOnRestorePrefsClickedRunner;
    private final HashMap<String, String> mOverrides = new HashMap();

    public OtherSettingsIndicator(Context context, ListPreference[] preference) {
        super(context);
        this.mPreference = preference;
        this.mAdapters = new GLListView.Model[preference.length + 1];
    }

    protected ResourceTexture getIcon() {
        if (this.mIcon == null) {
            Context context = this.getGLRootView().getContext();
            this.mIcon = new ResourceTexture(context, 2130837562);
        }
        return this.mIcon;
    }

    public void reloadPreferences() {
        if (this.mPopupContent != null) {
            ListPreference[] prefs = this.mPreference;
            int n = prefs.length;
            for (int i = 0; i < n; ++i) {
                ((PreferenceAdapter)this.mAdapters[i]).reload();
            }
        }
    }

    public void overrideSettings(String key, String value) {
        if (value == null) {
            this.mOverrides.remove(key);
        } else {
            this.mOverrides.put(key, value);
        }
        if (this.mPopupContent != null) {
            ListPreference[] prefs = this.mPreference;
            int n = prefs.length;
            for (int i = 0; i < n; ++i) {
                if (!prefs[i].getKey().equals(key)) continue;
                ((PreferenceAdapter)this.mAdapters[i]).overrideSettings(value);
                break;
            }
        }
    }

    private UberAdapter buildUberAdapter() {
        ListPreference[] prefs = this.mPreference;
        GLListView.Model[] adapters = this.mAdapters;
        Context context = this.getGLRootView().getContext();
        int n = prefs.length;
        for (int i = 0; i < n; ++i) {
            adapters[i] = new PreferenceAdapter(context, prefs[i]);
            String override = this.mOverrides.get(prefs[i].getKey());
            if (override == null) continue;
            ((PreferenceAdapter)adapters[i]).overrideSettings(override);
        }
        adapters[prefs.length] = new RestoreSettingsModel(context);
        return new UberAdapter();
    }

    public GLView getPopupContent() {
        if (this.mPopupContent == null) {
            Context context = this.getGLRootView().getContext();
            this.mPopupContent = new GLListView(context);
            this.mPopupContent.setHighLight(new ColorTexture(-15198184));
            this.mPopupContent.setScroller(new NinePatchTexture(context, 2130837575));
            UberAdapter adapter = this.buildUberAdapter();
            this.mPopupContent.setOnItemSelectedListener(adapter);
            this.mPopupContent.setDataModel(adapter);
        }
        return this.mPopupContent;
    }

    public void setOnRestorePreferencesClickedRunner(Runnable l) {
        this.mOnRestorePrefsClickedRunner = l;
    }

    private class RestoreSettingsModel
    implements GLListView.Model,
    GLListView.OnItemSelectedListener {
        private final GLView mHeader;
        private final GLView mItem;

        public RestoreSettingsModel(Context context) {
            this.mHeader = new GLOptionHeader(context, context.getString(2131296352));
            this.mItem = new RestoreSettingsItem(context, context.getString(2131296353));
        }

        public GLView getView(int index) {
            return index == 0 ? this.mHeader : this.mItem;
        }

        public boolean isSelectable(int index) {
            return index != 0;
        }

        public int size() {
            return 2;
        }

        public void onItemSelected(GLView view, int position) {
            if (OtherSettingsIndicator.this.mOnRestorePrefsClickedRunner != null) {
                OtherSettingsIndicator.this.mOnRestorePrefsClickedRunner.run();
            }
        }
    }

    private class UberAdapter
    implements GLListView.Model,
    GLListView.OnItemSelectedListener {
        private UberAdapter() {
        }

        public GLView getView(int index) {
            for (GLListView.Model adapter : OtherSettingsIndicator.this.mAdapters) {
                if (index < adapter.size()) {
                    return adapter.getView(index);
                }
                index -= adapter.size();
            }
            return null;
        }

        public boolean isSelectable(int index) {
            for (GLListView.Model adapter : OtherSettingsIndicator.this.mAdapters) {
                if (index < adapter.size()) {
                    return adapter.isSelectable(index);
                }
                index -= adapter.size();
            }
            return true;
        }

        public int size() {
            int size = 0;
            for (GLListView.Model adapter : OtherSettingsIndicator.this.mAdapters) {
                size += adapter.size();
            }
            return size;
        }

        public void onItemSelected(GLView view, int position) {
            for (GLListView.Model adapter : OtherSettingsIndicator.this.mAdapters) {
                if (position < adapter.size()) {
                    ((GLListView.OnItemSelectedListener)((Object)adapter)).onItemSelected(view, position);
                    return;
                }
                position -= adapter.size();
            }
        }
    }
}

