/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import com.android.camera.ui.GLRootView;
import com.android.camera.ui.NinePatchChunk;
import com.android.camera.ui.ResourceTexture;

class NinePatchTexture
extends ResourceTexture {
    private NinePatchChunk mChunk;

    public NinePatchTexture(Context context, int resId) {
        super(context, resId);
    }

    protected Bitmap getBitmap() {
        Bitmap bitmap;
        if (this.mBitmap != null) {
            return this.mBitmap;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        this.mBitmap = bitmap = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)this.mResId, (BitmapFactory.Options)options);
        this.setSize(bitmap.getWidth(), bitmap.getHeight());
        this.mChunk = NinePatchChunk.deserialize(bitmap.getNinePatchChunk());
        if (this.mChunk == null) {
            throw new RuntimeException("invalid nine-patch image: " + this.mResId);
        }
        return bitmap;
    }

    public Rect getPaddings() {
        if (this.mChunk == null) {
            this.getBitmap();
        }
        return this.mChunk.mPaddings;
    }

    public NinePatchChunk getNinePatchChunk() {
        if (this.mChunk == null) {
            this.getBitmap();
        }
        return this.mChunk;
    }

    public void draw(GLRootView root, int x, int y, int w, int h) {
        root.drawNinePatch(this, x, y, w, h);
    }
}

