/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import com.android.camera.ui.AbstractIndicator;
import com.android.camera.ui.GLRootView;
import com.android.camera.ui.GLView;
import com.android.camera.ui.MeasureHelper;
import com.android.camera.ui.NinePatchTexture;
import com.android.camera.ui.Texture;
import javax.microedition.khronos.opengles.GL11;

class IndicatorBar
extends GLView {
    public static final int INDEX_NONE = -1;
    private NinePatchTexture mBackground;
    private Texture mHighlight;
    private int mSelectedIndex = -1;
    private OnItemSelectedListener mSelectedListener;
    private boolean mActivated = false;
    private boolean mSelectionChanged = false;

    public IndicatorBar() {
        Background background = new Background();
        background.setVisibility(1);
        this.addComponent(background);
    }

    public void overrideSettings(String key, String value) {
        int n = this.getComponentCount();
        for (int i = 1; i < n; ++i) {
            AbstractIndicator indicator = (AbstractIndicator)this.getComponent(i);
            indicator.overrideSettings(key, value);
        }
    }

    public void setOnItemSelectedListener(OnItemSelectedListener l) {
        this.mSelectedListener = l;
    }

    public void setBackground(NinePatchTexture background) {
        if (this.mBackground == background) {
            return;
        }
        this.mBackground = background;
        if (background != null) {
            this.setPaddings(background.getPaddings());
        } else {
            this.setPaddings(0, 0, 0, 0);
        }
        this.invalidate();
    }

    public void setHighlight(Texture highlight) {
        if (this.mHighlight == highlight) {
            return;
        }
        this.mHighlight = highlight;
        this.invalidate();
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        int width = 0;
        int height = 0;
        int n = this.getComponentCount();
        for (int i = 1; i < n; ++i) {
            GLView component = this.getComponent(i);
            component.measure(0, 0);
            width = Math.max(width, component.getMeasuredWidth());
            height += component.getMeasuredHeight();
        }
        new MeasureHelper(this).setPreferredContentSize(width, height).measure(widthSpec, heightSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.getComponent(0).layout(0, 0, right - left, bottom - top);
        int count = this.getComponentCount();
        Rect p = this.mPaddings;
        int cBottom = bottom - top - p.bottom;
        int cRight = right - left - p.right;
        int yoffset = this.mPaddings.top;
        int xoffset = this.mPaddings.left;
        for (int i = 1; i < count; ++i) {
            int cHeight = (cBottom - yoffset) / (count - i);
            int nextYoffset = yoffset + cHeight;
            this.getComponent(i).layout(xoffset, yoffset, cRight, nextYoffset);
            yoffset = nextYoffset;
        }
    }

    private void setSelectedItem(GLView view, int index) {
        if (index == this.mSelectedIndex) {
            return;
        }
        this.mSelectionChanged = true;
        this.mSelectedIndex = index;
        if (this.mSelectedListener != null) {
            if (index == -1) {
                this.mSelectedListener.onNothingSelected();
            } else {
                this.mSelectedListener.onItemSelected(view, index);
            }
        }
        this.invalidate();
    }

    public void setSelectedIndex(int index) {
        if (index == this.mSelectedIndex) {
            return;
        }
        this.setSelectedItem(index == -1 ? null : this.getComponent(index), index);
    }

    public void setActivated(boolean activated) {
        if (activated == this.mActivated) {
            return;
        }
        this.mActivated = activated;
        if (activated) {
            GLView background = this.getComponent(0);
            background.setVisibility(0);
            AlphaAnimation anim2 = new AlphaAnimation(0.0f, 1.0f);
            anim2.setDuration(200L);
            background.startAnimation((Animation)anim2);
        } else {
            GLView background = this.getComponent(0);
            background.setVisibility(1);
            AlphaAnimation anim3 = new AlphaAnimation(1.0f, 0.0f);
            anim3.setDuration(200L);
            background.startAnimation((Animation)anim3);
        }
    }

    public boolean isActivated() {
        return this.mActivated;
    }

    protected boolean dispatchTouchEvent(MotionEvent event) {
        return this.onTouch(event);
    }

    protected boolean onTouch(MotionEvent event) {
        int y = (int)event.getY();
        switch (event.getAction()) {
            case 0: {
                this.mSelectionChanged = false;
                this.setActivated(true);
            }
            case 2: {
                int n = this.getComponentCount();
                for (int i = 1; i < n; ++i) {
                    GLView component = this.getComponent(i);
                    if (y > component.mBounds.bottom) continue;
                    this.setSelectedItem(component, i - 1);
                    return true;
                }
                this.setSelectedItem(null, -1);
                break;
            }
            case 1: {
                if (this.mSelectionChanged) break;
                this.setSelectedItem(null, -1);
            }
        }
        return true;
    }

    public void reloadPreferences() {
        int n = this.getComponentCount();
        for (int i = 1; i < n; ++i) {
            ((AbstractIndicator)this.getComponent(i)).reloadPreferences();
        }
    }

    public void setOrientation(int orientation) {
        int n = this.getComponentCount();
        for (int i = 1; i < n; ++i) {
            ((AbstractIndicator)this.getComponent(i)).setOrientation(orientation);
        }
    }

    public int getSelectedIndex() {
        return this.mSelectedIndex;
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(GLView var1, int var2);

        public void onNothingSelected();
    }

    private class Background
    extends GLView {
        private Background() {
        }

        protected void render(GLRootView root, GL11 gl) {
            IndicatorBar.this.mBackground.draw(root, 0, 0, this.getWidth(), this.getHeight());
            if (IndicatorBar.this.mActivated && IndicatorBar.this.mSelectedIndex != -1 && IndicatorBar.this.mHighlight != null) {
                Rect bounds = IndicatorBar.this.getComponent((int)(((IndicatorBar)IndicatorBar.this).mSelectedIndex + 1)).mBounds;
                IndicatorBar.this.mHighlight.draw(root, bounds.left, bounds.top, bounds.width(), bounds.height());
            }
        }
    }
}

