/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import com.android.camera.CameraSettings;
import com.android.camera.ComboPreferences;
import com.android.camera.IconListPreference;
import com.android.camera.ListPreference;
import com.android.camera.PreferenceGroup;
import com.android.camera.ui.AbstractIndicator;
import com.android.camera.ui.BasicIndicator;
import com.android.camera.ui.ColorTexture;
import com.android.camera.ui.GLRootView;
import com.android.camera.ui.GLView;
import com.android.camera.ui.IndicatorBar;
import com.android.camera.ui.NinePatchTexture;
import com.android.camera.ui.PopupWindow;
import com.android.camera.ui.ResourceTexture;
import java.util.ArrayList;

public class HeadUpDisplay
extends GLView {
    private static final int INDICATOR_BAR_TIMEOUT = 5500;
    private static final int POPUP_WINDOW_TIMEOUT = 5000;
    private static final int INDICATOR_BAR_RIGHT_MARGIN = 10;
    private static final int POPUP_WINDOW_OVERLAP = 20;
    private static final int POPUP_TRIANGLE_OFFSET = 16;
    private static final int COLOR_ICONBAR_HIGHLIGHT = -1708446933;
    private static final float MAX_HEIGHT_RATIO = 0.85f;
    private static final float MAX_WIDTH_RATIO = 0.8f;
    private static final int DESELECT_INDICATOR = 0;
    private static final int DEACTIVATE_INDICATOR_BAR = 1;
    private static int sIndicatorBarRightMargin = -1;
    private static int sPopupWindowOverlap;
    private static int sPopupTriangleOffset;
    private static final String TAG = "HeadUpDisplay";
    protected IndicatorBar mIndicatorBar;
    private ComboPreferences mSharedPrefs;
    private PreferenceGroup mPreferenceGroup;
    private PopupWindow mPopupWindow;
    private GLView mAnchorView;
    private int mOrientation = 0;
    private boolean mEnabled = true;
    protected Listener mListener;
    private Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            GLRootView root = HeadUpDisplay.this.getGLRootView();
            if (root != null) {
                GLRootView gLRootView = root;
                synchronized (gLRootView) {
                    this.handleMessageLocked(msg);
                }
            } else {
                this.handleMessageLocked(msg);
            }
        }

        private void handleMessageLocked(Message msg) {
            switch (msg.what) {
                case 0: {
                    HeadUpDisplay.this.mIndicatorBar.setSelectedIndex(-1);
                    break;
                }
                case 1: {
                    if (HeadUpDisplay.this.mIndicatorBar == null) break;
                    HeadUpDisplay.this.mIndicatorBar.setActivated(false);
                }
            }
        }
    };
    private final SharedPreferences.OnSharedPreferenceChangeListener mSharedPreferenceChangeListener = new SharedPreferences.OnSharedPreferenceChangeListener(){

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
            if (HeadUpDisplay.this.mListener != null) {
                HeadUpDisplay.this.mListener.onSharedPreferencesChanged();
            }
        }
    };

    public HeadUpDisplay(Context context) {
        HeadUpDisplay.initializeStaticVariables(context);
    }

    private static void initializeStaticVariables(Context context) {
        if (sIndicatorBarRightMargin >= 0) {
            return;
        }
        sIndicatorBarRightMargin = GLRootView.dpToPixel(context, 10);
        sPopupWindowOverlap = GLRootView.dpToPixel(context, 20);
        sPopupTriangleOffset = GLRootView.dpToPixel(context, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overrideSettings(String ... keyvalues) {
        GLRootView root = this.getGLRootView();
        if (root != null) {
            GLRootView gLRootView = root;
            synchronized (gLRootView) {
                this.overrideSettingsLocked(keyvalues);
            }
        } else {
            this.overrideSettingsLocked(keyvalues);
        }
    }

    public void overrideSettingsLocked(String ... keyvalues) {
        if (keyvalues.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        int n = keyvalues.length;
        for (int i = 0; i < n; i += 2) {
            this.mIndicatorBar.overrideSettings(keyvalues[i], keyvalues[i + 1]);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int width = right - left;
        int height = bottom - top;
        this.mIndicatorBar.measure(View.MeasureSpec.makeMeasureSpec((int)(width / 3), (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        DisplayMetrics metrics = this.getGLRootView().getDisplayMetrics();
        int rightMargin = (int)(metrics.density * 10.0f);
        this.mIndicatorBar.layout(width - this.mIndicatorBar.getMeasuredWidth() - rightMargin, 0, width - rightMargin, height);
        if (this.mPopupWindow != null && this.mPopupWindow.getVisibility() == 0) {
            this.layoutPopupWindow(this.mAnchorView);
        }
    }

    public void initialize(Context context, PreferenceGroup preferenceGroup) {
        this.mPreferenceGroup = preferenceGroup;
        this.mSharedPrefs = ComboPreferences.get(context);
        this.mPopupWindow = null;
        this.clearComponents();
        this.initializeIndicatorBar(context, preferenceGroup);
        this.requestLayout();
    }

    private void layoutPopupWindow(GLView anchorView) {
        this.mAnchorView = anchorView;
        Rect rect = new Rect();
        this.getBoundsOf(anchorView, rect);
        int anchorX = rect.left + sPopupWindowOverlap;
        int anchorY = (rect.top + rect.bottom) / 2;
        int width = (int)((double)((float)this.getWidth() * 0.8f) + 0.5);
        int height = (int)((double)((float)this.getHeight() * 0.85f) + 0.5);
        this.mPopupWindow.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE));
        width = this.mPopupWindow.getMeasuredWidth();
        height = this.mPopupWindow.getMeasuredHeight();
        int xoffset = Math.max(anchorX - width, 0);
        int yoffset = Math.max(0, anchorY - height / 2);
        if (yoffset + height > this.getHeight()) {
            yoffset = this.getHeight() - height;
        }
        this.mPopupWindow.setAnchorPosition(anchorY - yoffset);
        this.mPopupWindow.layout(xoffset, yoffset, xoffset + width, yoffset + height);
    }

    private void showPopupWindow(GLView anchorView) {
        this.layoutPopupWindow(anchorView);
        this.mPopupWindow.popup();
        this.mSharedPrefs.registerOnSharedPreferenceChangeListener(this.mSharedPreferenceChangeListener);
        if (this.mListener != null) {
            this.mListener.onPopupWindowVisibilityChanged(0);
        }
    }

    private void hidePopupWindow() {
        this.mPopupWindow.popoff();
        this.mSharedPrefs.unregisterOnSharedPreferenceChangeListener(this.mSharedPreferenceChangeListener);
        if (this.mListener != null) {
            this.mListener.onPopupWindowVisibilityChanged(1);
        }
    }

    private void scheduleDeactiviateIndicatorBar() {
        this.mHandler.removeMessages(0);
        this.mHandler.sendEmptyMessageDelayed(0, 5000L);
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessageDelayed(1, 5500L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrientation(int orientation) {
        GLRootView root = this.getGLRootView();
        if (root != null) {
            GLRootView gLRootView = root;
            synchronized (gLRootView) {
                this.setOrientationLocked(orientation);
            }
        } else {
            this.setOrientationLocked(orientation);
        }
    }

    private void setOrientationLocked(int orientation) {
        this.mOrientation = orientation;
        this.mIndicatorBar.setOrientation(orientation);
        if (this.mPopupWindow == null) {
            return;
        }
        if (this.mPopupWindow.getVisibility() == 0) {
            AlphaAnimation alpha = new AlphaAnimation(0.2f, 1.0f);
            alpha.setDuration(250L);
            this.mPopupWindow.startAnimation((Animation)alpha);
            this.scheduleDeactiviateIndicatorBar();
        }
        this.mPopupWindow.setOrientation(orientation);
    }

    private void initializePopupWindow(Context context) {
        this.mPopupWindow = new PopupWindow();
        this.mPopupWindow.setBackground(new NinePatchTexture(context, 2130837572));
        this.mPopupWindow.setAnchor(new ResourceTexture(context, 2130837573), sPopupTriangleOffset);
        this.mPopupWindow.setVisibility(1);
        this.mPopupWindow.setOrientation(this.mOrientation);
        this.addComponent(this.mPopupWindow);
    }

    protected boolean dispatchTouchEvent(MotionEvent event) {
        if (this.mEnabled && super.dispatchTouchEvent(event)) {
            this.scheduleDeactiviateIndicatorBar();
            return true;
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        if (this.mEnabled == enabled) {
            return;
        }
        this.mEnabled = enabled;
    }

    protected boolean onTouch(MotionEvent event) {
        if (this.mPopupWindow == null || this.mPopupWindow.getVisibility() == 1) {
            return false;
        }
        switch (event.getAction()) {
            case 1: {
                this.hidePopupWindow();
                this.mIndicatorBar.setSelectedIndex(-1);
                this.mIndicatorBar.setActivated(false);
            }
        }
        return true;
    }

    protected static ListPreference[] getListPreferences(PreferenceGroup group, String ... prefKeys) {
        ArrayList<ListPreference> list = new ArrayList<ListPreference>();
        for (String key : prefKeys) {
            ListPreference pref = group.findPreference(key);
            if (pref == null || pref.getEntries().length <= 0) continue;
            list.add(pref);
        }
        return list.toArray(new ListPreference[list.size()]);
    }

    protected BasicIndicator addIndicator(Context context, PreferenceGroup group, String key) {
        IconListPreference iconPref = (IconListPreference)group.findPreference(key);
        if (iconPref == null) {
            return null;
        }
        BasicIndicator indicator = new BasicIndicator(context, iconPref);
        this.mIndicatorBar.addComponent(indicator);
        return indicator;
    }

    protected void initializeIndicatorBar(Context context, PreferenceGroup group) {
        this.mIndicatorBar = new IndicatorBar();
        this.mIndicatorBar.setBackground(new NinePatchTexture(context, 2130837561));
        this.mIndicatorBar.setHighlight(new ColorTexture(-1708446933));
        this.addComponent(this.mIndicatorBar);
        this.mIndicatorBar.setOnItemSelectedListener(new IndicatorBarListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean collapse() {
        if (!this.mIndicatorBar.isActivated()) {
            return false;
        }
        this.mHandler.removeMessages(0);
        this.mHandler.removeMessages(1);
        GLRootView root = this.getGLRootView();
        if (root != null) {
            GLRootView gLRootView = root;
            synchronized (gLRootView) {
                this.mIndicatorBar.setSelectedIndex(-1);
                this.mIndicatorBar.setActivated(false);
            }
        } else {
            this.mIndicatorBar.setSelectedIndex(-1);
            this.mIndicatorBar.setActivated(false);
        }
        return true;
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public void restorePreferences(Camera.Parameters param) {
        SharedPreferences.OnSharedPreferenceChangeListener l = this.mSharedPreferenceChangeListener;
        this.mSharedPrefs.unregisterOnSharedPreferenceChangeListener(l);
        Context context = this.getGLRootView().getContext();
        SharedPreferences.Editor editor = this.mSharedPrefs.edit();
        editor.clear();
        editor.apply();
        CameraSettings.upgradeAllPreferences(this.mSharedPrefs);
        CameraSettings.initialCameraPictureSize(context, param);
        this.reloadPreferences();
        if (this.mListener != null) {
            this.mListener.onSharedPreferencesChanged();
        }
        this.mSharedPrefs.registerOnSharedPreferenceChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadPreferences() {
        GLRootView root = this.getGLRootView();
        if (root != null) {
            GLRootView gLRootView = root;
            synchronized (gLRootView) {
                this.mPreferenceGroup.reloadValue();
                this.mIndicatorBar.reloadPreferences();
            }
        } else {
            this.mPreferenceGroup.reloadValue();
            this.mIndicatorBar.reloadPreferences();
        }
    }

    private class IndicatorBarListener
    implements IndicatorBar.OnItemSelectedListener {
        private IndicatorBarListener() {
        }

        public void onItemSelected(GLView view, int position) {
            AbstractIndicator indicator = (AbstractIndicator)view;
            if (HeadUpDisplay.this.mPopupWindow == null) {
                HeadUpDisplay.this.initializePopupWindow(HeadUpDisplay.this.getGLRootView().getContext());
            }
            HeadUpDisplay.this.mPopupWindow.setContent(indicator.getPopupContent());
            if (HeadUpDisplay.this.mPopupWindow.getVisibility() == 0) {
                HeadUpDisplay.this.layoutPopupWindow(indicator);
            } else {
                HeadUpDisplay.this.showPopupWindow(indicator);
            }
        }

        public void onNothingSelected() {
            HeadUpDisplay.this.hidePopupWindow();
        }
    }

    public static interface Listener {
        public void onPopupWindowVisibilityChanged(int var1);

        public void onRestorePreferencesClicked();

        public void onSharedPreferencesChanged();
    }
}

